Echo off
  Cls
  Echo .
  Echo *==================[ LaunchCAD Install Program ]=====================*
  Echo .
  Echo This program will extract files from the LaunchCAD ZIP archive to your
  Echo AutoCAD directory and modify your ACAD.PGP and ACAD.LSP files. Backups
  Echo are make of these files as ACAD.PG2 and ACAD.LS2.
  Echo .
  Echo Press any key to continue or CTRL-C to quit now.
  Echo .
  Pause > nul
  If [%1] == [] GoTo :usage
  If [%2] == [] GoTo :usage
  If Not Exist %1\unzip.exe GoTo baddrive
  If Not Exist %2\acad.exe GoTo badacad
:ok
  Echo .
  Echo Extracting LaunchCAD files...
  %1\unzip %1\lcad\*.zip %2 /o
  ReName %2\!read.me! readme.lc
  ReName %2\order.doc order.lc
  Echo .
  Echo If you have previously installed an older version LaunchCAD,
  Echo then press CTRL-C now, or any other key to continue...
  Echo .
  Pause > nul
  If Not Exist %2\acad.pgp GoTo nopgp
  copy %2\acad.pgp %2\acad.pg2
  copy %2\acad.pgp + %2\lc.pgp %2\acad.pgp
  GoTo lisp
:nopgp
  Echo Unable to locate the file ACAD.PGP, you must add the contents of
  Echo LC.PGP to ACAD.PGP manually
:lisp
  If Not Exist %2\acad.lsp GoTo nolisp
  copy %2\acad.lsp %2\acad.ls2
  copy %2\acad.lsp + %2\lc.lsp %2\acad.lsp
  GoTo done
:nolisp
  Echo Unable to locate the file ACAD.LSP, you must add the contents of
  Echo LC.LSP to ACAD.LSP manually
:done
  Echo Done
  GoTo end
:badacad
  Echo Error: %2 is Not your AutoCAD directory.
  GoTo usage
:baddrive
  Echo Error: the file UNZIP.EXE can Not be found on drive %1
:usage
  Echo .
  Echo In order for Install to work properly you must provide both the
  Echo floppy drive and your AutoCAD directory:
  Echo .
  Echo Usage: INSTALL A: C:\ACAD
:end
