***

CHORDMASTER - Unregistered Version 1.4      Chord Chemistry Program for Guitar
Copyright (c) 1991 by Robert Watson
All Rights Reserved





                             TABLE OF CONTENTS


      INTRODUCTION ............................... 1

      INSTALLATION ............................... 2

      CHORD ENTRY ................................ 3
         IDENTIFIERS ............................. 3
         NOTE ENTRY .............................. 4
         ERRORS .................................. 4
         SCREEN FORMAT ........................... 4
         FRETBOARD COMMANDS ...................... 5

      DISPLAYING CHORDS .......................... 6

      OPTIONS MENU ............................... 7
         DISPLAY ................................. 7
         TUNINGS ................................. 7
         PLAY .................................... 8
         FILES ................................... 8
         PRINT .................................. 10
         RESOLVE ................................ 11

































***


                                INTRODUCTION

   CHORDMASTER is state-of-the-art chord chemistry software designed
   specifically for guitarists.  Though it was created with guitarists
   in mind, the concepts explored can be applied to a variety of musical
   instruments.  CHORDMASTER is designed to be a educational aid and
   reference, useful for a variety of educational and compositional
   purposes.


   CHORDMASTER VERSION 1.4 FEATURES -

            Enhances fretboard visualization by showing all notes of a
             chord on the fretboard.

            Fretboard views can be shifted to show a specific area.

            Two fretboards can be viewed simultaneously.

            Chords can be played by a MIDI device or internal speaker.

            Notes for two chords can be overlayed on one fretboard,
             allowing analysis of similarities and differences.

            Chords can be viewed either as notes or scale sequences.

            Chords can be input by name or by specifying notes to be
            resolved to a known chording.

            Obscure inputs can be resolved to proper chords,
             i.e.  Amaj add7 = Amaj7,  A C# E G# = Amaj7.

            Chords can be resolved to up to five chord synonyms.

            Chords libraries are provided, allowing for the display of
             thousands of individual chordings.  (Restricted in unregistered
             version).

            User chord libraries can be maintained for custom chord
             display capabilities.  (Unavailable in unregistered version).

            Individual chord display can be limited to certain string
             and fret ranges.

            Context-sensitive HELP screens.

            Mouse and printer support.




   CHORDMASTER VERSION 2.0

      CHORDMASTER version 2.0 is already in the works!  It will include
      many additional features that we expect version 1.x users to suggest,
      as well as sequencing capabilities necessary to make CHORDMASTER a
      true interactive compositional tool!




                                   - 1 -

***


                               INSTALLATION

   CHORDMASTER requires about 100 Kbytes of disk space, and can be run
   from either a floppy or hard disk.

   Versions distibuted on floppy disk can be run as is by logging the
   floppy drive and executing the program.

      Example:    A: <enter>                    (logs the drive)
                  CHORDS <enter>                (executes the program)


   A floppy disk version can easily be installed onto another disk or hard
   drive by copying the CHORDMASTER files and directories to the desired
   drive.

      Example:    C: <enter>                    (logs the drive)
                  CD\ <enter>                   (start from root directory)
                  MD CHORDS <enter>             (create chord directory)
                  CD CHORDS <enter>             (log the chord directory)
                  COPY A:\*.* <enter>           (copy CHORDMASTER from floppy)
                  CHORDS <enter>                (executes the program)


   BBS versions of CHORDMASTER are distributed in ZIP format and require
   PKUNZIP to install.  Here's a sample hard drive installation that assumes
   that the CHORDS10.ZIP file is in the current directory.


      Example:    MD \CHORDS <enter>                (create chord directory)
                  PKUNZIP CHORDS10  \CHORDS <enter> (unzip CHORDMASTER)
                  CD \CHORDS                        (log the chord directory)
                  CHORDS <enter>                    (executes the program)




























                                   - 2 -

***


                                CHORD ENTRY

   After the opening screens the program will display a blank fretboard
   and the cursor will blink, prompting you for chord entry.  You have
   several choices at this point.  You can enter the name of a chord to be
   displayed, enter a chord by notes(pg.4); or abort the entry to explore
   the OPTIONS menu.

   Use the following format for entering a chord by name:

                  [A-G][#,b(optional)] [chord identifier options]

   At the very least you must enter an uppercase letter in the range of
   'A' through 'G'.  Optionally, you may indicate that the note is to be
   sharped or flatted by adding a '#' for a sharp or a lowercase 'b' for
   a flat.  Why the preoccupation with upper and lowercase?  Consider a
   B flat chord.  It looks fine as 'Bb', but kind of silly as 'bb', 'BB',
   or 'bB'.

   So you must enter the key or root of the chord you want to work with.
   If this is all you enter it is assumed that you are looking for a
   major chord.  To specify other chords you must add one or more chord
   identifier options, separated by spaces.

   The following are legitimate identifier options:

   FIRST GROUP

      maj             maj6             maj7             maj9
      maj11           maj13            minmaj7          minmaj9
      min             min6             min7             min9
      min11           min13            dim              dim7
      5               6                7                9
      11              13               aug              aug9
      aug11           noroot

   SECOND GROUP

      add or /        sus              + or -    (followed by numbers 2 - 13)

   Identifiers may be combined, separated by a space, in any combination that
   is musically sensible.  Now, what is musically sensible may vary according
   to whose rules you are following.  For the most part you will use one of
   the identifier options in the first group, optionally followed by one or
   more of the identifier combinations in the second group.

   The identifiers in the first group are common in describing chords.  See
   a book on chord theory for an explanation of these identifiers.  The
   identifiers in the second group are less common and are often written in
   different ways.  Here is brief explanation of the second group:

      add   or   /      -  Used to add a tone to tone to a chord.  These
                           are useful in creating common and exotic chords
                           and scales.  The catch is that the tone to be
                           added must not have been described in a previous
                           identifier or an error message will result.
      sus               -  Generally used to add a 2nd or 4th tone to a
                           chord at the expense of the 3rd.
      +    or    -      -  used to add an altered tone, or alter an existing
                           tone, to an existing chord.

                                   - 3 -

***

   Entry can also be accomplished by specifying the notes to be used in the
   chord.  CHORDMASTER then attempts to identify the chord.  Note entry is
   particularly easy with a mouse.  Non-mouse users should use the RESOLVE
   - NOTE ENTRY item in the OPTIONS menu (pg. 12).

      IMPORTANT : A chord entered by notes cannot be properly identified
                  unless all notes in it's formula are part of the entry.

   NOTE ENTRY with a mouse:

      Enter a chord notes by clicking on the desired fret positions on the
      active fretboard.  Clicking on a previously selected note will
      de-select it.  Once the desired notes have been selected, click on
      the word PROCESS which will appear above the active fretboard.  If
      the notes can be identified as a chord, its name will be displayed.
      The lowest note selected will be considered as the primary root for
      the resulting chord.


   Now let's describe some of the errors that can be encountered during
   chord entry:

         ILLEGAL                    -  What you typed is nonsensible.
         STEP ALREADY EXISTS        -  Your trying to add (add or /) a tone
                                       that has already been established.
         TONE SPECIFIED IS > 13     -  You've tried to add or alter a tone
                                       that is greater than 13.
         ILLEGAL TONE SPECIFIED     -  You've tried add or alter a
                                       non-numeric entity.

   Once a valid chord has been entered, all the notes in the chord are
   displayed on a fretboard and the notes are sounded through the system
   speaker.  Additionally, a display appears above and to the right of the
   fretboard showing the relationship of the notes in the chord to the tones
   in a scale.  I call this display the chord formula header.

   For instance, if 'A' is entered; the chord formula header will display
   the following:
                        1  2  3  4  5  6  7
                        A     C#    E

   This indicates that the 'A' major chord that was entered has three tones
   in it; a 1st or root, a 3rd and a 5th.  Therefore, an 'A' major chord has
   a formula of 1, 3, 5 .  The established spacing of these notes is function
   of established music theory and will not be discussed in this section.  It
   is not necessary to fully understand these mechanisms to begin using and
   enjoying CHORDMASTER.

   An additional line of text appears immediately below the fretboard, this
   is called the RESOLVE line.  If you entered 'A', as in the example above,
   this line would simply read 'A MAJ'.  This may seem kind of redundant at
   this point, but as you will see as you read on, the RESOLVE line is one of
   CHORDMASTER's most powerful features.

   Let's look again at the fretboard.  If you have entered the simple example
   chord shown above, the fretboard shows all the notes in an 'A' major chord
   scattered about the fretboard.  This is a powerful visual tool.  It allows
   the user to visualize an entire section of fretboard.  In this case, any
   fingerable combination of notes that contains at least one 'A', one 'C#'
   and one 'E', is a legitimate 'A' major chord.  Don't worry, CHORDMASTER
   can also display individual chord fingerings as we will see shortly.

                                   - 4 -

***

   If you have been following along, a word should appear in the center of
   the screen.  This is actually one of a series of possible choices called
   the AUTOMENU.  If you strike the SPACEBAR repeatedly, alternate selections
   will appear.  A selection is executed by striking ENTER.  Let's take a
   look at each of these selections:

         REENTER     -  This selection only appears if there was an error
                        in the most recent chord entry.
         OVERLAY     -  Allows entry of another chord, whose notes will
                        appear in combination with those already on the
                        active fretboard.  On a color monitor, the results
                        may be particularly revealing.
         SWITCH      -  Opens a fretboard on the opposite half of the the
                        display for chord entry.
         CLEAR       -  Clears the active fretboard for chord entry.
         OPTIONS     -  Displays the OPTIONS menu.
         QUIT        -  Exits the program.


   The OVERLAY and SWITCH functions provide added power in fretboard
   visualization; allowing the user to view various chord patterns together,
   or side by side.  There are several quick key combinations available when
   the AUTOMENU is active, they are:

         <- or ->    -  Shifts the fretboard view range left or right.
                        At any one time 16 frets are visible, over a range
                        of 25.

            P        -  Repeats the playing of the tones in the chord.

         -  or  +    -  Changes the timing of the playing of the tones
                        in the chord.

            D        -  Displays individual fingerings for the entered chord.


   MOUSE USERS :  To cycle through AUTOMENU choices, position the cursor in
                  the center of the screen and click the right mouse button.
                  Click the left mouse button on the desired selection to
                  execute it.  

                  Chord entries equivalent to the OVERLAY, SWITCH, CLEAR and
                  REENTER can be initiated by clicking the left mouse button 
                  over the desired input area.

                  The OPTIONS menu can be accessed by clicking the left mouse
                  button at the top of the screen.















                                   - 5 -

***


                              DISPLAYING CHORDS

   Once a valid chord is entered on fretboard, individual chordings can be
   displayed.  This can be accomplished by pressing a 'D' on the keyboard or
   selecting DISPLAY from the OPTIONS menu.

   During DISPLAY the following keys are active:

            <-  and  ->      previous and next chords
             +  and  -       to change play timing
                 p           repeat chord play
                ESC          to quit DISPLAY

   Use basic chord entries to test the DISPLAY system.  If all attempts to
   DISPLAY result in file errors it is likely that CHORDMASTER is improperly
   installed.  Be sure that the chord files (.CFD) in the CHORDS directory.

   CHORDMASTER's unregistered version cannot display chordings for every
   entry.  In this version, new chord types cannot be added, and the display
   of individual chordings is severly limited.  If you purchase the registered
   version of this program, chord types can be added, and a nearly infinite
   number of individual chordings can be displayed.

   This chart demonstrates the difference in the number of individual
   chordings that can be displayed by the UNREGISTERED and REGISTERED versions.
   The REGISTERED version includes files for another 50 additional types of
   chords, which will result in thousands more chord possibilities.  The
   performance of registered version can be further enhanced by additional
   chordings that can be added by the user via CHORDMASTER's integrated chord
   file editor.


                              UNREG. VERSION     REG. VERSION
      CHORD ENTRY             DISPLAY COUNT      DISPLAY COUNT

      maj                           72                225
      maj7                          11                 91
      maj9                          19                147
      maj13                          7                100
      6                             33                199
      7                             19                117
      9                             30                330
      11                            14                 63
      13                             4                121
      min6                           5                133
      min7                          19                192
      min9                          24                137
      min11                          6                124
      minmaj7                        9                 46
      minmaj9                       16                 95
      aug                           28                 59
      dim7                           5                107
      aug9                                            124
      aug11                         17                 52
                                  ----               ----
      TOTAL                        338               2462





                                   - 6 -

***


                               OPTIONS MENU

   Let's examine the various features in the options menu.  We will work
   through the drop-down menus left to right.


DISPLAY

   The DISPLAY drop-down menu consists of three items.  The first choice,
   DISPLAY is equivalent to pressing the 'D' key after chord entry.  This
   choice initiates DISPLAY of individual chordings within the parameters
   specified by the second choice, DISPLAY SETUP.  


DISPLAY SETUP

   This menu selection brings up the DISPLAY SETUP menu.  The DISPLAY
   SETUP menu allows the user to specify the fret range, strings, and
   number of notes allowed for the chords to be displayed.

   Move from from field to field by pressing the up or down arrow keys,
   TAB or ENTER.  When the setup is as desired press F7 to save.  Press
   ESC to exit and ignore changes.

   For each STRING enter 'Y' or 'N' to indicate whether it should be used 
   for DISPLAY.  If too many strings are disabled an error message will 
   appear.  The number of strings required will vary according to the
   formula of the most recently entered chord.
   
   Specify the fret range over which chords should be displayed by adjusting  
   the LOW FRET and HIGH FRET entries.  Remember, not more than 16 frets can
   be diplayed at one time.  However, individual chordings may be displayed
   over a smaller range of frets.

   Select the MINIMUM and MAXIMUM number of notes in chords to be displayed.
   The MAXIMUM number of notes depends on how many strings are used, the 
   MINIMUM number of notes is determined by the formula of the chord.

   Select which tone in the chord should be the BASS NOTE.  Most commonly
   '1' would be entered to select the root note as the bass.  However, more
   chords will be displayed if '0' is entered, indicating no preference.

   The NOTE BLINK selection toggles the blinking of notes in a chord as they
   are displayed.
   

   MOUSE USERS : Click on a field to move cursor, click on a command
                 to execute it.


TUNINGS

   The TUNINGS menu allows fretboards to be tuned in a variety of manners.
   Tuning changes affect subsequent chord entries on.  Menu items allow for 
   a quick change to STANDARD, OPEN A, OPEN C, OPEN D, OPEN E or OPEN G
   tunings.  The final menu item provides for CUSTOM TUNING, in which any
   string can be altered from the standard tuning up to four half steps in
   either direction.

   NOTE : Individual chord DISPLAY is only available for standard tuning.

                                   - 7 -

***


PLAY

   This menu consists of several ON/OFF type functions. These include:   
   
            PLAY ON ENTRY     -  Chord play on entry
            PLAY ON DISPLAY   -  Chord play on DISPLAY
            MIDI PORT         -  Play on MIDI port channel '0'
            SPEAKER           -  PLAY on internal system speaker

   The TIMINGS selection controls the ATTACK and DURATION timings of
   the chords being played.  Units of time are defined as system ticks; 
   appproximately eighteen per second.



DISPLAY FILES

   This drop-down menu consists of several items used to maintain the
   chord library and other support files used by CHORDMASTER.


   APPEND FILE

      This function is used to add records to an existing chord library
      file.

      NOTE :   This function is not supported in the unregistered version of
               CHORDMASTER.


   NEW FILE

      This function is used to create a new, or overwrite an existing,
      chord library file.

      NOTE :   This function is not supported in the unregistered version of
               CHORDMASTER.


   EDIT FILE

      This function allows the user to enter or modify an existing chord 
      library file record by indicating the fret to be fingered on each 
      string.  Note that a chord must be entered in the key of 'A' before 
      its chord library file can be edited.  Valid fret entries are numbers 
      0 to 24.  Unsounded strings should be indicated by blanks (spaces).

      Move from from field to field by pressing the up or down arrow keys,
      TAB or ENTER.  When record is as desired press F7 to save changes.

            PGUP and PGDN        previous and next records
                 F8              clear the current record
                 F9              insert a record
                 F10             delete the current record

      Press ESC to save the file and exit when done.

      MOUSE USERS : Click on a field to move cursor, click on a command
                    to execute it.


                                   - 8 -

***


      The records in a chord file determine which chords can be diplayed
      when the DISPLAY option is selected.  Certain records may have no
      effect on DISPLAY depending on the DISPLAY SETUP.  Not only is each
      record in a chord file displayable, but subsets of each record, that
      are still legitimate chordings, can be displayed.

      As chord records are entered they are analyzed for legitimacy and
      redundancy.  The following error messages may appear during entry:

         ILLEGAL CHORDING           The attempted entry either consists 
                                    of tones that are not part of the
                                    chord, or does not have tones that
                                    necessary to form a legitimate chord.

         CHORDING IS A SUBSET       The attempted entry is a subset of an   
                                    existing entry, and is therefore
                                    redundant, remember that each entry is
                                    dissected into all legitimate chordings.

      While the editor will warn you that a proprosed entry is a subset of
      an existing entry, it does not warn you that the entry may be a
      superset of an existing entry.  For this reason the following is
      recommended; once records in a file have been added or altered, step
      through the records from the beginning, pressing F7 at each one.  This
      will alert the user of any existing subsets, that can then be deleted. 
      While DISPLAY will prevent them from being displayed, this will avoid
      unneccessary processing of duplicate chordings.

      As far as what constitutes a legitimate chord, the following rules
      apply:

           TONES IN FORMULA            RULES

                  3                 At least one instance of each tone must 
                                    be present.

                  4                 At least on instance of each tone must be
                                    present, excepting the 3rd may be dropped
                                    in the presence of a 2nd or 4th.

                  5                 The root or 5th may be dropped.  The 3rd
                                    may be dropped in the presence of a 2nd 
                                    or 4th.

                  6, 7              The root and 5th may be dropped.  The 3rd
                                    may be dropped in the presence of a 2nd
                                    or 4th.


   SAVE CONFIGURATION

      The selection saves information about current program settings in a
      file called CHORD.CFG.  The settings saved in this file are restored
      every time the program is started.


   FACTORY SETTINGS

      Restores program settings to the original settings distributed with
      the program.

                                   - 9 -

***


   ADD CHORD

      Adds the text and tone offsets of the most recently entered chord
      to the RESOLVE library.  This is necessary before elements of a chord 
      library file for the chording can be displayed.

      NOTE :   This function is disabled in the unregistered version of
               CHORDMASTER.


PRINT

   This drop-down menu consists of several selections which initiate printing
   of fretboards.  Printed output is sent to the standard print device.















































                                   - 10 -

***


RESOLVE

   The RESOLVE drop-down menu consists of selections that control the way
   chordings are resolved and displayed.

   RESOLVE performs two important functions.  First, RESOLVE can take an
   awkward chord entry and show a more eloquent method of achieving the
   same result.

   For instance, if you entered 'A MIN /2 /7', RESOLVE would "correct" your  
   entry by responding with 'A MIN9'.  This is a useful educational tool,
   helping to reinforce the user's understanding of chord chemistry.

   Secondly, RESOLVE's perform is critical to the DISPLAY of individual
   chordings.  This is very important, so it should be emphasized that
   DISPLAY WILL NOT BE AVAILABLE FOR A CHORD UNLESS IT IS RESOLVED TO A
   CHORD WITH A ROOT, AND A CHORD FILE EXISTS FOR AT LEAST ONE RESOLUTION.

   For instance, if 'A MIN7 /13' is entered, the notes will be shown on the
   fretboard, but the RESOLVE line would be blank with the factory setup.
   An attempt to DISPLAY this chord would result in an error message.  If
   RESOLVE settings were altered a NOROOT chord (D9 NOROOT) would be found
   to be a perfect synonym, however, as no chord library files exist for
   NOROOT chords.  Display of this or any legitimate entry can be achieved
   with the registered version of CHORDMASTER which supports updating of the
   RESOLVE library.

   RESOLVE is capable of revealing chord synonyms.  Factory settings limit the
   RESOLVE line display to three resolutions, but by altering these settings
   up to five synonyms or near matches can be displayed.  These synonyms may
   or may not include NOROOT chords depending on the settings.  This has
   implications in DISPLAY mode; if a chord is resolved to more than one
   perfect match by RESOLVE, chord library files for both chords would be
   combined and the resulting chordings DISPLAYed.  While this increase in
   DISPLAYed chordings is usually modest, it does provide a means by which
   NOROOT chords can be DISPLAYed, despite the fact that no chord library
   files exist for them.  To see this mechanism in action use the RESOLVE
   dropdown menu to set RESOLVE as follows DISPLAY ON, SET COUNT=2, PERFECT
   ONLY ON and NO ROOT OFF.  Obtain a clear fretboard for entry and enter
   'A MIN6'.  The RESOLVE line now indicates 'A MIN6  F#MIN7 -5'.  With the
   registered version of CHORDMASTER this would result in chord files for
   both chords being combined in a subsequent DISPLAY.  However, with the
   unregistered version DISPLAY is still a means of seeing some of CHORDMASTER's
   display mechanism.  DISPLAY would show two windows in this situation; a
   blue window showing success in finding the file for the 'MIN6' and a red
   window indicating a problem finding the file for the 'MIN7 -5'.  When
   you see this message you will usually want to strike 'a' for abort, and
   let the program continue.

   If you purchase the registered version of CHORDMASTER you will be well
   rewarded; not only are the existing chord library files larger, there
   are more of them.  The unregistered version of CHORDMASTER comes with about
   20 chord library files, limited to 4 entries each.  The registered version
   contains nearly 70 chord library files of up to 80 entries apiece.  The
   registered version also supports the incorporation of special 'user'
   chord library files which can be used to DISPLAY your chords alone or can
   be combined with the included chord files for expanded DISPLAY capability.
   There are other perks involved in purchasing the registered version, see
   the included README.DOC file for more info.


                                   - 11 -

***


   Here's a description of the RESOLVE menu functions:

      RESOLVE        -  Resolves the most recently entered chord according
                        to the current RESOLVE settings.

      DISPLAY        -  Enables or disables the display of the resolve line.
                        Either way RESOLVE still occurs and the results
                        affect DISPLAY.

      SET COUNT      -  Sets the number of resolutions RESOLVE will attempt
                        to achieve.

      PERFECT ONLY   -  This setting decides whether or not non-perfect
                        chord synonyms will be resolved.  On the resolve line
                        perfect synonyms are shown in reverse video.

      NO ROOT        -  This setting decides whether NOROOT chords will be
                        resolved.

      NOTE ENTRY     -  Provides a means by which individual notes of an
                        unknown chord can be entered and then resolved to
                        a known chord.  Notes should be entered separated by
                        a space.  Note Entry can be more easily accomplished
                        using a mouse (pg. 4).  The first note entered will
                        be considered as the primary root note for the chord.




































                                   - 12 -

***
