








                                Aporia(tm) User Manual



                                    Version 1.4











              Copyright 1989, 1990 NewTools, Inc. All rights reserved.









                                   NewTools, Inc.

                                    PO Box 3269

                               Church Street Station

                              New York, NY 10008-3269

                                   (718) 789-5980









       CONTENTS


       CONTENTS..................................................ii
       WARRANTY..................................................v
       LICENSE...................................................v
       REGISTRATION..............................................vi
       SUPPORT...................................................vi
       DISTRIBUTION .............................................vii
       TRADEMARKS................................................viii
       1. Chapter 1: Introduction................................1
           1.1 The Concepts Behind Aporia........................1
           1.2 User Created Tools................................2
               1.2.1 Tools are Attached to Files.................2
               1.2.2 You Design Your Own Tools...................3
           1.3 Overview of the Basic Tools.......................3
               1.3.1 Desk Tool...................................3
               1.3.2 Directory Tool .............................3
               1.3.3 Tree Tool...................................4
               1.3.4 Options Tool ...............................4
               1.3.5 Copy Tool...................................4
               1.3.6 Trash Tool..................................4
               1.3.7 Size Tool...................................5
               1.3.8 Hide Tool...................................5
               1.3.9 Help Tool...................................5
               1.3.10 Notes Tool.................................5
       2. Chapter 2: Installation................................6
           2.1 System Requirements...............................6
           2.2 Installing Aporia On Your System..................6
               2.2.1 Using Aporia As The Windows Shell...........7
               2.2.2 Creating Tools From Program Manager Setup...8
       3. Chapter 3: Getting Started, a Tutorial.................9
           3.1 Running Aporia....................................9
           3.2 Using Tools.......................................10
               3.2.1 Moving Tools................................10
               3.2.2 Running Tools...............................11
               3.2.3 Getting Help On Using Tools.................11
           3.3 Creating Tools....................................12
               3.3.1 The Tree Tool...............................12
               3.3.2 Creating User Tools.........................12
               3.3.3 Creating Directory Tools....................13
               3.3.4 Using the Copy Tool.........................14
           3.4 Using Your Tools..................................14
               3.4.1 Running Programs............................14
               3.4.2 Running Files...............................14
           3.5 Organizing Your Work..............................15
               3.5.1 Using Desk Tools............................15
               3.5.2 Hide a Desk's Contents......................16





                                                   Aporia User Manual ii



           3.6 Customizing Tools.................................16
               3.6.1 Using the Options Tool......................16
               3.6.2 Using the Size Tool.........................18
           3.7 Managing Your Files and Directories...............19
               3.7.1 Managing Directories........................19
               3.7.2 Managing Files..............................20
           3.8 Summary...........................................22
       4. Chapter 4: Aporia Reference............................23
           4.1 Creating Tools....................................23
               4.1.1 From a Directory Window.....................23
               4.1.2 With the Copy Tool..........................24
               4.1.3 Creating Directory Tools....................24
           4.2 Running Tools.....................................24
               4.2.1 Double-clicking Tools ......................24
               4.2.2 Dragging One Tool onto Another..............24
               4.2.3 Dragging a File onto a Tool.................25
           4.3 Managing Your Tools...............................25
               4.3.1 Moving Tools on the Screen..................25
               4.3.2 Moving Groups of Tools......................25
               4.3.3 Stacking Tools..............................26
               4.3.4 Canceling Moves.............................26
               4.3.5 Getting Information About a Tool............26
               4.3.6 The Aporia Menu.............................26
           4.4 The Desk Tool.....................................28
               4.4.1 Storing Tools...............................28
               4.4.2 Hiding and Displaying a Desk's Contents.....28
               4.4.3 Moving Desks................................29
               4.4.4 Running Desks...............................29
               4.4.5 Removing a Desk.............................29
           4.5 The Trash Tool....................................29
               4.5.1 Removing Tools and Files....................29
               4.5.2 Trash Management............................30
           4.6 The Notes Tool....................................30
               4.6.1 Notes on Tools..............................30
               4.6.2 General Notes...............................31
           4.7 The Help Tool.....................................31
           4.8 The Copy Tool.....................................32
           4.9 The Hide Tool.....................................33
           4.10 The Options Tool.................................33
               4.10.1 Individual Tool Options....................33
               4.10.2 General Aporia Options.....................37
           4.11 The Size Tool....................................40
               4.11.1 Sizing and Positioning Windows Programs....40
               4.11.2 Sizing Aporia Tools........................40
           4.12 The Tree Tool....................................41
               4.12.1 The Tree Tool Window.......................41
               4.12.2 The Tree Tool Menu.........................42
               4.12.3 Additional Tree Tool Features..............44





                                                  Aporia User Manual iii




           4.13 The Directory Tool...............................44
               4.13.1 Directory Windows..........................44
               4.13.2 Managing Your Files........................46
               4.13.3 The Directory Window Menu..................47
               4.13.4 Additional Directory Tool Features.........52
       5. Chapter 5: Advice for Experts..........................54
           5.1 Running Aporia as the Windows Shell...............54
           5.2 Passing Arguments to Tools........................54
           5.3 Turning Off Trash Management......................55
           5.4 Getting Rid of Prompts When Trashing Tools........56
           5.5 Desks: Organizing, Repetitious Jobs...............56
               5.5.1 Trees of Desks..............................56
           5.6 Aporia Tool Files.................................56
               5.6.2 Switching Tool Files........................57
           5.7 Aporia WIN.INI Settings...........................57
           5.8 Aporia on a Network...............................58
               5.8.1 Tools and Options...........................58
               5.8.2 Where to Locate Your APORIA Directory.......58
               5.8.3 Registration on Networks....................59
           5.9 Quick Menus.......................................59
           5.10 Using Other Screen Blankers......................60
           5.11 Large Tools for The Visually Impaired............60
           5.12 Layouts..........................................60
       6. Chapter 6: Image Maker Utility.........................62
           6.1 Running Image Maker...............................62
           6.2 The Image Maker Commands..........................63
               6.2.1 File Menu...................................63
               6.2.2 Capture Menu................................63
               6.2.3 Options Menu................................64
           6.3 General Notes.....................................64
       INDEX.....................................................66






















                                                   Aporia User Manual iv




       WARRANTY


            Aporia, and this manual, are provided AS IS without any
            warranty, expressed or implied, including but not limited to
            fitness for a particular purpose. NEWTOOLS, INC.
            SPECIFICALLY DISCLAIMS ANY AND ALL WARRANTIES. IN NO EVENT
            SHALL NEWTOOLS, INC. BE LIABLE FOR ANY LOSS OF PROFIT OR ANY
            OTHER COMMERCIAL DAMAGE, INCLUDING BUT NOT LIMITED TO
            SPECIAL, INCIDENTAL, CONSEQUENTIAL OR OTHER DAMAGES
            RESULTING FROM THE USE OF THIS PRODUCT.


       LICENSE


            Aporia is a SHAREWARE program. It is NOT Public Domain
            software nor is it Free software. Aporia requires the user
            to register the program if he or she intends to use it
            except for the purpose of limited evaluation described
            below. Registration grants the user a licence to use Aporia
            on a single computer at any one time.

            Non-registered users are granted a limited licence to use
            Aporia on a trial basis for the purpose of evaluation and
            determining if Aporia is suitable for their needs. Use of
            Aporia, except for this limited purpose, requires the user
            to register the product.

            All users of Aporia are granted limited licence to copy the
            product only for the trial use by others, subject to the
            above limitations, provided that Aporia is copied in its
            full and unmodified form. That is, the copy must include all
            files necessary to permit full operation of the program,
            this licence agreement, registration form and full
            documentation. No fee, charge, licence, warranty,
            registration obligation or other compensation of any kind
            may be accepted by the donor or recipient in exchange for a
            copy of Aporia.

            Operators of Electronic Bulletin Board Systems (BBS Sysops)
            may permit Aporia to be downloaded by any user, and any user
            may be permitted to upload a copy of Aporia to a BBS, with
            the Sysop's permission, provided the above conditions are
            met.

            Use of non-registered copies of Aporia by any person in
            connection with a business, corporation, educational





                                                    Aporia User Manual v




            establishment or government agency is forbidden. Such users
            must register the product and/or purchase a site licence
            agreement.

            Registered users are granted a license to use this software.
            You may use this software on only one computer at any given
            time. If you wish to use Aporia in on multiple computers
            concurrently, you should register one copy for each
            location.

            As a registered user, you will be notified of future Aporia
            upgrades and revisions and be offered the opportunity to
            acquire them at a preferred rate and also, for a limited
            time, you will be provided with minor upgrades and bug-fixes
            free of charge.




       REGISTRATION


            If you decide to use Aporia you must register it. The
            registration fee is $50 plus $4 for shipping and handling
            (for orders outside North America shipping and handling is
            $8). You will be sent a disk containing the latest version
            of the software and a printed, fully illustrated manual.

            When ordering, please use the order form included with the
            Aporia distribution files. The form is named ORDER.TXT. You
            can print it by changing to the directory where the file is
            located and typing:

                 COPY ORDER.TXT PRN <ENTER>




       SUPPORT


            Support is available in a variety of ways. If you use either
            CompuServe you can leave an electronic mail message for
            CompuServe IDs: 73157,461

            Or call (718) 789-5980 from 9am to 5pm Eastern time.







                                                   Aporia User Manual vi




       DISTRIBUTION


            You may distribute Aporia freely provided you distribute all
            files unaltered and do not charge a distribution fee that
            exceeds $7.

            Aporia version 1.4 is distributed with the following files:



            AP_READ.ME     Important information. You should read this
                           file first.
            APLIB.EXE      Aporia dynamic link library.
            APORIA.EXE     Aporia executable.
            APORIA.INT     This is Chapter 3 (the tutorial) of this
                           manual in Windows Write format. It is
                           intended to be read on-line using the Help
                           tool.
            APORIA.GRP     This is a Windows 3.0 Program Manager group
                           file containing icons for Aporia and Image
                           Maker.
            APORIA.MAN     This manual in ASCII text format.
            AIF_16.EXE     Self extracting file containing Aporia image
                           files for the basic Aporia tools and for
                           programs supplied with Windows 3.0. This file
                           contains image files for use systems running
                           in 16 color EGA, VGA, and SuperVGA display
                           modes under Windows 3.0.
            AIF_256.EXE    This is a self extracting compressed file
                           containing Aporia image files for the basic
                           Aporia tools and for programs supplied with
                           Windows 3.0. This file contains image files
                           for use systems running in 256 color EGA,
                           VGA, and SuperVGA display modes under Windows
                           3.0.
            AP_ICONS.EXE   Self extracting file containing the icons for
                           the basic Aporia tools in Windows 3.0 icon
                           (ICO) format.
            CHANGES.TXT    A list of changes in this release.
            IMAGEMKR.EXE   Aporia Image Maker utility.
            NOTES.TXT      Default Aporia note file.
            ORDER.TXT      Order form for Aporia. Please use this form
                           when you order.
            SETUP_AP.EXE   Run this program to setup Aporia on your
                           system.







                                                  Aporia User Manual vii




       TRADEMARKS


            Aporia(tm) and NewTools(tm) are trademarks of NewTools, Inc.

            Microsoft, Windows, and Excel are registered trademarks of
            Microsoft Corporation.PageMaker is a registered trademarks
            of Aldus Corporation. Norton Utilities is a registered
            trademark of Peter Norton Computing, Inc.








































                                                 Aporia User Manual viii


                                                 Chapter 1: Introduction




       1. CHAPTER 1: INTRODUCTION



       1.1 THE CONCEPTS BEHIND APORIA

            Aporia is a program which provides you with a more
            convenient, flexible interface for Microsoft Windows. It
            makes Windows easier to use by adding a fully graphical,
            object-oriented user interface which lets you customize your
            working environment. It gives you a better way to organize
            your work by allowing you to display graphically your
            programs and data files. Aporia also has the ability to
            train your programs to run the same way each time for a
            given situation; thus, allowing you to work more
            efficiently.

            The heart of Aporia is the concept of tools.  A tool in
            Aporia refers to both the icon that represents the tool and
            the object that you attach to the tool. That object can be
            any file on your disk drives, including programs and data
            files. You can arrange tools on the screen as you like, so
            your commonly used programs and files are always immediately
            available.  Programs can be run by pointing the mouse cursor
            over a program's tool and double clicking the mouse button
            or by using the mouse to drag a tool for a data file onto
            the program's tool.

            One of the goals of the tools concept is to make the
            programs and files you work with on your computer easier to
            find and identify. This is done by letting you give a tool
            both an icon and a name. Aporia comes with a large number of
            icon styles from which you can choose; and tool names can be
            up to 30 characters long. You no longer have to struggle
            with the cryptic eight character file names that DOS forces
            you to use. Another goal of the tool concept is to allow you
            to set up your programs and files so that you can work with
            them in exactly the way you like. A tool can store
            information about the way in which a program is to run such
            as the size of its window, the directory where it runs, and
            the file it should initially load.

            Aporia comes with a number of basic tools to manage your
            work environment. The basic tools work together to allow you
            to create, configure, store and even combine the tools that
            you create. You use the Desk Tool to store groups of related
            tools together. The Directory Tool opens into a directory



                                                    Aporia User Manual 1


                                                 Chapter 1: Introduction



            window that displays a list of the files in a directory
            which can be copied, moved, renamed, and sorted. The Tree
            Tool displays a graphic representation of your hard disk's
            directory structure. Several other tools are used to create,
            copy, and customize tools, as well as configure the way they
            behave.

            Because of the flexibility and power of the tools concept,
            Aporia has features that satisfy both the power user and the
            computer novice. Novices can create tools for their programs
            with one click of the mouse in the directory window. File
            management with Aporia is easy and intuitive. Power users
            are provided with everything they need to create a fully
            customized work environment. Aporia can be used in the
            creation of integrated applications on stand alone systems
            or on local area networks.


       1.2 USER CREATED TOOLS


       1.2.1 Tools are Attached to Files

            When you create a tool in Aporia you attach it to a
            particular file existing on one of your disk drives. In fact
            in most cases Aporia attaches the tool to the file for you.
            This tool then becomes a graphic representation of the file.
            As long as the tool is visible on your display you have easy
            access to the file. User tools can be run, no matter what
            kind of file they represent. If the file is a program, then
            running the tool runs that program. You can also run a tool
            by selecting the tool of a data file you want to work with
            (such as a document file) and dragging it onto the tool of a
            program (such as a word processor).

            Since you can see the tools you work with on your desk top
            you do not have to worry about remembering short file names
            contained in endless directories each containing many files.
            Your work becomes much more identifiable. You can
            personalize your file, with long names and icons of your
            choice. Also, since data files can be run, you don't need to
            worry about the programs so much anymore. Just click on your
            tool and get to work.







                                                    Aporia User Manual 2


                                                 Chapter 1: Introduction



       1.2.2 You Design Your Own Tools

            You can design the tools you create with names that can be
            up to 30 characters long and an icon. This icon can be
            chosen from over a 100 color and monochrome icons provided
            with Aporia. You can also create your icon using a paint
            program or by capturing an image from the screen. This
            ability to customize your tools appearance can help you to
            better organize your work. For example you can give all the
            files for a project the same icon. Aporia was designed to
            help you get real work done, but we also hope it will help
            people to personalize their computing environment. Many
            people put works of art or posters on their walls to
            personalize their office. Aporia lets you do the same thing
            with your electronic office.




       1.3 OVERVIEW OF THE BASIC TOOLS

            The following is a general overview of each of the basic
            tools provided by Aporia:


       1.3.1 Desk Tool - Storage

            The Desk Tool is a storage place for other tools. Think of
            the entire Aporia environment as an office and each Desk
            Tool as a desk. In an office there is a desk for the
            secretary, a desk for the book keeper, and a desk for the
            order entry clerk. Likewise in Aporia you can have a desk
            for word processing, a desk for spreadsheets, and a desk for
            database management. Since programs, data files, and even
            other desks can be placed in Desk Tools, they provide a
            powerful tool for organizing your work. Desks can also be
            run which means you can run a group of programs with one
            click of the mouse.


       1.3.2 Directory Tool - File and Tool Management

            The Directory Tool has a look and a set of menus similar to
            the MS-DOS Executive. While it performs similar functions it
            is both more powerful and easier to use. You have any number
            of Directory Tools open on screen at a time, each showing a
            different directory. Files can be copied and moved between
            directories using only the mouse. The Directory Tool also



                                                    Aporia User Manual 3


                                                 Chapter 1: Introduction



            gives you powerful options for customizing how your files
            are displayed. You can create permanent subsets of the files
            in a directory to create "virtual" directories.


       1.3.3 Tree Tool - Directory Management

            The Tree Tool works in close conjunction with the Directory
            Tool to help manage your hard disk. It displays a graphical
            representation of your disk drives' directory structure. You
            use it to move quickly from one directory to another,
            viewing the files in each directory with a special Directory
            Tool that changes as you select a different directory in the
            tree. You use the tree to create multiple directory windows
            which you can save as Directory Tools. You also use the Tree
            Tool to create, remove and rename directories. You can have
            any number of Tree Tools open on the screen, each showing
            the directories of a different disk drive.


       1.3.4 Options Tool - Customizing Tools

            The Options Tool lets you set various options for tools such
            the icon and name it will have. Aporia comes with over 100
            different color and monochrome icons from which you can
            choose or you can specify the name of an icon that you
            create and capture using the Aporia Image Maker utility. You
            have complete control over how and where you want the tool
            to run. The Options Tool also lets you set general options
            for Aporia such as the size of tool icons and the color,
            size and, typeface of tool text.


       1.3.5 Copy Tool - Duplicating Tools and Files

            The Copy Tool's primary function is to make copies of tools.
            You can also use it to copy files, though in most cases you
            will want to use Directory Tools for this.


       1.3.6 Trash Tool - Removing Tools and Files

            The Trash Tool is used to remove both tools and files. It
            provides a powerful Trash Management feature which lets you
            restore files that you delete accidentally.





                                                    Aporia User Manual 4



                                                 Chapter 1: Introduction



       1.3.7 Size Tool - Sizing Windows and Tools

            The Size Tool allows you to set the size of any tool's
            window. This is a very powerful utility for customizing your
            screen so that each time you run a program it will be
            displayed in the same place with the same size.


       1.3.8 Hide Tool - Showing and Hiding Tools

            The Hide Tool is used to hide any of the tools on your
            screen. This is helpful in avoiding a cluttered display. You
            also use it to "open" and "close" the drawers of a desk so
            that the tools contained in a desk can be put away when not
            in use.


       1.3.9 Help Tool - Getting Help

            The Help Tool provides general help on using Aporia as well
            as specific help in using each basic tool. You can customize
            the Help Tool to provide help for any tool that you create.


       1.3.10 Notes Tool - Keeping Notes

            The Notes Tool lets you keep notes for a tool to which you
            always have quick and easy access. This is very useful when
            you have files, such as graphics files, to which there is no
            easy way to add textual information.





















                                                    Aporia User Manual 5



                                                 Chapter 2: Installation




       2. CHAPTER 2: INSTALLATION



       2.1 SYSTEM REQUIREMENTS

            Aporia will run on any system set up to use Microsoft
            Windows 2.0 or later. When running it only uses only about
            65 kilobytes of memory.

            Aporia requires a mouse or some other type of pointing
            device. The graphical, object-oriented nature of Aporia
            would make it very awkward to use without a pointing device.
            If you don not have space next to your keyboard for a mouse
            then consider a track ball takes up less space.

            Aporia lets you display your tools with color icons. Some
            color icons are provided with Aporia and the Image Maker
            program provided lets you capture or create additional
            icons. In order to maintain compatibility with all versions
            of Windows these icons are stored in a device dependent
            bitmap format call Aporia Image Files (AIF). For users of
            Windows 3.0 or higher we provide two sets of AIF files. One
            set (stored in the self extracting file AIF_16.EXE) is for
            EGA, VGA, and SuperVGA display systems running in 16 color
            modes. A second set (in file AIF_256.EXE) is for SuperVGA
            256 color modes. Users with other types of displays may not
            be able to use these icons. Users with VGA monochrome
            monitors can use these AIF files provided they have set
            Windows to use the VGA color driver (and not "VGA with
            monochrome monitor"). If the AIF files provided do not work
            with your system you will still be able to use the set of
            monochrome icons provided with Aporia or you may use Image
            Maker to create your own.


       2.2 INSTALLING APORIA ON YOUR SYSTEM

            You install Aporia by running the SETUP_AP.EXE setup program
            provided on the Aporia distribution disk. The setup program
            copies all Aporia program files into the directory where you
            have Windows installed. It will also create a directory
            named APORIA on the same drive where Windows is installed.
            In this directory Aporia will store special files that it
            uses. Once you have started Aporia you can change the APORIA
            directory to some other directory on any drive that you




                                                    Aporia User Manual 6



                                                 Chapter 2: Installation



            wish. Refer to Chapter 4, Aporia Reference, in the section
            on the Options Tool, for an explanation of how to do this.

            To install Aporia insert the disk provided into your A:
            (floppy) disk drive. At the DOS prompt type:

                 A:<Enter>

            making A: the current drive and then type:

                 SETUP_AP<Enter>

            This runs the Aporia setup program. You will be ask some
            questions about how you want Aporia setup. The program will
            then copy the Aporia program files into the directory where
            you have Windows installed. It will also create a directory
            named APORIA on the same drive where Windows is installed.
            In this directory Aporia will store special files that it
            uses. Once you have started Aporia you can change the APORIA
            directory to some other directory on any drive that you
            wish. Refer to Chapter 4, Aporia Reference, in the section
            on the Options Tool, for an explanation of how to do this.


       2.2.1 Using Aporia As The Windows Shell

            If you are using Windows 3.0, when the setup program runs
            you will be asked if you wish to make Aporia your Windows
            shell. This means that each time you run Windows Aporia will
            be the first that runs instead of the Program Manager
            provided with Windows. By running Aporia as the Windows
            shell you will save the memory normally used by the Program
            Manager. You can still use the Program Manager by running it
            as you would any Windows program. If you decide not to make
            Aporia the Windows shell when you run the setup program you
            can set it to be the shell later by changing a setting in
            the SYSTEM.INI file. Refer to Chapter 5, Advice for Experts,
            in the section on Running Aporia as the Windows Shell for
            and explanation of how to do this.

            When you use Aporia as the Windows shell it ignores the
            "Run=" and "Load=" setting in the WIN.INI file. The reason
            for this is that Aporia provides a much easier and powerful
            way to do this by setting a tool's "Run on Start-up" option.
            Using this setting you not only make a tool's program run
            when you first start but you can also control the size and
            position of its window.




                                                    Aporia User Manual 7



                                                 Chapter 2: Installation



       2.2.2 Creating Tools From Program Manager Setup

            When you run Aporia for the first time you will be asked if
            you wish to automatically create Aporia tools for all of the
            programs you have setup in the Program Manager. A dialog box
            will appear listing each of the groups you have setup in
            Program Manager. You can select which of these groups you
            wish to use to set up tools. For each group you select an
            Aporia desk will be created which contains tools for the
            same programs and files as set up in the group. This is a
            good way to get a quick start with Aporia since your
            programs will be available to use with Aporia right away.

            Please be patient during this process as it can take Aporia
            a while to find all of your groups files and create Aporia
            tools. If you prefer not to run this procedure the first
            time you run Aporia you can always do so later by using the
            Load Tools command found on the system menu which pops up
            when you click on the Aporia program icon.
































                                                    Aporia User Manual 8



                                              Chapter 3: Getting Started




       3. CHAPTER 3: GETTING STARTED, A TUTORIAL


            The following is a short tutorial to get you familiar with
            the basic operation of Aporia. It is assumed that you have
            at least a basic knowledge of how to use Windows including
            the use of the mouse, menus, scroll bars, and the
            manipulation of windows.

            Using Aporia to its fullest capabilities requires that you
            acquire an understanding of the simple concepts behind it.
            This tutorial will attempt to teach you these concepts while
            showing you the basic operation of Aporia.

            This tutorial assumes that you already have Aporia properly
            installed but have not yet set up any of your own tools. If
            you have already set up some tools it will not cause you any
            problems when using this tutorial, but your screen may
            appear differently than as described in this tutorial.


       3.1 RUNNING APORIA

            How you run Aporia depends upon whether or not you have set
            it up as the Windows shell and upon what version of Windows
            you are using.

            If you have set up Aporia as your Windows shell it will
            automatically be the first program loaded each time you run
            Windows. Just run Windows as you normally would.

                 win<E><<enter>>

            If Aporia is not the shell and you have Windows 286 or
            Windows 3.0 or later, at the DOS prompt type:

                 win aporia<E><<enter>>

            If Aporia is not the shell and you have Windows 386, at the
            DOS prompt type:

                 win386 aporia<E><<enter>>

            When Windows comes up on your screen you will see ten icons
            along the right side of your screen. These icons are the
            basic tools that make up Aporia.




                                                    Aporia User Manual 9



                                              Chapter 3: Getting Started



            If you let Aporia set up tools from your Program Manager
            setup you will also see desk tools corresponding to your
            Program Manager groups. To see the tools in a desk double-
            click on the desk with the left mouse button. Aporia tries
            to organize the tools it creates around the desk they are
            stored in. You will probably want you re-arrange the tools
            to suit your tastes. Note that when you move a desk the
            tools in the desk move along with it. For this reason it's
            best to locate tools near to the desk in which they are
            stored. If you do not do this you may find that when you
            move a desk you will move some of the tools stored in it off
            the screen.

            Note: The way the tools appear on your display may differ
            from the illustrations in this manual depending upon the
            type of display adapter (such as EGA, VGA, etc) you have in
            your computer.


       3.2 USING TOOLS

            Aporia tools are visually similar to the icons that Windows
            uses to represent minimized programs and the icons in the
            Program Manager. They can also be arranged on the screen
            using the mouse in much the same way as Windows icons.


       3.2.1 Moving Tools

            Moving a tool is done by dragging it with the left mouse
            button.

                 Move the mouse cursor over the Tree Tool.

            Notice that the cursor changes to look like a hammer. It
            does this whenever it is over a tool.

                 Press and hold down the left mouse button.

            The cursor will change to look like a pair of pliers. It
            does this whenever you move a tool.

                 With the left button held down, move the mouse to drag
                 the tool to another area of the screen.

            As you move a tool its image is replaced by an outline. Once
            you "put the tool down" by releasing the left button, the
            image will return.



                                                   Aporia User Manual 10



                                              Chapter 3: Getting Started



                 Release the left mouse button. The tool will reappear
                 at the place you dragged it to.


       3.2.2 Running Tools

            Running a tool is a simple matter of placing the mouse
            cursor over the tool and double-clicking the left mouse
            button.

                 Move the mouse cursor over the Tree Tool and double
                 click the left button.

            The Tree Tool will open up to a window displaying the
            directories on your hard drive. In the next section you will
            learn how to use this tool.


       3.2.3 Getting Help On Using Tools

            You can get quick help on how to use any of the basic tools
            using the Help Tool.

                 Use the mouse to move the Tree Tool over the Help Tool,
                 making sure that the upper left corner of the Tree Tool
                 is over the Help Tool, and release the mouse button.

            A dialog box appears explaining the basic information you
            need to know to use the Tree Tool.

                 When you are done reading the help text, click the
                 mouse button on the OK button in the dialog box to
                 remove it from the screen.

            Help is available for all of the basic tools in this way.

            Important: The upper left corner of a tool is its "hot
            spot". This means that whenever you move one tool over
            another to perform some action, you should make sure that
            its upper left corner is over the tool below.











                                                   Aporia User Manual 11



                                              Chapter 3: Getting Started



       3.3 CREATING TOOLS


       3.3.1 The Tree Tool

            The Tree Tool, which should already be open on your screen,
            displays a graphical representation of the directory
            structure of a disk drive. You use it in conjunction with
            Directory Windows to quickly get at your files. Think of the
            Tree Tool as a map for your disk drives. With the Tree Tool
            you can quickly find a directory and then open a window into
            that directory to get to the directory's files. You also use
            the Tree Tool to create, delete, and rename directories.

                 Click on the down arrow in the Tree Tool scroll bars
                 until the directory where your Windows program files
                 are located comes into view. If your Windows directory
                 is on a drive other than the one currently loaded into
                 the tree, you will first have to use the Drives menu to
                 change to that drive.

                 Double click on your Windows directory with the left
                 mouse button.

            A Directory Window will appear on your screen. The Aporia
            Directory Window is similar in appearance and function to
            the MS-DOS Executive. It displays a listing of all the files
            located in one directory.


       3.3.2 Creating User Tools

            One of the most important uses of Directory Windows is to
            allow you to create your own tools. These tools you create
            are called user tools. When you create a user, Aporia
            creates a new tool which is attached to a file on your disk
            drive. This file can be either a program or a data file
            (such as a text file).

                 Using the scroll bars in the Directory Window, find the
                 listing for the file named NOTEPAD.EXE. You can use the
                 Directory Window View menu commands just as you do for
                 the MS-DOS Executive to help you find the file if you
                 like.

            The NOTEPAD.EXE file is the executable file for the Windows
            Notepad program. If you have for some reason deleted this




                                                   Aporia User Manual 12



                                              Chapter 3: Getting Started



            from your drive you can use any program that will read a
            plain text file.

                 Double click with the right mouse button on the
                 NOTEPAD.EXE file listing.

            A new tool named "notepad.exe" will appear in the upper
            right corner of your screen.

                 Using the mouse, move the tool you just created to an
                 open area of your screen.


       3.3.3 Creating Directory Tools

            Aporia Directory Windows can be created in a number of
            different ways, each of which has its own advantages. The
            way you just did it is useful when you want to quickly open
            multiple Directory Windows in different directories. Another
            way is to use the Tree Tool Options menu to create a
            Directory Window that is "attached" to the tree. This window
            always displays the directory that is currently highlighted
            in the tree.

            The third, and possibly most powerful way to create a
            Directory Window is with a Directory Tool. The advantage of
            using Directory Tools is that they save any settings you
            make in their Directory Windows, thus allowing you to store
            "views" of the files you work with that match the way you
            work.

                 Make sure that the Directory Window for your Windows
                 directory is still open on your screen. Using the
                 mouse, open the Special menu in the Directory Window
                 and choose the Make Directory Tool command.

            A new Directory Tool will appear in the upper right corner
            of your screen. From now on each time you double click the
            left mouse button on this tool a Directory Window will
            appear displaying your Windows directory.

                 With the Directory Window for your Windows directory
                 still open, find the file named AP_READ.ME and double
                 click the right button on over it.

            A tool named "AP_READ.ME" will appear on your screen.





                                                   Aporia User Manual 13



                                              Chapter 3: Getting Started



       3.3.4 Using the Copy Tool

            Another way to create a new tool is with the Copy Tool. You
            will now use the Copy Tool to create a new Desk Tool which
            later on you will use to store all of the tools you are
            creating.

                 Using the mouse drag the Desk Tool (which by default is
                 located at the upper right corner of your screen) onto
                 the Copy Tool and release the mouse button.

            A new Desk Tool will appear on the right side of your
            screen.

                 Move the newly created Desk Tool to an open area of
                 your screen.

            When a tool is copied it will have the same appearance as
            the tool from which it is was copied. Later on you will
            learn how to customize your tools so that each one has a
            unique look.


       3.4 USING YOUR TOOLS

            You should now have four new tools on your screen. Pretty
            icons are nice but the real power of tools is in using them.
            All Aporia tools, whether basic tools such as the Desk and
            Directory Tools you created, or user tools such as the
            Notepad program or text file, are run by double clicking on
            them with the left mouse button.


       3.4.1 Running Programs

                 Move the mouse cursor over the "notepad.exe" tool and
                 double click the left mouse button.

            The Notepad program will run, opening a window on your
            screen.

                 Close the Notepad program.


       3.4.2 Running Files

            Files can be run by dragging their tools onto the tool of
            the program you want them to run in. This causes the program



                                                   Aporia User Manual 14



                                              Chapter 3: Getting Started



            tool to run, and load the file associated with the tool to
            be loaded.

                 Move the mouse cursor over the "ap_read.me" tool. Hold
                 down the left mouse button, drag the tool over the
                 "notepad.exe" tool, and release the button.

            The Notepad program will run with the AP_READ.ME file
            loaded.


       3.5 ORGANIZING YOUR WORK

            One of the most powerful features of Aporia is the ability
            it gives you to organize your work. The primary tool you use
            to do this is the Desk Tool.


       3.5.1 Using Desk Tools

            The Desk Tool acts as a container for other tools. All of
            the tools you create are stored in Desk Tool drawers. Desk
            drawers can be opened and closed, allowing you to display or
            hide the tools inside. By using desks you can group related
            programs and files together.

                 Using the mouse, drag the "ap_read.me" tool onto the
                 Desk Tool you created earlier.

            Aporia prompts you to confirm that you want to place the
            tool into the desk's drawer.

                 Click on the OK button to confirm.

                 Now drag the Directory Tool you created onto this Desk
                 Tool also.

            Aporia will display the same prompt again.

                 Click on the OK button to confirm.

            You now have two tools in this Desk Tool.









                                                   Aporia User Manual 15



                                              Chapter 3: Getting Started



       3.5.2 Hide a Desk's Contents

            When you are done using a desk you can close its drawer,
            that is hide what it contains, by double clicking on it with
            the left mouse button.

                 Double click over the desk you created with the left
                 mouse button.

            The directory and "ap_read.me" tools disappear.

                 Double click over your Desk Tool again.

            The directory and "ap_read.me" tools reappear.


       3.6 CUSTOMIZING TOOLS

            Aporia provides a large number of ways for you to customize
            your tools. You change a tool's icon, its name, and tell the
            tool how you want it to run. Only a few of the most
            important options will be covered in this tutorial. To
            learn, more refer to Chapter 4, Aporia Reference.


       3.6.1 Using the Options Tool


         Changing Tool Names

            Most of the customizing you will perform on tools will be
            done with the Options Tool. Let's use it now to customize
            the tools you just created.

                 Drag the Desk Tool you created onto the Options Tool.

            The Options Tool dialog box appears. You use this dialog to
            customize all of the different types of tools. Note that not
            all of the options have an effect on all of the tools.

                 The Displayed Name field should be highlighted.
                 Type: Aporia Tutor<Enter>.

            The Options Tool dialog box will disappear and the name of
            the Desk Tool is now changed to "Aporia Tutor."

                 Drag the Directory Tool you created onto the Options
                 Tool.



                                                   Aporia User Manual 16



                                              Chapter 3: Getting Started



                 In the Displayed Name field type: Windows<Enter>.

            The Directory Tool's name is now "Windows."


         Changing Tool Icons

            Aporia uses two types of icons. There are color icons which
            are stored as separate files and there are "built-in"
            monochrome icons which are stored within the Aporia program.
            The color icons bring you the advantages of full color and
            the ability to create your own icons. The monochrome icons
            will work with any type of display running any version of
            Windows.

            You will now use the "notepad.exe" tool you created earlier
            to learn how to use the two types of icons.

                 Drag the "notepad.exe" tool onto the Options Tool.

            If you system is set up to use the color icons you will the
            text "NOTEPAD" in the Image File field of the Options Tool
            dialog box. This is the name of the Aporia image file (AIF)
            for the Notepad program provided with Aporia. Notice that
            the Options dialog also displays the image for the Notepad
            program just as it appears on the tool you created. When you
            created this tool Aporia searched for an AIF file with the
            same name as the program.

                 Press the <Tab> key three times until the Image File
                 field is highlighted. When the field is highlighted
                 press the <Delete> key.

            When you remove the name from the Image File field the image
            displayed in the Options dialog changes to display one of
            the built-in monochrome icons. Also a scroll bar appears
            below the icon. Using this scroll bar you can choose from
            the many monochrome icons. Try using the scroll bar now to
            view the various icons.

                 Make sure the cursor is still in the Image File field
                 and type: notepad

            The icon displayed will change back to the color Notepad
            icon and the scroll bar will disappear. You can enter the
            name of any AIF file stored in your IMAGES in this field.
            Refer to Chapter 4 in the section on the Options Tool for
            description of AIF files and the IMAGES directory.



                                                   Aporia User Manual 17



                                              Chapter 3: Getting Started



         Tools Without Icons

            One important benefit to being able to name your tools is
            that it allows you to give files names which are much longer
            (up to 30 characters) than the eight character limit imposed
            by MS-DOS. This can make it much easier to identify files.

            When you give a tool a particularly long name you may want
            to turn off the icon for that tool. The icon for a tool
            always stretches to be as wide as the name. With a long name
            an icon can take up a lot of space on the screen and may
            become distorted in appearance.

                 Drag the "ap_read.me" tool onto the Options Tool.

                 Press the <Tab> key once, highlighting the "Displayed
                 Name" field and type: Aporia Readme File

                 In the box labeled "Show..." click on the check box
                 labeled "Image" to turn off that option.

                 Click on the OK button to close the dialog box.

            The name of the "ap_read.me" tool has changed to "Aporia
            Readme File."


       3.6.2 Using the Size Tool

            The ability to run multiple programs in different windows
            has always been one of Windows most useful features. The
            annoying thing about this is that when you run multiple
            programs you have to size and move each one to create an
            arrangement that works well for you. With Aporia this is no
            longer a problem. Using the Size Tool can store the size and
            position of a tool's window so that each time you run the
            tool its window will appear in a size and position that you
            choose.

            Let's size the "Notepad" tool.

                 Double click the left mouse button over the "Notepad"
                 tool to run it.

                 Size and move the Notepad window to any position you
                 like.

                 Drag the "Notepad" tool onto the Size Tool.



                                                   Aporia User Manual 18



                                              Chapter 3: Getting Started



            A dialog box appears giving you the options to either set
            the tool's window size or to clear it.

                 Click on the OK button.

            The size cursor appears.

                 Move the cursor over the title of the Notepad window
                 and click the left button.


       3.7 MANAGING YOUR FILES AND DIRECTORIES WITH APORIA

            Aporia has powerful tools for managing the files on your
            hard drive. The primary tools for file management are the
            tree and Directory Tools.


       3.7.1 Managing Directories

            As you have already seen, the Tree Tool provides a graphical
            display of the directories on a disk drive. It can be used
            as a way to create Directory Windows. You also use the Tree
            Tool to create, delete, and rename directories.


         Creating a Directory

            Creating a directory with the Tree Tool is easy. You simply
            select the directory in which you want the new directory to
            be located, choose the Create command from the Directories
            menu, and enter the name you wish to give to the new
            directory. Let's create a new directory in the Aporia
            directory on your "C" drive.

                 Make sure the Tree Tool is open and that the current
                 drive is "C".

                 Find the"APORIA" directory and select it by clicking on
                 it with the left mouse button.

                 From the Directories menu choose the Create command.

            A dialog box appears prompting you to enter the name of the
            directory you wish to create.

                 Type: temp<Enter>




                                                   Aporia User Manual 19



                                              Chapter 3: Getting Started



            The dialog box disappears and a the "TEMP" directory appears
            beneath the "APORIA" directory.


       3.7.2 Managing Files

            You use Directory Windows for most of your file management
            needs.


         Using the Tree Tool Directory Window

            Earlier you created a Directory Window by clicking on a
            directory in the tree and by using Directory Tools. Another
            way is to create a Directory Window which is attached to the
            Tree Tool. The benefit of this type of Directory Window is
            that as you change the selected directory in the tree the
            Directory Window is updated to show its files. You turn this
            window on and off using the Tree Tool Options menu.

                 From the Options menu choose the Directory Window
                 command.

            A Directory Window appears displaying the currently selected
            directory.

                 Click the left mouse button on the "APORIA\TEMP"
                 directory to select it.


         Selecting Files

            You select files in a Directory Window by clicking on them
            with the mouse or with the cursor keys. Selected files have
            their text and background colors reversed. Since the
            "APORIA\TEMP" directory is empty, you will now open another
            directory that has files in it.

                 Double click the left mouse button on the "Windows"
                 Directory Tool you created earlier.

            A Directory Window for the your Windows directory appears.

                 Click the left mouse button on the first file listed in
                 the window.

            Additional files can be selected by holding down the
            <Control> key while you click with the mouse.



                                                   Aporia User Manual 20



                                              Chapter 3: Getting Started



                 Hold down the <Control> key and click on another file.

            You should now have two files selected.


         Copying Files

            You can copy files by selecting the ones you want to copy
            and dragging them to the Directory Window you want to copy
            them to.

                 In the Directory Window for the Windows directory first
                 locate the cursor over the file you want to copy and
                 then press and hold down the left mouse button.

            The cursor changes to a graphic representation of a file
            being copied as illustrated above.

                 Holding down the left button, move the cursor over the
                 window for the"APORIA/TEMP" directory and release the
                 button.

            A dialog box appears asking you to confirm the copy.

                 Click on the OK button to confirm.

            The cursor changes to an hour glass while the files are
            copied.


         Moving files

            You can move files from one directory or drive to another
            just as you copy them. The only difference is that to move
            files you use the right mouse button.


         Deleting Files

            Deleting files is similar to copying them except that
            instead of dragging the file onto another Directory Window
            you drag it onto the Trash Tool.

                 In the "APORIA\TEMP" Directory Window locate the cursor
                 over the file you want to delete and then press and
                 hold down the left mouse button.

            The copy cursor appears.



                                                   Aporia User Manual 21



                                              Chapter 3: Getting Started



                 With the left button still down, move the cursor over
                 the Trash Tool and release the button.

            A dialog box appears prompting you to confirm that you want
            to delete the files.

                 Click the mouse button on the OK button to delete the
                 files.


         Deleting Directories

            To delete a directory, select the one you want to delete in
            the Tree Tool and use the Delete command. You can not delete
            a directory if it contains any files.

                 Select the APORIA\TEMP directory, open the Directories
                 menu and choose the Delete command.

            A dialog box appears asking you to confirm.

                 Click on the OK button to carry out the deletion.


       3.8 SUMMARY

            You have now learned the basic functions of Aporia. You
            should now be able to:

            1.   Create user tools.

            2.   Use the Copy Tool to make new Desk Tools.

            3.   Use the Desk Tool to organize your tools.

            4.   Use the Tree Tool to view and manage directories and
                 make Directory Tools.

            5.   Use Directory Windows to manage your files.












                                                   Aporia User Manual 22



                                             Chapter 4: Aporia Reference




       4. CHAPTER 4: APORIA REFERENCE


            This chapter of the manual contains a detailed description
            of each of the Aporia basic tools, how to create your own
            tools, and how to manage the tools you have created. If you
            are new to Aporia you probably want to read the first three
            chapters before getting to this one. Examples are give in
            this chapter only for those functions not covered in the
            tutorial (Chapter 3).


       4.1 CREATING TOOLS

            There are number of ways to create tools. Any tool can be
            duplicated using the Copy Tool. User tools can be created
            from Directory Windows. Directory Tools can be created from
            Directory Windows and from the Tree Tool.


       4.1.1 Creating User Tools from a Directory Window

            The easiest way to create new user tools from the files on
            your disk drives is from a Directory Window. To create a new
            tool just double-click with the right mouse button over the
            name of the file in the Directory Window that you want to
            make into a tool. The new tool will appear on the screen and
            flash momentarily so you can easily spot it.

            You can also create user tools using the Directory Window
            Make User Tool command found on the Special menu. The
            advantage of using this command is that it lets you create a
            number of tools at once. To use it first select the files
            you wish to make tools for and then choose the command.
            Refer to the section on Directory Tools in this chapter for
            a complete description of how this command is used.

            When you create new tools they will initially be stored in
            which ever desk the tool you created them with is in. When
            you are going to create a large number of tools that will
            all go into the same Desk Tool, first store the directory or
            Tree Tool you are going to create them with in that desk.
            This will save you from having to copy each of the tools
            into this desk after you create them.

            When you create a new tool Aporia searches in the IMAGES
            directory for an Aporia image file with the same base name



                                                   Aporia User Manual 23



                                             Chapter 4: Aporia Reference



            as the file you are creating the tool for. If such a file
            exists it will be used as the image file for this tool. If
            you wish you can later change the image file to something
            else.


       4.1.2 Creating Tools with the Copy Tool

            You can create new tools by duplicating an existing tool
            with the Copy Tool. This is the only way to create new basic
            tools other than with Directory Tools. Tools created this
            way inherit all of the settings of the tool they were
            created from except for the tool's window size. Refer to
            Chapter 3, Getting Started for an example of how to use the
            Copy Tool.


       4.1.3 Creating Directory Tools

            Directory Tools can be created from Copy Tools, Tree Tools,
            and Directory Windows. In the Tree Tool window they are
            created by double-clicking the right button over the
            directory you want to create the tool for. From Directory
            Windows you create them using the Make Directory Tool
            command on the Special menu.


       4.2 RUNNING TOOLS

            To use tools you run them. There are two ways to run a tool:
            double-clicking on it or dragging another tool onto it:


       4.2.1 Double-clicking Tools

            To double-click, put the cursor (which will change to a
            hammer when over a tool) onto the tool, and press and
            release the left mouse button twice quickly.  The tool will
            flash, and the cursor will change to an hourglass, and the
            program attached to the tool will run.


       4.2.2 Dragging One Tool onto Another

            You can drag a tool onto another by moving the mouse cursor
            onto the tool, pressing down the left mouse button and,
            keeping the button down, move the mouse.  The cursor will
            become a pair of pliers and as the mouse moves the tool will



                                                   Aporia User Manual 24



                                             Chapter 4: Aporia Reference



            move or "drag", along with it.  Move the tool so that its
            upper-left corner, the hot spot, lies inside of the tool you
            want to run it on, then release the left button. This will
            run the tool below with the tool on top as an argument.

            You can cancel a drag at any time by pressing the right
            mouse button.


       4.2.3 Dragging a File onto a Tool

            You can drag a file from a Directory Window onto a tool.
            This will run the tool with file passed to it as an
            argument. See the section in this chapter on Directory
            Windows for a complete description of this function.


       4.3 MANAGING YOUR TOOLS

            Aporia tools can be arranged on the screen in any way that
            you wish. This allows you to group related tools together.
            Tool arrangements are saved between Aporia sessions so that
            each time you start Windows your tools will be arranged in
            the same way.


       4.3.1 Moving Tools on the Screen

            Moving a tool is done by dragging it with the left mouse
            button in the same way you move standard Windows program
            icons, as explained above.


       4.3.2 Moving Groups of Tools

            When you move a desk tool all tools contained in that desk,
            except for other desk, will move along with it. This
            provides an easy way to move a group of tools together. A
            tool's position on the screen will change when its desk is
            moved even if the tool is hidden at the time. When moving
            desks keep in mind that you may inadvertently move tools
            contained in it off of the screen.









                                                   Aporia User Manual 25



                                             Chapter 4: Aporia Reference



       4.3.3 Stacking Tools

            Tools can be stacked so that tools can be placed all or
            partially over other tools. This can be a way to have more
            tools on your screen without taking much space.

            Tools are stacked by holding down the <Ctrl> key while
            dragging one tool onto another tool. Normally, when you drag
            one tool onto another, the tool below will attempt to run.
            Holding down the <Ctrl> key prevents this from happening
            allowing you to stack tools.


       4.3.4 Canceling Moves

            If you begin to move a tool and decide you want to put it
            back where it came from, you can cancel the move by clicking
            the right mouse button. The tool will return to its original
            position.


       4.3.5 Getting Information About a Tool

            You can get brief information about a tool by double
            clicking on it with the right mouse button.

            A message box appears displaying the following information:

            Name:          The name of the tool
            Path:          The path name of the file it represents
            Dir:      The directory it will run in (blank means the
                           current directory)
            Args:          Any arguments it will be given when it is run
            Pos:      Were on the screen its window will be positioned
            In Desk:  The desk it is in and the other tools in that
                           desk.
            Parent Desk:   The desk that the tool's desk is in and the
                           other tools in that desk.

       4.3.6 The Aporia Menu

            The Aporia menu provides a number of commands that let you
            manage Aporia and get information about your Windows
            environment. You access the Aporia menu by clicking the left
            mouse button on the Aporia icon.


           About



                                                   Aporia User Manual 26



                                             Chapter 4: Aporia Reference



            Selecting this command displays an dialog box which provides
            information about Aporia. Pressing the HELP button displays
            a dialog box providing general help for Aporia. Pressing the
            REGISTER button displays a dialog box in which you can enter
            your Aporia registration name and ID number. If you have
            already entered your registration information pressing this
            button has no effect.


           Memory Status

            This command brings up a dialog box which displays memory
            information and, under Windows 3.0, the mode that Windows is
            running in.

            The information it displays will be different depending upon
            which version of Windows you are running and whether or not
            you have expanded memory installed in your system. If you do
            not have expanded memory, or are running Windows 3.0 in
            Standard or 386 Enhanced mode, it will display a single
            figure representing the total amount of memory available to
            your applications. Running in real mode with expanded memory
            it will display the amount of conventional memory available
            to Aporia, the total expanded memory you have in your system
            and the amount of expanded memory available for your
            applications.


           Save Tools

            This command saves all of your current tools and their
            options to disk. Normally Aporia only saves your tools when
            you exit either Aporia or Windows. You can use this command
            to assure that any changes you have made to your tools will
            not be lost in the event of a system crash.


           Load Tools

            When you use this command Aporia will ask you if you wish to
            automatically create tools based on the programs and files
            setup in Program Manager. This is the same procedure that
            Aporia asked you if you wanted to do when you ran Aporia for
            the first time. Read Chapter 2, Installation, for an
            explanation of this procedure.


           Blank Now



                                                   Aporia User Manual 27



                                             Chapter 4: Aporia Reference



            This command turns the screen blanker on immediately. It is
            disabled when screen blanker time set in the General Options
            dialog is set to zero.


       4.4 THE DESK TOOL


       4.4.1 Storing Tools

            Desk Tools (also referred herein simply as desks) store
            other tools. Each Desk Tool has a drawer in which you put
            other tools. All tools are in a desk. By default all tools
            are in the top desk which is the desk on your screen when
            you first install Aporia.

            To store a tool in a desk, drag in onto the Desk Tool icon
            you want it to be stored in. A tool can be in only one desk
            at a time. When you store a tool in one desk, it leaves the
            desk it was previously stored in.

            You can put a desk into a another desk.  Thus, you can make
            a tree of desks, each inside the other.  You can take a
            desk, and the desks in it, and attach it to  another desk,
            but you cannot put a desk into its own sub-tree; no desk can
            be inside itself.


       4.4.2 Hiding and Displaying a Desk's Contents

            When you double-click the left mouse button on a desk, the
            default action is to display or hide the contents of the
            desk. This can also be done by dragging the desk onto the
            Hide Tool. Think of displaying a desk's contents as taking
            them out of the desk's drawer and placing them on the
            desktop. Hiding the desk's contents is like putting them
            back in the drawer.

            If the contents of a desk are only partially displayed
            double-clicking the left button on the desk or dragging it
            onto the Hide Tool will cause all of the tools stored in the
            desk to be displayed. Doing this again will cause all of the
            desk's tools to disappear. The illustration below shows how
            this works:

            When you hide a desk's contents, each desk it contains and
            their contents are also hidden. When you re-display the




                                                   Aporia User Manual 28



                                             Chapter 4: Aporia Reference



            desk's contents, all the desks within it will be appear on
            the screen but their contents will remain hidden.


       4.4.3 Moving Desks

            When you move a desk tool all tools contained in that desk,
            except for other desk, will move along with it. To move a
            desk without moving its contents hold down the <Control> key
            while moving the desk and keep it pressed until you release
            the mouse button.


       4.4.4 Running Desks

            You can use the Options Tool to set the Run Desk's Contents
            option on for a desk so that double-clicking the left mouse
            button on it runs the desk. When a desk is run every tool
            stored in it will be run except for any Desk Tools within
            it. This allows you to run a group of applications with one
            action. When you use this option for a desk you can still
            hide and re-display its contents using the Hide Tool.


       4.4.5 Removing a Desk

            You remove a desk one at a time; that is, by dragging it
            onto the Trash Tool. When you remove a desk you remove all
            tools stored in that desk. For each tool in the desk you
            will be asked if you wish to delete the file attached to the
            tool. By pressing the Cancel button at any time you can
            abort the removal of the desk and its tools but any tools
            you have already deleted are gone.


       4.5 THE TRASH TOOL

            The Trash Tool has three primary functions. Deleting tools,
            deleting and trash management files. With Trash Management
            accidentally removed files can be recovered.


       4.5.1 Removing Tools and Files

            You remove a tool by dragging it onto the Trash Tool. If the
            tool is a user tool, you will be asked if you wish to remove
            the file that is attached to the tool. Using the Options
            Tool's General Options dialogue you can have Aporia prompt



                                                   Aporia User Manual 29



                                             Chapter 4: Aporia Reference



            you before it removes a tool. This prevents you from
            removing tools by mistake.

            You can delete files by selecting them in a Directory Window
            and dragging them onto the Trash Tool. Refer to Chapter 3
            for an example of how to delete files with the Trash Tool.


       4.5.2 Trash Management

            When you run the Trash Tool by double-clicking on it with
            the left mouse button, the following dialog box appears:

            When Trash Management is on, any file that is deleted is
            first copied to the !TRASH sub-directory of the APORIA
            directory, from which it can be recovered. You can recover
            the trash or empty it by double-clicking left on the Trash
            Tool and pushing the Manage the Trash button.  You will get
            a Directory Window which you can use to copy out removed
            files, or, to finally remove the trashed files entirely.

            When you set Trash Management on you will notice that file
            deletions will take longer than usual. This is because of
            the time it takes to store the files in the !TRASH
            directory.

            Important: The !TRASH directory is emptied each time you
            exit Aporia. Once you have left Aporia the files you deleted
            are gone for good.

            The Trash Management option is turned on and off using the
            Options Tool's General Options dialog box. Refer to the
            section in this chapter on the Options Tool for an
            explanation of how to set general options.


       4.6 THE NOTES TOOL


       4.6.1 Notes on Tools

            Any tool can record notes for the program or file it
            represents by dragging it onto the Notes Tool. By default,
            the Windows Notepad program is run. The first time you drag
            a tool onto the Notes tool you are prompted to create the
            Notes file. If you answer "yes" and create the file the next
            time you drag the tool onto the Notes tool the Notes file is
            loaded and ready for use. The default name of a tool's Notes



                                                   Aporia User Manual 30



                                             Chapter 4: Aporia Reference



            file is the first eight characters of the tool's name with
            the extension TXT.

            These two defaults, the Note Program and the Notes file, can
            be overridden for each tool by dragging it onto the Options
            Tool. The default Note Program can be specified for all
            tools by running the Options Tool.

            The default directory for Notes files is the Aporia
            directory, C:\APORIA\NOTES, and can be changed by running
            the Options Tool.


       4.6.2 General Notes

            Double-clicking, the left button on the Notes Tool itself
            provides general notes that can be used for anything at all.
            This can be used as a to-do list.

            The Notes Tool is very useful when you want to jot down
            notes about a file you are working on or a description of
            the various tools in a desk.


       4.7 THE HELP TOOL

            The Help Tool provides different types of help. Dragging any
            of Aporia's basic tools onto the Help Tool provides help on
            the use of that tool; dragging your own user tool lets you
            display your own customized help for that tool, finally,
            running the Help Tool provides a tutorial on Aporia.

            When used to provide help for user tools (those that you
            create) the Help Tool works much like the Notes Tool. Drag
            your tool onto the Help Tool to display or create a help
            file. The default notes program is Windows Notepad
            (NOTEPAD.EXE). The default name of a tool's help file is the
            first eight characters of the tool's name with the extension
            HLP. The default help file and help program can be changed
            on an individual tool basis by dragging the tool onto the
            Options Tool and setting the Help File there (leaving the
            field empty causes the tool to use the default), and the
            default Help Program can be changed for all tools by running
            the Options Tool and setting the general Help Program
            option.

            When you create a new tool for  program Aporia checks to see
            if there is a Window Help program help file for the program



                                                   Aporia User Manual 31



                                             Chapter 4: Aporia Reference



            located on your system's path. If there is it uses this file
            as the help file for this tool and Windows Help as the help
            program.

            The Help Tool is intended to be used to display files,
            rather than to create or edit them. The idea being that help
            materials can be created for a specific application and
            distributed to users in a read-only format. For simple help
            text, a browse program will work. For more advanced needs
            one of the hypertext programs available for Windows, such as
            the Windows Help program, could be used.

            Double-clicking left on the Help Tool displays the file
            APORIA.INT. This file, as distributed with Aporia, contains
            the text and graphics of the tutorial chapter of this
            manual. This file is normally located in your WINDOWS
            directory, but you can put it in any directory in your
            systems PATH. You can also change this file to provide any
            type of help information you wish.


       4.8 THE COPY TOOL

            The Copy Tool is used to copy tools. You can use it to copy
            both basic and user tools. The only way to make copies of
            the basic tools is with the Copy Tool (the Directory Tool
            can be duplicated by other means).

            You Copy Tools by dragging them onto the Copy Tool. An exact
            duplicate of the tool will appear on the screen, flashing
            for a moment so that you can find it easily. All the
            information in the tool is copied except for the size
            information. When copying a user tool the file attached to
            the tool is not copied, there is simply another tool
            referencing the file. Refer to Chapter 3 for an example of
            how to use the Copy Tool.

            If you double-click left on the Copy Tool alone a dialogue
            appears which you can use to copy files. This is the same
            dialog box that appears when you use the Copy command on the
            Directory Window File menu. A more efficient way of coping
            files is provided by using Directory Windows. Refer to the
            section on the Directory Tool later in this chapter for an
            explanation of how to use the copy dialog.







                                                   Aporia User Manual 32



                                             Chapter 4: Aporia Reference



       4.9 THE HIDE TOOL

            The Hide Tool is used to both hide and re-display tools on
            your screen.

            You hide a tool by dragging it on the Hide Tool. The tool
            will disappear from the screen. Once a tool is hidden it
            will remain hidden, even between Aporia sessions, until you
            use the Hide Tool to re-display it.

            To re-display a tool, drag the desk it is in onto the Hide
            Tool, and it will again appear on the screen.

            Desks work differently with the Hide Tool than other tools.
            When you hide a desk, all the tools in the desk, including
            other desks and everything in them, are hidden. The Desk
            Tool itself is not hidden. The contents of desks can also be
            hidden and re-displayed by double clicking on them with the
            left mouse button. Refer to the section on Desk Tools
            earlier in this chapter for a complete discussion on hiding
            and re-displaying the contents of desks.

            Double-clicking left on the Hide Tool will hide everything
            except the Hide Tool. This is a quick way to clean up the
            screen. Double-clicking on the Hide Tool again will re-
            display all tools that were on the screen when the Hide Tool
            was first double-clicked. Tools hidden this way will appear
            on the next Aporia sessions.


       4.10 THE OPTIONS TOOL

            You use the Options Tool to set various options about how a
            tool looks and behaves. You also use it to set general
            options for Aporia.


       4.10.1 Individual Tool Options

            You customize a tool by dragging it onto the Options Tool. A
            dialog box appears in which you can set a number of options.

            The different items you can set in the Options Tool dialog
            box include the following. Note that certain options that do
            not apply to a particular tool will not appear.


           Displayed Name



                                                   Aporia User Manual 33



                                             Chapter 4: Aporia Reference



            This field contains the tool's name. When you create a tool
            from a file, Aporia will insert the name of the file in this
            field automatically. You change this to any name you wish up
            to 30 characters long.


           Displayed Icon

            This window shows the icon currently displayed by the tool.
            When there is the name of an image file entered into the
            Image File field (see below) that image is displayed. If the
            Image File field is blank a built-in monochrome icon is
            displayed and a scroll bar appears below. Use the scroll bar
            to select one of over 50 different monochrome icons.


           Show

            Three check boxes control how the tool appears. Check the
            Icon box to display the tool with an icon. Check the Name
            box to display the tool with a name. These boxes can be used
            in any combination. The Dir Tool Dir Name box is used only
            for Directory and Tree Tools. When it is checked the
            Directory Tool displays the name of the directory it is
            attached to. When it is used with the Tree Tool any
            directory tools you create from the tree will display their
            directory names.


           Image File

            In this field you enter in the name of an image file that
            you wish to use for the tool's icon. The file must be
            located in the IMAGES directory (the IMAGES directory is by
            default located in your APORIA directory). These files must
            be created using the Image Maker program provided with
            Aporia. Image Maker lets you capture an icon, a window, or a
            portion of the screen that is saved as a bitmap. These files
            must have the extension "AIF".

            As you type in the name of the file Aporia will search for
            it in the IMAGES directory. If it finds the file it will
            display the bitmap in the Displayed Icon window. If it can't
            find the file no image will be displayed and Aporia will not
            let you leave the dialog until you either enter in the name
            of a file that does exist or clear the contents of the
            field.




                                                   Aporia User Manual 34



                                             Chapter 4: Aporia Reference



           Notes File

            Enter the name of a note file you want to associate with
            this tool. Use of this field is optional. By default the
            name for a tool's note file is the first eight characters of
            the tool's name with the extension "TXT".


           Note Editing Program

            Enter the name of a program you want to use to edit the note
            file for this tool. Use of this field is optional. The
            default note editing program is set in the general options.


           Help File

            Enter the name of a help file you want to associate with
            this tool. Use of this field is optional. By default name
            for a tool's help file is the first eight characters of the
            tool's name with the extension "HLP". This option is only
            used for user tools.


           Help Display Program

            Enter the name program you want to use to view the help file
            for this tool. Use of this field is optional. The default
            help viewing program is set in the general options. This
            option is only used for user tools.


           Program/File

            This field contains the name of the program or data file
            that is attached to the tool. It is the file that the tool
            represents. It can be any file on your disk drives. When you
            create a tool in a Directory Window, Aporia will copy the
            files path into this field automatically. You can change it
            as you wish. This option is only used for user tools. File
            names do not need to be the full path name, so long as they
            can be found on your DOS environment PATH.

            When you drag one file onto another the text in this field
            for the tool on top will be passed to the tool below. For
            example if you drag a tool for a text file onto a tool for a
            word processor, the word processor will load the text file
            listed in the top tool's Program/file field.



                                                   Aporia User Manual 35



                                             Chapter 4: Aporia Reference



           Directory To Run In

            This is the directory in which the tool will run. When the
            tool is run, Aporia makes this the current working
            directory, so long as the "No Chdir Before" running field is
            clear. When you create a tool from the Directory Window,
            Aporia will copy the file's directory path into this field
            automatically.

            This field is also used to specify the directory a Directory
            Tool will display and the drive that a Tree Tool will
            display.


           Default Arguments

            In this field you can enter a default argument that will be
            passed to a program listed in the Program/file field.

            If you enter ?? anywhere in this field Aporia will prompt
            you to enter arguments each time you run this tool. This is
            useful for a program which has may different command line
            options and for which you don't want to have a different
            tool for each of them.

            By entering %1 into the argument text, you can substitute a
            tool in its place.  Drag a tool onto one that is using a
            replaceable parameter, the dragged tools attached file (as
            listed in the Program/file field) will be substituted in
            place of the %1 in the argument list. Once all the
            substitutions are done the lower tools program is run with
            this argument list.  %0 is replaced by the tool's own
            program/file field. Refer to Chapter 5, Advanced Techniques,
            for an example of how you can use this feature to create a
            print tool for Aporia.


           Default/Fullscreen/Iconic

            This check box is be used to set how the tool's program will
            run. Clicking on the box will cycle through the three
            options. When it is set to Default the tool's program will
            run either with a default size and position determined by
            Windows or a size and position you have set with the Size
            Tool. If it is set to Full Screen it will run as a full
            screen (maximized) window. If it is set to Iconic it will
            load as an icon. Note that if you run a program Iconic and
            later open the program's window Aporia will not be able to



                                                   Aporia User Manual 36



                                             Chapter 4: Aporia Reference



            size the window, even if you have set its size with the Size
            Tool.


           No Chdir Before

            This causes the tool to ignore the directory entered in the
            Directory To Run In field. Use this option when you
            temporarily want to run a tool in the directory where its
            file is located.


           Run On Start-up

            Setting this option will cause this tool to be run each time
            you run Aporia. The tool will run whether or not it was
            visible on the screen when you last ran Aporia. You can run
            a set of tools that you commonly use by setting this field
            for each tool. Use of this option replaces the WIN.INI
            "Run=" and "Load=" settings.


           Run Desk's Contents

            Setting this option for a Desk Tool changes it so that
            double-clicking the left mouse button over the desk causes
            all tools contained in the desk to be run. By turning on the
            RUN ON START-UP option as well, you can run a group of
            programs each time you load Aporia.


         Protected Fields

            Some tools will not let certain fields be changed and will
            indicate this by not letting you edit those fields.


         Customizing the Options Tool

            To customize the Options Tool itself, double-click on the
            Options Tool and push the "Change Options Tool" button.


       4.10.2 General Aporia Options

            The general Aporia options can be set by double-clicking on
            the Options Tool.




                                                   Aporia User Manual 37



                                             Chapter 4: Aporia Reference



            The different items you can set in the Change Tool dialog
            box include:


           Set Tool Size

            Clicking on this button brings up a dialog box with which
            you can set the size of your tools. In the Size of a Tool
            field enter the size, in pixels (a pixel is the smallest
            point that your screen can display), that you want your
            tools' icons to be. The default tools size is 32 pixels.
            Changing your tools size to some other size may result in
            some distortion.

            A tool's icon is normally made up of both an icon and a
            displayed name. If you have made tools that have no
            displayed names you may notice that these tools are smaller
            than others on your screen. You may want to use the Extra
            amount to add to tools that are icons only field. This will
            increase the size of tools that are icons only by the number
            of pixels you specify. The default value for this field is
            0.


           Tool Name Font

            Clicking on this button brings up a dialog box with which
            you can set the typeface, size and color of the names for
            your tools. Changing the size of the font used will change
            the overall size of your tools. On monochrome displays you
            will probably want to make your font color white.


           Directory Font

            Clicking on this button brings up a dialog box with you can
            set the typeface, size and color of the directory names for
            your Directory Tools. Its function is identical to the
            dialog box you use to set the tool name font. This option
            only has an effect for Directory and Tree Tools which have
            the Show Dir Tool Dir Name option turned on.


           Set Screen Blanking

            Enter the number of seconds of no keyboard or mouse activity
            before the screen is blanking. Entering a value of 0 will
            turn off screen blanking and disable the Blank Now command



                                                   Aporia User Manual 38



                                             Chapter 4: Aporia Reference



            on the Aporia system menu. While a DOS application window
            has the input focus this time before screen blanking turns
            on is increase by a factor of four. This is done since
            Aporia has no knowledge of the keyboard activity in a DOS
            window. Screen blanking is disabled when you are using some
            Windows applications (such as the tutorial for Microsoft
            Excel) which handle keyboard and mouse input in a non-
            standard way.


           Enable Trash Management

            When this check box is set Trash Management enabled. When
            Trash Management is enabled, all files that you delete using
            Aporia are temporarily copied to a special trash directory
            !TRASH under the Aporia Directory. Running the Trash Tool
            will give you the choice of restoring accidentally deleted
            files.


           Ask Before Removing Tools

            When a tool is dragged onto the trash and this check box is
            set on Aporia will prompt you before it removes the tool.
            This is to help prevent the accidental removal of tools.


           Aporia Directory

            This is the drive and directory where Aporia stores various
            files and directories it uses.  These include the HELP,
            NOTES, !TRASH, and TOOLS directories, and various files. By
            default this directory is C:\APORIA but you can set it to
            some other drive and directory if you prefer. It should not
            be located on a ramdisk.


           Help Program

            This is the name of the default program used by the Help
            Tool to display help files. The default program is the
            Windows Notepad program. To specify another program enter it
            here. This default can be overridden for individual tools by
            setting the tools Help Program field.


           Notes Program




                                                   Aporia User Manual 39



                                             Chapter 4: Aporia Reference



            This is the name of the default program used by the Notes
            Tool to display note files. The default program is the
            Windows Notepad program. To specify another program enter it
            here.  This default can be overridden by setting the tools
            notes program field.


       4.11 THE SIZE TOOL


       4.11.1 Sizing and Positioning Windows Programs

            You use the Size Tool to size a window run by a tool. Each
            time you run a tool, its window will appear with the same
            size and in the same place.

            Tools are sized by dragging them onto the Size Tool. The
            procedure is as follows:

                 Run a window and put it at the desired position and
                 with the desired size. This does not have to be the
                 window of the program attached to the tool whose size
                 you want to set.

                 Drag the desired tool onto the Size Tool. A box appears
                 containing three buttons. Click on the "Yes" button to
                 size the tool, "No" to clear all size information from
                 the tool, and "Cancel" to exit making no changes.

                 After clicking on the "Yes" button, click on the window
                 whose size you want to save with the tool. For best
                 results click on the window's title bar.

            Refer to Chapter 3 for an example of using the Size Tool.


       4.11.2 Sizing Aporia Tools

            You can set the size of the tools themselves, by running the
            Size Tool itself. Tool size can also be set with the Options
            Tool. Refer earlier in this chapter to the section on the
            Options Tool, General Aporia Options, for a description of
            how to use this feature.








                                                   Aporia User Manual 40



                                             Chapter 4: Aporia Reference



       4.12 THE TREE TOOL

            The Tree Tool displays a graphical "map" of your disks'
            directories. It is used to manage directories and create
            Directory Tools and Windows. When run, the Tree Tool loads
            the disk drive specified in its Directory To Run In field.
            You can run multiple Tree Tool windows allowing you to
            easily work with files from different disks at the same
            time.


       4.12.1 The Tree Tool Window


         Selecting Directories

            You can scroll through the directory tree in the Tree Tool
            window using the mouse and scroll bars or the <Page Up>,
            <Page Down> and <UP> and <DOWN> cursor keys.

            Directories are selected by clicking the left button over a
            directory name or by moving the highlight to the directory
            using the cursor keys. Only one directory can be selected at
            a time.


         Creating Directory Windows and Tools

            Double-clicking the left button over a directory name
            creates a Directory Window for that directory. This can be
            done with the keyboard by moving the highlight to the
            desired directory and pressing the <Enter> key.

            Double-clicking the right button, over a directory name
            creates a Directory Tool for that directory.


         Reloading the Tree Tool

            In order to be able to show all of the directories on a disk
            drive the Tree Tool must search the entire disk to find
            every directory. On a hard disk with many directories this
            can take a long time, as much as ten seconds or more
            depending on the speed of the drive and the number of files
            on it.

            Aporia's Tree Tool greatly speeds up this process by storing
            the drives directory structure information in a cache file.



                                                   Aporia User Manual 41



                                             Chapter 4: Aporia Reference



            The only caution with this is that if you create, delete, or
            rename directories outside Aporia, the Tree Tool has no way
            of knowing about it. This means that any changes you make to
            directories do not appear until you reload the drive.

            Fortunately reloading a drive is easy. Just select the
            Reload command which appears at the bottom of the Tree Tool
            Drives menu.

            The Tree Tool will automatically reload a drive's directory
            information when the drive's directory cache file is more
            than two days old.  You can also reload directory
            information by selecting letter of the currently displayed
            drive from the Drives menu.


       4.12.2 The Tree Tool Menu

            The Tree Tool window's menu bar contains three menus:


         The Drives Menu

            This menu contains a list of all disk drives in your system.
            Use this menu to change the current disk drive displayed in
            the tree window. Changing the drive this way does not change
            the default drive for that Tree Tool. This is set by
            changing the Tools directory to run in field with the
            Options Tool.

            When you try to change the current drive to a floppy drive
            Aporia checks to make sure the drive is ready. If it is not
            selecting the drive will have no effect.

            The Drives menu also contains the Reload command mentioned
            above. Selecting this command reloads directory information
            for the drive currently displayed in the Tree.


         The Directories Menu

            This menu contains three commands which you use to maintain
            your directories. Before using any of these commands you
            must first select the directory where you want the commands
            to be carried out.


           Create



                                                   Aporia User Manual 42



                                             Chapter 4: Aporia Reference



            After you choose this command a dialog box appears in which
            you enter the name of the subdirectory you want to create in
            the currently selected directory.


           Delete

            This command deletes the currently selected directory. You
            are prompted to confirm that you want to carry out the
            deletion. You can not delete directories that contain files
            or subdirectories.


           Rename

            After you choose this command a dialog box appears in which
            you enter the new name you want to give to the currently
            selected directory. In this dialog box only the To field is
            enabled.


         The Options Menu

            This menu contains the Directory Window command. This
            command creates a special Directory Window which is attached
            to the Tree Tool. Each time you change the selected
            directory in the tree window the tree's Directory Window is
            changed to show that directory. When you move the tree
            window its Directory Window moves with it. The tree's
            Directory Window has all the function of any other Directory
            Window. For use of Directory Windows see the section on
            Directory Tools.

            If the tree's Directory Window is open when you close the
            tree, when you next open the Tree Tool its Directory Window
            will open automatically. Any options you set in the tree's
            Directory Window are saved between sessions, as they are for
            Directory Tools.


         The Special Menu

            This menu contains the three useful commands.


           Disk Information





                                                   Aporia User Manual 43



                                             Chapter 4: Aporia Reference



            This command displays information the disk drive currently
            displayed by the Tree Tool. Information includes the size of
            the drive, the amount of free space, the total number of
            directories.


           Make Directory Window

            This command creates a Directory Window in the directory
            currently selected in the tree. This is the same as if you
            double-clicked the left button on a directory in the tree.


           Make Directory Tool

            This command creates a Directory Tool in the directory
            currently selected in the tree. This is the same as if you
            double-clicked the right button on a directory in the tree.


       4.12.3 Additional Tree Tool Features


         Copying Files

            Dragging a user tool onto a Tree Tool (when an icon) copies
            that file to the disk directory specified by the Tree's
            Directory To Run In field.


         Quick Change of a Tools Directory

            Dragging a basic tool onto a Tree Tool (when an icon) will
            change its directory to the root directory of the disk drive
            that the Tree Tool is currently set to.


       4.13 THE DIRECTORY TOOL

            You use the Directory Tool to manage your files and to
            create user tools.


       4.13.1 Directory Windows

            Double-clicking the left button on the Directory Tool opens
            a Directory Window. Directory Windows can also be created
            from the Tree Tool.



                                                   Aporia User Manual 44



                                             Chapter 4: Aporia Reference



         The Directory Window Display

            Directory Windows display a listing of file information
            including each file's name, extension, size, date, time and
            attributes. Attributes are displayed by the letters "R",
            "A", "S", and "H" which stand for "read only", "archive",
            "system", and "hidden". A file can have any combination of
            attributes or none at all.

            You move through the Directory Window using the mouse and
            scroll bars or by using the cursor, <Page Up> and <Page
            Down> keys.


         Selecting Files

            Files in a Directory Window are selected by clicking on
            their listing with the left mouse button or by moving the
            highlight with the cursor keys.

            Multiple file selections can be made by holding down the
            <Control> key and clicking the left button on the file.

            When using the keyboard selections can be toggled on and off
            using the <space bar>.

            To select a continuous range of files first select the file
            to start the range. Then hold down the <Shift> key and click
            on the last file in the range. To select multiple ranges
            repeat this process keeping the <Control> key pressed on the
            first selection and both the <Control> and <Shift> keys
            pressed on the second.


         Running Files

            Files can be run from a Directory Window by either double
            clicking on them with the left button or by pressing the
            <Enter> key. Pressing the <Enter> will run all selected
            files.


         Creating Tools

            Double clicking the right button over a file will create a
            new user tool that is attached to that file. You can also
            create tools using a menu command (see below).




                                                   Aporia User Manual 45



                                             Chapter 4: Aporia Reference



       4.13.2 Managing Your Files With Directory Windows

            Directory Windows provide powerful features for copying,
            moving, deleting, and renaming files. Two methods are
            provided for carrying out this actions: direct manipulation
            and menu commands.

            Direct manipulation means that a selected group of files are
            dragged to another Directory Window to start a copy or move,
            or to the Trash Tool to be deleted. No menus are used, just
            the mouse.

            With Menu commands selected files can be copied, moved,
            deleted, and renamed. You must use menu commands to rename
            files.


         Using Direct Manipulation of Files


           Copying Files

            To copy files you must first have open Directory Windows for
            both the location and destination of the file(s) you want to
            copy. Select the files you want to copy and then hold down
            the left mouse button, this turns on the copy cursor.
            Holding down the button, move the cursor to the destination
            Directory Window and release the mouse button. You will be
            prompted to confirm that you want to copy the files. The hot
            spot for the copy cursor is the tip of the arrow.


           Moving Files

            When you move files they are copied to the destination
            directory and then deleted them from where they were
            originally.

            Moving files is identical to copying them except that you
            use the right mouse button. When you hold it down you will
            see the move cursor. The hotspot for the move cursor is the
            tip of the arrow.


           Deleting Files






                                                   Aporia User Manual 46



                                             Chapter 4: Aporia Reference



            The process for deleting files is identical to copying them
            except that instead of moving the copy cursor onto a
            Directory Window you drag it onto the Trash Tool.


           Dragging Files onto Tools

            You can drag a file from a Directory Window onto a tool.
            This will run the tool with file passed to it as an
            argument. This can be used to, for example, load a text file
            into a word processor when you have not created a tool for
            the file. You can drag the file with either the left or
            right mouse button. Make sure when you drag the file that
            the cursor's hotspot (the tip of the arrow) is over the tool
            you want to use. You can only drag one file at a time onto a
            tool. If multiple files are selected only the first listed
            in the window will be passed to the tool.


           Working With Multiple Files

            If you have selected multiple files and the mouse button is
            no longer pressed you can turn on the copy or move cursor by
            pointing the cursor to the area above, below, or to the
            right or the file listing in the Directory Window.

            Refer to Chapter 3 for examples of copying and deleting
            files.


       4.13.3 The Directory Window Menu

            The Directory Window's menu bar contains three menus:


         The File Menu

            The File menu contains commands for manipulating and running
            files.


           Run

            This command runs all files in the window that are selected.
            If no files are selected a dialog box appears into which you
            can enter the name of a program you wish to run.





                                                   Aporia User Manual 47



                                             Chapter 4: Aporia Reference



           Load

            This command loads all files in the window that are
            selected. After loading the programs will appear in their
            iconic state at the bottom of your screen. If no files are
            selected a dialog box appears into which you can enter the
            name of a program you wish to load.


           Copy

            When you select the Copy command a dialog box will appear in
            which the names of files that you want to copy and the
            destination where you wish to copy them can be entered. If
            any files are currently selected in the Directory Window
            they will appear in the From field in the dialog box.

            Standard DOS wildcard characters ("*" and "?") can be used
            in both the From and To fields. Multiple file specifications
            can be entered in the From field but not the To field. This
            can be very useful as it allows you, for example, to copy
            all files with the extensions "DOC" and "XLS" in one copy
            operation.


           Move

            The Move command works just like the Copy command except
            that it moves files from one location to another.


           Delete

            When you select the Delete command a dialog box will appear
            in which the names of files that you want to delete can be
            entered. If any files are currently selected in the
            Directory Window they will appear listed in the dialog box.

            As with the Copy command standard DOS wildcard characters
            and multiple file specifications can be used.


           Rename

            This command is used to rename files. After you choose this
            command a dialog box appears in which you enter the name of
            a file or files you want to rename and the new name you want
            if to have. If any files are currently selected in the



                                                   Aporia User Manual 48



                                             Chapter 4: Aporia Reference



            Directory Window they will appear in the Rename field in the
            dialog box.

            As with the Copy command standard DOS wildcard characters
            can be used. Multiple file specifications can be entered
            into the Rename field but not the To field. Since DOS does
            not allow two files in the same directory to have the same
            name, if you enter multiple file specifications into the
            Rename field you must use wildcards in the To field.


         The View Menu

            The View menu contains four groups of commands which control
            how the contents of the Directory Window will be displayed.
            In each group only one of the commands can be set on at a
            time. And is indicated by a check next to it.


           Long

            The Long command causes the window to display full
            information for each of the files. Long information includes
            the file name, extension, size, date, time, and attributes.
            Using this command also changes to the width of the window
            so that the entire width of the listing is displayed. This
            is the default command for the first group of View commands.


           Short

            The Short command causes the window to display only the name
            and extension for each of the files. Using this command
            narrows the width of the window to match the width of the
            listing.


           All

            The All command changes the window so that all files in the
            directory are displayed. This is the default command for the
            second group of View commands.


           Partial

            When you choose the Partial command a dialog box appears in
            which you can enter one or more file specifications. Only



                                                   Aporia User Manual 49



                                             Chapter 4: Aporia Reference



            those files which meet one of the specifications will be
            displayed. The standard DOS wildcards can be entered. For
            example entering a file specification of:

                 *.DOC A*.TXT

            will cause the window to only those files with the extension
            "DOC" and those files beginning with the letter "A" that
            have the extension "TXT". The specification is saved when
            the window is closed.

            When you enter a partial file specification in one Directory
            Window it will appear when you bring up the Partial dialog
            box in another Directory Window.


           Programs

            The Programs command changes the window so that only those
            files that are programs will be displayed. These files are
            those that have the extension "EXE", "COM", or "BAT".


           By Name

            The By Name command sorts the file listing so that files are
            displayed in alphabetical order based on the name of the
            file. This is the default command for the third group of
            View commands.


           By Date

            The By Date command sorts the file listing so that files are
            displayed in date and time order with the files with the
            most recent date and time at the top.


           By Size

            The By Size command sorts the file listing so that files are
            displayed in the order of their size with the files that are
            greater in size at the top.


           By Kind





                                                   Aporia User Manual 50



                                             Chapter 4: Aporia Reference



            The By Kind command sorts the file listing so that files are
            displayed in alphabetical order based on the extension of
            the file.


           Update

            The Update command causes Aporia to re-read the contents of
            the directory currently displayed in the Directory Window.


         The Special Menu

            The Special menu contains commands for making tools and
            selecting and getting information on files.


           Make User Tool

            This command will create user tools for all currently
            selected files.

            When you create new user tools, they are stored in which
            ever desk the tool you create them with is in. When you are
            going to create a large number of tools that will all go in
            the same Desk Tool, first store the directory or Tree Tool
            you are going to create them with in that desk. Then create
            your tools and they will be in that desk. This will save you
            from having to copy each of the tools into this desk after
            you create them.


           Make Directory Tool

            This command makes a Directory Tool for the directory
            displayed in the window. This tool stores all information
            for the Directory Window, except for the window size (set
            separately using the Size Tool). Information stored with the
            tool includes both the name of the drive and directory the
            tool's window will display and any of the View menu options
            such as how the file listing is displayed, any text entered
            in for the Partial command, and the order the file listing
            is sorted in.

            This ability to save the Directory Window settings is a very
            powerful feature. It allows you to create "file sets" which
            display only the files you wish to view for a particular
            application. For example, you can set multiple Directory



                                                   Aporia User Manual 51



                                             Chapter 4: Aporia Reference



            Tools for one directory, one which sorts by date and is used
            when you do backups, and another which sorts by name and is
            used to find files quickly. Since the Partial command lets
            you enter multiple file specifications, you can create tools
            which permanently display a complex subset of the files in a
            directory.


           Select All

            The Select All command selects all files currently displayed
            in the window. Files not currently displayed in the window
            as a result of the Partial or Programs commands are not
            effected.


           Disk Space Used

            The Disk Space Used command displays a count of selected
            files, the total combined size of the files and the amount
            of disk space they use. The amount of disk space used will
            usually be higher than the total combined size of the files
            due to the 2 kilobyte minimum DOS disk block size.


       4.13.4 Additional Directory Tool Features


         Quick Copies and Directory Changes

            Dragging a user tool for a data file onto a Directory Tool
            copies the file attached to the tool to the Directory Tool's
            directory.

            Dragging a user tool for an executable (program) file onto a
            Directory Tool changes the directory the tool runs in to the
            Directory Tool's directory.

            Dragging a basic tool onto a Directory Tool will change the
            directory of that tool to that of the Directory Tool.


         Changing Where a Directory Tool Runs

            The directory a Directory Tool runs in, that is the
            directory it will display when it is opened to a Directory
            Window, can be changed by dragging it onto the Options Tool
            and entering the name of the directory in the Directory To



                                                   Aporia User Manual 52



                                             Chapter 4: Aporia Reference



            Run In. Enter a "." in this field causes the Directory Tool
            to run in the current directory.

















































                                                   Aporia User Manual 53



                                           Chapter 5: Advice For Experts




       5. CHAPTER 5: ADVICE FOR EXPERTS


            The ideas here are intended to help you think through some
            of Aporia's uses, and to help those who no longer consider
            themselves novices. The subjects here are all independent of
            each other... Plunge in!  Also, we welcome your suggestions
            and shortcuts to share with other users.


       5.1 RUNNING APORIA AS THE WINDOWS SHELL

            Running Aporia as Window shell program causes Aporia to be
            run first when you start Windows 3.0 without the Program
            Manager program being run. When you run the Aporia setup
            program (SETUP_AP.EXE) you are given the option of making
            Aporia the shell at that time. If you decline to make Aporia
            the shell at setup time you can do so later by modifying the
            "SYSTEM.INI" file located in your Windows directory. Open
            the file with any text editor and replace the line:

                 shell=progman.exe

            with:

                 shell=aporia.exe

            In effect you are replacing the Program Manager with Aporia.
            This makes sense if you find (as most Aporia users do) that
            you are using Aporia more than Program Manager. You can
            still run the Program Manager as you would any Windows
            program. When running Aporia (or any program) as the Windows
            shell exiting the program will cause you to exit Windows.


       5.2 PASSING ARGUMENTS TO TOOLS, OR, MAKING A PRINT TOOL

            Aporia lets you pass replaceable parameters to tools. The
            following is a demonstration of this function's use in the
            creation of a tool which you can use to print text files.

            To make a print tool, create or copy one of your own file
            tools, then drag the new tool onto the options tool and
            change the following fields:

                 Program/File: command.com
                 Argument: /c copy %1 prn



                                                   Aporia User Manual 54



                                           Chapter 5: Advice For Experts



            To use the tool, drag the file you want printed onto your
            printer tool and voila.

            Explanation: The program command.com will run the line "copy
            %1 prn", substituting the first dragged tool for the "%1",
            so that the program line of the tool will be copied to the
            printer. If there is no dragged tool %1 will be null, empty.
            The "/c" tells DOS to execute the command and return
            automatically.

            A fancier alternative is to use something like the Norton
            Utilities line printer, lp, which will format the pages and
            supplies form feeds at the end. Change the tools options to:

                 Program/File: lp.pif
                 Argument: %1 /w80

            Explanation: Run the lp program on the first dragged icon
            and set the line length to 80.  You could not do this with a
            PIF file alone. Note: if you change the Argument line to

                 Argument: %1 %1 %1 /w80

            you could print the file in triplicate.

            Note: the pattern %1 can be picked anywhere out of a line so
            that, for example, the following lines are each legal.

                 hello%1world
                 %1%1%1

            Note: the pattern %0 is the filename of the bottom, base
            tool.


       5.3 TURNING OFF TRASH MANAGEMENT

            Trash management provides a way of preventing the accidental
            removal of files by users. This feature is intended for
            inexperienced users or for those with lots of disk space.
            Aporia will copy the file to its "!TRASH" directory under
            its default directory before it removes it. The file can be
            recovered by running the Trash Tool. This copying takes a
            time and disk space. If you want to prevent this copying,
            then run the Options Tool and turn off the Enable Trash
            Management check box.





                                                   Aporia User Manual 55



                                           Chapter 5: Advice For Experts



            A way to speed up Trash Management significantly is to use a
            RAM disk for the "!TRASH" directory.


       5.4 GETTING RID OF PROMPTS WHEN TRASHING TOOLS

            Aporia provides a way for inexperienced users to protect
            themselves from accidentally removing tools. The default
            mode for Aporia is to ask if you really want to remove a
            tool. If this is annoying for more expert users, it can be
            disabled by running the Options Tool and turning of the Ask
            Before Removing Tools check box.


       5.5 DESKS: ORGANIZING, REPETITIOUS JOBS


       5.5.1 Trees of Desks

            Desks are the main tools for organizing your work. Besides
            clarifying the types of work you do, the use of desks can
            make your screen less cluttered. We highly recommend their
            use. You might make a desk of "Spreadsheets" associated with
            your accounting, another for your "General Ledger" files,
            and another of for correspondence with your "Accountant".
            All these separate desks could be put into one desk called
            "Accounting".  Hiding the "Accounting" desk will hide all
            the desks in it.


         Finding Tools

            If you double-click right on any tool, you can see what desk
            that tool is in and what other tools are in that desk. This
            provides a way to find out what desk a given tool is in and
            what tools are in a given desk. This listing function shows
            not only what is in a desk, but what is in all desks in that
            desk. It also shows the order in which tools are stored in
            the desk.


       5.6 APORIA TOOL FILES

            The tools you create are stored in an ASCII format file,
            "APORIA.TUL" in the TOOLS directory which by default is
            located in your APORIA directory.





                                                   Aporia User Manual 56



                                           Chapter 5: Advice For Experts



       5.6.1 Switching Tool Files

            You can maintain different sets of tool files by saving and
            restoring different tools files.  One way to do this is to
            have a batch file to run Windows, such as:

                 REM ** Run Aporia with a special set of tools
                      cd c:\aporia\tools
                 REM ** Save the previous Aporia tools and load in our
                 REM **   special set.
                      ren aporia.tul oaporia.tul
                      copy saved.tul aporia.tul
                 REM ** Run Aporia with our special setup
                      win aporia
                 REM ** Restore the original set of Aporia tools.
                      ren oaporia.tul aporia.tul
                 REM ** Fini!

            The beauty of this is that pre-designed tool setups can be
            maintained and supplied to users, and users can come to rely
            on seeing the same tools in the same places.


       5.7 APORIA WIN.INI SETTINGS

            The WIN.INI file stores all the general options about Aporia
            except for the tools themselves. All of the information used
            by Aporia is stored in a section labeled "Aporia". Most of
            this information is only intended to be changed by Aporia.
            There are however settings that you can add yourself which
            control where Aporia stores files that it uses.

            By default all of these directories are created in the
            APORIA directory which you can specify using the Options
            tool. Using the following WIN.INI options you can locate
            these directories anywhere you wish. This can be very useful
            in certain situations such is on a local area network where
            you may want to share Aporia files between a number of
            users.

            Add the line "ToolsDir=<path>" where <path> is the directory
            where you want Aporia to the tools file (APORIA.TUL).

            Add the line "TrashDir=<path>" where <path> is the directory
            where you want Aporia to store files for Trash Management.






                                                   Aporia User Manual 57



                                           Chapter 5: Advice For Experts



            Add the line "ImageDir=<path>" where <path> is the directory
            where you want Aporia to look for Aporia image files to be
            used as images for your icons.

            Add the line "HelpDir=<path>" where <path> is the directory
            where you want Aporia to look for Help files that you use
            with the Help tool.

            Add the line "NotesDir=<path>" where <path> is the directory
            where you want Aporia to look for Notes files that you use
            with the Notes tool.


       5.8 APORIA ON A NETWORK

            Aporia works with local area networks though it currently
            has no features that specifically support them. There are
            some issues involved with its use that you may want to be
            aware of.


       5.8.1 Tools and Options

            As is discussed earlier in this chapter, the Aporia tools
            file  ("APORIA.TUL") and the Windows "WIN.INI" file both
            store information about Aporia's setup. On a network, where
            more than one person is using Aporia, the best option is for
            each user to have their own tool and "WIN.INI" files. By
            setting the various options for Aporia special directories
            in WIN.INI (see above section) have complete control which
            Aporia files are accessed by users. For example each user
            can have their own tools file while all of them can share
            the same set of image files.


         Sharing Tools and Options

            When users share these files they will be forced to use the
            same set of tools and the same general options for Aporia.
            Also problems may occur in the (unlikely) event that two
            users save their tools at the exact same time. In general
            the sharing of these files by users is not recommended.


       5.8.2 Where to Locate Your APORIA Directory

            Where you chose to locate the APORIA directory can be an
            issue on networks. By default Aporia creates it in the root



                                                   Aporia User Manual 58



                                           Chapter 5: Advice For Experts



            directory of the C drive with the name APORIA ("C:\APORIA").
            Using the Options Tools you can locate it on any drive with
            any name you wish. By default all of the other directories
            needed by Aporia are created in the APORIA directory, but
            you can place them anywhere you like using settings in the
            WIN.INI file (see above). An important decision to make is
            whether all users should share one APORIA directory or if
            each one should have their own.

            If users share the directory then all can have access to the
            same help and note files. This may or may not be a good
            thing depending upon the way they use these files. Conflicts
            may occur if two users attempt to create help files with the
            same name.

            Sharing the directory also gives users access to the same
            Tree Tool cache files. This will cause problems for local
            drives since the directory structure for each user's drive
            will be different. When a user accesses his local drive
            using the Tree Tool he may see the directory structure for
            another user's local drive. On network drives problems can
            also occur since different users will have different access
            rights for directories. If a user has no rights to a
            directory it will not appear in the Tree Tool. The effect is
            that even on network drives the directory structure can
            differ from user to user.

            In general the safest approach is to give each user their
            own APORIA directory. In cases where users have local drives
            this is taken care of by Aporia automatically. Where a user
            has no local hard drive the Options Tool general options
            must be set to the directory to something other than
            "C:\APORIA".


       5.8.3 Registration on Networks

            Remember that each Aporia registration is for one user on
            one machine. Multiple users on a network are only allowed
            when a registration has been purchased for each person who
            will be using Aporia.


       5.9 QUICK MENUS

            Directory tools can be used as a menuing system for your
            files. Just make a directory tool in the directory where the
            files are located, and set the View Programs option to show



                                                   Aporia User Manual 59



                                           Chapter 5: Advice For Experts



            programs, or use the View Partial display to show a certain
            list of programs and/or files. Each time this directory tool
            is run it will show this list so that the programs listed
            can be quickly run. This is great for directories (such as
            your Windows directory) where you store a large number of
            programs that you run only once in a while. This can also be
            a way to run DOS applications since you can put a group of
            PIF files in one directory, set the View Partial option to
            "*.PIF", and have easy and quick access to any of your DOS
            programs, no matter where they are located on your hard
            disk.


       5.10 USING OTHER SCREEN BLANKERS

            You can use any screen blanker you'd like with Aporia but
            first be sure to turn off Aporia's screen blanker by running
            the Options Tool and setting the blanker time period to
            zero.


       5.11 LARGE TOOLS FOR THE VISUALLY IMPAIRED

            The tool images and fonts can be made very large in a way
            suitable for the visually impaired. Tools can be sized by
            double clicking left on the Size Tool. Similarly the text in
            a tool can be made large by selecting a large font, up to 72
            points big, by double clicking left on the Options Tool and
            setting both the Directory and Tools Fonts.

            We also recommend that directories be set to a different
            color than the other tools by dragging a directory tool onto
            the Options Tool and setting the Dir Tool Dir Name checkbox
            on.


       5.12 LAYOUTS

            You are encouraged to experiment with placing the tools
            around the screen to visually organize your work.

            Suggestion: We have found that making the desk display as
            text only and moving its contents near it has the effect of
            making a label for its contents. Using the text only display
            and image only display can be effective ways of making your
            work look clear and orderly.





                                                   Aporia User Manual 60



                                           Chapter 5: Advice For Experts



            Suggestion: Make a desk and put all the basic tools into it.
            Call the desk "Basic Tools" and set it to display text only.
            Arrange the tools into a 3x3 grid at the top right. This
            frees the rest of screen for other things. Hiding the "Basic
            Tools" hides all the tools.

            Suggestion: Make multiple Hide Tools and put them at either
            side of the screen. Then if you want to hide an tool it you
            can do it quickly.










































                                                   Aporia User Manual 61



                                                  Chapter 6: Image Maker




       6. CHAPTER 6: IMAGE MAKER UTILITY


            The Aporia Image Maker utility is a simple program which
            lets you capture an image to be used as an icon for an
            Aporia tool. It is designed to let you capture a window,
            icon, or any area of the screen and store the image to a
            file which is used by Aporia. An image file is used by
            specifying it for a tool with the Aporia Options Tool.

            Using Image Maker you can create tools which display the
            icons for your programs. You can also create your own icons
            for tools by creating them with any Windows paint program
            (such the Paintbrush supplied with Windows) and capturing
            them with Image Maker.


       6.1 RUNNING IMAGE MAKER

            Image Maker works by getting a copy of a bitmap from the
            Windows clipboard. When Image Maker is running it will
            display any bitmap that is copied into the clipboard from
            any program. Along with the actual bitmap it will display
            textual information such as the dimensions and number of
            color planes of the bitmap.

            You control the size at which the bitmap will be displayed.
            This can be different than the actual dimensions of the
            bitmap. The displayed size of the bitmap can be set from the
            Options menu. The default displayed size if 32x32, which is
            also the default size of the images displayed on Aporia
            tools and for Windows icons.

            Since Image Maker grabs bitmaps from the Windows clipboard
            any program that can generate a bitmap can be used to create
            Aporia icons. For example you can create a chart in
            Microsoft Excel, copy it to the clipboard, and create a new
            tool to represent chart files.












                                                   Aporia User Manual 62



                                                  Chapter 6: Image Maker



       6.2 THE IMAGE MAKER COMMANDS


       6.2.1 File Menu


         Save

            You use the Save command to store the image you have
            captured in a file. For Aporia to use the bitmap files they
            must be stored in the IMAGES directory which by default it
            located APORIA directory specified in the Options tool (for
            example: C:\APORIA\IMAGES). When Image Maker it determines
            where the IMAGE directory is so that when you go to save a
            file this directory is already specified. When saving files
            give them a standard (up to 8 character) DOS name, the
            extension "AIF" will be added to the end.

            Note that if make changes to an existing image file you will
            not see those changes show up in the tools where you are
            already using them until you exit and re-start Aporia.


         Load

            The Load command lets you load an existing image file. Use
            this command when you want to load an make changes to an
            existing image file. Load the file, paste in into your paint
            program, and then capture it again with Image Maker.


       6.2.2 Capture Menu


         Area

            The Capture Area is used to capture any area of the screen
            to Image Maker. After selecting the Area command a crosshair
            cursor will appear which you can use to select an area of
            the screen to capture. Hold down the left mouse button over
            the upper left corner of the area you want to capture, drag
            the cursor to the lower right corner, and release the
            button. The area will appear in the Image Maker window.








                                                   Aporia User Manual 63



                                                  Chapter 6: Image Maker



         Icon

            Use the Capture Icon command to capture the icon of a
            Windows application or for an icon in the Program Manager.
            After selecting the command click the mouse over the icon
            you want to capture. Note that the background of the icon
            will be captured as well. For this reason when capturing
            program icons you may want to set your desktop color to the
            color for the background of your tools. Unlike Windows icons
            Aporia tools have not transparent areas.


         Window

            Select Capture Window command to capture the contents of an
            entire window. After selecting the command click the mouse
            over the window you want to capture.


       6.2.3 Options Menu


         Displayed Size

            Use the Displayed Size to specify the displayed size of the
            bitmap in the Image Maker window. The default size is 32x32.
            In order to get an idea of what a bitmap will look like on
            as an Aporia tool you should set the displayed size to the
            same size you use for your tools (as set with the Options
            tool).


       6.3 GENERAL NOTES

            The files created by Image Maker are actually device
            dependent bitmaps (the type used with Window 2.x). These
            type of bitmaps were used, instead of the device independent
            bitmaps provided with Windows 3.0, so that they could be
            created by users of both Window 2.x and 3.0.

            There are some limitations to these types of bitmaps. If you
            are running Windows 3.0 or later the image files you create
            can be used on a variety of display types. Aporia comes with
            two sets of color image files for all of the basic Aporia
            tools, plus image file versions of the icons for programs
            supplied with Windows 3.0. One set is for 16 colors display
            modes and the other is for 256 color modes. We have used
            these image files successfully on EGA, VGA and Super VGA



                                                   Aporia User Manual 64



                                                  Chapter 6: Image Maker



            systems though we can not guarantee that the will work on
            all type of displays. If you are using a monochrome VGA
            system and use the standard color VGA driver supplied with
            Windows (VGA.DRV) you should be able to use the 16 color
            image files.

            If you are running under Windows 2.x things do not work quit
            as well. The image files you create on a particular display
            type (such as EGA) will likely not work on another type of
            display (such as SuperVGA). This means that you may not be
            able to share the bitmap files between different systems.
            This problem can be gotten around by creating your images in
            a paint program such as Paintbrush (the PCX file format is
            fairly device independent) and then capturing them with
            Image Maker on the target display type.

            Included on your Aporia distribution disk you will find a
            file named "AP_ICONS.EXE". This is a self-extracting archive
            which contains all of the images for the basic Aporia tools
            in Windows 3.0 icon (ICO) file format. These are included
            for those of you who may be using a display type not
            compatible with the image files provided. You can use these
            icons to create image files for the basic tools by
            displaying them in Program Manager (or an icon editing
            program), capturing them with Image Maker, and saving them
            as image files.

























                                                   Aporia User Manual 65


                                                                Index


         INDEX


       Aporia                               File menu 47
         memory usage 6                     multiple file specification
         options 37                             49
         registering 27                     selecting file 20
         system requirements 6              selecting files 45
       Aporia as the Windows shell 54       Special menu 51
       Aporia as Windows Shell 7            updating 51
       Aporia directory 39, 58              View menu 49
       Aporia Image File 34, 62           Directory Window command 20,
       APORIA.TUL file 56                     43
       Basic tools                        Disk Information command 44
         creating 24                      Disk Space Used command 52
       Blank Now command 28               EGA 6, 64
       By Date command 50                 File
       By Kind command 50                   copying 46
       By Name command 50                   dragging onto tools 25
       By Size command 50                   moving 21
       Canceling move 25                  Files
       Canceling moves 26                   copying 21, 48
       Copy command 48                      deleting 21, 47, 48
       Copy cursor 21, 46                   disk space used by 52
       Copy Tool 4, 14, 24, 32              dragging onto tools 47
       Create (directory) command 19,       listing 49
           43                               moving 46, 48
       Delete (directory) command 22,       recovering deleted 30
           43                               renaming 48
       Delete (file) command 48             sorting 50
       Desk Tool 3, 15, 23, 28, 51          working with multiple 47
         hiding contents 16, 28, 33       Fonts 38, 60
         moving 29                        Help
         removing 29                        for basic tools 11
         running 29, 37                     for user tools 31
         showing contents 16, 28          Help Tool 5, 31
         storing tools in 15, 28            program 39
       Desk Tools                         Hide Tool 5
         moving 25                        Hot spot 11, 25
       Direct manipulation 46             Icons
       Directories                          changing 34
         creating 19, 43                    changingAporia uses two
         deleting 22, 43                        types of icons. There
         renaming 43                            are color icons which
       Directory Tool 3, 44, 59                 are stored as separate
         changing directory of 36, 52           files and there are
         creating 13, 24                        "built-in" monochrome
         font 38                                icons which are stored
         showing directory name 34              within the Aporia
       Directory Tools                          program. The color icons
         creating 23, 41                        bring you the advantages
       Directory Window 12, 13, 20,             of full color and the 17
           23, 35, 41, 43, 45             Image File 6, 23, 34, 62


                                                  Aporia User Manual 66



                                                                Index

											 
       Image Maker 62                       dragging 10, 24
       Installing Aporia 6, 7               finding 56
       Load command 48                      fonts 38
       Load Tools command 27                hiding 16, 28, 33
       Load= 7                              information 26
       Local Area Networks 58               moving 10, 25
       Long command 49                      naming 16, 34
       Make Directory Tool command          removing 29, 56
           13, 44, 51                       running 11, 14, 24, 37
       Make Directory Window command        saving 27
           44                               sizing 38, 40
       Make User Tool command 51            storing 15, 28
       Memory status 27                     user 2
       Move command 48                    Tools concept 1
       Move cursor 21, 46                 Tools file 56
       Note Tool 5                        Trash Management 30
       Notes Tool 30, 35                    enabling 30, 39, 55
         program 40                       Trash Tool 4, 21, 29, 39, 47,
         setting program 35                   55, 56
       Options Tool 4, 16, 33             Tree Tool 4, 12, 34, 41
         general options 37                 Directory menu 19, 42
         individual tool options 33         directory window with 12,
       Partial command 49                       20, 43
       Programs                             Drives menu 42
         loading 48                         Options menu 20, 43
         running 24, 45, 47                 reloading 41
         specifying in tools 35             Special menu 43
       Programs command 50                Update command 51
       Rename (directory) command 43      User tools 2
       Rename (file) command 48             creating 12, 23, 45
       Replaceable parameters 36, 54      VGA 6, 64
       Run command 47
       Run= 7
       Screen Blanking 28, 38, 60
       Select All command 52
       Short command 49
       Size Tool 5, 18, 36, 40
         sizing tools 40
         sizing windows 18, 40
       Stacking tools 26
       Tools 1
         arguments 36, 54
         basic 3
         copying 14, 24, 32
         creating 12, 14, 23, 45
         customizing 3, 16, 33
         directory to run in 36
         double-clicking 11, 24

                                                 Aporia User Manual 67








