/*
 **************************************************************
 * newpaper.c                                                 *
 * 7/28/90 by Jim Button and Roger Hadgraft                   *
 *------------------------------------------------------------*
 * Updates WIN.INI Wallpaper specification to point to the    *
 *   to the next BMP file in the windows subdirectory.        *
 *                                                            *
 * This hardly looks like a Windows program. The traditional  *
 *   message loop is not even needed, since it does no input, *
 *   has no output, and terminates almost before it starts!   *
 **************************************************************

16/10/1990  Looks in Win.ini for tiling or centering.
        Otherwise it asks, and records the setting.
        Pressing "Cancel" causes no setting to be recorded, and
        sets centering on as a means of previewing the bitmap.

16/11/1990  This version uses ZIP files instead of BMP files, and spawns
        PKUNZIP to unpack the required file. Each bitmap is stored in a
        ZIP file of the same name as itself. (eg. FRED.BMP is stored as FRED.ZIP).

19/11/1990  Fixed (?) problem where a UAE would occur if the dialog box was produced.
        It's suspected that this was caused by using the active window's handle.

23/11/1990  Moved the execution of PKUZIP to the last action trying to fix the
        hanging problem when the message box is generated.

22/06/1991	Added a dialog box to ask if wallpaper should be changed.
			Added capability for bitmaps to be stored in another directory.

13/07/1991	Moved settings into NEWPAPER.INI from WIN.INI.
			This file must be in the Windows directory.

27/08/1991	Added the ability to run WUNZIP instead of PKUNZIP.
			Added check to make sure bitmap file exists.

*/

#ifndef _WINDOWS
#define _WINDOWS
#endif

#include <windows.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

static char NewPaper[] = "NewPaper 1.6 by Roger Hadgraft"
			, NewPaperIni[] = "NewPaper.Ini";

#define MAX_PROF_STR  80

#include <..\subs\chcurdir.c>

int PASCAL WinMain(  HANDLE hInstance,
                     HANDLE hPrevInstance,
                     LPSTR lpszCmdLine,
                     int nCmdShow)
	{
	unsigned	int done;
	char	oldbmp[MAX_PROF_STR+1];
	char	firstbmp[MAX_PROF_STR+1];
	char	newbmp[MAX_PROF_STR+1];
	char	wallpaperdir[MAX_PROF_STR+1];
	char	unzipper[MAX_PROF_STR+1];
	char	windowsdir[145];
	char	cmdline[200];
	FILE	*fBmpfile;
	HWND	hWnd;

   struct   find_t dta;
/* struct   stat   buf; */
   char     *tiled;
   int      result, iShowFlag, confirm, i;

   /* create a window as parent for the message boxes that are created */
   hWnd = CreateWindow( (LPSTR)"NewPaper",
                        (LPSTR)NewPaper,
                        WS_OVERLAPPED,
                        100,      /*  x - ignored for tiled windows */
                        100,      /*  y - ignored for tiled windows */
                        50,       /* cx - ignored for tiled windows */
                        20,       /* cy - ignored for tiled windows */
                        (HWND)NULL,        /* no parent */
                        (HMENU)NULL,       /* use class menu */
                        (HANDLE)hInstance, /* handle to window instance */
                        (LPSTR)NULL        /* no params to pass on */
                        );

	/* find current bitmap */
	confirm = GetPrivateProfileInt((LPSTR)"Options", (LPSTR)"Confirm", 1, (LPSTR)NewPaperIni );

	/* check if any change is to be made */
	if( confirm == 1 )
    	result = MessageBox( hWnd, (LPSTR)"Change the BitMap on the Desktop ?",
        	NewPaper, MB_ICONQUESTION | MB_YESNO );

    if( result == IDYES || confirm == 0 ) {

		/* find current bitmap in WIN.INI */
		GetProfileString((LPSTR)"Desktop", (LPSTR)"WallPaper", (LPSTR)"", (LPSTR)oldbmp, MAX_PROF_STR);
		/* change to the Windows directory, just in case the program was started from somewhere else */
		GetWindowsDirectory( windowsdir, 145 );
		ChangeCurDir( windowsdir );

		/* check for a bitmap directory in NEWPAPER.INI */
		GetPrivateProfileString((LPSTR)"Options", (LPSTR)"WallPaperDir", (LPSTR)"", (LPSTR)wallpaperdir, MAX_PROF_STR, (LPSTR)NewPaperIni );
		if( wallpaperdir[0] != NULL )	/* then change to the relevant directory */
			ChangeCurDir( wallpaperdir );

		strcpy( strstr( oldbmp, ".BMP" ), ".ZIP" );
		newbmp[0] = '\0';                            /* In case no BMP files exist */

		/*** Get the list of .ZIP files ***/
		done = _dos_findfirst("*.ZIP", 0, &dta);     /* Find files */
		if (!done) {
			strcpy(firstbmp, dta.name);
			strcpy(newbmp, firstbmp);
			}

		while (!done) {
			if (!strcmpi(dta.name, oldbmp)) {         /* Current one? */
 				done = _dos_findnext(&dta);
				strcpy(newbmp, (done ? firstbmp : dta.name));
				break;
				}
			done = _dos_findnext(&dta);
			}

		if( newbmp[0] == NULL ) {	/* couldn't find any ZIP files */
			MessageBox( hWnd, 
				"Couldn't find any Zipped files.\nDesktop bitmap was not changed.\nCheck the WallpaperDir= line in NEWPAPER.INI.", NewPaper, MB_OK );
			return( FALSE );
			}

		/* change to the Windows directory, just in case the program was started from somewhere else */
		ChangeCurDir( windowsdir );
		/* delete the old BMP file here */
/*		MessageBox( hWnd, oldbmp, NewPaper, MB_OK );	debug only */
		strcpy( strstr( oldbmp, ".ZIP" ), ".BMP" );
		remove( oldbmp );

		/* build the command line to later spawn PKUNZIP or WUNZIP to unzip the file */
		GetPrivateProfileString((LPSTR)"Options", (LPSTR)"Unzipper", (LPSTR)"pkunzip", (LPSTR)unzipper, MAX_PROF_STR, (LPSTR)NewPaperIni );
		if( strcmpi( unzipper, "WUNZIP" ) == 0 ) {
			strcpy( cmdline, "wunzip.exe " );
			if( wallpaperdir[0] != NULL ) {		/* then give a full path name */
				strcat( cmdline, wallpaperdir );
				strcat( cmdline, "\\" );
				}
			strcat( cmdline, newbmp );		/* this is actually a .ZIP name */
			strcat( cmdline, " -p" );		/* unzip into the Windows directory */
			strcat( cmdline, windowsdir );
			strcat( cmdline, " -a -e -o -g" );
			}
		else {	/* assume PKUNZIP */
			strcpy( cmdline, "pkunzip.pif " );
			if( wallpaperdir[0] != NULL ) {		/* then give a full path name */
				strcat( cmdline, wallpaperdir );
				strcat( cmdline, "\\" );
				}
			strcat( cmdline, newbmp );		/* this is actually a .ZIP name */
			strcat( cmdline, " ." );		/* unzip into the current (Windows) directory */
			}
/* 		MessageBox( hWnd, cmdline, NewPaper, MB_OK ); debug only */

		/* run Unzipper */
		if( ( GetWinFlags() & WF_ENHANCED ) == WF_ENHANCED )
		    iShowFlag = SW_SHOWMINIMIZED;   /* run as an icon in enhanced mode */
		else
			iShowFlag = SW_SHOW;
		if( WinExec( (LPSTR)cmdline, iShowFlag ) < 32 )
    		MessageBox( hWnd, (LPSTR)"Problem running PKunZip", (LPSTR)"NewPaper", MB_ICONEXCLAMATION | MB_YESNOCANCEL );

		/* now replace .ZIP with .BMP */
		strcpy( strstr( newbmp, ".ZIP" ), ".BMP" );

		/*** Update WIN.INI ***/
		WriteProfileString((LPSTR)"Desktop", (LPSTR)"WallPaper", (LPSTR)newbmp);

		/*** Check for a previously recorded setting, otherwise ask ***/
		result = GetPrivateProfileInt("Bitmaps", newbmp, -1, (LPSTR)NewPaperIni );
		if( result == -1 ) {
    		/* this bitmap hasn't been specified yet */
		    result = MessageBox( hWnd, (LPSTR)"Tile this BitMap on the DeskTop ?\n(Otherwise centre it)",
        		(LPSTR)newbmp, MB_ICONQUESTION | MB_YESNOCANCEL );
		    if( result == IDYES )
       			tiled = "1";                         /* Point to string "1" */
		    else
        		tiled = "0";
		    if( result != IDCANCEL )
       			/* record choice as a permanent setting */
				WritePrivateProfileString((LPSTR)"Bitmaps", (LPSTR)newbmp, (LPSTR)tiled, (LPSTR)NewPaperIni);
			}

		else {
    		if( result == 1 )
				tiled = "1";                         /* Point to string "1" */
		    else
        		tiled = "0";
			   }

		/*** Update WIN.INI ***/
		WriteProfileString((LPSTR)"Desktop", (LPSTR)"TileWallpaper", (LPSTR)tiled);

		/* check that the bitmap file exists */
		for( i=0; i<50; i++ ) Yield();	/* wait for the unzipper to finish */
		if( ( fBmpfile = fopen( newbmp, "r" ) ) == NULL ) {
			/* the file doesn't exist! */
			MessageBox( hWnd, "The bitmap file doesn't exist!\nPlease make sure that the bitmap and zip files\nshare the same name.\nThe WallPaper= setting has been cleared.", NewPaper, MB_OK );
			WriteProfileString((LPSTR)"Desktop", (LPSTR)"WallPaper", (LPSTR)"");
			}
		else 
			fclose( fBmpfile );

		}

	return( FALSE );
	}
