/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#if defined( Uses_TProject ) && !defined( __TProject__ )
#define __TProject__

class TOptions;
class TParamList;

class TProject : public TDependency
{
public:
  TOptions *options;
  char *defaultprojectmask;
  ushort screen_mode;
  uint32 tabsize;
  uint32 options1;
  TParamList *info_files;
  char *main_function;
  ushort info_search_mode;
#define INFO_MODE_EXACT 0
#define INFO_MODE_SUBSTRING 1
#define INFO_MODE_FUZZY 2
  union {
    ushort info_search_options;
    struct {
      unsigned _case:1;
      unsigned dummy:15;
    } _info_search_options;
  };
  int fuzzy_value;
#define INFO_OPTIONS_CASE _info_search_options._case
  TProject(void);
  ~TProject(void);
private:
  virtual const char *streamableName() const
    { return name; }
protected:
  TProject( StreamableInit ) : TDependency(streamableInit) {}
  virtual void write( opstream& );
  virtual void *read( ipstream& );
public:
  static const char * const near name;
  static TStreamable *build();
  TProject & operator = ( const TProject& );
};

inline ipstream& operator >> ( ipstream& is, TProject& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TProject*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TProject& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TProject* cl )
    { return os << (TStreamable *)cl; }

#endif
