#! /bin/sh
#-----------------------------------------------------------------------------
#  This script patches original sources of egcs-1.1.1 together with
#  sources of libg++ for building under DJGPP.
#-----------------------------------------------------------------------------
#  NOTES: 
#  
#  1) LFN support is required both for this script and for building egcs
#     and libraries (but not for using resulting binaries)
#  2) Win9X DPMI server is buggy and will crash some times. You may need
#     to delete some directories if something is crashed in inappropriate  
#     place
#  3) This all is intended for DJGPP-2.02. I haven't tested
#     it with 2.01 however I think there should be no serious problems
#     except than some hacking will be needed to get exceptions working
#-----------------------------------------------------------------------------
#  1) Unpack egcs-1.1.1.tar.gz and libg++-2.8.1.3.tar.gz and
#     move libg++ and librx directories into egcs tree. If You are using
#     later version of libg++ there may be problems with ./djmake.sh install ...
#     (however make should not fail, at least I hope so)
#  2) Run this script from egcs top directory
#  3) Change to gcc/build.djg and run
#         ./djconfig.sh
#	  ./djmake.sh ../cstamp-h.in
#         ./djconfig.sh
#     Last commands are needed only if distribution version of source archive
#     is being created to avoid need to have autoheader later.
#     You should also patch autoheader (see patch in README.DJGPP)
#  4) Build gcc
#         ./djmake.sh CFLAGS=-O2   
#  5) Change to libs/build.djg and run
#         ./djconfig.sh
#  6) Build libraries
#         ./djmake.sh CFLAGS=-O2 CXXFLAGS=-O2
#  7) Run test (if You want)
#         ./djmake.sh check CFLAGS=-O2 CXXFLAGS=-O2
#  8) Install both gcc and libraries
#         ./djmake.sh install prefix=where_to_install
#  9) Run fixinst.sh in directory where You installed egcs and libraries.
#-----------------------------------------------------------------------------
#  Happy hacking
#
#  Andris Pavenis <pavenis@lanet.lv> 
#-----------------------------------------------------------------------------


# 	Patch file from GPC distribution. Should be updated for future
#	GPC versions. Don't matter if GPC sources is not installed
GPC_PATCH_FILE=gcc-egcs-2.91.60.diff


update() 
{ 
	if ! { cmp -s $1.new $1 }; then
             test -f $1.orig || ( mv -f $1 $1.orig; echo "File $1 updated"; )
             mv -f $1.new $1;
             test -f $1.new && rm -f $1.new;
	     dtou $1;	
	fi
}

currdir=`pwd`

LIBIO_RENAME=iostreamP.h

LIBSTDCXX_RENAME="stl_algobase.h stl_hash_map.h stl_hash_set.h stl_hashtable.h \
		  stl_multiset.h"

LIBGPP_RENAME="Complex.h Regex.h String.h"

################################################################################				
#  Remove directories not supported for DJGPP
################################################################################				
for dir in `find . -type d -name testsuite`; do
	echo "Removing directory $currdir/$dir"
	rm -fr $dir;
done
#
test -d libio/dbz && ( echo "Removing directory $currdir/libio/dbz"; \
	rm -fr libio/dbz; );
#
test -d libg++/etc/lf && ( echo "Removing directory libg++/etc/lf"; \
	rm -fr libg++/etc/lf; );
#
for dir in `find gcc/config -type d -not -name i386 -not -name config`; do
	echo "Removing directory $currdir/$dir";
	rm -rf $currdir/$dir;
done;
#
for file in `find . -name .brik -or -name .cvsignore`; do
	rm -vf $file
done
#
################################################################################				
#
echo 'HDEFINES=-DHAVE_GETRUSAGE' >libiberty/config/mh-go32
#
################################################################################				
#
#  Rename include files in libio. We must do this with iostreamP.h only. 
#  Let's rename it to _iostreamP.h. Fix also corresponding sources and
#  depend file
#
################################################################################				
for incname in $LIBIO_RENAME; do
	newname=_$incname;
	incpath=libio/$incname
	if test -f $incpath; then
		for file in `grep -l $incname libio/*.c libio/*.cc libio/*.h`; do
			sed -e 's,\"iostreamP.h\",\"_iostreamP.h\",g' $file >$file.new;
			update $file
		done;
	fi;
done;
#
sed -e 's,iostreamP.h,_iostreamP.h,g' libio/depend >libio/depend.new
update libio/depend;
#
for incname in $LIBIO_RENAME; do
	test -f libio/$incname && mv -f libio/$incname libio/$newname;
done
###########  patch libio/configure.in  #############

patch -Nb libio/configure.in << 'EOF'
--- libio/configure.in~       Thu Mar 19 05:31:58 1998
+++ libio/configure.in        Thu Apr  2 18:32:06 1998
@@ -41,6 +41,8 @@
   *-sco3.2v[45]*)   frags=sco4.mt ;;
   *-isc*)        frags=isc.mt ;;
   *-netware*)    frags=netware.mt ;;
+  *-pc-msdosdjgpp*)
+               frags=go32.mt ;;
   *)             frags=${target_cpu}.mt ;;
 esac
EOF

################################################################################

for file in libio/config.shared libio/tests/Makefile.in; do
    sed -e 's,-lstdc[+][+],-lstdcxx,g' \
	-e 's,-lg[+][+],-lgpp,g' $file >$file.new
    update $file
done    

rm -f libio/config/go32.mt

patch -Nb libio/config/go32.mt << 'EOF'
--- go32.mt~    Sun Feb  1 22:29:00 1998
+++ go32.mt     Fri Jul 24 17:33:04 1998
@@ -0,0 +1,5 @@
+# That is where we keep the g++ header files.
+gxx_include_dir =$(prefix)/lang/cxx
+
+G_CONFIG_ARGS=size_t="long unsigned int"
+
EOF

################################################################################				
#
#  Rename include files in libstdc++. Fix also corresponding sources and
#  depend file
#
################################################################################				
for incname in $LIBSTDCXX_RENAME; do
	newname=`echo $incname | sed -e 's,_,,g'`
	if test -f libstdc++/stl/$incname; then
		flist=`grep -l '<'$incname'>' libstdc++/stl/* 2>/dev/null`;
		for file in $flist; do
			sed -e 's,<'$incname'>,<'$newname'>,g' $file >$file.new;
			update $file;
		done;
	fi;
done;
#
for incname in $LIBSTDCXX_RENAME; do	 
	if test -f libstdc++/stl/$incname; then
		newname=`echo $incname | sed -e 's,_,,g'`
		mv -f libstdc++/stl/$incname libstdc++/stl/$newname;
		echo "Rename libstdc++/stl/$incname ==> libstdc++/stl/$newname"
	fi;
done;	   
#
################################################################################

for file in libstdc++/Makefile.in libstdc++/tests/Makefile.in; do
	sed -e 's,libstdc[+][+][.]a,libstdcxx.a,g' \
	    -e 's,-lstdc[+][+],-lstdcxx,g' $file >$file.new;
	update $file;
done		

################################################################################				
#
#  Rename include files in libg++. Fix also corresponding sources and
#  depend file
#
################################################################################				
#
if [ -d libg++ ]; then 
	flisth=`find libg++ -name '*.h'`;
	flistcc=`find libg++ -name '*.cc'`;
	flistin=`find libg++ -name Makefile.in`;

	for incname in $LIBGPP_RENAME; do
		if test -f libg++/src/$incname; then
			newname=_$incname;
			edlist=`grep -l '<'$incname'>' $flisth $flistcc`;
			for file in $edlist; do
				sed -e 's,<'$incname'>,<'$newname'>,g' $file >$file.new
				update $file
			done;
		fi;
	done;	
		
#
	for incname in $LIBGPP_RENAME; do
		if test -f libg++/src/$incname; then
  	       		newname=_$incname;
	       		mv -f libg++/src/$incname libg++/src/$newname;
	       		echo "Rename libg++/src/$incname ==> libg++/src/$newname";
		fi;	     
	done;	
#
	for file in libg++/tests/test_h.cc; do
		sed -e 's,sys[/]signal[.]h,signal.h,g' $file >$file.new;
		update $file;
	done
#
	for file in `find libg++ -name depend`; do
		sed -e 's,[/]String.h,/_String.h,g' \
		    -e 's,[/]Regex.h,/_Regex.h,g' \
		    -e 's,[/]Complex.h,/_Complex.h,g' $file >$file.new;
		update $file;
	done;	
#
	for file in $flistin; do
		sed -e 's,libstdc[+][+][.]a,libstdcxx.a,g' \
		    -e 's,-lstdc[+][+],-lstdcxx,g' \
		    -e 's,libg[+][+][.]a,libgpp.a,g' \
		    -e 's,-lg[+][+],-lgpp,g' $file >$file.new
	        update $file
	done;
#
#
	patch -Nb libg++/etc/trie-gen/Makefile.in << 'EOF'
--- Makefile.in.orig	Mon Nov  2 16:45:24 1998
+++ Makefile.in	Mon Nov  2 17:11:10 1998
@@ -28,15 +28,15 @@
 trie-gen: $(OBJS) 
 	$(CXX) $(CXXFLAGS) -o $@ $(OBJS) $(LIBS)
 
-LS_1 = /bin/ls # -1 default on most systems, not supported on all.
+LS_1 = ls # -1 default on most systems, not supported on all.
 
 out.cc: trie-gen
 	@echo "Generating a compacted minimal-prefix trie for files in /bin"
-	$(LS_1) /bin | ./trie-gen -c > out.cc
+	$(LS_1) $(DJDIR) | ./trie-gen -c > out.cc
 
 check: out.o test.o
 	$(CXX) $(CXXFLAGS) out.o test.o $(LIBS)
-	$(LS_1) /bin | ./a.out -v
+	$(LS_1) $(DJDIR) | ./a.out -v
 
 run_tests: check
EOF


	patch -Nb libg++/etc/benchmarks/dhrystone.cc << 'EOF'
--- dhrystone.cc~	Sat Mar 11 10:42:00 1995
+++ dhrystone.cc	Fri Mar 20 13:11:14 1998
@@ -307,9 +307,13 @@
 
 /* define only one of the next two defines */
 #ifndef _G_SYSV
+#ifndef __DJGPP__
 #define TIMES			/* Use times(2) time function */
 #else
 #define TIME			/* Use time(2) time function */
+#endif /* __DJGPP__ */
+#else
+#define TIME			/* Use time(2) time function */
 #endif
 
 #ifdef TIMES
EOF
fi 

################################################################################				
#
#  gcc 
#
################################################################################				
#
patch -Nb gcc/Makefile.in << 'EOF'
--- Makefile.in.orig	Wed Mar 10 14:18:08 1999
+++ Makefile.in	Wed Mar 10 14:21:16 1999
@@ -366,6 +366,10 @@
 # the gcc driver.
 EXTRA_GCC_OBJS =@host_extra_gcc_objs@
 
+# List of extra object files that should be compiled and linked with
+# the collect2.
+EXTRA_COLLECT2_OBJS =
+
 # List of additional header files to install.
 # Often this is edited directly by `configure'.
 EXTRA_HEADERS =@extra_headers_list@
@@ -1291,11 +1295,12 @@
     flags.h toplev.h $(EXPR_H)
 
 collect2$(exeext): collect2.o tlink.o hash.o cplus-dem.o underscore.o \
-	version.o choose-temp.o mkstemp.o $(LIBDEPS)
+	version.o choose-temp.o mkstemp.o $(EXTRA_COLLECT2_OBJS) $(LIBDEPS)
 # Don't try modifying collect2 (aka ld) in place--it might be linking this.
 	-rm -f collect2$(exeext)
 	$(CC) $(ALL_CFLAGS) $(LDFLAGS) -o $@ collect2.o tlink.o hash.o \
-	  cplus-dem.o underscore.o version.o choose-temp.o mkstemp.o $(LIBS)
+	  cplus-dem.o underscore.o version.o choose-temp.o mkstemp.o \
+	  $(EXTRA_COLLECT2_OBJS) $(LIBS)
 
 collect2.o : collect2.c $(CONFIG_H) system.h gansidecl.h gstab.h obstack.h \
 	$(DEMANGLE_H)
EOF

sed -e 's,SYSCALLS[.]c[.]X,SYSCALLS.cX,g' gcc/Makefile.in >gcc/Makefile.in.new
update gcc/Makefile.in

#-------------------------------------------------------------------------------
#   Patch gcc/configure.in:  add xmake_file=i386/x-go32
#-------------------------------------------------------------------------------
patch -Nb gcc/configure.in << 'EOF'
--- configure.in.orig	Mon Mar  8 00:22:22 1999
+++ configure.in	Wed Mar 10 14:21:16 1999
@@ -988,7 +988,14 @@
 		tm_file=i386/go32.h
 		tmake_file=i386/t-go32
 		gnu_ld=yes
+		xmake_file=i386/x-go32
 		gas=yes
+		exeext=.exe
+		case $host in
+		*pc-msdosdjgpp*)
+			target_alias=djgpp
+			;;
+		esac
 		;;
 	i[[34567]]86-moss-msdos* | i[[34567]]86-*-moss*)
 		tm_file=i386/moss.h
EOF
#-------------------------------------------------------------------------------
#   Apply GPC patch to GCC sources if GNU Pascal sources are found
#   (Currently last is for 2.91.60 
#-------------------------------------------------------------------------------
if [ -d gcc/p ]; then
	if [ -f gcc/p/diffs/${GPC_PATCH_FILE} ]; then
		( 
			echo '==============================================';
			echo "Applying GPC patch file $GPC_PATCH_FILE";
			cd gcc; 
			patch -p1 <p/diffs/${GPC_PATCH_FILE};
			echo '==============================================';
		)
	else
		echo "ERROR GNU Pascal sources installed but no patch for GCC found";
		exit 1;
	fi
fi
#-------------------------------------------------------------------------------
#   Patch gcc/cccp.c:   new macro DIR_SEPARATOR_1 
#-------------------------------------------------------------------------------
patch -Nb gcc/cccp.c << 'EOF'
--- cccp.c.orig	Tue Jul 21 14:30:56 1998
+++ cccp.c	Mon Nov  2 17:07:42 1998
@@ -421,7 +421,9 @@
   = {
     /* Pick up GNU C++ specific include files.  */
     { GPLUSPLUS_INCLUDE_DIR, "G++", 1, 1 },
+#ifndef __DJGPP__
     { OLD_GPLUSPLUS_INCLUDE_DIR, 0, 1, 1 },
+#endif
 #ifdef CROSS_COMPILE
     /* This is the dir for fixincludes.  Put it just before
        the files that we fix.  */
@@ -4799,6 +4801,10 @@
    It is OK to miss simplifications on non-Posix hosts,
    since this merely leads to suboptimal results.  */
 
+/* For DJGPP additionally translate BACKSLASHES to SLASHES
+   at startup (when both DIR_SEPARATOR and DIR_SEPARATOR_1 are defined
+   and they are different). */
+
 static size_t
 simplify_filename (filename)
      char *filename;
@@ -4807,6 +4813,14 @@
   register char *to = filename;
   char *to0;
 
+  #if defined(DIR_SEPARATOR) && defined(DIR_SEPARATOR_1)
+    #if DIR_SEPARATOR!=DIR_SEPARATOR_1
+      for (to0=filename; *to0; to0++)
+        if (*to0==DIR_SEPARATOR)
+          *to0=DIR_SEPARATOR_1;
+    #endif
+  #endif 
+
   /* Remove redundant initial /s.  */
   if (*from == '/') {
     *to++ = '/';
@@ -10044,6 +10058,10 @@
 #define DIR_SEPARATOR '/'
 #endif
 
+#ifndef DIR_SEPARATOR_1
+#define DIR_SEPARATOR_1 DIR_SEPARATOR
+#endif
+
 /* The previous include prefix, if any, is PREV_FILE_NAME.
    Translate any pathnames with COMPONENT.
    Allocate a new include prefix whose name is the
@@ -10088,7 +10106,7 @@
 	/* must be '/', hack_vms_include_specification triggers on it.  */
 	dir->fname[len++] = '/';
 #else
-	dir->fname[len++] = DIR_SEPARATOR;
+	dir->fname[len++] = DIR_SEPARATOR_1;
 #endif
       dir->fname[len] = 0;
     }
EOF
#-------------------------------------------------------------------------------
#   Patch gcc/cpplib.c: not actually needed, but if somebody wants to use
#   --enable-c-cpplib ...
#-------------------------------------------------------------------------------
patch -Nb gcc/cpplib.c << 'EOF'
--- cpplib.c~	Mon Jul 20 22:36:24 1998
+++ cpplib.c	Thu Dec 10 16:24:22 1998
@@ -302,7 +302,9 @@
   = {
     /* Pick up GNU C++ specific include files.  */
     { GPLUSPLUS_INCLUDE_DIR, "G++", 1, 1 },
+#ifndef __DJGPP__
     { OLD_GPLUSPLUS_INCLUDE_DIR, 0, 1, 1 },
+#endif
 #ifdef CROSS_COMPILE
     /* This is the dir for fixincludes.  Put it just before
        the files that we fix.  */

EOF
#-------------------------------------------------------------------------------
#   Patch gcc/gcc.c:   new macro DIR_SEPARATOR_1, other changes
#-------------------------------------------------------------------------------
patch -Nb gcc/gcc.c << 'EOF'
--- gcc.c.orig	Thu Aug  6 16:15:52 1998
+++ gcc.c	Fri Aug  7 11:12:26 1998
@@ -112,7 +112,11 @@
 #define DIR_SEPARATOR '/'
 #endif
 
-static char dir_separator_str[] = {DIR_SEPARATOR, 0};
+#ifndef DIR_SEPARATOR_1
+#define DIR_SEPARATOR_1 DIR_SEPARATOR
+#endif
+
+static char dir_separator_str[] = {DIR_SEPARATOR_1, 0};
 
 #define obstack_chunk_alloc xmalloc
 #define obstack_chunk_free free
@@ -2629,7 +2633,7 @@
 		strcpy (nstore, concat (".", dir_separator_str, NULL_PTR));
 	      else if (endp[-1] != '/' && endp[-1] != DIR_SEPARATOR)
 		{
-		  nstore[endp-startp] = DIR_SEPARATOR;
+		  nstore[endp-startp] = DIR_SEPARATOR_1;
 		  nstore[endp-startp+1] = 0;
 		}
 	      else
@@ -2663,7 +2667,7 @@
 		strcpy (nstore, concat (".", dir_separator_str, NULL_PTR));
 	      else if (endp[-1] != '/' && endp[-1] != DIR_SEPARATOR)
 		{
-		  nstore[endp-startp] = DIR_SEPARATOR;
+		  nstore[endp-startp] = DIR_SEPARATOR_1;
 		  nstore[endp-startp+1] = 0;
 		}
 	      else
@@ -2696,7 +2700,7 @@
 		strcpy (nstore, concat (".", dir_separator_str, NULL_PTR));
 	      else if (endp[-1] != '/' && endp[-1] != DIR_SEPARATOR)
 		{
-		  nstore[endp-startp] = DIR_SEPARATOR;
+		  nstore[endp-startp] = DIR_SEPARATOR_1;
 		  nstore[endp-startp+1] = 0;
 		}
 	      else
@@ -2986,6 +2990,7 @@
 
 	    case 'o':
 	      have_o = 1;
+#if !defined(__DJGPP__)	      
 #if defined(HAVE_EXECUTABLE_SUFFIX)
 	      if (! have_c)
 		{
@@ -3021,6 +3026,7 @@
 	      else
 		argv[i] = convert_filename (argv[i], ! have_c);
 #endif
+#endif /* __DJGPP__  */
 	      goto normal_switch;
 
 	    default:
@@ -4588,7 +4594,7 @@
   bcopy (path2, path + len1, len2);
   cp = path + len1 + len2;
   if (cp[-1] != '/' && cp[-1] != DIR_SEPARATOR)
-    *cp++ = DIR_SEPARATOR;
+    *cp++ = DIR_SEPARATOR_1;
   *cp++ = '.';
   *cp = '\0';
 
@@ -4709,7 +4715,11 @@
   /* Choose directory for temp files.  */
 
 #ifndef MKTEMP_EACH_FILE
+#if defined(__MSDOS__) && defined(__GO32__)
+  temp_filename = "";
+#else
   temp_filename = choose_temp_base ();
+#endif  
   temp_filename_length = strlen (temp_filename);
 #endif
 
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/p/gpc.c
#-------------------------------------------------------------------------------
test -f gcc/p/gpc.c && patch -Nb gcc/p/gpc.c << 'EOF'
--- gpc.c~1	Sun Jan 17 22:43:56 1999
+++ gpc.c	Sat Mar 13 16:11:02 1999
@@ -4670,7 +4670,11 @@
 
   /* Choose a name for the AutoMake temp file.
    */
+  #if !defined(DJGPP) && !defined(MKTEMP_EACH_FILE)
   automake_temp_file_name = concat (choose_temp_base(), ".gpc", NULL_PTR);
+  #else
+  automake_temp_file_name = choose_temp_base();
+  #endif
 
   /* Add an implicit command line argument `--amtmpfile=ccXXXXXX.gpc'.
    */
@@ -5047,8 +5051,13 @@
 
   /* Choose directory for temp files.  */
 
+#if !defined(DJGPP) || !defined(MKTEMP_EACH_FILE)
   temp_filename = choose_temp_base ();
+#else
+  temp_filename = "";
+#endif
   temp_filename_length = strlen (temp_filename);
+
 
   /* Make a table of what switches there are (switches, n_switches).
      Make a table of specified input files (infiles, n_infiles).
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/dwarf2out.c (exceptions handling)
#-------------------------------------------------------------------------------
patch -Nb gcc/dwarf2out.c << 'EOF'
--- dwarf2out.c~1	Thu Jul 30 12:52:18 1998
+++ dwarf2out.c	Mon Jan 25 15:46:16 1999
@@ -53,6 +53,10 @@
 # define assert(e) do { if (! (e)) abort (); } while (0)
 #endif
 
+#ifndef ASM_OUTPUT_ALIGN_Z
+#define ASM_OUTPUT_ALIGN_Z(FILE,LOG) ASM_OUTPUT_ALIGN(FILE,LOG)
+#endif
+
 /* Decide whether we want to emit frame unwind information for the current
    translation unit.  */
 
@@ -1770,7 +1774,7 @@
     output_cfi (cfi, NULL);
 
   /* Pad the CIE out to an address sized boundary.  */
-  ASM_OUTPUT_ALIGN (asm_out_file, floor_log2 (PTR_SIZE));
+  ASM_OUTPUT_ALIGN_Z (asm_out_file, floor_log2 (PTR_SIZE));
   ASM_OUTPUT_LABEL (asm_out_file, l2);
 #ifdef ASM_OUTPUT_DEFINE_LABEL_DIFFERENCE_SYMBOL
   ASM_OUTPUT_DEFINE_LABEL_DIFFERENCE_SYMBOL (asm_out_file, ld, l2, l1);
@@ -1830,7 +1834,7 @@
 	output_cfi (cfi, fde);
 
       /* Pad the FDE out to an address sized boundary.  */
-      ASM_OUTPUT_ALIGN (asm_out_file, floor_log2 (PTR_SIZE));
+      ASM_OUTPUT_ALIGN_Z (asm_out_file, floor_log2 (PTR_SIZE));
       ASM_OUTPUT_LABEL (asm_out_file, l2);
 #ifdef ASM_OUTPUT_DEFINE_LABEL_DIFFERENCE_SYMBOL
       ASM_OUTPUT_DEFINE_LABEL_DIFFERENCE_SYMBOL (asm_out_file, ld, l2, l1);
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/final.c
#-------------------------------------------------------------------------------
patch -Nb gcc/final.c << 'EOF'
--- final.c.orig	Mon Jun 29 21:39:44 1998
+++ final.c	Wed Mar 10 14:21:18 1999
@@ -417,7 +417,7 @@
 	assemble_integer (const0_rtx, pointer_bytes, 1);
 
       /* byte count for extended structure.  */
-      assemble_integer (GEN_INT (10 * UNITS_PER_WORD), long_bytes, 1);
+      assemble_integer (GEN_INT (11 * UNITS_PER_WORD), long_bytes, 1);
 
       /* address of function name table */
       if (profile_block_flag)
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/prefix.c
#-------------------------------------------------------------------------------
patch -Nb gcc/prefix.c << 'EOF'
--- prefix.c.orig	Wed Mar 10 14:18:10 1999
+++ prefix.c	Wed Mar 10 14:21:18 1999
@@ -311,6 +311,18 @@
     }
       
 #ifdef DIR_SEPARATOR
+#ifdef DIR_SEPARATOR_1
+  if (DIR_SEPARATOR != DIR_SEPARATOR_1)
+    {
+      int i;
+      int len = strlen (path);
+
+      path = save_string (path, len);
+      for (i = 0; i < len; i++)
+	if (path[i] == DIR_SEPARATOR)
+	  path[i] = DIR_SEPARATOR_1;
+    }
+#else
   if (DIR_SEPARATOR != '/')
     {
       int i;
@@ -322,7 +334,7 @@
 	  path[i] = DIR_SEPARATOR;
     }
 #endif
-
+#endif
   return path;
 }
 
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/choose-temp.c
#-------------------------------------------------------------------------------
patch -Nb gcc/choose-temp.c << 'EOF'
--- choose-temp.c~	Tue Jun 30 04:41:42 1998
+++ choose-temp.c	Tue Aug 11 18:16:15 1998
@@ -58,6 +58,7 @@
 #include "libiberty.h"
 #if defined (__MSDOS__) || defined (_WIN32)
 #define DIR_SEPARATOR '\\'
+#define DIR_SEPARATOR_1 '/'
 #endif
 #endif
 
@@ -65,6 +66,10 @@
 #define DIR_SEPARATOR '/'
 #endif
 
+#ifndef DIR_SEPARATOR_1
+#define DIR_SEPARATOR_1 DIR_SEPARATOR
+#endif
+
 /* On MSDOS, write temp files in current dir
    because there's no place else we can expect to use.  */
 /* ??? Although the current directory is tried as a last resort,
@@ -140,7 +145,7 @@
   if (len != 0
       && temp_filename[len-1] != '/'
       && temp_filename[len-1] != DIR_SEPARATOR)
-    temp_filename[len++] = DIR_SEPARATOR;
+    temp_filename[len++] = DIR_SEPARATOR_1;
   strcpy (temp_filename + len, TEMP_FILE);
 
   mktemp (temp_filename);
@@ -193,7 +198,7 @@
   if (base_len != 0
       && temp_filename[base_len-1] != '/'
       && temp_filename[base_len-1] != DIR_SEPARATOR)
-    temp_filename[base_len++] = DIR_SEPARATOR;
+    temp_filename[base_len++] = DIR_SEPARATOR_1;
   strcpy (temp_filename + base_len, TEMP_FILE);
 
   if (suffix)
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/collect2.c (patch from Mark E.)
#-------------------------------------------------------------------------------
patch -Nb gcc/collect2.c << 'EOF'
--- collect2.c.orig	Wed Oct 28 19:18:06 1998
+++ collect2.c	Wed Nov  4 13:06:00 1998
@@ -35,9 +35,17 @@
 #include "demangle.h"
 #include "obstack.h"
 #include "gansidecl.h"
-#ifdef __CYGWIN32__
-#include <process.h>
-#endif
+
+/* Declarations for pexecute.c */
+extern int pexecute PROTO ((const char *, char * const *, const char *,
+			    const char *, char **, char **, int));
+extern int pwait PROTO ((int, int *, int));
+
+/* Flag arguments to pexecute.  */
+#define PEXECUTE_FIRST   1
+#define PEXECUTE_LAST    2
+#define PEXECUTE_SEARCH  4
+#define PEXECUTE_VERBOSE 8
 
 /* Obstack allocation and deallocation routines.  */
 #define obstack_chunk_alloc xmalloc
@@ -47,6 +55,9 @@
 #define vfork fork
 #endif
 
+/* Pid of the process spawned by pexecute. */
+int pid;
+
 #ifndef WIFSIGNALED
 #define WIFSIGNALED(S) (((S) & 0xff) != 0 && ((S) & 0xff) != 0x7f)
 #endif
@@ -933,6 +944,10 @@
   int first_file;
   int num_c_args	= argc+9;
 
+#ifdef __DJGPP__
+  __system_flags |= (__system_allow_multiple_cmds | __system_emulate_chdir);
+#endif
+
 #ifdef DEBUG
   debug = 1;
 #endif
@@ -1570,7 +1585,7 @@
 {
   int status;
 
-  wait (&status);
+  pwait (pid, &status, 0);
   if (status)
     {
       if (WIFSIGNALED (status))
@@ -1611,7 +1626,7 @@
 }
 
 
-/* Fork and execute a program, and wait for the reply.  */
+/* Execute a program, and wait for the reply.  */
 
 void
 collect_execute (prog, argv, redir)
@@ -1619,7 +1634,11 @@
      char **argv;
      char *redir;
 {
-  int pid;
+  char *errmsg_fmt;
+  char *errmsg_arg;
+  int redir_handle = -1;
+  int stdout_save = -1;
+  int stderr_save = -1;
 
   if (vflag || debug)
     {
@@ -1646,36 +1665,39 @@
   if (argv[0] == 0)
     fatal ("cannot find `%s'", prog);
 
-#ifndef __CYGWIN32__
-  pid = vfork ();
-  if (pid == -1)
-    {
-#ifdef vfork
-      fatal_perror ("fork");
-#else
-      fatal_perror ("vfork");
-#endif
-    }
+  if (redir)
+  {
+/* Open response file */
+    redir_handle = open(redir, O_WRONLY | O_TRUNC | O_CREAT);
 
-  if (pid == 0)			/* child context */
-    {
-      if (redir)
-	{
-	  unlink (redir);
-	  if (freopen (redir, "a", stdout) == NULL)
-	    fatal_perror ("redirecting stdout: %s", redir);
-	  if (freopen (redir, "a", stderr) == NULL)
-	    fatal_perror ("redirecting stderr: %s", redir);
-	}
+/* Duplicate the stdout and stderr file handles so they can be restored later */
+    stdout_save = dup(STDOUT_FILENO);
+    if (stdout_save == -1)
+      fatal_perror ("redirecting stdout: %s", redir);
+
+    stderr_save = dup(STDERR_FILENO);
+    if (stderr_save == -1)
+      fatal_perror ("redirecting stdout: %s", redir);
+
+/* Redirect stdout & stderr to our response file */
+    dup2(redir_handle, STDOUT_FILENO);
+    dup2(redir_handle, STDERR_FILENO);
+  }
+
+  pid = pexecute(argv[0], argv, argv[0], NULL, &errmsg_fmt, &errmsg_arg,
+                 (PEXECUTE_FIRST | PEXECUTE_LAST | PEXECUTE_SEARCH));
+
+  if (redir)
+  {
+/* Restore stdout and stderr to their previous settings */
+    dup2 (stdout_save, STDOUT_FILENO);
+    dup2 (stderr_save, STDERR_FILENO);
+/* Close reponse file */
+    close (redir_handle);
+  }
 
-      execvp (argv[0], argv);
-      fatal_perror ("executing %s", prog);
-    }
-#else
-  pid = _spawnvp (_P_NOWAIT, argv[0], argv);
   if (pid == -1)
-    fatal ("spawnvp failed");
-#endif
+    fatal_perror (errmsg_fmt, errmsg_arg);
 }
 
 static void
EOF
#-------------------------------------------------------------------------------
#   Patch gcc/cp/g++spec.c:  rename -lstdc++ to -lstdcxx
#-------------------------------------------------------------------------------
patch -Nb gcc/cp/g++spec.c << 'EOF'
--- g++spec.c.orig	Wed Aug  5 17:22:34 1998
+++ g++spec.c	Wed Aug  5 17:24:47 1998
@@ -239,7 +239,12 @@
   /* Add `-lstdc++' if we haven't already done so.  */
   if (library)
     {
+#ifdef __DJGPP__
+/* libstdc++.a is an invalid name on DOS, so we have there libstdcxx.a */
+      arglist[j++] = "-lstdcxx";
+#else
       arglist[j++] = "-lstdc++";
+#endif
       added_libraries++;
     }
   if (saw_math)
EOF



#-------------------------------------------------------------------------------
#   Replace libiberty/cplus-dem.c and gcc/cplus-dem.c with newer version
#   from development snapshot. That is needed to fix collect2.exe
#   I included check to be sure this patch will not be used for next
#   major release of egcs.
#-------------------------------------------------------------------------------
grep egcs[-]2[.]91 gcc/version.c >/dev/null || \
	( echo "Patching cplus-dem.c is not required for this version"; \
	  echo "Please fix this script."; \
	  exit 1; )
patch -Nb libiberty/cplus-dem.c << 'EOF'
RCS file: /cvs/egcs/egcs/libiberty/cplus-dem.c,v
retrieving revision 1.17.2.2
retrieving revision 1.32
diff -p -u -r1.17.2.2 -r1.32
--- egcs/libiberty/cplus-dem.c	1998/11/23 08:52:34	1.17.2.2
+++ /cvs/egcs/egcs/libiberty/cplus-dem.c	1998/11/13 05:55:40	1.32
@@ -1,5 +1,5 @@
 /* Demangler for GNU C++ 
-   Copyright 1989, 1991, 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
+   Copyright 1989, 91, 94, 95, 96, 97, 1998 Free Software Foundation, Inc.
    Written by James Clark (jjc@jclark.uucp)
    Rewritten by Fred Fish (fnf@cygnus.com) for ARM and Lucid demangling
    
@@ -28,6 +28,10 @@ Boston, MA 02111-1307, USA.  */
 /* This file lives in both GCC and libiberty.  When making changes, please
    try not to break either.  */
 
+#ifdef HAVE_CONFIG_H
+#include "config.h"
+#endif
+
 #include <ctype.h>
 #include <sys/types.h>
 #include <string.h>
@@ -35,6 +39,9 @@ Boston, MA 02111-1307, USA.  */
 
 #ifdef HAVE_STDLIB_H
 #include <stdlib.h>
+#else
+char * malloc ();
+char * realloc ();
 #endif
 
 #include <demangle.h>
@@ -119,8 +126,8 @@ struct work_stuff
   int constructor;
   int destructor;
   int static_type;	/* A static member function */
-  int const_type;	/* A const member function */
-  int volatile_type;    /* A volatile member function */
+  int type_quals;       /* The type qualifiers.  */
+  int dllimported;	/* Symbol imported from a PE DLL */
   char **tmpl_argvec;   /* Template function arguments. */
   int ntmpl_args;       /* The number of template function arguments. */
   int forgetting_types; /* Nonzero if we are not remembering the types
@@ -220,7 +227,20 @@ static const struct optable
   {"sz",          "sizeof ",    DMGL_ANSI}      /* pseudo-ansi */
 };
 
-
+/* These values are used to indicate the various type varieties.
+   They are all non-zero so that they can be used as `success'
+   values.  */
+typedef enum type_kind_t 
+{ 
+  tk_none,
+  tk_pointer,
+  tk_reference,
+  tk_integral, 
+  tk_bool,
+  tk_char, 
+  tk_real
+} type_kind_t;
+			     
 #define STRING_EMPTY(str)	((str) -> b == (str) -> p)
 #define PREPEND_BLANK(str)	{if (!STRING_EMPTY(str)) \
     string_prepend(str, " ");}
@@ -369,8 +389,26 @@ static void
 string_prepends PARAMS ((string *, string *));
 
 static int 
-demangle_template_value_parm PARAMS ((struct work_stuff*, 
-				      const char**, string*)); 
+demangle_template_value_parm PARAMS ((struct work_stuff*, const char**, 
+				      string*, type_kind_t));
+
+/* There is a TYPE_QUAL value for each type qualifier.  They can be
+   combined by bitwise-or to form the complete set of qualifiers for a
+   type.  */
+
+#define TYPE_UNQUALIFIED   0x0
+#define TYPE_QUAL_CONST    0x1
+#define TYPE_QUAL_VOLATILE 0x2
+#define TYPE_QUAL_RESTRICT 0x4
+
+static int 
+code_for_qualifier PARAMS ((char));
+
+static const char*
+qualifier_string PARAMS ((int));
+
+static const char*
+demangle_qualifier PARAMS ((char));
 
 /*  Translate count to integer, consuming tokens in the process.
     Conversion terminates on the first non-digit character.
@@ -383,7 +421,7 @@ consume_count (type)
 {
   int count = 0;
 
-  while (isdigit (**type))
+  while (isdigit ((unsigned char)**type))
     {
       count *= 10;
       count += **type - '0';
@@ -406,7 +444,7 @@ consume_count_with_underscores (mangled)
   if (**mangled == '_')
     {
       (*mangled)++;
-      if (!isdigit (**mangled))
+      if (!isdigit ((unsigned char)**mangled))
 	return -1;
 
       idx = consume_count (mangled);
@@ -428,6 +466,84 @@ consume_count_with_underscores (mangled)
   return idx;
 }
 
+/* C is the code for a type-qualifier.  Return the TYPE_QUAL
+   corresponding to this qualifier.  */
+
+static int
+code_for_qualifier (c)
+     char c;
+{
+  switch (c) 
+    {
+    case 'C':
+      return TYPE_QUAL_CONST;
+
+    case 'V':
+      return TYPE_QUAL_VOLATILE;
+      
+    case 'u':
+      return TYPE_QUAL_RESTRICT;
+
+    default:
+      break;
+    }
+
+  /* C was an invalid qualifier.  */
+  abort ();
+}
+
+/* Return the string corresponding to the qualifiers given by
+   TYPE_QUALS.  */
+
+static const char*
+qualifier_string (type_quals)
+     int type_quals;
+{
+  switch (type_quals)
+    {
+    case TYPE_UNQUALIFIED:
+      return "";
+
+    case TYPE_QUAL_CONST:
+      return "const";
+
+    case TYPE_QUAL_VOLATILE:
+      return "volatile";
+
+    case TYPE_QUAL_RESTRICT:
+      return "__restrict";
+
+    case TYPE_QUAL_CONST | TYPE_QUAL_VOLATILE:
+      return "const volatile";
+
+    case TYPE_QUAL_CONST | TYPE_QUAL_RESTRICT:
+      return "const __restrict";
+
+    case TYPE_QUAL_VOLATILE | TYPE_QUAL_RESTRICT:
+      return "volatile __restrict";
+
+    case TYPE_QUAL_CONST | TYPE_QUAL_VOLATILE | TYPE_QUAL_RESTRICT:
+      return "const volatile __restrict";
+
+    default:
+      break;
+    }
+
+  /* TYPE_QUALS was an invalid qualifier set.  */
+  abort ();
+}
+
+/* C is the code for a type-qualifier.  Return the string
+   corresponding to this qualifier.  This function should only be
+   called with a valid qualifier code.  */
+
+static const char*
+demangle_qualifier (c)
+     char c;
+{
+  return qualifier_string (code_for_qualifier (c));
+}
+
 int
 cplus_demangle_opname (opname, result, options)
      const char *opname;
@@ -512,7 +628,7 @@ cplus_demangle_opname (opname, result, o
 	  for (i = 0; i < sizeof (optable) / sizeof (optable[0]); i++)
 	    {
 	      len1 = len - 10;
-	      if (strlen (optable[i].in) == len1
+	      if ((int) strlen (optable[i].in) == len1
 		  && memcmp (optable[i].in, opname + 10, len1) == 0)
 		{
 		  strcat (result, "operator");
@@ -529,7 +645,7 @@ cplus_demangle_opname (opname, result, o
 	  for (i = 0; i < sizeof (optable) / sizeof (optable[0]); i++)
 	    {
 	      len1 = len - 3;
-	      if (strlen (optable[i].in) == len1 
+	      if ((int) strlen (optable[i].in) == len1 
 		  && memcmp (optable[i].in, opname + 3, len1) == 0)
 		{
 		  strcat (result, "operator");
@@ -574,7 +690,7 @@ cplus_mangle_opname (opname, options)
   len = strlen (opname);
   for (i = 0; i < sizeof (optable) / sizeof (optable[0]); i++)
     {
-      if (strlen (optable[i].out) == len
+      if ((int) strlen (optable[i].out) == len
 	  && (options & DMGL_ANSI) == (optable[i].flags & DMGL_ANSI)
 	  && memcmp (optable[i].out, opname, len) == 0)
 	return optable[i].in;
@@ -644,15 +760,13 @@ internal_cplus_demangle (work, mangled)
   int success = 0;
   char *demangled = NULL;
   int s1,s2,s3,s4;
-  int saved_volatile_type;
   s1 = work->constructor;
   s2 = work->destructor;
   s3 = work->static_type;
-  s4 = work->const_type;
-  saved_volatile_type = work->volatile_type;
+  s4 = work->type_quals;
   work->constructor = work->destructor = 0;
-  work->static_type = work->const_type = 0;
-  work->volatile_type = 0;
+  work->type_quals = TYPE_UNQUALIFIED;
+  work->dllimported = 0;
 
   if ((mangled != NULL) && (*mangled != '\0'))
     {
@@ -687,13 +801,17 @@ internal_cplus_demangle (work, mangled)
           string_prepend (&decl, "global destructors keyed to ");
           work->destructor = 0;
         }
+      else if (work->dllimported == 1)
+        {
+          string_prepend (&decl, "import stub for ");
+          work->dllimported = 0;
+        }
       demangled = mop_up (work, &decl, success);
     }
   work->constructor = s1;
   work->destructor = s2;
   work->static_type = s3;
-  work->const_type = s4;
-  work->volatile_type = saved_volatile_type;
+  work->type_quals = s4;
   return (demangled);
 }
 
@@ -845,10 +963,8 @@ demangle_signature (work, mangled, declp
 
 	case 'C':
 	case 'V':
-	  if (**mangled == 'C')
-	    work -> const_type = 1;
-	  else
-	    work->volatile_type = 1;
+	case 'u':
+	  work->type_quals |= code_for_qualifier (**mangled);
 
 	  /* a qualified member function */
 	  if (oldmangled == NULL)
@@ -925,7 +1041,8 @@ demangle_signature (work, mangled, declp
 	    {
 	      remember_type (work, oldmangled, *mangled - oldmangled);
 	    }
-	  string_append(&tname, SCOPE_STRING (work));
+	  string_append (&tname, SCOPE_STRING (work));
+
 	  string_prepends(declp, &tname);
 	  if (work -> destructor & 1)
 	    {
@@ -1029,12 +1146,16 @@ demangle_signature (work, mangled, declp
 	  success = demangle_args (work, mangled, declp);
 	}
     }
-  if (success && work -> static_type && PRINT_ARG_TYPES)
-    string_append (declp, " static");
-  if (success && work -> const_type && PRINT_ARG_TYPES)
-    string_append (declp, " const");
-  else if (success && work->volatile_type && PRINT_ARG_TYPES)
-    string_append (declp, " volatile");
+  if (success && PRINT_ARG_TYPES)
+    {
+      if (work->static_type)
+	string_append (declp, " static");
+      if (work->type_quals != TYPE_UNQUALIFIED)
+	{
+	  APPEND_BLANK (declp);
+	  string_append (declp, qualifier_string (work->type_quals));
+	}
+    }
 
   return (success);
 }
@@ -1178,7 +1299,8 @@ demangle_integral_value (work, mangled, 
 	  else
 	    need_operator = 1;
 
-	  success = demangle_template_value_parm (work, mangled, s);
+	  success = demangle_template_value_parm (work, mangled, s,
+						  tk_integral);
 	}
 
       if (**mangled != 'W')
@@ -1200,7 +1322,7 @@ demangle_integral_value (work, mangled, 
 	  string_appendn (s, "-", 1);
 	  (*mangled)++;
 	}
-      while (isdigit (**mangled))	
+      while (isdigit ((unsigned char)**mangled))
 	{
 	  string_appendn (s, *mangled, 1);
 	  (*mangled)++;
@@ -1212,76 +1334,14 @@ demangle_integral_value (work, mangled, 
 }
 
 static int 
-demangle_template_value_parm (work, mangled, s)
+demangle_template_value_parm (work, mangled, s, tk)
      struct work_stuff *work;
      const char **mangled;
      string* s;
+     type_kind_t tk;
 {
-  const char *old_p = *mangled;
-  int is_pointer = 0;
-  int is_real = 0;
-  int is_integral = 0;
-  int is_char = 0;
-  int is_bool = 0;
-  int done = 0;
   int success = 1;
 
-  while (*old_p && !done)
-    {	
-      switch (*old_p)
-	{
-	case 'P':
-	case 'p':
-	case 'R':
-	  done = is_pointer = 1;
-	  break;
-	case 'C':	/* const */
-	case 'S':	/* explicitly signed [char] */
-	case 'U':	/* unsigned */
-	case 'V':	/* volatile */
-	case 'F':	/* function */
-	case 'M':	/* member function */
-	case 'O':	/* ??? */
-	case 'J':	/* complex */
-	  old_p++;
-	  continue;
-	case 'E':       /* expression */
-	case 'Q':	/* qualified name */
-	case 'K':       /* qualified name */
-	  done = is_integral = 1;
-	  break;
-	case 'B':	/* remembered type */
-	case 'T':	/* remembered type */
-	  abort ();
-	  break;
-	case 'v':	/* void */
-	  abort ();
-	  break;
-	case 'x':	/* long long */
-	case 'l':	/* long */
-	case 'i':	/* int */
-	case 's':	/* short */
-	case 'w':	/* wchar_t */
-	  done = is_integral = 1;
-	  break;
-	case 'b':	/* bool */
-	  done = is_bool = 1;
-	  break;
-	case 'c':	/* char */
-	  done = is_char = 1;
-	  break;
-	case 'r':	/* long double */
-	case 'd':	/* double */
-	case 'f':	/* float */
-	  done = is_real = 1;
-	  break;
-	default:
-	  /* it's probably user defined type, let's assume
-	     it's integral, it seems hard to figure out
-	     what it really is */
-	  done = is_integral = 1;
-	}
-    }
   if (**mangled == 'Y')
     {
       /* The next argument is a template parameter. */
@@ -1302,9 +1362,9 @@ demangle_template_value_parm (work, mang
 	  string_append (s, buf);
 	}
     }
-  else if (is_integral)
+  else if (tk == tk_integral)
     success = demangle_integral_value (work, mangled, s);
-  else if (is_char)
+  else if (tk == tk_char)
     {
       char tmp[2];
       int val;
@@ -1322,7 +1382,7 @@ demangle_template_value_parm (work, mang
       string_appendn (s, &tmp[0], 1);
       string_appendn (s, "'", 1);
     }
-  else if (is_bool)
+  else if (tk == tk_bool)
     {
       int val = consume_count (mangled);
       if (val == 0)
@@ -1332,14 +1392,14 @@ demangle_template_value_parm (work, mang
       else
 	success = 0;
     }
-  else if (is_real)
+  else if (tk == tk_real)
     {
       if (**mangled == 'm')
 	{
 	  string_appendn (s, "-", 1);
 	  (*mangled)++;
 	}
-      while (isdigit (**mangled))	
+      while (isdigit ((unsigned char)**mangled))
 	{
 	  string_appendn (s, *mangled, 1);
 	  (*mangled)++;
@@ -1348,7 +1408,7 @@ demangle_template_value_parm (work, mang
 	{
 	  string_appendn (s, ".", 1);
 	  (*mangled)++;
-	  while (isdigit (**mangled))	
+	  while (isdigit ((unsigned char)**mangled))
 	    {
 	      string_appendn (s, *mangled, 1);
 	      (*mangled)++;
@@ -1358,14 +1418,14 @@ demangle_template_value_parm (work, mang
 	{
 	  string_appendn (s, "e", 1);
 	  (*mangled)++;
-	  while (isdigit (**mangled))	
+	  while (isdigit ((unsigned char)**mangled))
 	    {
 	      string_appendn (s, *mangled, 1);
 	      (*mangled)++;
 	    }
 	}
     }
-  else if (is_pointer)
+  else if (tk == tk_pointer || tk == tk_reference)
     {
       int symbol_len = consume_count (mangled);
       if (symbol_len == 0)
@@ -1377,8 +1437,16 @@ demangle_template_value_parm (work, mang
 	  char *p = xmalloc (symbol_len + 1), *q;
 	  strncpy (p, *mangled, symbol_len);
 	  p [symbol_len] = '\0';
-	  q = internal_cplus_demangle (work, p);
-	  string_appendn (s, "&", 1);
+	  /* We use cplus_demangle here, rather than
+	     internal_cplus_demangle, because the name of the entity
+	     mangled here does not make use of any of the squangling
+	     or type-code information we have built up thus far; it is
+	     mangled independently.  */
+	  q = cplus_demangle (p, work->options);
+	  if (tk == tk_pointer)
+	    string_appendn (s, "&", 1);
+	  /* FIXME: Pointer-to-member constants should get a
+	            qualifying class name here.  */
 	  if (q)
 	    {
 	      string_append (s, q);
@@ -1417,7 +1485,7 @@ demangle_template (work, mangled, tname,
   int success = 0;
   const char *start;
   string temp;
-  int bindex;
+  int bindex = 0;
 
   (*mangled)++;
   if (is_type)
@@ -1455,7 +1523,8 @@ demangle_template (work, mangled, tname,
 	}
       else
 	{
-	  if ((r = consume_count (mangled)) == 0 || strlen (*mangled) < r)
+	  if ((r = consume_count (mangled)) == 0
+	      || (int) strlen (*mangled) < r)
 	    {
 	      return (0);
 	    }
@@ -1518,7 +1587,8 @@ demangle_template (work, mangled, tname,
 	  success = demangle_template_template_parm (work, mangled, tname);
 	  
 	  if (success
-	      && (r2 = consume_count (mangled)) > 0 && strlen (*mangled) >= r2)
+	      && (r2 = consume_count (mangled)) > 0
+	      && (int) strlen (*mangled) >= r2)
 	    {
 	      string_append (tname, " ");
 	      string_appendn (tname, *mangled, r2);
@@ -1546,20 +1616,9 @@ demangle_template (work, mangled, tname,
 
 	  /* temp is initialized in do_type */
 	  success = do_type (work, mangled, &temp);
-	  /*
-	    if (success)
-	    {
-	    string_appends (s, &temp);
-	    }
-	    */
 	  string_delete(&temp);
 	  if (!success)
-	    {
-	      break;
-	    }
-	  /*
-	    string_append (s, "=");
-	    */
+	    break;
 
 	  if (!is_type)
 	    {
@@ -1569,7 +1628,8 @@ demangle_template (work, mangled, tname,
 	  else
 	    s = tname;
 
-	  success = demangle_template_value_parm (work, mangled, s);
+	  success = demangle_template_value_parm (work, mangled, s,
+						  (type_kind_t) success);
 
 	  if (!success)
 	    {
@@ -1592,9 +1652,11 @@ demangle_template (work, mangled, tname,
 	}
       need_comma = 1;
     }
+    {
   if (tname->p[-1] == '>')
     string_append (tname, " ");
   string_append (tname, ">");
+    }
   
   if (is_type && remember)
     remember_Btype (work, tname->b, LEN_STRING (tname), bindex);
@@ -1666,6 +1728,14 @@ demangle_arm_pt (work, mangled, n, declp
       --declp->p;
       string_append (declp, ">");
     }
+  else if (n>10 && strncmp (*mangled, "_GLOBAL_", 8) == 0
+	   && (*mangled)[9] == 'N'
+	   && (*mangled)[8] == (*mangled)[10]
+	   && strchr (cplus_markers, (*mangled)[8]))
+    {
+      /* A member of the anonymous namespace.  */
+      string_append (declp, "{anonymous}");
+    }
   else
     {
       string_appendn (declp, *mangled, n);
@@ -1683,7 +1753,7 @@ demangle_class_name (work, mangled, decl
   int success = 0;
 
   n = consume_count (mangled);
-  if (strlen (*mangled) >= n)
+  if ((int) strlen (*mangled) >= n)
     {
       demangle_arm_pt (work, mangled, n, declp);
       success = 1;
@@ -1805,7 +1875,17 @@ demangle_prefix (work, mangled, declp)
   const char *scan;
   int i;
 
-  if (strlen(*mangled) >= 11 && strncmp(*mangled, "_GLOBAL_", 8) == 0)
+  if (strlen(*mangled) > 6
+      && (strncmp(*mangled, "_imp__", 6) == 0 
+          || strncmp(*mangled, "__imp_", 6) == 0))
+    {
+      /* it's a symbol imported from a PE dynamic library. Check for both
+         new style prefix _imp__ and legacy __imp_ used by older versions
+	 of dlltool. */
+      (*mangled) += 6;
+      work->dllimported = 1;
+    }
+  else if (strlen(*mangled) >= 11 && strncmp(*mangled, "_GLOBAL_", 8) == 0)
     {
       char *marker = strchr (cplus_markers, (*mangled)[8]);
       if (marker != NULL && *marker == (*mangled)[10])
@@ -1872,19 +1952,20 @@ demangle_prefix (work, mangled, declp)
     }
   else if (work -> static_type)
     {
-      if (!isdigit (scan[0]) && (scan[0] != 't'))
+      if (!isdigit ((unsigned char)scan[0]) && (scan[0] != 't'))
 	{
 	  success = 0;
 	}
     }
   else if ((scan == *mangled)
-	   && (isdigit (scan[2]) || (scan[2] == 'Q') || (scan[2] == 't')
-	       || (scan[2] == 'K') || (scan[2] == 'H')))
+	   && (isdigit ((unsigned char)scan[2]) || (scan[2] == 'Q')
+	       || (scan[2] == 't') || (scan[2] == 'K') || (scan[2] == 'H')))
     {
       /* The ARM says nothing about the mangling of local variables.
 	 But cfront mangles local variables by prepending __<nesting_level>
 	 to them. As an extension to ARM demangling we handle this case.  */
-      if ((LUCID_DEMANGLING || ARM_DEMANGLING) && isdigit (scan[2]))
+      if ((LUCID_DEMANGLING || ARM_DEMANGLING)
+	  && isdigit ((unsigned char)scan[2]))
 	{
 	  *mangled = scan + 2;
 	  consume_count (mangled);
@@ -1903,7 +1984,8 @@ demangle_prefix (work, mangled, declp)
 	  *mangled = scan + 2;
 	}
     }
-  else if ((scan == *mangled) && !isdigit (scan[2]) && (scan[2] != 't'))
+  else if ((scan == *mangled) && !isdigit ((unsigned char)scan[2])
+	   && (scan[2] != 't'))
     {
       /* Mangled name starts with "__".  Skip over any leading '_' characters,
 	 then find the next "__" that separates the prefix from the signature.
@@ -2030,7 +2112,6 @@ gnu_special (work, mangled, declp)
 	(*mangled) += 4; /* Old style, no thunks: "_vt<CPLUS_MARKER>" */
       while (**mangled != '\0')
 	{
-	  p = strpbrk (*mangled, cplus_markers);
 	  switch (**mangled)
 	    {
 	    case 'Q':
@@ -2042,14 +2123,14 @@ gnu_special (work, mangled, declp)
 					   1);
 	      break;
 	    default:
-	      if (isdigit(*mangled[0]))
+	      if (isdigit((unsigned char)*mangled[0]))
 		{
 		  n = consume_count(mangled);
 		  /* We may be seeing a too-large size, or else a
 		     ".<digits>" indicating a static local symbol.  In
 		     any case, declare victory and move on; *don't* try
 		     to use n to allocate.  */
-		  if (n > strlen (*mangled))
+		  if (n > (int) strlen (*mangled))
 		    {
 		      success = 1;
 		      break;
@@ -2063,6 +2144,7 @@ gnu_special (work, mangled, declp)
 	      (*mangled) += n;
 	    }
 
+	  p = strpbrk (*mangled, cplus_markers);
 	  if (success && ((p == NULL) || (p == *mangled)))
 	    {
 	      if (p != NULL)
@@ -2299,7 +2381,7 @@ demangle_qualified (work, mangled, resul
       int idx;
       (*mangled)++;
       idx = consume_count_with_underscores (mangled);
-      if (idx == -1 || idx > work -> numk)
+      if (idx == -1 || idx >= work -> numk)
         success = 0;
       else
         string_append (&temp, work -> ktypevec[idx]);
@@ -2313,11 +2395,11 @@ demangle_qualified (work, mangled, resul
 	 by an underscore.  */
       p = *mangled + 2;
       qualifiers = atoi (p);
-      if (!isdigit (*p) || *p == '0')
+      if (!isdigit ((unsigned char)*p) || *p == '0')
 	success = 0;
 
       /* Skip the digits.  */
-      while (isdigit (*p))
+      while (isdigit ((unsigned char)*p))
 	++p;
 
       if (*p != '_')
@@ -2387,7 +2469,7 @@ demangle_qualified (work, mangled, resul
           int idx;
           (*mangled)++;
           idx = consume_count_with_underscores (mangled);
-          if (idx == -1 || idx > work->numk)
+          if (idx == -1 || idx >= work->numk)
             success = 0;
           else
             string_append (&temp, work->ktypevec[idx]);
@@ -2466,7 +2548,7 @@ get_count (type, count)
   const char *p;
   int n;
 
-  if (!isdigit (**type))
+  if (!isdigit ((unsigned char)**type))
     {
       return (0);
     }
@@ -2474,7 +2556,7 @@ get_count (type, count)
     {
       *count = **type - '0';
       (*type)++;
-      if (isdigit (**type))
+      if (isdigit ((unsigned char)**type))
 	{
 	  p = *type;
 	  n = *count;
@@ -2484,7 +2566,7 @@ get_count (type, count)
 	      n += *p - '0';
 	      p++;
 	    } 
-	  while (isdigit (*p));
+	  while (isdigit ((unsigned char)*p));
 	  if (*p == '_')
 	    {
 	      *type = p + 1;
@@ -2495,7 +2577,8 @@ get_count (type, count)
   return (1);
 }
 
-/* result will be initialised here; it will be freed on failure */
+/* RESULT will be initialised here; it will be freed on failure.  The
+   value returned is really a type_kind_t.  */
 
 static int
 do_type (work, mangled, result)
@@ -2508,9 +2591,9 @@ do_type (work, mangled, result)
   int success;
   string decl;
   const char *remembered_type;
-  int constp;
-  int volatilep;
+  int type_quals;
   string btype;
+  type_kind_t tk = tk_none;
 
   string_init (&btype);
   string_init (&decl);
@@ -2529,33 +2612,35 @@ do_type (work, mangled, result)
 	case 'p':
 	  (*mangled)++;
 	  string_prepend (&decl, "*");
+	  if (tk == tk_none)
+	    tk = tk_pointer;
 	  break;
 
 	  /* A reference type */
 	case 'R':
 	  (*mangled)++;
 	  string_prepend (&decl, "&");
+	  if (tk == tk_none)
+	    tk = tk_reference;
 	  break;
 
 	  /* An array */
 	case 'A':
 	  {
-	    const char *p = ++(*mangled);
-
-	    string_prepend (&decl, "(");
-	    string_append (&decl, ")[");
-	    /* Copy anything up until the next underscore (the size of the
-	       array).  */
-	    while (**mangled && **mangled != '_')
-	      ++(*mangled);
-	    if (**mangled == '_')
+	    ++(*mangled);
+	    if (!STRING_EMPTY (&decl)
+		&& (decl.b[0] == '*' || decl.b[0] == '&'))
 	      {
-		string_appendn (&decl, p, *mangled - p);
-		string_append (&decl, "]");             
-		*mangled += 1;
+		string_prepend (&decl, "(");
+		string_append (&decl, ")");
 	      }
-	    else
-	      success = 0;
+	    string_append (&decl, "[");
+	    if (**mangled != '_')
+	      success = demangle_template_value_parm (work, mangled, &decl,
+						      tk_integral);
+	    if (**mangled == '_')
+	      ++(*mangled);
+	    string_append (&decl, "]");
 	    break;
 	  }
 
@@ -2576,7 +2661,8 @@ do_type (work, mangled, result)
 	  /* A function */
 	case 'F':
 	  (*mangled)++;
-	  if (!STRING_EMPTY (&decl) && decl.b[0] == '*')
+	    if (!STRING_EMPTY (&decl)
+		&& (decl.b[0] == '*' || decl.b[0] == '&'))
 	    {
 	      string_prepend (&decl, "(");
 	      string_append (&decl, ")");
@@ -2597,12 +2683,11 @@ do_type (work, mangled, result)
 	case 'M':
 	case 'O':
 	  {
-	    constp = 0;
-	    volatilep = 0;
+	    type_quals = TYPE_UNQUALIFIED;
 
 	    member = **mangled == 'M';
 	    (*mangled)++;
-	    if (!isdigit (**mangled) && **mangled != 't')
+	    if (!isdigit ((unsigned char)**mangled) && **mangled != 't')
 	      {
 		success = 0;
 		break;
@@ -2610,10 +2695,10 @@ do_type (work, mangled, result)
 
 	    string_append (&decl, ")");
 	    string_prepend (&decl, SCOPE_STRING (work));
-	    if (isdigit (**mangled)) 
+	    if (isdigit ((unsigned char)**mangled))
 	      {
 		n = consume_count (mangled);
-		if (strlen (*mangled) < n)
+		if ((int) strlen (*mangled) < n)
 		  {
 		    success = 0;
 		    break;
@@ -2638,16 +2723,19 @@ do_type (work, mangled, result)
 	    string_prepend (&decl, "(");
 	    if (member)
 	      {
-		if (**mangled == 'C')
-		  {
-		    (*mangled)++;
-		    constp = 1;
-		  }
-		if (**mangled == 'V')
+		switch (**mangled)
 		  {
+		  case 'C':
+		  case 'V':
+		  case 'u':
+		    type_quals |= code_for_qualifier (**mangled);
 		    (*mangled)++;
-		    volatilep = 1;
+		    break;
+
+		  default:
+		    break;
 		  }
+
 		if (*(*mangled)++ != 'F')
 		  {
 		    success = 0;
@@ -2665,15 +2753,10 @@ do_type (work, mangled, result)
 	      {
 		break;
 	      }
-	    if (constp)
-	      {
-		APPEND_BLANK (&decl);
-		string_append (&decl, "const");
-	      }
-	    if (volatilep)
+	    if (type_quals != TYPE_UNQUALIFIED)
 	      {
 		APPEND_BLANK (&decl);
-		string_append (&decl, "volatile");
+		string_append (&decl, qualifier_string (type_quals));
 	      }
 	    break;
 	  }
@@ -2683,18 +2766,13 @@ do_type (work, mangled, result)
 
 	case 'C':
 	case 'V':
-	  /*
-	    if ((*mangled)[1] == 'P')
-	    {
-	    */
+	case 'u':
 	  if (PRINT_ANSI_QUALIFIERS)
 	    {
 	      if (!STRING_EMPTY (&decl))
-		{
-		  string_prepend (&decl, " ");
-		}
-	      string_prepend (&decl, 
-			      (**mangled) == 'C' ? "const" : "volatile");
+		string_prepend (&decl, " ");
+
+	      string_prepend (&decl, demangle_qualifier (**mangled));
 	    }
 	  (*mangled)++;
 	  break;
@@ -2709,7 +2787,7 @@ do_type (work, mangled, result)
 	}
     }
 
-  switch (**mangled)
+  if (success) switch (**mangled)
     {
       /* A qualified name, such as "Outer::Inner".  */
     case 'Q':
@@ -2723,11 +2801,9 @@ do_type (work, mangled, result)
     case 'B':
       (*mangled)++;
       if (!get_count (mangled, &n) || n >= work -> numb)
-          success = 0;
+	success = 0;
       else
-        {
-          string_append (result, work->btypevec[n]);
-        }
+	string_append (result, work->btypevec[n]);
       break;
 
     case 'X':
@@ -2762,6 +2838,8 @@ do_type (work, mangled, result)
 
     default:
       success = demangle_fund_type (work, mangled, result);
+      if (tk == tk_none)
+	tk = (type_kind_t) success;
       break;
     }
 
@@ -2774,11 +2852,14 @@ do_type (work, mangled, result)
 	}
     }
   else
-    {
-      string_delete (result);
-    }
+    string_delete (result);
   string_delete (&decl);
-  return (success);
+
+  if (success)
+    /* Assume an integral type, if we're not sure.  */
+    return (int) ((tk == tk_none) ? tk_integral : tk);
+  else
+    return 0;
 }
 
 /* Given a pointer to a type string that represents a fundamental type
@@ -2792,7 +2873,7 @@ do_type (work, mangled, result)
 	"Sl"	=>	"signed long"
 	"CUs"	=>	"const unsigned short"
 
-   */
+   The value returned is really a type_kind_t.  */
 
 static int
 demangle_fund_type (work, mangled, result)
@@ -2803,6 +2884,8 @@ demangle_fund_type (work, mangled, resul
   int done = 0;
   int success = 1;
   string btype;
+  type_kind_t tk = tk_integral;
+
   string_init (&btype);
 
   /* First pick off any type qualifiers.  There can be more than one.  */
@@ -2812,11 +2895,13 @@ demangle_fund_type (work, mangled, resul
       switch (**mangled)
 	{
 	case 'C':
+	case 'V':
+	case 'u':
 	  (*mangled)++;
 	  if (PRINT_ANSI_QUALIFIERS)
 	    {
 	      APPEND_BLANK (result);
-	      string_append (result, "const");
+	      string_append (result, demangle_qualifier (**mangled));
 	    }
 	  break;
 	case 'U':
@@ -2829,14 +2914,6 @@ demangle_fund_type (work, mangled, resul
 	  APPEND_BLANK (result);
 	  string_append (result, "signed");
 	  break;
-	case 'V':
-	  (*mangled)++;
-	  if (PRINT_ANSI_QUALIFIERS)
-	    {
-	      APPEND_BLANK (result);
-	      string_append (result, "volatile");
-	    }
-	  break;
 	case 'J':
 	  (*mangled)++;
 	  APPEND_BLANK (result);
@@ -2884,35 +2961,41 @@ demangle_fund_type (work, mangled, resul
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "bool");
+      tk = tk_bool;
       break;
     case 'c':
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "char");
+      tk = tk_char;
       break;
     case 'w':
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "wchar_t");
+      tk = tk_char;
       break;
     case 'r':
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "long double");
+      tk = tk_real;
       break;
     case 'd':
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "double");
+      tk = tk_real;
       break;
     case 'f':
       (*mangled)++;
       APPEND_BLANK (result);
       string_append (result, "float");
+      tk = tk_real;
       break;
     case 'G':
       (*mangled)++;
-      if (!isdigit (**mangled))
+      if (!isdigit ((unsigned char)**mangled))
 	{
 	  success = 0;
 	  break;
@@ -2954,7 +3037,7 @@ demangle_fund_type (work, mangled, resul
       break;
     }
 
-  return (success);
+  return success ? ((int) tk) : 0;
 }
 
 /* Demangle the next argument, given by MANGLED into RESULT, which
@@ -3445,7 +3528,7 @@ demangle_function_name (work, mangled, d
 	  for (i = 0; i < sizeof (optable) / sizeof (optable[0]); i++)
 	    {
 	      int len = declp->p - declp->b - 10;
-	      if (strlen (optable[i].in) == len
+	      if ((int) strlen (optable[i].in) == len
 		  && memcmp (optable[i].in, declp->b + 10, len) == 0)
 		{
 		  string_clear (declp);
@@ -3461,7 +3544,7 @@ demangle_function_name (work, mangled, d
 	  for (i = 0; i < sizeof (optable) / sizeof (optable[0]); i++)
 	    {
 	      int len = declp->p - declp->b - 3;
-	      if (strlen (optable[i].in) == len 
+	      if ((int) strlen (optable[i].in) == len 
 		  && memcmp (optable[i].in, declp->b + 3, len) == 0)
 		{
 		  string_clear (declp);
@@ -3879,9 +3962,6 @@ fatal (str)
   fprintf (stderr, "%s: %s\n", program_name, str);
   exit (1);
 }
-
-char * malloc ();
-char * realloc ();
 
 char *
 xmalloc (size)
EOF
cp -vf libiberty/cplus-dem.c gcc/cplus-dem.c
#-------------------------------------------------------------------------------
#   Replace gcc/config/i386/xm-go32.h
#-------------------------------------------------------------------------------
echo "Writting file gcc/config/i386/xm-go32.h"
cat >gcc/config/i386/xm-go32.h << 'EOF'
/* Configuration for GNU C-compiler for Intel 80386 running GO32.
   Copyright (C) 1988, 1996, 1998 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#define __MSDOS__ 1

#define NO_STAB_H

#include "i386/xm-i386.h"

/* Use semicolons to separate elements of a path.  */
#define PATH_SEPARATOR ';'

/* when building libgcc.a the following defines are needed to ignore
   the definitions in gansidecl.h, because they are defined already
   in the libc headers for DJGPP */
#define HAVE_BCOPY 1
#define HAVE_BZERO 1
#define HAVE_BCMP 1
#define HAVE_RINDEX 1
#define HAVE_INDEX 1

#define EXECUTABLE_SUFFIX ".exe"

/* This is required to make temporary file names unique on file
   systems which severely restrict the length of file names. */
#define MKTEMP_EACH_FILE

#define DIR_SEPARATOR '\\'
#define DIR_SEPARATOR_1 '/'

EOF
#-------------------------------------------------------------------------------
#   Replace gcc/config/i386/t-go32
#-------------------------------------------------------------------------------
echo "Writting file gcc/config/i386/t-go32"
cat >gcc/config/i386/t-go32 << 'EOF'
LIBGCC1 = libgcc1.null
CROSS_LIBGCC1 = libgcc1.null
EOF
#-------------------------------------------------------------------------------
#   Patch file gcc/config/i386/go32.h
#-------------------------------------------------------------------------------
patch -Nb gcc/config/i386/go32.h << 'EOF'
--- go32.h.orig	Mon Jun 29 03:36:18 1998
+++ go32.h	Wed Mar 10 14:02:46 1999
@@ -2,7 +2,10 @@
 
 #include "dbxcoff.h"
 
+#define NO_STAB_H /* DJGPP has no stab.h */
+
 /* Don't assume anything about the header files. */
+
 #define NO_IMPLICIT_EXTERN_C
 
 #define HANDLE_SYSV_PRAGMA
@@ -11,12 +14,61 @@
 
 #include "i386/gas.h"
 
+/* We should search $DJDIR/bin for executables before current directory 
+   and path for DJGPP. This is to avoid looking for as.exe and ld.exe
+   in current directory and on the path */
+
+#define MD_EXEC_PREFIX "$DJDIR/bin/"
+
+/* Define FILE_NAME_ABSOLUTE_P to handle correctly absolute filename
+   detection (eg. cp/xref.c) */
+   
+#define FILE_NAME_ABSOLUTE_P(NAME) \
+        (((NAME)[0] == '/') || ((NAME)[0] == '\\') || \
+        (((NAME)[0] >= 'A') && ((NAME)[0] <= 'z') && ((NAME)[1] == ':')))
+
+/* Override specs we need to do for DJGPP */
+
 #ifdef CPP_PREDEFINES
 #undef CPP_PREDEFINES
 #endif
-#define CPP_PREDEFINES "-Dunix -Di386 -DGO32 -DMSDOS \
+#define CPP_PREDEFINES "-Dunix -Di386 -DGO32 -DMSDOS -DDJGPP=2 \
   -Asystem(unix) -Asystem(msdos) -Acpu(i386) -Amachine(i386)"
 
+#undef CPP_SPEC
+#define CPP_SPEC "%{posix:-D_POSIX_SOURCE}"
+
+#undef LIB_SPEC
+#define LIB_SPEC "-lc"
+
+#undef STARTFILE_SPEC
+#define STARTFILE_SPEC "%{pg:gcrt0.o%s}%{!pg:crt0.o%s}"
+
+/* We need to override link_command_spec in gcc.c (this also required
+   modification of gcc.c as such override were no supported before).
+   We need this to add command line option -Tdjgpp.djl. This cannot be done
+   in LINK_SPECS as that LINK_SPECS is processed before library search 
+   directories are known by linker. This is to avoid problems when specs
+   file is not available.
+   An alternate way without editting gcc.c is to use SUBTARGET_EXTRA_SPECS
+   suggested by Robert Hoehne.
+   */ 
+#undef LINK_COMMAND_SPEC
+#define LINK_COMMAND_SPEC \
+"%{!fsyntax-only: \
+%{!c:%{!M:%{!MM:%{!E:%{!S:%(linker) %l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} \
+\t%{r} %{s} %{t} %{u*} %{x} %{z} %{Z}\
+\t%{!A:%{!nostdlib:%{!nostartfiles:%S}}}\
+\t%{static:} %{L*} %D %o\
+\t%{!nostdlib:%{!nodefaultlibs:%G %L %G}}\
+\t%{!A:%{!nostdlib:%{!nostartfiles:%E}}}\
+\t-Tdjgpp.djl %{T*}}}}}}}\n\
+%{!c:%{!M:%{!MM:%{!E:%{!S:stubify %{v} %{o*:%*} %{!o*:a.out} }}}}}"
+
+/* make sure that gcc will not look for .h files in /usr/local/include 
+   (unless user explicitly requests it)  */
+#undef LOCAL_INCLUDE_DIR
+
 #undef EXTRA_SECTIONS
 #define EXTRA_SECTIONS in_ctor, in_dtor
 
@@ -86,6 +138,11 @@
 #undef ASM_OUTPUT_ALIGN
 #define ASM_OUTPUT_ALIGN(FILE,LOG) \
   if ((LOG) != 0) fprintf ((FILE), "\t.p2align %d\n", LOG)
+
+
+#undef ASM_OUTPUT_ALIGN_Z
+#define ASM_OUTPUT_ALIGN_Z(FILE,LOG) \
+  if ((LOG) != 0) fprintf ((FILE), "\t.p2align %d,0\n", LOG)
 
 /* djgpp has atexit ().  */
 #undef HAVE_ATEXIT
EOF
#-------------------------------------------------------------------------------
#   Replace file gcc/config/i386/x-go32
#-------------------------------------------------------------------------------
echo "Writting file gcc/config/i386/x-go32"
cat >gcc/config/i386/x-go32 << 'EOF'
# translate the version string, so it can be used on DJGPP, where only
# one dot in filename is allowed

# to avoid recursion when redefining $(version)
_version:=$(version)
__version=$(subst ., ,$(_version))
version=$(word 1,$(__version))$(word 2,$(__version)).$(word 3,$(__version))

SYSTEM_HEADER_DIR=$(DJDIR)/include
X_CPPFLAGS=-DSTANDARD_INCLUDE_DIR=\"\$$DJDIR/include\" \
	   -DSTANDARD_INCLUDE_COMPONENT=\"\"
FIXINCLUDES=fixinc.djgpp

# when building a native compiler for DJGPP, make the target_alias
# a shorter name, since otherwise it will produce some problems, when
# using the same gcc once with long filenames and once with short (8+3)
# filenames
ifeq ($(findstring -pc-msdosdjgpp,$(target_alias)),-pc-msdosdjgpp)
target_alias=djgpp
endif

# on DJGPP the 'ln -s' does not work correctly
LN = cp -p
LN_S = cp -p

EXTRA_GCC_OBJS += djgcc-mktemp.o
EXTRA_COLLECT2_OBJS += pexecute.o
#
#   Replacement for DJGPP libc.a function mktemp() that excludes 
#   possibility of filename conflicts between 2 or more copies of
#   gcc running simultanously. I added -I$(DJDIR)/include before
#   $(INCLUDES) to get DJGPP specific headers included before gcc
#   specific ones (the problem is with go32.h)
#
djgcc-mktemp.o: $(srcdir)/config/i386/djgcc-mktemp.c $(CONFIG_H) 
	$(CC) $(ALL_CFLAGS) $(ALL_CPPFLAGS) \
  -I$(DJDIR)/include \
  $(INCLUDES) \
  $(DRIVER_DEFINES) \
  -o djgcc-mktemp.o -c $(srcdir)/config/i386/djgcc-mktemp.c

EOF
#-------------------------------------------------------------------------------
#   New file gcc/config/i386/djgpp-mktemp.c:  replacement of mktemp() for gcc
#-------------------------------------------------------------------------------
echo "Writting file gcc/config/i386/djgcc-mktemp.c"
cat >gcc/config/i386/djgcc-mktemp.c << 'EOF'
/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */

/*************************************************************/
/* This is replacement for mktemp() for DJGPP port of gcc    */
/* Temporary file is created by this version so the          */
/* possibility of race conditions between 2 or more copies   */
/* of gcc when using mktemp is excluded.                     */
/* I also used biostime to set initial value for searching   */
/* available name to minimize need for more than one         */
/* try to get available name.                                 */
/*                                                           */
/* Andris Pavenis <pavenis@lanet.lv>       1998.04.28        */
/*************************************************************/

#include <dos.h>
#include <bios.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <libc/bss.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <go32.h>
#include <dpmi.h>
#include <libc/dosio.h>
#include <sys/fsext.h>


#define USES_BIOSTIME

static char * mktemp00 (char *_template);

static int
_creatnew00(const char* filename, int attrib, int flags);

char *
mktemp (char *_template)
{
  char tmp_name[FILENAME_MAX];
  int  fd = -1;

  /* Make sure we create a non-exisiting file, even
     if race conditions exist with other processes.  */
  do {
    strcpy(tmp_name, _template);
    errno = 0;
  } while ( mktemp00(tmp_name) != NULL
	   && (fd = _creatnew00(tmp_name, 0, SH_DENYRW)) == -1
	   && errno == EEXIST);

  if (fd == -1)
    {
       errno = ENOENT;
       *_template=0;
       return NULL;
    }
  else
    {
       close (fd);
       strcpy (_template,tmp_name);
       return _template;
    }
}

/*****************  mktemp.c  ********************************/
/* Copyright (C) 1996 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */

static int mktemp_count = -1;

#ifdef USES_BIOSTIME
static int mktemp_start = 1;
static long mktemp_base;
#endif

static char *
mktemp00 (char *_template)
{
  static int count = 0;
  char *cp, *dp;
  int i, len, xcount, loopcnt;

  /* Reinitialize counter if we were restarted (emacs).  */
  if (__bss_count != mktemp_count)
    {
      mktemp_count = __bss_count;
      count = 0;
    }

#ifdef USES_BIOSTIME
  if (mktemp_start)
    {
      mktemp_start = 0;
      mktemp_base = biostime(0,0L)<<8;
    }
#endif

  len = strlen (_template);
  cp = _template + len;

  xcount = 0;
  while (xcount < 6 && cp > _template && cp[-1] == 'X')
    xcount++, cp--;

  if (xcount) {
    dp = cp;
    while (dp > _template && dp[-1] != '/' && dp[-1] != '\\' && dp[-1] != ':')
      dp--;

    /* Keep the first characters of the template, but turn the rest into
       Xs.  */
    while (cp > dp + 8 - xcount) {
      *--cp = 'X';
      xcount = (xcount >= 6) ? 6 : 1 + xcount;
    }

    /* If dots occur too early -- squash them.  */
    while (dp < cp) {
      if (*dp == '.') *dp = 'a';
      dp++;
    }

    /* Try to add ".tmp" to the filename.  Truncate unused Xs.  */
    if (cp + xcount + 3 < _template + len)
      strcpy (cp + xcount, ".tmp");
    else
      cp[xcount] = 0;

    /* This loop can run up to 2<<(5*6) times, or about 10^9 times.  */
    for (loopcnt = 0; loopcnt < (1 << (5 * xcount)); loopcnt++) {
#ifdef USES_BIOSTIME
      int c = mktemp_base + (count++);
#else
      int c = count++;
#endif
      for (i = 0; i < xcount; i++, c >>= 5)
	cp[i] = "abcdefghijklmnopqrstuvwxyz012345"[c & 0x1f];
      if (!__file_exists(_template))
	return _template;
    }
  }

  /* Failure:  truncate the template and return NULL.  */
  *_template = 0;
  return 0;
}


/* Needed if djdev201 is being used */


#include <libc/stubs.h>


static int
_creatnew00(const char* filename, int attrib, int flags)
{
  __dpmi_regs r;
  int rv;
  unsigned use_lfn = _USE_LFN;

  if (filename == 0)
  {
    errno = EINVAL;
    return -1;
  }

  if (__FSEXT_call_open_handlers(__FSEXT_creat, &rv, &filename))
    return rv;

  _put_path(filename);
  r.x.bx =
    0x2002 | (flags & 0xfff0);	/* r/w, no Int 24h, use caller-defined flags */
  r.x.dx = 0x0010;		/* Create, fail if exists */
  r.x.si = __tb_offset;
  if(use_lfn)
    r.x.ax = 0x716c;
  else
  {
    if (_osmajor == 0)
      _get_dos_version (0);
    if (_osmajor > 3)
      r.x.ax = 0x6c00;
    else
    {
      r.h.ah = 0x5b;
      r.x.bx = 0;		/* lose support for fancy flags in DOS 3.x */
      r.x.dx = __tb_offset;
      r.x.si = 0;
    }
  }
  r.x.cx = attrib & 0xffff;
  r.x.ds = __tb_segment;
  __dpmi_int(0x21, &r);
  if(r.x.flags & 1)
  {
    errno = __doserr_to_errno(r.x.ax);
    return -1;
  }
  __file_handle_set(r.x.ax, O_BINARY);
  return r.x.ax;
}

/*************************************************************/
/* This is startup check for DJGPP installation errors       */
/* (C) A.Pavenis  <pavenis@lanet.lv>       1998.06.06        */
/*************************************************************/


#include <crt0.h>
#include <stdlib.h>


static void  __attribute__((constructor)) CheckDJGPPEnvVar (void) 
{
  /* __dos_argv0; */
  char *djdir, *djgpp;
  djdir = getenv("DJDIR");
  if (djdir) return;   // is %DJDIR% is defined then don't check more

  /* Some installation problem found. Let's check slightly deeper */
  fprintf (stderr,"Fatal:\tError in DJGPP instalation\n");
  djgpp = getenv("DJGPP");
  if (!djgpp)
       fprintf (stderr,"\tEnvironment variable DJGPP is not defined\n");
  else if (!__file_exists(djgpp))
       fprintf (stderr,"\tEnvironment variable DJGPP point to file '%s',\n"
                       "\twhich does not exist\n",djgpp);
  else
       fprintf (stderr,"\tEnvironment variable DJGPP points to wrong or "
                       "corrupt file '%s'\n",djgpp);
  exit (16);
}
EOF

if [ -d libg++ ]; then
#-------------------------------------------------------------------------------
#   Write  libg++/config/go32.ml if file is not already there
#-------------------------------------------------------------------------------
	test -f libg++/config/go32.ml || cat >libg++/config/go32.ml << 'EOF'
#  Defaults breaks things for DJGPP (broken LN)
BUILD_LIBS=$(ARLIB)
ARLIB=libgpp.a
#  Rename unused ARLINK to avoid having duplicate targets in Makefile
ARLINK=libgpp.dummy
EOF
#-------------------------------------------------------------------------------
# Rename  libg++/g++FAQ.texi  and do corresponding changes to libg++
#-------------------------------------------------------------------------------
	mv libg++/g++FAQ.texi libg++/gxxFAQ.texi
	mv libg++/libg++.texi libg++/libgpp.texi
	for file in libg++/Makefile.in libg++/configure.in; do
		sed -e 's,g[+][+]FAQ[.],gxxFAQ.,g' \
	            -e 's,libg[+][+][.]texi,libgpp.texi,g' \
		    -e 's,INFO_FILES=libg[+][+],INFO_FILES=libgpp,g' \
		    $file >$file.new
		update $file
	done
	sed -e 's,[(]libg[+][+][)],(libgpp),g' libg++/libgpp.texi >libg++/libgpp.texi.new
	update libg++/libgpp.texi
	sed -e 's,g[+][+]FAQ[.]info,gxxFAQ.info,g' libg++/gxxFAQ.texi >libg++/gxxFAQ.texi.new
	update libg++/gxxFAQ.texi
#-------------------------------------------------------------------------------
#   Patch  libg++/configure.in. This patch is in in newer libg++ versions
#   So avoid it then.
#-------------------------------------------------------------------------------
	grep -q msdosdjgpp libg++/configure.in || \
	patch -Nb libg++/configure.in << 'EOF'
--- configure.in~	Sat Nov 14 07:17:14 1998
+++ configure.in	Sat Dec  5 16:58:12 1998
@@ -149,6 +149,7 @@
 else
   # Not shared.
   case "${target}" in
+    *-*-msdosdjgpp*)   frags="${frags} go32.ml" ;;
     *-*-aix4*)		frags="${frags} aix4.ml" ;;
   esac
 fi
EOF
fi

#-------------------------------------------------------------------------------
#   Patch for libf2c/libI77/configure.in
#-------------------------------------------------------------------------------
patch -Nb libf2c/libI77/configure.in << 'EOF'
--- configure.in~	Thu Aug  6 16:15:58 1998
+++ configure.in	Fri Aug  7 14:57:10 1998
@@ -160,7 +160,10 @@
 # define NON_ANSI_RW_MODES on unix (can't hurt)
 AC_MSG_CHECKING(NON_ANSI_RW_MODES)
 AC_EGREP_CPP(yes,
-[#ifdef unix
+[#ifdef __DJGPP__
+  no
+#else
+#ifdef unix
   yes
 #endif
 #ifdef __unix
@@ -168,6 +171,7 @@
 #endif
 #ifdef __unix__
   yes
+#endif
 #endif
 ], is_unix=yes, is_unix=no)
 # NON_ANSI_RW_MODES shouldn't be necessary on cygwin for binary mounts.
EOF
#-------------------------------------------------------------------------------
#   Running autoconf where needed. Fails in librx but I didn't want to
#   fight it now (AP)
#-------------------------------------------------------------------------------
currdir=`pwd`
for file in `find . -name configure.in`; do
	directory=$currdir/`echo $file | sed -e 's,/configure.in,,g' -e 's,[.]/,,g'`;
	cd $directory;
	if grep -q AC_INIT configure.in; then
		echo "Running autoconf in `pwd`"
		autoconf;
	fi;
	cd $currdir;
done;
#-------------------------------------------------------------------------------
#   Now creating some directories where to build egcs as it is recommended
#   not to build in source directories
#-------------------------------------------------------------------------------
#
echo "Creating directories build.djg and gcc/build.djg"
mkdir gcc/build.djg
mkdir build.djg
#
#-------------------------------------------------------------------------------
#   Create script djconfig.sh for building libraries
#-------------------------------------------------------------------------------
echo "Writting file build.djg/djconfig.sh"
cat >build.djg/djconfig.sh << 'EOF'
#! /bin/sh
# where are the sources? If you use (like I) to have the sources
# in a separate directory and the objects in an other, then set
# here the full path to the source directory and run this script
# in the directory where you want to build gcc!!
# WARNING: Only unix-like absolute paths are known to work, like
#
# /src/egcs-1.1a
#
# do not use any drive in it like
#
# c:/src/egcs-1.1a
#
# since this will confuse all that unix like scrips, which
# assume that a absolute path starts with a slash.
srcdir=..

# just in case
export PATH_SEPARATOR=:

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# give now the configure script some hints
topdir=`(cd $srcdir/..; pwd;)`
export CC="$topdir/gcc/build.djg/xgcc.exe -B $topdir/gcc/build.djg/"
export CXX="$topdir/gcc/build.djg/g++.exe -B $topdir/gcc/build.djg/"
export LD=ld
export DEFAULT_LEX=flex
export LEX=flex
export RANLIB=ranlib
export ac_cv_path_install="ginstall -c"
export CONFIG_SHELL=bash
#
$srcdir/configure --srcdir=$srcdir --disable-shared --verbose \
		  --with-gxx-include-dir=\\\${prefix}/lang/cxx \
		  --with-gnu-ld	--target=i586-pc-msdosdjgpp \
		  --host=i586-pc-msdosdjgpp
#
dtou `find . -name Makefile`
EOF
#-------------------------------------------------------------------------------
#   Create script djmake.sh for building libraries
#-------------------------------------------------------------------------------
echo "Writting file build.djg/djmake.sh"
cat >build.djg/djmake.sh << 'EOF'
#! /bin/sh
# just in case
export PATH_SEPARATOR=:

# The following is not needed to build plain gcc but may be usefull
# if some addons such as g77 is included
export CONFIG_SHELL=bash

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# set this to the wanted CFLAGS, I set here also the default output
# debugging type to stabs.
# currently disabled because we (djgpp-workers) have decided to leave
# the SBD COFF debug information as default.
# CFLAGS="-DPREFERRED_DEBUGGING_TYPE=DBX_DEBUG"

# Create now a stub, which has a larger stack, which is needed for
# at least cc1 when compiling gcc with itself
if [ ! -r stub.exe ]; then
  ln -s dummy stub
  stubedit stub.exe runfile= minstack=1536k
fi
export STUB=`pwd`/stub.exe

#  Find locations of current gcc specs file. We need this as
#  target specific specs file will be in current directory
#  (new specs may different from old ones, so we should separate them.
#  Let's hope that root directory doesn't contain file specs)
orig_specs=`( cd /; gcc -print-file-name=specs; )`

# now call make with any additional commandline argument
if [ -z $CFLAGS ]; then
  make  CFLAGS="$CFLAGS" XCFLAGS="-specs=$orig_specs" \
	LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
	$*
else
  make  CFLAGS="$CFLAGS" XCFLAGS="-specs=$orig_specs" \
	LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
	$*
fi
EOF
#-------------------------------------------------------------------------------
#   Create script djconfig.sh for configuring gcc
#-------------------------------------------------------------------------------
echo "Writting file gcc/build.djg/djconfig.sh"
cat >gcc/build.djg/djconfig.sh << 'EOF'
#! /bin/sh
# where are the sources? If you use (like I) to have the sources
# in a separate directory and the objects in an other, then set
# here the full path to the source directory and run this script
# in the directory where you want to build gcc!!
# WARNING: Only unix-like absolute paths are known to work, like
#
# /src/egcs-1.1a
#
# do not use any drive in it like
#
# c:/src/egcs-1.1a
#
# since this will confuse all that unix like scrips, which
# assume that a absolute path starts with a slash.
srcdir=..

# just in case
export PATH_SEPARATOR=:

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# give now the configure script some hints
export CC=gcc
export LD=ld
export DEFAULT_LEX=flex
export LEX=flex
export RANLIB=ranlib
export ac_cv_path_install="ginstall -c"
export CONFIG_SHELL=bash
#
$srcdir/configure --srcdir=$srcdir --disable-shared --verbose \
		  --prefix=\\\$\$DJDIR \
		  --with-gxx-include-dir=\${prefix}/lang/cxx \
		  --with-gnu-ld	\
		  --enable-haifa \
		  --target=i586-pc-msdosdjgpp \
	          --host=i586-pc-msdosdjgpp
#
dtou `find . -name Makefile`
EOF
#-------------------------------------------------------------------------------
#   Create script djmake.sh for building gcc
#-------------------------------------------------------------------------------
echo "Writting file gcc/build.djg/djmake.sh"
cat >gcc/build.djg/djmake.sh << 'EOF'
#! /bin/sh
# just in case
export PATH_SEPARATOR=:

# The following is not needed to build plain gcc but may be usefull
# if some addons such as g77 is included
export CONFIG_SHELL=bash

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# set this to the wanted CFLAGS, I set here also the default output
# debugging type to stabs.
# currently disabled because we (djgpp-workers) have decided to leave
# the SBD COFF debug information as default.
# CFLAGS="-DPREFERRED_DEBUGGING_TYPE=DBX_DEBUG"

# Create now a stub, which has a larger stack, which is needed for
# at least cc1 when compiling gcc with itself
if [ ! -r stub.exe ]; then
  ln -s dummy stub
  stubedit stub.exe runfile= minstack=1536k
fi
export STUB=`pwd`/stub.exe

# now call make with any additional commandline argument
if [ -z $CFLAGS ]; then
  make $*
else
  make CFLAGS="$CFLAGS" $*
fi
EOF
#----------------------------------------------------------------------
echo "Writting file gcc/fixinc.djgpp"
cat >gcc/fixinc.djgpp << 'FIXINC_EOF'
#! /bin/sh
# Install modified versions of certain ANSI-incompatible system header files
# which are fixed to work correctly with ANSI C
# and placed in a directory that GNU C will search.

# See README-fixinc for more information.

# Directory containing the original header files.
# (This was named INCLUDES, but that conflicts with a name in Makefile.in.)
INPUT=${2-${INPUT-$DJDIR/include}}

# Directory in which to store the results.
LIB=${1?"fixincludes: output directory not specified"}

# Define what target system we're fixing.
if test -r ./Makefile; then
	target_canonical="`sed -n -e 's,^target[ 	]*=[ 	]*\(.*\)$,\1,p' < Makefile`"
	test -z "${target_canonical}" && target_canonical=unknown
else
	target_canonical=unknown
fi

# Define PWDCMD as a command to use to get the working dir
# in the form that we want.
PWDCMD=pwd

# Original directory.
ORIGDIR=`${PWDCMD}`

# Make sure it exists.
if [ ! -d $LIB ]; then
  mkdir $LIB || exit 1
fi

# Make LIB absolute only if needed to avoid problems with the amd.
case $LIB in
/*)
	;;
*)
	cd $LIB; LIB=`${PWDCMD}`
	;;
esac

# Fail if no arg to specify a directory for the output.
if [ x$1 = x ]
then echo fixincludes: no output directory specified
exit 1
fi

echo Building fixed headers in ${LIB}

# Determine whether this system has symbolic links.
LINKS=false

echo Finding directories and links to directories
# cd ${INPUT}
# Find all directories and all symlinks that point to directories.
# Put the list in $files.
# Each time we find a symlink, add it to newdirs
# so that we do another find within the dir the link points to.
# Note that $files may have duplicates in it;
# later parts of this file are supposed to ignore them.
dirs="."
levels=2
while [ -n "$dirs" ] && [ $levels -gt 0 ]
do
    levels=`expr $levels - 1`
    newdirs=
    for d in $dirs
    do
	echo " Searching $INPUT/$d"

	# Find all directories under $d, relative to $d, excluding $d itself.
	# (The /. is needed after $d in case $d is a symlink.)
        files="$files `find $INPUT/$d -type d -print | \
		       sed -e s,$INPUT/\.\$,,g -e s,$INPUT/,,g`"
	# Find all links to directories.
	# Using `-exec test -d' in find fails on some systems,
	# and trying to run test via sh fails on others,
	# so this is the simplest alternative left.
	# First find all the links, then test each one.
	theselinks=
	$LINKS && \
	  theselinks=`find $d/. -type l -print | sed -e 's@/./@/@g'`
	for d1 in $theselinks --dummy--
	do
	    # If the link points to a directory,
	    # add that dir to $newdirs
	    if [ -d $d1 ]
	    then
		files="$files $d1"
		if [ "`ls -ld $d1 | sed -n 's/.*-> //p'`" != "." ]
		then
		    newdirs="$newdirs $d1"
		fi
	    fi
	done
    done

    dirs="$newdirs"
done

dirs=
echo "All directories (including links to directories):"
echo $files

for file in $files; do
  rm -rf $LIB/$file
  if [ ! -d $LIB/$file ]
  then mkdir $LIB/$file
  fi
done
mkdir $LIB/root

# treetops gets an alternating list
# of old directories to copy
# and the new directories to copy to.
treetops="${INPUT} ${LIB}"

if $LINKS; then
  echo 'Making symbolic directory links'
  for file in $files; do
    dest=`ls -ld $file | sed -n 's/.*-> //p'`
    if [ "$dest" ]; then    
      cwd=`${PWDCMD}`
      # In case $dest is relative, get to $file's dir first.
      cd ${INPUT}
      cd `echo ./$file | sed -n 's&[^/]*$&&p'`
      # Check that the target directory exists.
      # Redirections changed to avoid bug in sh on Ultrix.
      (cd $dest) > /dev/null 2>&1
      if [ $? = 0 ]; then
	cd $dest
	# X gets the dir that the link actually leads to.
	x=`${PWDCMD}`
	# Canonicalize ${INPUT} now to minimize the time an
	# automounter has to change the result of ${PWDCMD}.
	cinput=`cd ${INPUT}; ${PWDCMD}`
	# If a link points to ., make a similar link to .
	if [ $x = ${cinput} ]; then
	  echo $file '->' . ': Making link'
	  rm -fr ${LIB}/$file > /dev/null 2>&1
	  ln -s . ${LIB}/$file > /dev/null 2>&1
	# If link leads back into ${INPUT},
	# make a similar link here.
	elif expr $x : "${cinput}/.*" > /dev/null; then
	  # Y gets the actual target dir name, relative to ${INPUT}.
	  y=`echo $x | sed -n "s&${cinput}/&&p"`
	  # DOTS is the relative path from ${LIB}/$file's dir back to ${LIB}.
	  dots=`echo "$file" |
	    sed -e 's@^./@@' -e 's@/./@/@g' -e 's@[^/][^/]*@..@g' -e 's@..$@@'`
	  echo $file '->' $dots$y ': Making link'
	  rm -fr ${LIB}/$file > /dev/null 2>&1
	  ln -s $dots$y ${LIB}/$file > /dev/null 2>&1
	else
	  # If the link is to a dir $target outside ${INPUT},
	  # repoint the link at ${INPUT}/root$target
	  # and process $target into ${INPUT}/root$target
	  # treat this directory as if it actually contained the files.
	  echo $file '->' root$x ': Making link'
	  if [ -d $LIB/root$x ]
	  then true
	  else
	    dirname=root$x/
	    dirmade=.
	    cd $LIB
	    while [ x$dirname != x ]; do
	      component=`echo $dirname | sed -e 's|/.*$||'`
	      mkdir $component >/dev/null 2>&1
	      cd $component
	      dirmade=$dirmade/$component
	      dirname=`echo $dirname | sed -e 's|[^/]*/||'`
	    done
	  fi
	  # Duplicate directory structure created in ${LIB}/$file in new
	  # root area.
	  for file2 in $files; do
	    case $file2 in
	      $file/*)
		dupdir=${LIB}/root$x/`echo $file2 | sed -n "s|^${file}/||p"`
		echo "Duplicating ${file}'s ${dupdir}"
		if [ -d ${dupdir} ]
		then true
		else
		  mkdir ${dupdir}
		fi
		;;
	      *)
		;;
	    esac
          done
	  # Get the path from ${LIB} to $file, accounting for symlinks.
	  parent=`echo "$file" | sed -e 's@/[^/]*$@@'`
	  libabs=`cd ${LIB}; ${PWDCMD}`
	  file2=`cd ${LIB}; cd $parent; ${PWDCMD} | sed -e "s@^${libabs}@@"`
	  # DOTS is the relative path from ${LIB}/$file's dir back to ${LIB}.
	  dots=`echo "$file2" | sed -e 's@/[^/]*@../@g'`
	  rm -fr ${LIB}/$file > /dev/null 2>&1
	  ln -s ${dots}root$x ${LIB}/$file > /dev/null 2>&1
	  treetops="$treetops $x ${LIB}/root$x"
	fi
      fi
      cd $cwd
    fi
  done
fi

required=
set x $treetops
shift
while [ $# != 0 ]; do
  # $1 is an old directory to copy, and $2 is the new directory to copy to.
# The same dir can appear more than once in treetops.
# There's no need to scan it more than once.
  if [ -f $2/DONE ]
  then
    files=
  else
    touch $2/DONE
    echo Fixing directory $1 into $2
# Check .h files which are symlinks as well as those which are files.
# A link to a header file will not be processed by anything but this.
    if $LINKS; then
      files=`find . -name '*.h' \( -type f -o -type l \) -print`
    else
      files=`find . -name '*.h' -type f -print`
    fi
    echo Checking header files
  fi
# Note that BSD43_* are used on recent MIPS systems.
  for file in $files; do
# This call to egrep is essential, since checking a file with egrep
# is much faster than actually trying to fix it.
# It is also essential that most files *not* match!
# Thus, matching every #endif is unacceptable.
# But the argument to egrep must be kept small, or many versions of egrep
# won't be able to handle it.
#
# We use the pattern [!-.0-z{|}~] instead of [^/ 	] to match a noncomment
# following #else or #endif because some buggy egreps think [^/] matches
# newline, and they thus think `#else ' matches `#e[ndiflse]*[ 	]+[^/ 	]'.
# [!-.0-~] does not work properly on AIX 4.1.
#
# We use the pattern [^a-zA-Z0-9_][_a-ce-km-z][a-z0-9] to match an identifier
# following #if or #elif that is not surrounded by __.  The `a-ce-km-z'
# in this pattern lacks `d' and `l'; this means we don't worry about
# identifiers starting with `d' or `l'.  This is OK, since none of the
# identifiers below start with `d' or `l'.  It also greatly improves
# performance, since many files contain lines of the form `#if ... defined ...'
# or `#if lint'.
    if egrep '//|[      _]_IO|CTRL|^#define.NULL|^#e[nl][ds][ief]*[     ]+[!-.0-z\{\|\}\~]|^#[el]*if.*[^a-zA-Z0-9_][_a-ce-km-zA-Z][a-zA-Z0-9]' $1/$file >/dev/null; then
      if [ -r $1/$file ]; then
        cp $1/$file $2/$file >/dev/null 2>&1       \
	|| echo "Can't copy $file"
	chmod +w $2/$file
	chmod a+r $2/$file
	# The fixinc_eol stuff is to work around a bug in the sed
	# program on HP/UX 10.20.
	# Here is how the sed commands in braces work.
	# (It doesn't work to put the comments inside the sed commands.)
		# Surround each word with spaces, to simplify matching below.
		# ANSIfy each pre-ANSI machine-dependent symbol
		# by surrounding it with __ __.
		# Remove the spaces that we inserted around each word.
	sed -e '
				   :loop
	  /\\$/			N
 	  s/\\$/\\*fixinc_eol*/
	  /\\$/			b loop
	  s/\\\*fixinc_eol\*/\\/g
	  s%^\([ 	]*#[ 	]*else\)[ 	]*/[^*].*%\1%
	  s%^\([ 	]*#[ 	]*else\)[ 	]*[^/ 	].*%\1%
	  s%^\([ 	]*#[ 	]*endif\)[ 	]*/[^*].*%\1%
	  s%^\([ 	]*#[ 	]*endif\)[ 	]*\*[^/].*%\1%
	  s%^\([ 	]*#[ 	]*endif\)[ 	]*[^/* 	].*%\1%
	  /\/\/[^*]/			s|//\(.*\)$|/*\1*/|
	  /^[ 	]*\/\/[ 	]*/s///
	  /[ 	]_IO[A-Z]*[ 	]*(/	s/\(_IO[A-Z]*[ 	]*(\)\(.\),/\1'\''\2'\'',/
	  /[ 	]BSD43__IO[A-Z]*[ 	]*(/	s/(\(.\),/('\''\1'\'',/
	  /#[ 	]*define[ 	]*[ 	]_IO/			s/'\''\([cgxtf]\)'\''/\1/g
	  /#[ 	]*define[ 	]*[ 	]BSD43__IO/		s/'\''\([cgx]\)'\''/\1/g
	  /#[ 	]*define[ 	]*[ 	]DESIOC/		s/'\''\([cdgx]\)'\''/\1/g
	  /[^A-Z0-9_]CTRL[ 	]*(/		s/\([^'\'']\))/'\''\1'\'')/
	  /[^A-Z0-9]_CTRL[ 	]*(/		s/\([^'\'']\))/'\''\1'\'')/
	  /#[ 	]*define[ 	]*[ 	]CTRL/		s/'\''\([cgx]\)'\''/\1/g
	  /#[ 	]*define[ 	]*[ 	]_CTRL/		s/'\''\([cgx]\)'\''/\1/g
	  /#[ 	]*define.BSD43_CTRL/		s/'\''\([cgx]\)'\''/\1/g
	  /#[	 ]*[el]*if/{
		s/[a-zA-Z0-9_][a-zA-Z0-9_]*/ & /g

		s/ bsd4\([0-9]\) / __bsd4\1__ /g
		s/ _*host_mips / __host_mips__ /g
		s/ _*i386 / __i386__ /g
		s/ M32 / __M32__ /g
		s/ is68k / __is68k__ /g
		s/ m68k / __m68k__ /g
		s/ mc680\([0-9]\)0 / __mc680\10__ /g
		s/ m88k / __m88k__ /g
		s/ _*mips / __mips__ /g
		s/ news\([0-9]*\) / __news\1__ /g
		s/ ns32000 / __ns32000__ /g
		s/ pdp11 / __pdp11__ /g
		s/ pyr / __pyr__ /g
		s/ sel / __sel__ /g
		s/ sony_news / __sony_news__ /g
		s/ sparc / __sparc__ /g
		s/ sun\([a-z0-9]*\) / __sun\1__ /g
		s/ tahoe / __tahoe__ /g
		s/ tower\([_0-9]*\) / __tower\1__ /g
		s/ u370 / __u370__ /g
		s/ u3b\([0-9]*\) / __u3b\1__ /g
		s/ unix / __unix__ /g
		s/ vax / __vax__ /g
		s/ _*MIPSE\([LB]\) / __MIPSE\1__ /g
		s/ _*\([Rr][34]\)000 / __\1000__ /g
		s/ _*SYSTYPE_\([A-Z0-9]*\) / __SYSTYPE_\1__ /g

		s/ \([a-zA-Z0-9_][a-zA-Z0-9_]*\) /\1/g
	  }
	  /^#define.NULL[ 	]/	i\
		#undef NULL
	' $2/$file > $2/$file_
	mv $2/$file_ $2/$file
	if cmp $1/$file $2/$file >/dev/null 2>&1 \
	    || egrep 'This file is part of the GNU C Library' $2/$file >/dev/null 2>&1; then
	   rm $2/$file
	else
	   echo Fixed $file
	   # Find any include directives that use "file".
	   for include in `egrep '^[ 	]*#[ 	]*include[ 	]*"[^/]' $2/$file | sed -e 's/^[ 	]*#[ 	]*include[ 	]*"\([^"]*\)".*$/\1/'`; do
	      dir=`echo $file | sed -e s'|/[^/]*$||'`
	      required="$required $1 $dir/$include $2/$dir/$include"
	   done
	fi
      fi
    fi
  done
  shift; shift
done

# Install the proper definition of the three standard types in header files
# that they come from.
for file in sys/types.h stdlib.h sys/stdtypes.h stddef.h memory.h unistd.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing size_t, ptrdiff_t and wchar_t in $file
    sed \
      -e '/^[ 	]*\*[ 	]*typedef unsigned int size_t;/N'	\
      -e 's/^\([ 	]*\*[ 	]*typedef unsigned int size_t;\n[ 	]*\*\/\)/\1\
#ifndef __SIZE_TYPE__\
#define __SIZE_TYPE__ long unsigned int\
#endif\
typedef __SIZE_TYPE__ size_t;\
/'	\
      -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]size_t/i\
#ifndef __SIZE_TYPE__\
#define __SIZE_TYPE__ long unsigned int\
#endif
' \
      -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]size_t/typedef __SIZE_TYPE__ size_t/' \
      -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]ptrdiff_t/i\
#ifndef __PTRDIFF_TYPE__\
#define __PTRDIFF_TYPE__ long int\
#endif
' \
      -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]ptrdiff_t/typedef __PTRDIFF_TYPE__ ptrdiff_t/' \
      -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/i\
#ifndef __WCHAR_TYPE__\
#define __WCHAR_TYPE__ int\
#endif\
#ifndef __cplusplus
' \
      -e '/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/a\
#endif
' \
      -e 's/typedef[ 	][ 	]*[a-z_][ 	a-z_]*[ 	]wchar_t/typedef __WCHAR_TYPE__ wchar_t/' \
      ${LIB}/$file > ${LIB}/${file}_
    rm -f ${LIB}/$file; mv ${LIB}/${file}_ ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# Fix #defines under Alpha OSF/1:
# The following files contain '#pragma extern_prefix "_FOO"' followed by
# a '#define something(x,y,z) _FOOsomething(x,y,z)'.  The intent of these
# statements is to reduce namespace pollution.  While these macros work
# properly in most cases, they don't allow you to take a pointer to the
# "something" being modified.  To get around this limitation, change these
# statements to be of the form '#define something _FOOsomething'.
for file in libgen.h dirent.h ftw.h grp.h ndbm.h pthread.h pwd.h signal.h standards.h stdlib.h string.h stropts.h time.h unistd.h
do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing $file extern_prefix
    sed -e 's/^[ 	]*#[ 	]*define[ 	]*\([^(]*\)\(([^)]*)\)[ 	]*\(_.\)\1\2[ 	]*$/#define \1 \3\1/' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $file | sed -e s'|/[^/]*$||'`
	required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done
 
# Fix this Sun file to avoid interfering with stddef.h.
file=sys/stdtypes.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
sed -e '/[	 ]size_t.*;/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
    -e '/[	 ]size_t.*;/a\
#endif
' \
    -e '/[	 ]ptrdiff_t.*;/i\
#ifndef _GCC_PTRDIFF_T\
#define _GCC_PTRDIFF_T
' \
    -e '/[	 ]ptrdiff_t.*;/a\
#endif
' \
    -e '/[	 ]wchar_t.*;/i\
#ifndef _GCC_WCHAR_T\
#define _GCC_WCHAR_T
' \
    -e '/[	 ]wchar_t.*;/a\
#endif
' ${LIB}/$file > ${LIB}/${file}_
  rm -f ${LIB}/$file; mv ${LIB}/${file}_ ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix this ARM/RISCiX file to avoid interfering with the use of __wchar_t
# in cc1plus.
file=stdlib.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e "s/\(#[ 	]*ifndef[ 	]*\)__wchar_t/\1_GCC_WCHAR_T/" \
      -e "s/\(#[ 	]*define[ 	]*\)__wchar_t/\1_GCC_WCHAR_T/" \
     ${LIB}/$file > ${LIB}/${file}_
  rm -f ${LIB}/$file; mv ${LIB}/${file}_ ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix this ARM/RISCiX file where ___type is a Compiler hint that is specific to
# the Norcroft compiler.
file=X11/Intrinsic.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e "s/___type p_type/p_type/" \
     ${LIB}/$file > ${LIB}/${file}_
  rm -f ${LIB}/$file; mv ${LIB}/${file}_ ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[         ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix this file to avoid interfering with stddef.h, but don't mistakenly
# match ssize_t present in AIX for the ps/2, or typedefs which use (but do not
# set) size_t.
file=sys/types.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
sed -e '/typedef[ 	][ 	]*[A-Za-z_][ 	A-Za-z_]*[ 	]size_t/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
    -e '/typedef[ 	][ 	]*[A-Za-z_][ 	A-Za-z_]*[ 	]size_t/a\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix HP's use of ../machine/inline.h to refer to
# /usr/include/machine/inline.h
file=sys/spinlock.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file
fi
if [ -r ${LIB}/$file ] ; then
  echo Fixing $file
  sed -e 's,"../machine/inline.h",<machine/inline.h>,' \
    -e 's,"../machine/psl.h",<machine/psl.h>,' \
  ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix an error in this file: the #if says _cplusplus, not the double
# underscore __cplusplus that it should be
file=tinfo.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpcsvc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, __cplusplus macro
  sed -e 's/[ 	]_cplusplus/ __cplusplus/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix an error in this file: a missing semi-colon at the end of the statsswtch
# structure definition.
file=rpcsvc/rstat.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpcsvc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, definition of statsswtch
  sed -e 's/boottime$/boottime;/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix an error in this file: a missing semi-colon at the end of the nodeent
# structure definition.
file=netdnet/dnetdb.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/netdnet 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, definition of nodeent
  sed -e 's/char.*na_addr *$/char *na_addr;/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Check for bad #ifdef line (in Ultrix 4.1)
file=sys/file.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, bad \#ifdef line
  sed -e 's/#ifdef KERNEL/#if defined(KERNEL)/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Check for (...) in C++ code in HP/UX sys/file.h.
file=sys/file.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if egrep HPUX_SOURCE ${LIB}/$file > /dev/null; then
    echo Fixing $file, use of '(...)'
    sed -e 's/(\.\.\.)/(struct file * ...)/' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $file | sed -e s'|/[^/]*$||'`
	required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
fi

# Check for superfluous `static' (in Ultrix 4.2)
# On Ultrix 4.3, includes of other files (r3_cpu.h,r4_cpu.h) is broken.
file=machine/cpu.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/machine 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, superfluous static and broken includes of other files.
  sed -e 's/^static struct tlb_pid_state/struct tlb_pid_state/' \
      -e 's/^#include "r3_cpu\.h"$/#include <machine\/r3_cpu\.h>/' \
      -e 's/^#include "r4_cpu\.h"$/#include <machine\/r4_cpu\.h>/' \
      ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
# This file has an alternative name, mips/cpu.h.  Fix that name, too.
    if cmp machine/cpu.h mips/cpu.h > /dev/null 2>&1; then
      mkdir ${LIB}/mips 2>&-
# Don't remove the file first, they may be the same file!
      ln ${LIB}/$file ${LIB}/mips/cpu.h > /dev/null 2>&1
    fi
  fi
fi

# Incorrect sprintf declaration in X11/Xmu.h
file=X11/Xmu.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/X11 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file sprintf declaration
  sed -e 's,^extern char \*	sprintf();$,#ifndef __STDC__\
extern char *	sprintf();\
#endif /* !defined __STDC__ */,' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Incorrect sprintf declaration in X11/Xmu/Xmu.h
# (It's not clear whether the right file name is this or X11/Xmu.h.)
file=X11/Xmu/Xmu.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/X11/Xmu 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file sprintf declaration
  sed -e 's,^extern char \*	sprintf();$,#ifndef __STDC__\
extern char *	sprintf();\
#endif /* !defined __STDC__ */,' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Check for missing ';' in struct
file=netinet/ip.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/netinet 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/^struct/,/^};/s/}$/};/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix the CAT macro in SunOS memvar.h.
file=pixrect/memvar.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/pixrect 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/^#define.CAT(a,b)/ i\
#ifdef __STDC__ \
#define CAT(a,b) a##b\
#else
/^#define.CAT(a,b)/ a\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Check for yet more missing ';' in struct (in SunOS 4.0.x)
file=rpcsvc/rusers.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpcsvc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/^struct/,/^};/s/_cnt$/_cnt;/' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix return type of exit and abort in <stdlib.h> on SunOS 4.1.
# Also wrap protection around size_t for m88k-sysv3 systems.
file=stdlib.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  if grep _GCC_SIZE_T ${LIB}/$file >/dev/null
  then size_t_pattern='<<< do not double-wrap the size_t typedef >>>'
  else size_t_pattern='typedef[ 	a-zA-Z_]*[ 	]size_t[ 	]*;'
  fi
  sed -e 's/int	abort/void	abort/g' \
  -e 's/int	free/void	free/g' \
  -e 's/char[ 	]*\*[ 	]*calloc/void \*	calloc/g' \
  -e 's/char[ 	]*\*[ 	]*malloc/void \*	malloc/g' \
  -e 's/char[ 	]*\*[ 	]*realloc/void \*	realloc/g' \
  -e 's/int[ 	][ 	]*exit/void	exit/g' \
  -e "/$size_t_pattern/"'i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
  -e "/$size_t_pattern/"'a\
#endif
' \
      ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix return type of free and {c,m,re}alloc in <malloc.h> on SunOS 4.1.
# Also fix return type of {m,re}alloc in <malloc.h> on sysV68
file=malloc.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/typedef[ 	]char \*	malloc_t/typedef void \*	malloc_t/g' \
  -e 's/int[ 	][ 	]*free/void	free/g' \
  -e 's/char\([ 	]*\*[ 	]*malloc\)/void\1/g' \
  -e 's/char\([ 	]*\*[ 	]*realloc\)/void\1/g' \
  ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix bogus #ifdef in <hsfs/hsfs_spec.h> on SunOS 4.1.
file=hsfs/hsfs_spec.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/hsfs 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/\#ifdef __i386__ || __vax__/\#if __i386__ || __vax__/g' \
    ${LIB}/$file > ${LIB}/${file}.
  rm -f ${LIB}/$file; mv ${LIB}/${file}. ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix bogus #ifdef in <hsfs/hsnode.h> on SunOS 4.1.
file=hsfs/hsnode.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/hsfs 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/\#ifdef __i386__ || __sun4c__/\#if __i386__ || __sun4c__/g' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix bogus #ifdef in <hsfs/iso_spec.h> on SunOS 4.1.
file=hsfs/iso_spec.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/hsfs 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/\#ifdef __i386__ || __vax__/\#if __i386__ || __vax__/g' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Incorrect #include in Sony News-OS 3.2.
file=machine/machparam.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/machine 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, incorrect \#include
  sed -e 's@"../machine/endian.h"@<machine/endian.h>@' \
    ${LIB}/$file > ${LIB}/${file}.
  rm -f ${LIB}/$file; mv ${LIB}/${file}. ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Multiline comment after typedef on IRIX 4.0.1.
file=sys/types.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, comment in the middle of \#ifdef
  sed -e 's@type of the result@type of the result */@' \
    -e 's@of the sizeof@/* of the sizeof@' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Turning // comments into /* */ comments trashes this IRIX 4.0.1
# header file, which embeds // comments inside multi-line /* */
# comments.  If this looks like the IRIX header file, we refix it by
# just throwing away the // comments.
file=fam.h
if [ -r ${LIB}/$file ]; then
  if egrep indigo.esd ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
    sed -e 's|//.*$||g' $file > ${LIB}/$file
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi
fi

# There is a similar problem with the VxWorks drv/netif/if_med.h file.
file=drv/netif/if_med.h
if [ -r ${LIB}/$file ]; then
  if egrep 'Wind River' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
    sed -e 's|//.*$||g' $file > ${LIB}/$file
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi
fi

# And also with the HP-UX 10 and HP-UX 11 sys/pci.h file
file=sys/pci.h
if [ -r ${LIB}/$file ]; then
  if egrep 'System Private Structures' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
    sed -e 's|//.*$||g' $file > ${LIB}/$file
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi
fi

# And also with a few more HP-UX 11 headers which are only broken
# after they are "fixed".
file=sys/ki_iface.h
if [ -r ${LIB}/$file ]; then
  if egrep 'These definitions are for HP Internal developers' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
  fi
fi

file=sys/ki.h
if [ -r ${LIB}/$file ]; then
  if egrep '11.00 HP-UX LP64' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
  fi
fi

file=sys/ki_calls.h
if [ -r ${LIB}/$file ]; then
  if egrep 'KI_MAX_PROCS is an arbitrary number' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
  fi
fi

file=sys/ki_defs.h
if [ -r ${LIB}/$file ] ; then
  if egrep 'Kernel Instrumentation Definitions' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
  fi
fi

file=sys/time.h
if [ -r ${LIB}/$file ] ; then
  if egrep 'For CASPEC, look in' ${LIB}/$file > /dev/null; then
    echo Fixing $file, overeager sed script
    rm ${LIB}/$file
  fi
fi

# Some IRIX header files contains the string "//"
for file in elf_abi.h elf.h; do
  if [ -r ${LIB}/$file ]; then
    echo Fixing $file, overeager sed script
    sed -e 's|"/\*"\*/|"//"|' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
    fi
  fi
done

# IRIX 4.0.5 <rpc/auth.h> uses struct sockaddr in prototype without
# previous definition.
file=rpc/auth.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, undefined type
  sed -e '/authdes_create.*struct sockaddr/i\
struct sockaddr;
' \
    ${LIB}/$file > ${LIB}/$file.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# IRIX 4.0.5 <rpc/xdr.h> uses struct __file_s in prototype without previous
# definition.
file=rpc/xdr.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, undefined type
  sed -e '/xdrstdio_create.*struct __file_s/i\
struct __file_s;
' \
    ${LIB}/$file > ${LIB}/$file.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Same problem with a file from SunOS 4.1.3 : a header file containing
# the string "//" embedded in "/**/"
file=sbusdev/audiovar.h
if [ -r ${LIB}/$file ]; then
  echo Fixing $file, overeager sed script
  rm ${LIB}/$file
  sed -e 's|//.*$||g' $file > ${LIB}/$file
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

# Fix non-ANSI memcpy declaration that conflicts with gcc's builtin
# declaration on Sun OS 4.x.  We must only fix this on Sun OS 4.x, because
# many other systems have similar text but correct versions of the file.
# To ensure only Sun's is fixed, we grep for a likely unique string.
# Fix also on sysV68 R3V7.1 (head/memory.h\t50.1\t )
file=memory.h
if [ -r ${INPUT}/$file ] && egrep '/\*	@\(#\)(head/memory.h	50.1	 |memory\.h 1\.[2-4] 8./../.. SMI; from S5R2 1\.2	)\*/' $file > /dev/null; then
  if [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi
  if [ -r ${LIB}/$file ]; then
    echo Replacing $file
    cat > ${LIB}/$file << EOF
/* This file was generated by fixincludes */
#ifndef __memory_h__
#define __memory_h__

#ifdef __STDC__
extern void *memccpy();
extern void *memchr();
extern void *memcpy();
extern void *memset();
#else
extern char *memccpy();
extern char *memchr();
extern char *memcpy();
extern char *memset();
#endif /* __STDC__ */

extern int memcmp();

#endif /* __memory_h__ */
EOF
  fi
fi

# Fix return type of fread and fwrite on sysV68
file=stdio.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, fread and fwrite return type
  sed -e 's/^\(extern int	fclose(), fflush()\), \(fread(), fwrite()\)\(.*\)$/extern unsigned int	\2;\
\1\3/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# parameters not const on DECstation Ultrix V4.0 and OSF/1.
file=stdio.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, non-const arg
  sed -e 's@perror( char \*__s );@perror( const char *__s );@' \
      -e 's@fputs( char \*__s,@fputs( const char *__s,@' \
      -e 's@fopen( char \*__filename, char \*__type );@fopen( const char *__filename, const char *__type );@' \
      -e 's@fwrite( void \*__ptr,@fwrite( const void *__ptr,@' \
      -e 's@fscanf( FILE \*__stream, char \*__format,@fscanf( FILE *__stream, const char *__format,@' \
      -e 's@scanf( char \*__format,@scanf( const char *__format,@' \
      -e 's@sscanf( char \*__s, char \*__format,@sscanf( const char *__s, const char *__format,@' \
      -e 's@popen(char \*, char \*);@popen(const char *, const char *);@' \
      -e 's@tempnam(char\*,char\*);@tempnam(const char*,const char*);@' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# parameters conflict with C++ new on rs/6000 
for file in stdio.h unistd.h ; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing $file, parameter name conflicts
    sed -e 's@rename(const char \*old, const char \*new)@rename(const char *_old, const char *_new)@' \
      ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# function class(double x) conflicts with C++ keyword on rs/6000 
file=math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if grep '[^a-zA-Z_]class[(]' ${LIB}/$file >/dev/null; then
    echo Fixing $file
    sed -e '/class[(]/i\
#ifndef __cplusplus
' \
        -e '/class[(]/a\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
fi

# Wrong fchmod prototype on RS/6000.
file=sys/stat.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, fchmod prototype
  sed -e 's/fchmod(char \*/fchmod(int/' \
    ${LIB}/$file > ${LIB}/$file.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# There are several name conflicts with C++ reserved words in X11
# header files.  These are fixed in some versions, so don't do the
# fixes if we find __cplusplus in the file.  These were found on the
# RS/6000.

# class in X11/ShellP.h
file=X11/ShellP.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if grep __cplusplus ${LIB}/$file >/dev/null 2>/dev/null; then
    true;
  else
    echo Fixing $file, field class
    sed -e '/char [*]class;/i\
#ifdef __cplusplus\
	char *c_class;\
#else
' \
        -e '/char [*]class;/a\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi
# new in Xm/Traversal.h
file=Xm/Traversal.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if grep __cplusplus ${LIB}/$file >/dev/null 2>/dev/null; then
    true;
  else
    echo Fixing $file, uses of new
    sed -e '/Widget	old, new;/i\
#ifdef __cplusplus\
	Widget	old, c_new;\
#else
' \
        -e '/Widget	old, new;/a\
#endif
' \
	-e 's/Widget new,/Widget c_new,/g' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi
# class in Xm/BaseClassI.h
file=Xm/BaseClassI.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if grep __cplusplus ${LIB}/$file >/dev/null 2>/dev/null; then
    true;
  else
    echo Fixing $file, prototype parameter name
    sed -e 's/ class[)]/ c_class)/g' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# NeXT 3.2 adds const prefix to some math functions. These conflict
# with the built-in functions.
file=ansi/math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
fi
if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/^extern.*double.*__const__.*sqrt(/s/__const__//' \
      -e '/^extern.*double.*__const__.*fabs(/s/__const__//' \
      -e '/^extern.*double.*__const__.*cos(/s/__const__//' \
      -e '/^extern.*double.*__const__.*hypot(/s/__const__//' \
      -e '/^extern.*double.*__const__.*sin(/s/__const__//' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# NeXT 3.2 uses the word "template" as a parameter for some 
# functions. GCC reports an invalid use of a reserved key word
# with the built-in functions. NeXT 3.2 includes the keyword
# volatile in the prototype for abort(). This conflicts with
# the built-in definition.
file=bsd/libc.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
fi
if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/\(.*template\)/s/template//' \
      -e '/extern.*volatile.*void.*abort/s/volatile//' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# NeXT 3.2 includes the keyword volatile in the abort() and 
# exit() function prototypes. That conflicts with the 
# built-in functions.
file=ansi/stdlib.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
fi
if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/extern.*volatile.*void.*exit/s/volatile//' \
      -e '/extern.*volatile.*void.*abort/s/volatile//' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# sys/wait.h on AIX 3.2.5 puts the declaration of wait3 before the definition
# of struct rusage, so the prototype (added by fixproto) causes havoc.
file=sys/wait.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ] \
  && grep 'bos325,' ${LIB}/$file >/dev/null; then
  echo Fixing $file, wait3 declaration
  sed -e '/^extern pid_t wait3();$/i\
struct rusage;
'\
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# NeXT 2.0 defines 'int wait(union wait*)', which conflicts with Posix.1.
# Note that version 3 of the NeXT system has wait.h in a different directory,
# so that this code won't do anything.  But wait.h in version 3 has a
# conditional, so it doesn't need this fix.  So everything is okay.
file=sys/wait.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ] \
  && grep 'wait[(]union wait' ${LIB}/$file >/dev/null; then
  echo Fixing $file, bad wait formal
  sed -e 's@wait(union wait@wait(void@' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Don't use or define the name va_list in stdio.h.
# This is for ANSI and also to interoperate properly with gcc's varargs.h.
file=stdio.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, use of va_list
  # Arrange for stdio.h to use stdarg.h to define __gnuc_va_list
  if egrep "__need___va_list" ${LIB}/$file >/dev/null 2>&1; then
    touch ${LIB}/${file}.sed
  else
    (echo "#define __need___va_list"
     echo "#include <stdarg.h>") > ${LIB}/${file}.sed
  fi
  # Use __gnuc_va_list in arg types in place of va_list.
  # On 386BSD use __gnuc_va_list instead of _VA_LIST_. We're hoping the
  # trailing parentheses and semicolon save all other systems from this.
  # Define __va_list__ (something harmless and unused) instead of va_list.
  # Don't claim to have defined va_list.
  sed -e 's@ va_list @ __gnuc_va_list @' \
      -e 's@ va_list)@ __gnuc_va_list)@' \
      -e 's@ _BSD_VA_LIST_));@ __gnuc_va_list));@' \
      -e 's@ _VA_LIST_));@ __gnuc_va_list));@' \
      -e 's@ va_list@ __va_list__@' \
      -e 's@\*va_list@*__va_list__@' \
      -e 's@ __va_list)@ __gnuc_va_list)@' \
      -e 's@GNUC_VA_LIST@GNUC_Va_LIST@' \
      -e 's@_NEED___VA_LIST@_NEED___Va_LIST@' \
      -e 's@VA_LIST@DUMMY_VA_LIST@' \
      -e 's@_Va_LIST@_VA_LIST@' \
    ${LIB}/$file >> ${LIB}/${file}.sed
  
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Cancel out ansi_compat.h on Ultrix.  Replace it with empty file.
file=ansi_compat.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  if grep -s ULTRIX $file; then
    echo "/* This file intentionally left blank.  */" > $LIB/$file
  fi
fi

# parameter to atof not const on DECstation Ultrix V4.0 and NEWS-OS 4.2R.
# also get rid of bogus inline definitions in HP-UX 8.0
file=math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, non-const arg
  sed -e 's@atof(\([ 	]*char[ 	]*\*[^)]*\))@atof(const \1)@' \
      -e 's@inline int abs(int [a-z][a-z]*) {.*}@extern "C" int abs(int);@' \
      -e 's@inline double abs(double [a-z][a-z]*) {.*}@@' \
      -e 's@inline int sqr(int [a-z][a-z]*) {.*}@@' \
      -e 's@inline double sqr(double [a-z][a-z]*) {.*}@@' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# fix bogus recursive stdlib.h in NEWS-OS 4.0C
file=stdlib.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, recursive inclusion
  sed -e '/^#include <stdlib.h>/i\
#if 0
' \
      -e '/^#include <stdlib.h>/a\
#endif
' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Avoid nested comments on Ultrix 4.3.
file=rpc/svc.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, nested comment
  sed -e 's@^\( \*	int protocol;  \)/\*@\1*/ /*@' \
    ${LIB}/$file > ${LIB}/$file.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# This file in RISC/os uses /**/ to concatenate two tokens.
file=bsd43/bsd43_.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi
if [ -r ${LIB}/$file ]; then
  sed -e 's|/\*\*/|##|' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

file=rpc/rpc.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, nested comment
  sed -e 's@^\(/\*.*rpc/auth_des.h>.*\)/\*@\1*/ /*@' \
    ${LIB}/$file > ${LIB}/$file.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# rpc/types.h on OSF1/2.0 is not C++ ready, even though NO_IMPLICIT_EXTERN_C
# is defined for the alpha.  The problem is the declaration of malloc.
file=rpc/types.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/rpc 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi
if [ -r ${LIB}/$file ]; then
  if egrep '"C"' ${LIB}/$file >/dev/null 2>&1; then
    true
  else
    echo Fixing $file
    echo '#ifdef __cplusplus
extern "C" {
#endif' > ${LIB}/${file}.sed
    cat ${LIB}/${file} >> ${LIB}/${file}.sed
    echo '#ifdef __cplusplus
}
#endif' >> ${LIB}/${file}.sed 
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
fi

# In limits.h, put #ifndefs around things that are supposed to be defined
# in float.h to avoid redefinition errors if float.h is included first.
# On HP/UX this patch does not work, because on HP/UX limits.h uses
# multi line comments and the inserted #endif winds up inside the
# comment.  Fortunately, HP/UX already uses #ifndefs in limits.h; if
# we find a #ifndef FLT_MIN we assume that all the required #ifndefs
# are there, and we do not add them ourselves.
# Also fix a nested comment problem in sys/limits.h on Motorola sysV68 R3V7.1
for file in limits.h sys/limits.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    mkdir ${LIB}/sys 2>/dev/null
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    if egrep 'ifndef[ 	]+FLT_MIN' ${LIB}/$file >/dev/null; then
      true
    else
      echo Fixing $file
      sed -e '/[ 	]FLT_MIN[ 	]/i\
#ifndef FLT_MIN
'\
	  -e '/[ 	]FLT_MIN[ 	]/a\
#endif
'\
	  -e '/[ 	]FLT_MAX[ 	]/i\
#ifndef FLT_MAX
'\
	  -e '/[ 	]FLT_MAX[ 	]/a\
#endif
'\
	  -e '/[ 	]FLT_DIG[ 	]/i\
#ifndef FLT_DIG
'\
	  -e '/[ 	]FLT_DIG[ 	]/a\
#endif
'\
	  -e '/[ 	]DBL_MIN[ 	]/i\
#ifndef DBL_MIN
'\
	  -e '/[ 	]DBL_MIN[ 	]/a\
#endif
'\
	  -e '/[ 	]DBL_MAX[ 	]/i\
#ifndef DBL_MAX
'\
	  -e '/[ 	]DBL_MAX[ 	]/a\
#endif
'\
	  -e '/[ 	]DBL_DIG[ 	]/i\
#ifndef DBL_DIG
'\
	  -e '/[ 	]DBL_DIG[ 	]/a\
#endif
'\
	  -e '/^\(\/\*#define	HUGE_VAL	3\.[0-9e+]* *\)\/\*/s//\1/'\
	${LIB}/$file > ${LIB}/${file}.sed
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    fi
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      echo Deleting ${LIB}/$file\; no fixes were needed.
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# In math.h, put #ifndefs around things that might be defined in a gcc
# specific math-*.h file.
file=math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/define[ 	]HUGE_VAL[ 	]/i\
#ifndef HUGE_VAL
'\
      -e '/define[ 	]HUGE_VAL[ 	]/a\
#endif
'\
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file

  # In addition, copy the definition of DBL_MAX from float.h
  # if math.h requires one.  The Lynx math.h requires it.
  if egrep '#define[ 	]*HUGE_VAL[ 	]+DBL_MAX' $file >/dev/null 2>&1; then
    if egrep '#define[ 	]+DBL_MAX[ 	]+' $file >/dev/null 2>&1; then
      true;
    else
      dbl_max_def=`egrep 'define[ 	]+DBL_MAX[ 	]+.*' float.h 2>/dev/null`
      if [ "$dbl_max_def" != "" ]; then
        dbl_max_def=`echo $dbl_max_def | sed 's/.*define[ 	]*DBL_MAX[ 	]*//'`
        sed -e "/define[ 	]HUGE_VAL[ 	]DBL_MAX/s/DBL_MAX/$dbl_max_def/" \
          ${LIB}/$file > ${LIB}/${file}.sed
	rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
      fi
    fi
  fi

  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    echo Deleting ${LIB}/$file\; no fixes were needed.
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Remove erroneous parentheses in sym.h on Alpha OSF/1.
file=sym.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/#ifndef(__mips64)/#ifndef __mips64/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix return value of mem{ccpy,chr,cpy,set} and str{len,spn,cspn}
# in string.h on sysV68
# Correct the return type for strlen in string.h on Lynx.
# Correct the argument type for ffs in string.h on Alpha OSF/1 V2.0.
# Add missing const for strdup on OSF/1 V3.0.
# On sysV88 layout is slightly different.
file=string.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, mem{ccpy,chr,cpy,set} and str{len,spn,cspn} return value
  sed -e 's/extern[ 	]*int[ 	]*strlen();/extern unsigned int strlen();/' \
      -e 's/extern[ 	]*int[ 	]*ffs[ 	]*(long);/extern int ffs(int);/' \
      -e 's/strdup(char \*s1);/strdup(const char *s1);/' \
      -e '/^extern char$/N' \
      -e 's/^extern char\(\n	\*memccpy(),\)$/extern void\1/'\
      -e '/^	strncmp(),$/N'\
      -e 's/^\(	strncmp()\),\n\(	strlen(),\)$/\1;\
extern unsigned int\
\2/'\
      -e '/^extern int$/N'\
      -e 's/^extern int\(\n	strlen(),\)/extern size_t\1/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Correct the return type for strlen in strings.h in SunOS 4.
file=strings.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/int[ 	]*strlen();/__SIZE_TYPE__ strlen();/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Delete the '#define void int' line from curses.h on Lynx
file=curses.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e '/#[ 	]*define[ 	][ 	]*void[ 	]int/d' \
     ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix `typedef struct term;' on hppa1.1-hp-hpux9.
file=curses.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/^[ 	]*typedef[ 	][ 	]*\(struct[ 	][ 	]*term[ 	]*;[ 	]*\)$/\1/' \
     ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# For C++, avoid any typedef or macro definition of bool, and use the
# built in type instead.
for files in curses.h; do
  if [ -r ${INPUT}/$file ] && egrep bool $file >/dev/null 2>&1; then
    if [ ! -r ${LIB}/$file ]; then
      cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
      chmod +w ${LIB}/$file 2>/dev/null
      chmod a+r ${LIB}/$file 2>/dev/null
    fi

    echo Fixing $file
    sed -e '/^#[ 	]*define[ 	][ 	]*bool[ 	][ 	]*char[ 	]*$/i\
#ifndef __cplusplus
'\
	-e '/^#[ 	]*define[ 	][ 	]*bool[ 	][ 	]*char[ 	]*$/a\
#endif
'\
	-e '/^typedef[ 	][ 	]*char[ 	][ 	]*bool[ 	]*;/i\
#ifndef __cplusplus
'\
	-e '/^typedef[ 	][ 	]*char[ 	][ 	]*bool[ 	]*;/a\
#endif
'\
	${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# Fix incorrect S_IF* definitions on m88k-sysv3.
file=sys/stat.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/^\(#define[ 	]*S_IS[A-Z]*(m)\)[ 	]*(m[ 	]*&[ 	]*\(S_IF[A-Z][A-Z][A-Z][A-Z]*\)[ 	]*)/\1 (((m)\&S_IFMT)==\2)/' \
      -e 's/^\(#define[ 	]*S_IS[A-Z]*(m)\)[ 	]*(m[ 	]*&[ 	]*\(0[0-9]*\)[ 	]*)/\1 (((m)\&S_IFMT)==\2)/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix nested comments in Motorola's <limits.h> and <sys/limits.h>
for file in limits.h sys/limits.h; do
  if [ $target_canonical = m88k-motorola-sysv3 -o \
       $target_canonical = m68k-motorola-sysv ]; then

    if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
      cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
      chmod +w ${LIB}/$file 2>/dev/null
      chmod a+r ${LIB}/$file 2>/dev/null
    fi

    if [ -r ${LIB}/$file ]; then
      echo "Fixing nested comments in Motorola's $file"
      sed \
        -e 's@^\(#undef[ 	][ 	]*PIPE_BUF[ 	]*/\* max # bytes atomic in write to a\)$@\1 */@' \
        -e 's@\(/\*#define	HUGE_VAL	3.40282346638528860e+38 \)\(/\*error value returned by Math lib\*/\)$@\1*/ \2@'	\
  	  < ${LIB}/$file > ${LIB}/${file}.sed
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
      if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
        rm -f ${LIB}/$file
      fi
    fi
  fi
done

# Fix getopt declarations in stdio.h and stdlib.h on Alpha OSF/1 and AIX.
for file in stdio.h stdlib.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing $file, getopt declaration
    sed -e 's/getopt(int, char \*\[\],[ ]*char \*)/getopt(int, char *const[], const char *)/' \
      ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# Fix __page_size* declarations in pthread.h AIX 4.1.[34].
# The original ones fail if uninitialized externs are not common.
# This is the default for all ANSI standard C++ compilers.
for file in pthread.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing $file, __page_size* declarations
    sed -e 's/^int __page_size/extern int __page_size/' \
      ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# Determine if we're on Interactive Unix 2.2 or later, in which case we
# need to fix some additional files.  This is the same test for ISC that
# Autoconf uses.
if test -d /etc/conf/kconfig.d \
    && grep _POSIX_VERSION /usr/include/sys/unistd.h >/dev/null 2>&1; then
  echo "Fixing ISC __STDC__ goof in several files..."
  for name in stdio.h math.h ctype.h sys/limits.h sys/fcntl.h sys/dirent.h; do
    echo $name
    if test -r ${LIB}/$name; then
      file=${LIB}/$name
    else
      file=${INPUT}/$name
    fi
    # On Interactive 2.2, certain traditional Unix definitions
    # (notably getc and putc in stdio.h) are omitted if __STDC__ is
    # defined, not just if _POSIX_SOURCE is defined.  This makes it
    # impossible to compile any nontrivial program except with -posix.
    sed \
's/!defined(__STDC__) && !defined(_POSIX_SOURCE)/!defined(_POSIX_SOURCE)/' \
	    < $file > ${LIB}/$name.
    mv ${LIB}/$name. ${LIB}/$name
  done
  
  echo "Fixing ISC fmod declaration"
  # This one's already been fixed for other things.
  file=${LIB}/math.h
  sed 's/fmod(double)/fmod(double, double)/' <$file >$file.
  mv $file. $file
  
  echo "Fixing nested comments in ISC <sys/limits.h>"
  file=sys/limits.h
  sed '/CHILD_MAX/s,/\* Max, Max,' < ${INPUT}/$file >${LIB}/$file.
  sed '/OPEN_MAX/s,/\* Max, Max,' < ${LIB}/$file. >${LIB}/$file
fi

# These files in Sun OS 4.x use /**/ to concatenate tokens.
for file in sparc/asm_linkage.h sun3/asm_linkage.h sun3x/asm_linkage.h	\
	sun4/asm_linkage.h sun4c/asm_linkage.h sun4m/asm_linkage.h	\
	sun4c/debug/asm_linkage.h sun4m/debug/asm_linkage.h;
do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    sed -e 's|/\*\*/|##|g' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
        dir=`echo $file | sed -e s'|/[^/]*$||'`
        required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# These files in ARM/RISCiX use /**/ to concatenate tokens.
for file in arm/as_support.h arm/mc_type.h arm/xcb.h dev/chardefmac.h \
	dev/ps_irq.h dev/screen.h dev/scsi.h sys/tty.h Xm.acorn/XmP.h
do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    sed -e 's|/\*\*/|##|g' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
    fi
  fi
done

# libm.a on m88k-motorola-sysv3 contains a stupid optimization for function
# hypot(), which returns the second argument without even looking at its value
# if the other is 0.0
# Another drawback is that fix-header doesn't fix fabs' prototype, and I have
#  no idea why.
file=math.h
if [ $target_canonical = m88k-motorola-sysv3 ]; then
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo Fixing $file, fabs/hypot definition
    sed \
      -e 's/extern double floor(), ceil(), fmod(), fabs();/extern double floor(), ceil(), fmod(), fabs _PARAMS((double));/' \
      -e '/^extern double hypot();$/a\
\/* Workaround a stupid Motorola optimization if one\
   of x or y is 0.0 and the other is negative!  *\/\
#ifdef __STDC__\
static __inline__ double fake_hypot (double x, double y)\
#else\
static __inline__ double fake_hypot (x, y)\
	double x, y;\
#endif\
{\
	return fabs (hypot (x, y));\
}\
#define hypot	fake_hypot
' \
      ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    fi
  fi
fi

# math.h on SunOS 4 puts the declaration of matherr before the definition
# of struct exception, so the prototype (added by fixproto) causes havoc.
file=math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, matherr declaration
  sed -e '/^struct exception/,$b' \
      -e '/matherr/i\
struct exception;
'\
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# assert.h and sys/mman.h on HP/UX are not C++ ready, even though
# NO_IMPLICIT_EXTERN_C is defined on HP/UX.
for file in assert.h sys/mman.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    if egrep '"C"' ${LIB}/$file >/dev/null 2>&1 \
       || egrep '__BEGIN_DECLS' ${LIB}/$file >/dev/null 2>&1; then
      true
    else
      echo Fixing $file
      echo '#ifdef __cplusplus
extern "C" {
#endif' > ${LIB}/${file}.sed
      cat ${LIB}/${file} >> ${LIB}/${file}.sed
      echo '#ifdef __cplusplus
}
#endif' >> ${LIB}/${file}.sed 
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    fi
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $file | sed -e s'|/[^/]*$||'`
	required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# Fix return value of sbrk in unistd.h on Alpha OSF/1 V2.0
file=unistd.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${input}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, sbrk declaration
  sed -e 's/char\([ 	]*\*[	 ]*sbrk[ 	]*(\)/void\1/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# This file on SunOS 4 has a very large macro.  When the sed loop
# tries pull it in, it overflows the pattern space size of the SunOS
# sed (GNU sed does not have this problem).  Since the file does not
# require fixing, we remove it from the fixed directory.
file=sundev/ipi_error.h
if [ -r ${LIB}/$file ]; then
  echo "Removing incorrect fix to SunOS <sundev/ipi_error.h>"
  rm -f ${LIB}/$file
fi

# Put cpp wrappers around these include files to avoid redeclaration
# errors during multiple inclusion on m88k-tektronix-sysv3.
for file in time.h sys/time.h ; do
  if egrep '#ifndef' $file >/dev/null 2>&1; then
    true
  else
    if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
      cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
      chmod +w ${LIB}/$file 2>/dev/null
    fi
    if [ -r ${LIB}/$file ]; then
      echo Fixing $file, to protect against multiple inclusion.
      cpp_wrapper=`echo $file | sed -e 's,\.,_,g' -e 's,/,_,g'`
      (echo "#ifndef __GCC_GOT_${cpp_wrapper}_"
      echo "#define __GCC_GOT_${cpp_wrapper}_"
      cat ${LIB}/${file}
      echo '#endif /* !_GCC_GOT_'${cpp_wrapper}_' */')  > ${LIB}/${file}.new
      rm -f ${LIB}/$file; mv ${LIB}/${file}.new ${LIB}/$file
    fi
  fi
done

# Fix fcntl prototype in fcntl.h on LynxOS.
file=fcntl.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, fcntl declaration
  sed -e 's/\(fcntl.*(int, int, \)int)/\1...)/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix definitions of macros used by va-i960.h in VxWorks header file.
file=arch/i960/archI960.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/__vsiz/__vxvsiz/' -e 's/__vali/__vxvali/' \
      -e s'/__vpad/__vxvpad/' -e 's/__alignof__/__vxalignof__/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Make VxWorks header which is almost gcc ready fully gcc ready.
file=types/vxTypesBase.h
if [ -r $file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file
  sed -e 's/#ifdef __GNUC_TYPEOF_FEATURE_BROKEN_USE_DEFAULT_UNTIL_FIXED__/#if 1/' \
      -e '/[ 	]size_t/i\
#ifndef _GCC_SIZE_T\
#define _GCC_SIZE_T
' \
      -e '/[ 	]size_t/a\
#endif
' \
      -e '/[ 	]ptrdiff_t/i\
#ifndef _GCC_PTRDIFF_T\
#define _GCC_PTRDIFF_T
' \
      -e '/[ 	]ptrdiff_t/a\
#endif
' \
      -e '/[ 	]wchar_t/i\
#ifndef _GCC_WCHAR_T\
#define _GCC_WCHAR_T
' \
      -e '/[ 	]wchar_t/a\
#endif
' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix VxWorks <sys/stat.h> to not require including <vxWorks.h>.
file=sys/stat.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if egrep '#include' ${LIB}/$file >/dev/null 2>&1; then
    :
  else
    if egrep 'ULONG' ${LIB}/$file >/dev/null 2>&1 \
       && [ -r types/vxTypesOld.h ]; then
      echo Fixing $file
      sed -e '/#define[ 	][ 	]*__INCstath/a\
#include <types/vxTypesOld.h>
' \
    ${LIB}/$file > ${LIB}/${file}.sed
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    fi
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Fix VxWorks <time.h> to not require including <vxTypes.h>.
file=time.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if egrep 'uint_t[ 	][ 	]*_clocks_per_sec' ${LIB}/$file >/dev/null 2>&1; then
    echo Fixing $file
    sed -e 's/uint_t/unsigned int/' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi
    
# Fix hpux10.20 <sys/time.h> to avoid invalid forward decl
file=sys/time.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if egrep '^extern struct sigevent;' ${LIB}/$file >/dev/null 2>&1; then
    echo Fixing $file
    sed -e 's/^extern struct sigevent;/struct sigevent;/' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi
    
# Another bad dependency in VxWorks 5.2 <time.h>.
file=time.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  mkdir ${LIB}/sys 2>/dev/null
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  if egrep VOIDFUNCPTR ${LIB}/$file >/dev/null 2>&1; then
    if [ -r vxWorks.h ]; then
      echo Fixing $file
      sed -e '/VOIDFUNCPTR/i\
#ifndef __gcc_VOIDFUNCPTR_defined\
#ifdef __cplusplus\
typedef void (*__gcc_VOIDFUNCPTR) (...);\
#else\
typedef void (*__gcc_VOIDFUNCPTR) ();\
#endif\
#define __gcc_VOIDFUNCPTR_defined\
#endif
' \
	  -e 's/VOIDFUNCPTR/__gcc_VOIDFUNCPTR/g' \
	${LIB}/$file > ${LIB}/${file}.sed
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    fi
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi
    
# This file in A/UX 3.0.x/3.1.x contains an __asm directive for c89; gcc
# doesn't understand it.
file=sys/param.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo "Fixing __asm directive in sys/param.h"
  sed -e 's|#ifndef NOINLINE|#if !defined(NOINLINE) \&\& !defined(__GNUC__)|' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# signal.h on SunOS defines signal using (), which causes trouble when
# compiling with g++ -pedantic.
for file in signal.h sys/signal.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo "Checking for bad C++ prototype in $file"
    sed -e '/^void	(\*signal())();$/i\
  #ifdef __cplusplus\
  void	(*signal(...))(...);\
  #else
  ' \
	-e '/^void	(\*signal())();$/a\
  #endif
  ' \
      ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $file | sed -e s'|/[^/]*$||'`
	required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# sys/signal.h on some versions of AIX uses volatile in the typedef of
# sig_atomic_t, which causes gcc to generate a warning about duplicate
# volatile when a sig_atomic_t variable is declared volatile, as
# required by ANSI C.
file=sys/signal.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo "Checking for duplicate volatile in sys/signal.h"
  sed -e 's/typedef volatile int sig_atomic_t/typedef int sig_atomic_t/' \
    ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# Some math.h files define struct exception, which conflicts with
# the class exception defined in the C++ file std/stdexcept.h.  We
# redefine it to __math_exception.  This is not a great fix, but I
# haven't been able to think of anything better.
file=math.h
if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
  cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
  chmod +w ${LIB}/$file 2>/dev/null
  chmod a+r ${LIB}/$file 2>/dev/null
fi

if [ -r ${LIB}/$file ]; then
  echo Fixing $file, exception
  sed -e '/struct exception/i\
#ifdef __cplusplus\
#define exception __math_exception\
#endif
'\
      -e '/struct exception/a\
#ifdef __cplusplus\
#undef exception\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
  rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  if egrep 'matherr()' ${LIB}/$file >/dev/null 2>&1; then
    sed -e '/matherr/i\
#ifdef __cplusplus\
#define exception __math_exception\
#endif
'\
        -e '/matherr/a\
#ifdef __cplusplus\
#undef exception\
#endif
' ${LIB}/$file > ${LIB}/${file}.sed
    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
  fi
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
fi

# rpc/auth.h on SunOS needs prototypes for its AUTH->auth_ops function pointers
# Similarly for 
#   rpc/clnt.h CLIENT->clnt_ops
#   rpc/svc.h SVCXPRT->xp_ops
#   rpc/xdr.h XDR->xdr_ops
for file in rpc/auth.h rpc/clnt.h rpc/svc.h rpc/xdr.h; do
  # each file has a different name to replace, so if you add a file to
  # that list please update the following case statement.
  case "$file" in
    rpc/auth.h)
      prefix="ah_"
      ;;
    rpc/clnt.h)
      prefix="cl_"
      ;;
    rpc/svc.h)
      prefix="xp_"
      ;;
    rpc/xdr.h)
      prefix="x_"
      ;;
    *)
      # Oh Oh, we shouldn't be here
      exit 1;
      ;;
  esac

  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    echo "Checking for needed C++ prototype in $file"
    sed -e 's/^\(.*\)\*\('$prefix'.*\)();\(.*\)/\
#ifdef __cplusplus\
\1*\2(...);\3\
#else\
\1*\2();\3\
#endif/g' \
     $LIB/$file > ${LIB}/${file}.sed

    rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
    if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
      rm -f ${LIB}/$file
    else
      # Find any include directives that use "file".
      for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $file | sed -e s'|/[^/]*$||'`
	required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
      done
    fi
  fi
done

# sys/lc_core.h on some versions of OSF1/4.x pollutes the namespace by
# defining regex.h types.  This causes C++ library build and usage failures.
# Fixing this correctly requires checking and modifying 3 files.
for file in reg_types.h regex.h sys/lc_core.h; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi
done
if [ -r ${LIB}/reg_types.h ]; then
  if egrep '} regex_t;' ${LIB}/reg_types.h >/dev/null 2>&1; then
    if [ -r ${LIB}/sys/lc_core.h ]; then
      if egrep ' regex_t ' ${LIB}/sys/lc_core.h >/dev/null 2>&1; then
        if [ -r ${LIB}/regex.h ]; then
	  if egrep '__regex_t' ${LIB}/regex.h >/dev/null 2>&1; then
	    true;
	  else
	    echo Fixing reg_types.h, regex.h, sys/lc_core.h
	    for file in reg_types.h sys/lc_core.h; do
	      sed -e 's/regex_t/__regex_t/g' \
	        -e 's/regoff_t/__regoff_t/g' \
		-e 's/regmatch_t/__regmatch_t/g' \
		${LIB}/$file > ${LIB}/${file}.sed
	      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
	    done
	    sed -e '/#include <reg_types.h>/a\
typedef __regex_t	regex_t;\
typedef __regoff_t	regoff_t;\
typedef __regmatch_t	regmatch_t;\
' \
	      ${LIB}/regex.h > ${LIB}/regex.h.sed
	    rm -f ${LIB}/regex.h; mv ${LIB}/regex.h.sed ${LIB}/regex.h
	  fi
	fi
      fi
    fi
  fi
fi
for file in reg_types.h regex.h sys/lc_core.h; do
  if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
    rm -f ${LIB}/$file
  else
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
done

# AIX headers define NULL to be cast to a void pointer, which is illegal
# in ANSI C++.
for file in curses.h dbm.h locale.h stdio.h stdlib.h string.h time.h unistd.h sys/dir.h sys/param.h sys/types.h ; do
  if [ -r ${INPUT}/$file ] && [ ! -r ${LIB}/$file ]; then
    cp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1 || echo "Can't copy $file"
    chmod +w ${LIB}/$file 2>/dev/null
    chmod a+r ${LIB}/$file 2>/dev/null
  fi

  if [ -r ${LIB}/$file ]; then
    if egrep '#.*define.*NULL.*void' ${LIB}/$file >/dev/null 2>&1; then
      echo "Fixing $file, bad NULL macro"
      sed -e 's/^#[ 	]*define[ 	]*NULL[ 	]*((void[ 	]*\*)0)/#define NULL 0/' \
        ${LIB}/$file > ${LIB}/${file}.sed
      rm -f ${LIB}/$file; mv ${LIB}/${file}.sed ${LIB}/$file
      if cmp ${INPUT}/$file ${LIB}/$file >/dev/null 2>&1; then
        rm -f ${LIB}/$file
      else
        # Find any include directives that use "file".
        for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[      ]*"\([^"]*\)".*$/\1/'`; do
  	  dir=`echo $file | sed -e s'|/[^/]*$||'`
	  required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
        done
      fi
    fi
  fi
done

# HPUX 10.x sys/param.h defines MAXINT which clashes with values.h
file=sys/param.h
base=`basename $file`
if [ -r ${LIB}/$file ]; then
  file_to_fix=${LIB}/$file
else
  if [ -r ${INPUT}/$file ]; then
    file_to_fix=${INPUT}/$file
  else
    file_to_fix=""
  fi
fi
if [ \! -z "$file_to_fix" ]; then
  echo Checking $file_to_fix
  sed -e '/^#[ 	]*define[ 	]*MAXINT[ 	]/i\
#ifndef MAXINT
'\
      -e '/^#[ 	]*define[ 	]*MAXINT[ 	]/a\
#endif
' $file_to_fix > /tmp/$base
  if cmp $file_to_fix /tmp/$base >/dev/null 2>&1; then \
    true
  else
    echo Fixed $file_to_fix
    rm -f ${LIB}/$file
    cp /tmp/$base ${LIB}/$file
    chmod a+r ${LIB}/$file
    # Find any include directives that use "file".
    for include in `egrep '^[       ]*#[    ]*include[      ]*"[^/]' ${LIB}/$file | sed -e 's/^[    ]*#[    ]*include[ 	]*"\([^"]*\)".*$/\1/'`; do
      dir=`echo $file | sed -e s'|/[^/]*$||'`
      required="$required ${INPUT} $dir/$include ${LIB}/$dir/$include"
    done
  fi
  rm -f /tmp/$base
fi

#
#  	Patch sys/djtypes.h to avoid unneeded warnings
#
cp -v ${INPUT}/sys/djtypes.h ${LIB}/sys/djtypes.h
patch -Nb ${LIB}/sys/djtypes.h << 'EOF'
*** include/sys/djtypes.h.orig	Wed Sep  9 16:56:26 1998
--- include/sys/djtypes.h	Tue Mar  9 21:22:50 1999
***************
*** 7,24 ****
--- 7,39 ----
  #define __DJ_gid_t	typedef int gid_t;
  #define __DJ_off_t	typedef int off_t;
  #define __DJ_pid_t	typedef int pid_t;
+ #ifndef _SIZE_T_DEFINED_
+ #define _SIZE_T_DEFINED_
  #define __DJ_size_t	typedef long unsigned int size_t;
+ #else
+ #define __DJ_size_t
+ #endif
  #define __DJ_ssize_t	typedef int ssize_t;
  #define __DJ_time_t	typedef unsigned int time_t;
  #define __DJ_uid_t	typedef int uid_t;
+ #ifndef _VA_LIST_DEFINED
+ #define _VA_LIST_DEFINED
  #define __DJ_va_list	typedef void *va_list;
+ #else
+ #define __DJ_va_list
+ #endif
  
  #if defined(__cplusplus) && ( (__GNUC_MINOR__ >= 8 && __GNUC__ == 2 ) || __GNUC__ >= 3 )
  /* wchar_t is now a keyword in C++ */
  #define __DJ_wchar_t
  #else
  /* but remains a typedef in C */
+ #ifndef _WCHAR_T_DEFINED_
+ #define _WCHAR_T_DEFINED_
  #define __DJ_wchar_t    typedef int wchar_t;
+ #else
+ #define __DJ_wchar_t
+ #endif
  #endif
  
  #define __DJ_wint_t     typedef int wint_t;
EOF
rm -f ${LIB}/sys/djtypes.h.orig

# Make sure that any include files referenced using double quotes
# exist in the fixed directory.  This comes last since otherwise
# we might end up deleting some of these files "because they don't
# need any change."
set x $required
shift
while [ $# != 0 ]; do
  newreq=
  while [ $# != 0 ]; do
    # $1 is the directory to copy from, $2 is the unfixed file,
    # $3 is the fixed file name.
    cd ${INPUT}
    cd $1
    if [ -r $2 ] && [ ! -r $3 ]; then
      cp $2 $3 >/dev/null 2>&1 || echo "Can't copy $2"
      chmod +w $3 2>/dev/null
      chmod a+r $3 2>/dev/null
      echo Copied $2
      for include in `egrep '^[ 	]*#[ 	]*include[ 	]*"[^/]' $3 | sed -e 's/^[ 	]*#[ 	]*include[ 	]*"\([^"]*\)".*$/\1/'`; do
	dir=`echo $2 | sed -e s'|/[^/]*$||'`
	dir2=`echo $3 | sed -e s'|/[^/]*$||'`
	newreq="$newreq $1 $dir/$include $dir2/$include"
      done
    fi
    shift; shift; shift
  done
  set x $newreq
  shift
done

echo 'Cleaning up DONE files.'
cd $LIB
find . -name DONE -o -name done -exec rm -f '{}' ';'

echo 'Removing unneeded directories:'
cd $LIB
files=`find . -type d -print | sort -r`
for file in $files; do
  rmdir $LIB/$file > /dev/null 2>&1
done

# This is ugly hack to force use of DJGPP stddef.h
cp -vf $DJDIR/include/stddef.h $LIB/stddef.h
chmod -w $LIB/stddef.h

exit 0
FIXINC_EOF
#
dtou gcc/fixinc.djgpp
#
#################################################################################
#   Building gcc simultanously with C++ and Fortran libraries does not
#   work for DJGPP. Therefore let's split package into 2 parts:
#   gcc itself and libraries
#################################################################################
echo "Creating directory libs and moving all except gcc to this directory"
movelist=`echo * | sed -e 's,gcc,,g'`
mkdir libs
for file in $movelist; do
  case $file in
    gcc) ;;
    egcs-patch.sh) ;;
    *) mv -f $file libs/$file ;;
  esac 
done

for file in install-sh config.sub config.guess; do
  cp -f libs/$file gcc/$file
done

for file in `find gcc -name .gdbinit`; do
  mv $file `echo $file | sed -e 's,[.]gdbinit,gdb.ini,g'`
done
	  