#! /bin/sh
# just in case
export PATH_SEPARATOR=:

# The following is not needed to build plain gcc but may be usefull
# if some addons such as g77 is included
export CONFIG_SHELL=bash

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# set this to the wanted CFLAGS, I set here also the default output
# debugging type to stabs.
# currently disabled because we (djgpp-workers) have decided to leave
# the SBD COFF debug information as default.
# CFLAGS="-DPREFERRED_DEBUGGING_TYPE=DBX_DEBUG"

# Create now a stub, which has a larger stack, which is needed for
# at least cc1 when compiling gcc with itself
if [ ! -r stub.exe ]; then
  ln -s dummy stub
  stubedit stub.exe runfile= minstack=1536k
fi
export STUB=`pwd`/stub.exe

# now call make with any additional commandline argument
if [ -z $CFLAGS ]; then
  make $*
else
  make CFLAGS="$CFLAGS" $*
fi
