#! /bin/sh
# just in case
export PATH_SEPARATOR=:

# The following is not needed to build plain gcc but may be usefull
# if some addons such as g77 is included
export CONFIG_SHELL=bash

# The following is needed, to get not the // syntax, when
# the configure script or the makefile calls pwd
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/

# set this to the wanted CFLAGS, I set here also the default output
# debugging type to stabs.
# currently disabled because we (djgpp-workers) have decided to leave
# the SBD COFF debug information as default.
# CFLAGS="-DPREFERRED_DEBUGGING_TYPE=DBX_DEBUG"

# Create now a stub, which has a larger stack, which is needed for
# at least cc1 when compiling gcc with itself
if [ ! -r stub.exe ]; then
  ln -s dummy stub
  stubedit stub.exe runfile= minstack=1536k
fi
export STUB=`pwd`/stub.exe

#  Find locations of current gcc specs file. We need this as
#  target specific specs file will be in current directory
#  (new specs may different from old ones, so we should separate them.
#  Let's hope that root directory doesn't contain file specs)
orig_specs=`( cd /; gcc -print-file-name=specs; )`

# now call make with any additional commandline argument
if [ -z $CFLAGS ]; then
  make  CFLAGS="$CFLAGS" XCFLAGS="-specs=$orig_specs" \
	LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
	$*
else
  make  CFLAGS="$CFLAGS" XCFLAGS="-specs=$orig_specs" \
	LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
	$*
fi
