This is Info file gpc.info, produced by Makeinfo version 1.68 from the
input file /usr/local/src/gcc-2.8.1/p/doc/gpc.texi.

   This file documents the use and the internals of the GNU Pascal
compiler.

   Copyright (C) 1988, 1996 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License," "Funding for
Free Software," and "Protect Your Freedom--Fight `Look And Feel'" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License," "Funding for Free Software," and "Protect Your Freedom--Fight
`Look And Feel'", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.


File: gpc.info,  Node: Build Cross,  Next: Crossbuilding,  Prev: Configure Cross,  Up: cross-compilers

Building the Pascal cross-compiler
----------------------------------

   Once you have verified the C cross-compiler, the Pascal
cross-compiler can be configured and built. Note that the `configure'
script does not require any cross-compiler related switches because GPC
inherits all of this from GNU CC.

   Sample output for a FreeBSD->msdos cross configuration:

     --------------------------------------------------------------------------
     Configuration summary:
       Building a i386-go32 cross-compiler hosted by i386-unknown-freebsd2.1.0
     
       GPC sources in:         ../gpc-2.0
       GCC sources in:         ../gcc-2.8.1
       GCC object code in:     ../gcc
       GCC version:            2.8.1
     
       Compiler for GPC:       gcc
       Compiler for libgpc.a:  i386-go32-gcc
       Compiler flags:         -g -O
     
       Cross-ar utility:       i386-go32-ar
       Cross-ranlib utility:   i386-go32-ranlib
     
       Installation path:      /usr/bin, /usr/lib/gcc-lib/i386-go32/2.8.1
     --------------------------------------------------------------------------
     
     Now, type `make' to build the compiler and runtime system.

   Building a cross-compiler requires cross-binutils for your target,
i386-go32 in this examples. If `configure' is not able to find
`i386-go32-ar' and/or `i386-go32-ranlib', you may have to run it again
with again with `--with-ar=YOUR-CROSS-AR' or
`--with-ranlib=YOUR-CROSS-RANLIB' switches.

   Then, `make' and `make install' the cross-compiler like you would
for a native configuration.


File: gpc.info,  Node: Crossbuilding,  Prev: Build Cross,  Up: cross-compilers

Crossbuilding a compiler.
-------------------------

   Yet another possibility is CROSSBUILDING : Using a cross-compiler to
build GNU Pascal results in a compiler binary that runs on the
cross-target platform. A possible reason why anybody would want to do
this, is when the platform on which you want to run the GNU Pascal
compiler, is not self-hosting. An example is cygwin32.

   To crossbuild GNU Pascal, you have to install a cross-compiler for
your target first. This is covered in chapter 4 of "Using and Porting
GNU CC".  Assuming you want to build a native cygwin32 Pascal compiler
on a FreeBSD system, configure GCC:

     % ../gcc-2.8.1/configure --prefix=/usr --build=i386-freebsd \
     	--host=i386-cygwin32 --target=i386-cygwin32

   Build it:

     % make CFLAGS=-O2 LANGUAGES=c

   Now, configure and build GPC. The output of `configure' should look
like:

     --------------------------------------------------------------------------
     Configuration summary:
       Building a i386-cygwin32 cross-compiler hosted by i386-cygwin32
     
       GPC sources in:         ../gpc-2.0
       GCC sources in:         ../gcc-2.8.1
       GCC object code in:     ../gcc
       GCC version:            2.8.1
     
       Compiler for GPC:       i386-cygwin32-gcc
       Compiler for libgpc.a:  i386-cygwin32-gcc
       Compiler flags:         -g -O
     
       Cross-ar utility:       i386-cygwin32-ar
       Cross-ranlib utility:   i386-cygwin32-ranlib
     
       Installation path:      /usr/bin, /usr/lib/gcc-lib/i386-cygwin32/2.8.1
     --------------------------------------------------------------------------
     
     Now, type `make' to build the compiler and runtime system.

   Again, `configure' should be able to detect and configure this setup
without additional flags. If not, specify `--with-ar', `--with-ranlib',
`--with-gcc' and/or `--with-rtsgcc' as appropriate.

   A cross-built compiler must be installed by hand.


File: gpc.info,  Node: binary distributions,  Prev: cross-compilers,  Up: Installation

Installation instructions for a GPC binary distribution
=======================================================

   To install a binary distribution, cd to the main directory and
unpack the archive while preserving the stored directory structure.  In
concrete, to install a ZIP archive under DOS with PKunzip, `cd' the the
appropriate directory (usually `\' for EMX, `\DJGPP' for DJGPP), then
type

       C:\> pkunzip -d ARCHIVE

   where ARCHIVE is the name of the distribution file.  To install a
`.tar.gz' archive under a UNIX compatible system, become root, then
extract the archive from the root of the filesystem:

       # tar xzf ARCHIVE.tar.gz

   If you are using a `tar' utility other than GNU tar, it might be
necessary to do the above in two steps:

       # gzip -d ARCHIVE.tar.gz
       # tar xf ARCHIVE.tar

   Binary distributions include `libgcc.a' and `specs', files that are
normally part of GCC.  If you have GCC installed, they will be replaced
unless you manually install the archive.


File: gpc.info,  Node: Invoking GPC,  Next: Programming,  Prev: Installation,  Up: Top

GNU Pascal Command Options
**************************

   GPC is a command-line compiler, i.e. to compile a program you have
to invoke `gpc' passing it the name of the file you want to compile,
plus options.

   Typing

     gpc foo.pas

   means to compile the source file `foo.pas' and to produce an
executable of the default name which is `foo.exe' on EMX, `a.exe' on
DJGPP, and `a.out' on most other platforms.

   A more typical example reads

     gpc -O --automake foo.pas -o foo

   This means to compile the source file `foo.pas' to an executable
named `foo' (that's the meaning of the `-o' option) with optimization
(the `-O' option).  When the program uses Units or imports Modules, they
will be automatically compiled and linked (the `--automake' option).

   The following gives a detailed description of all options accepted by
`gpc'.  While there are really a lot of options, you will need only a
few of them, so don't worry.  ;-)  Most options are there to customize
GPC's behaviour in order to satisfy a large variety of users on a large
variety of platforms.

   When you invoke GPC, it normally does preprocessing, compilation,
assembly and linking.  The "overall options" allow you to stop this
process at an intermediate stage.  For example, the `-c' option says
not to run the linker.  Then the output consists of object files output
by the assembler.

   Other options are passed on to one stage of processing.  Some options
control the preprocessor and others the compiler itself.  Yet other
options control the assembler and linker; most of these are not
documented here, since you rarely need to use any of them.

   The `gpc' program accepts options and file names as operands.  Many
options have multiletter names; therefore multiple single-letter options
may *not* be grouped: `-dr' is very different from `-d -r'.

   You can mix options and other arguments.  For the most part, the
order you use doesn't matter.  Order does matter when you use several
options of the same kind; for example, if you specify `-L' more than
once, the directories are searched in the order specified.

   Many options have long names starting with `-f' or with `-W'--for
example, `-fforce-mem', `-fstrength-reduce', `-Wformat' and so on.
Most of these have both positive and negative forms; the negative form
of `-ffoo' would be `-fno-foo'.  This manual documents only one of
these two forms, whichever one is not the default.

* Menu:

* Option Summary::   	   Brief list of all options, without explanations.
* Overall Options::        Controlling the kind of output:
                           an executable, object files, assembler files,
                           or preprocessed source.
* Pascal Dialect Options:: Controlling the variant of Pascal language compiled.
* Code Gen Options::       Specifying conventions for function calls, data
                           layout and register usage.
* Warning Options::        How picky should the compiler be?
* Debugging Options::      Symbol tables, measurements, and debugging dumps.
* Optimize Options::       How much optimization?
* Preprocessor Options::   Controlling header files and macro definitions.
                           Also, getting dependency information for Make.
* Assembler Options::      Passing options to the assembler.
* Link Options::           Specifying libraries and so on.
* Directory Options::      Where to find header files and libraries.
                           Where to find the compiler executable files.
* Target Options::         Running a cross-compiler, or an old version
                           of GNU Pascal.
* Submodel Options::       Specifying minor hardware or convention variations,
                           such as 68010 vs 68020.
* Environment Variables::  Env vars that affect GNU Pascal.


File: gpc.info,  Node: Option Summary,  Next: Overall Options,  Up: Invoking GPC

Option Summary
==============

   Here is a summary of all the options, grouped by type.  Explanations
are in the following sections.

*Overall Options*
     *Note Options Controlling the Kind of Output: Overall Options.
          -c  --automake  -S  -E  -o FILE  -pipe  -v  -x LANGUAGE

*Pascal Language Options*
     *Note Options Controlling Pascal Dialect: Pascal Dialect Options.
          --nested-comments --char-escapes --c-numbers --borland-char-constants
          --standard-pascal --extended-pascal --object-pascal --borland-pascal
          --pascal-sc --extended-syntax

*Code Generation Options*
     *Note Options for Code Generation Conventions: Code Gen Options.
          --short-circuit --lazy-io --setlimit --gpc-main
          --call-saved-REG  --call-used-REG
          --fixed-REG  --inhibit-size-directive
          --no-common  --no-ident  --no-gnu-linker
          --pcc-struct-return  --pic  --PIC
          --reg-struct-return  --shared-data  --short-enums
          --short-double  --volatile  --volatile-global
          --verbose-asm --pack-struct

*Warning Options*
     *Note Options to Request or Suppress Warnings: Warning Options.
          --syntax-only  --pedantic  --pedantic-errors
          -w  -W  -Wall  -Waggregate-return  -Wbad-function-cast
          -Wcast-align -Wcast-qual  -Wchar-subscript  -Wcomment
          -Wconversion -Wenum-clash  -Werror  -Wformat
          -Wid-clash-LEN  -Wimplicit  -Wimport  -Winline
          -Wlarger-than-LEN  -Wmissing-declarations
          -Wmissing-prototypes  -Wnested-externs
          -Wno-import  -Woverloaded-virtual -Wparentheses
          -Wpointer-arith  -Wredundant-decls -Wreorder -Wreturn-type -Wshadow
          -Wstrict-prototypes  -Wswitch  -Wsynth  -Wtemplate-debugging
          -Wtraditional  -Wtrigraphs -Wuninitialized  -Wunused
          -Wwrite-strings

*Debugging Options*
     *Note Options for Debugging Your Program or GPC: Debugging Options.
          -a  -dLETTERS  -fpretend-float
          -g  -gLEVEL -gcoff  -gdwarf  -gdwarf+
          -ggdb  -gstabs  -gstabs+  -gxcoff  -gxcoff+
          -p  -pg  -print-file-name=LIBRARY  -print-libgcc-file-name
          -print-prog-name=PROGRAM  -print-search-dirs  -save-temps
          --lines  --debug-gpi

*Optimization Options*
     *Note Options that Control Optimization: Optimize Options.
          --caller-saves  --cse-follow-jumps  --cse-skip-blocks
          --delayed-branch   --expensive-optimizations
          --fast-math  --float-store  --force-addr  --force-mem
          --inline-functions  --keep-inline-functions
          --no-default-inline  --no-defer-pop  --no-function-cse
          --no-inline  --no-peephole  --omit-frame-pointer
          --rerun-cse-after-loop  --schedule-insns
          --schedule-insns2  --strength-reduce  --thread-jumps
          --unroll-all-loops  --unroll-loops
          -O  -O0  -O1  -O2  -O3

*Preprocessor Options*
     *Note Options Controlling the Preprocessor: Preprocessor Options.
          -AQUESTION(ANSWER)  -C  -dD  -dM  -dN
          -DMACRO[=DEFN]  -E  -H
          -idirafter DIR
          -include FILE  -imacros FILE
          -iprefix FILE  -iwithprefix DIR
          -iwithprefixbefore DIR  -isystem DIR
          -M  -MD  -MM  -MMD  -MG  -nostdinc  -P  -trigraphs
          -undef  -UMACRO  -Wp,OPTION

*Assembler Option*
     *Note Passing Options to the Assembler: Assembler Options.
          -Wa,OPTION

*Linker Options*
     *Note Options for Linking: Link Options.
          OBJECT-FILE-NAME  -lLIBRARY
          -nostartfiles  -nodefaultlibs  -nostdlib
          -s  -static  -shared  -symbolic
          -Wl,OPTION  -Xlinker OPTION
          -u SYMBOL

*Directory Options*
     *Note Options for Directory Search: Directory Options.
          -BPREFIX  -IDIR  -I-  -LDIR

*Target Options*
     *Note Target Options::.
          -b MACHINE  -V VERSION

*Machine Dependent Options*
     *Note Hardware Models and Configurations: Submodel Options.
          *M680x0 Options*
          -m68000  -m68020  -m68020-40  -m68030  -m68040  -m68881
          -mbitfield  -mc68000  -mc68020  -mfpa  -mnobitfield
          -mrtd  -mshort  -msoft-float
          
          *VAX Options*
          -mg  -mgnu  -munix
          
          *SPARC Options*
          -mapp-regs  -mcypress  -mepilogue  -mflat  -mfpu  -mhard-float
          -mhard-quad-float  -mno-app-regs  -mno-flat  -mno-fpu
          -mno-epilogue  -mno-unaligned-doubles
          -msoft-float  -msoft-quad-float
          -msparclite  -msupersparc  -munaligned-doubles  -mv8
          
          SPARC V9 compilers support the following options
          in addition to the above:
          
          -mmedlow  -mmedany
          -mint32  -mint64  -mlong32  -mlong64
          -mno-stack-bias  -mstack-bias
          
          *Convex Options*
          -mc1  -mc2  -mc32  -mc34  -mc38
          -margcount  -mnoargcount
          -mlong32  -mlong64
          -mvolatile-cache  -mvolatile-nocache
          
          *AMD29K Options*
          -m29000  -m29050  -mbw  -mnbw  -mdw  -mndw
          -mlarge  -mnormal  -msmall
          -mkernel-registers  -mno-reuse-arg-regs
          -mno-stack-check  -mno-storem-bug
          -mreuse-arg-regs  -msoft-float  -mstack-check
          -mstorem-bug  -muser-registers
          
          *ARM Options*
          -mapcs -m2 -m3 -m6 -mbsd -mxopen -mno-symrename
          
          *M88K Options*
          -m88000  -m88100  -m88110  -mbig-pic
          -mcheck-zero-division  -mhandle-large-shift
          -midentify-revision  -mno-check-zero-division
          -mno-ocs-debug-info  -mno-ocs-frame-position
          -mno-optimize-arg-area  -mno-serialize-volatile
          -mno-underscores  -mocs-debug-info
          -mocs-frame-position  -moptimize-arg-area
          -mserialize-volatile  -mshort-data-NUM  -msvr3
          -msvr4  -mtrap-large-shift  -muse-div-instruction
          -mversion-03.00  -mwarn-passed-structs
          
          *RS/6000 and PowerPC Options*
          -mcpu=CPU  TYPE
          -mpower  -mno-power  -mpower2  -mno-power2
          -mpowerpc  -mno-powerpc
          -mpowerpc-gpopt  -mno-powerpc-gpopt
          -mpowerpc-gfxopt  -mno-powerpc-gfxopt
          -mnew-mnemonics  -mno-new-mnemonics
          -mfull-toc   -mminimal-toc  -mno-fop-in-toc  -mno-sum-in-toc
          -msoft-float  -mhard-float -mmultiple -mno-multiple
          -mstring -mno-string -mbit-align -mno-bit-align
          -mstrict-align -mno-strict-align -mrelocatable -mno-relocatable
          -mtoc -mno-toc -mtraceback -mno-traceback
          -mlittle -mlittle-endian -mbig -mbig-endian
          -mcall-aix -mcall-sysv -mprototype
          
          *RT Options*
          -mcall-lib-mul  -mfp-arg-in-fpregs  -mfp-arg-in-gregs
          -mfull-fp-blocks  -mhc-struct-return  -min-line-mul
          -mminimum-fp-blocks  -mnohc-struct-return
          
          *MIPS Options*
          -mabicalls  -mcpu=CPU  TYPE  -membedded-data
          -membedded-pic  -mfp32  -mfp64  -mgas  -mgp32  -mgp64
          -mgpopt  -mhalf-pic  -mhard-float  -mint64 -mips1
          -mips2 -mips3  -mlong64  -mlong-calls  -mmemcpy
          -mmips-as  -mmips-tfile  -mno-abicalls
          -mno-embedded-data  -mno-embedded-pic
          -mno-gpopt  -mno-long-calls
          -mno-memcpy  -mno-mips-tfile  -mno-rnames  -mno-stats
          -mrnames -msoft-float
          -m4650 -msingle-float -mmad
          -mstats  -EL  -EB  -G NUM  -nocpp
          
          *i386 Options*
          -m486  -m386 -mieee-fp  -mno-fancy-math-387
          -mno-fp-ret-in-387  -msoft-float  -msvr3-shlib
          -mno-wide-multiply -mrtd -malign-double
          -mreg-alloc=LIST -mregparm=NUM
          -malign-jumps=NUM -malign-loops=NUM
          -malign-functions=NUM
          
          *HPPA Options*
          -mdisable-fpregs  -mdisable-indexing  -mfast-indirect-calls
          -mgas  -mjump-in-delay -mlong-millicode-calls -mno-disable-fpregs
          -mno-disable-indexing -mno-fast-indirect-calls -mno-gas
          -mno-jump-in-delay -mno-millicode-long-calls
          -mno-portable-runtime -mno-soft-float -msoft-float
          -mpa-risc-1-0  -mpa-risc-1-1  -mportable-runtime -mschedule=LIST
          
          *Intel 960 Options*
          -mCPU TYPE  -masm-compat  -mclean-linkage
          -mcode-align  -mcomplex-addr  -mleaf-procedures
          -mic-compat  -mic2.0-compat  -mic3.0-compat
          -mintel-asm  -mno-clean-linkage  -mno-code-align
          -mno-complex-addr  -mno-leaf-procedures
          -mno-old-align  -mno-strict-align  -mno-tail-call
          -mnumerics  -mold-align  -msoft-float  -mstrict-align
          -mtail-call
          
          *DEC Alpha Options*
          -mfp-regs  -mno-fp-regs  -mno-soft-float
          -msoft-float
          
          *Clipper Options*
          -mc300 -mc400
          
          *H8/300 Options*
          -mrelax  -mh
          
          *System V Options*
          -Qy  -Qn  -YP,PATHS  -Ym,DIR

* Menu:

* Overall Options::        Controlling the kind of output:
                           an executable, object files, assembler files,
                           or preprocessed source.
* Pascal Dialect Options:: Controlling the variant of Pascal language compiled.
* Code Gen Options::       Specifying conventions for function calls, data
                           layout and register usage.
* Warning Options::        How picky should the compiler be?
* Debugging Options::      Symbol tables, measurements, and debugging dumps.
* Optimize Options::       How much optimization?
* Preprocessor Options::   Controlling header files and macro definitions.
                           Also, getting dependency information for Make.
* Assembler Options::      Passing options to the assembler.
* Link Options::           Specifying libraries and so on.
* Directory Options::      Where to find header files and libraries.
                           Where to find the compiler executable files.
* Target Options::         Running a cross-compiler, or an old version
                           of GNU Pascal.
* Submodel Options::       Specifying minor hardware or convention variations,
                           such as 68010 vs 68020.
* Environment Variables::  Env vars that affect GNU Pascal.


File: gpc.info,  Node: Overall Options,  Next: Pascal Dialect Options,  Prev: Option Summary,  Up: Invoking GPC

Options Controlling the Kind of Output
======================================

   Compilation can involve up to four stages: preprocessing, compilation
proper, assembly and linking, always in that order.  The first three
stages apply to an individual source file, and end by producing an
object file; linking combines all the object files (those newly
compiled, and those specified as input) into an executable file.

   For any given input file, the file name suffix determines what kind
of compilation is done:

`FILE.p'
`FILE.pas'
     Pascal source code which must be preprocessed.

`FILE.i'
     Pascal source code which should not be preprocessed.

`FILE.h'
     Pascal header file (not to be compiled or linked).

`FILE.s'
     Assembler code.

`FILE.S'
     Assembler code which must be preprocessed.

`OTHER'
     An object file to be fed straight into linking.  Any file name
     with no recognized suffix is treated this way.

   You can specify the input language explicitly with the `-x' option:

`-x LANGUAGE'
     Specify explicitly the LANGUAGE for the following input files
     (rather than letting the compiler choose a default based on the
     file name suffix).  This option applies to all following input
     files until the next `-x' option.  Possible values for LANGUAGE
     are:
          pascal   c  objective-c  c++
          c-header  cpp-output  c++-cpp-output
          assembler  assembler-with-cpp

`-x none'
     Turn off any specification of a language, so that subsequent files
     are handled according to their file name suffixes (as they are if
     `-x' has not been used at all).

   If you only want some of the stages of compilation, you can use `-x'
(or filename suffixes) to tell `gcc' where to start, and one of the
options `-c', `-S', or `-E' to say where `gpc' is to stop.  Note that
some combinations (for example, `-x cpp-output -E' instruct `gpc' to do
nothing at all.

`-c'
     Compile or assemble the source files, but do not link.  The linking
     stage simply is not done.  The ultimate output is in the form of an
     object file for each source file.

     By default, the object file name for a source file is made by
     replacing the suffix `.p', `.pas', `.i', `.s', etc., with `.o'.

     Unrecognized input files, not requiring compilation or assembly,
     are ignored.

`--automake'
     Check whether Modules/Units used by the main program must be
     recompiled and do the recompilation.  For example, if the program
     `mainprog.pas' uses the Modules `module1.pas' and `module2.pas',
     the modules are automatically compiled if necessary when you
     specify
            gpc --automake mainprog.pas

     Options to be passed to "child" compilations must be given
     explicitely as a "String" argument to -automake, for example:
            gpc -O --automake mainprog.pas

     (For an explanation of the -O option, see *Note Optimize
     Options::.)

     *WARNING:* The AutoMake mechanism is a new feature in version 2.0
     and may be unstable.

`-S'
     Stop after the stage of compilation proper; do not assemble.  The
     output is in the form of an assembler code file for each
     non-assembler input file specified.

     By default, the assembler file name for a source file is made by
     replacing the suffix `.p', `.pas', `.i', etc., with `.s'.

     Input files that don't require compilation are ignored.

`-E'
     Stop after the preprocessing stage; do not run the compiler
     proper.  The output is in the form of preprocessed source code,
     which is sent to the standard output.

     Input files which don't require preprocessing are ignored.

`-o FILE'
     Place output in file FILE.  This applies regardless to whatever
     sort of output is being produced, whether it be an executable file,
     an object file, an assembler file or preprocessed C code.

     Since only one output file can be specified, it does not make
     sense to use `-o' when compiling more than one input file, unless
     you are producing an executable file as output.

     If `-o' is not specified, the default is to put an executable file
     in `a.out', the object file for `SOURCE.SUFFIX' in `SOURCE.o', its
     assembler file in `SOURCE.s', and all preprocessed C source on
     standard output.

`-v'
     Print (on standard error output) the commands executed to run the
     stages of compilation.  Also print the version number of the
     compiler driver program and of the preprocessor and the compiler
     proper.

`-pipe'
     Use pipes rather than temporary files for communication between the
     various stages of compilation.  This fails to work on some systems
     where the assembler is unable to read from a pipe; but the GNU
     assembler has no trouble.


File: gpc.info,  Node: Pascal Dialect Options,  Next: Code Gen Options,  Prev: Overall Options,  Up: Invoking GPC

Options Controlling Pascal Dialect
==================================

   GNU Pascal tries to support several different Pascal dialects.  Some
features of some dialects contradict each other, some other "features"
we do not consider to be a good idea.  To achive compatibility to all
dialects (in as much as currently implemented), a number of options is
provided.

`--standard-pascal-level-0'
`--standard-pascal'
`--extended-pascal'
`--object-pascal'
`--borland-pascal'
`--pascal-sc'
     These switches tell `gpc' to comply to the specified standard.
     Keywords coming from other dialects are not recognized and can be
     redefined without warning.  The use of other extensions triggers a
     warning; other warnings about constructs which would be legal in
     the specified dialect (e.g. assignment to a Borland-style "typed
     constant") are suppressed.

     By default, GNU Pascal allows redefinition of keywords.  Each of
     this switches causes GNU Pascal to forbid the redefinition of
     keywords of the specified standard.

     Valid ISO Standard Pascal programs should compile properly with or
     without `--standard-pascal'.  However, without this option,
     certain GNU extensions and Pascal features from other dialects are
     supported as well.  With this option, they are rejected.

     This options are not intended to be useful; they exist only to
     satisfy pedants who would otherwise claim that GNU Pascal fails to
     support the ISO Standard or is not really compatible to Borland
     Pascal, or whatever.  We recommend, rather, that users take
     advantage of the extensions of GNU Pascal and disregard the
     limitations of other compilers.

`--extended-syntax  (*$X+*)'
     Enables "dangerous" features of GNU Pascal such as
        * function return value ignore (works always, but gives warning
          without         this option),

        * pointer arithmetics,

        * declaring statements (gives warning otherwise; see *Note
          Var::),

        * use of `CString's as strings (see *Note CString::).

     The compiler switch `$X+' is equivalent to `--extended-syntax' and
     allows local specifications.

     *A cross reference to compiler switches is in preparation.*

`--no-nested-comments  (*$N-*)'
     By default (unless full ISO compliance has been requested), GPC
     allows nested comments (* like this one { see? } *) in your Pascal
     source which contradicts ISO standard.  To allow comments starting
     with `{' and ending with `*)', specify this option.

`--char-escapes  (*$E+*)'
     Enable C-style character escape sequences in strings.

`--c-numbers  (*$C+*)'
     Enable C-style octal and hexadecimal numbers: The decimal number
     255 is equal to the hexadecimal number `16#FF' (Extended Pascal
     notation) or `$FF' (Borland Pascal notation) or `0xFF' (C
     notation--works only with this switch active) or the octal number
     `0177' (C notation--ditto).

`--borland-char-constants'
     Enable Borland-style `#42' character constants.  The default is
     "on" unless full ISO compliance has been selected using
     `--standard-pascal', `--extended-pascal', or `--object-pascal'.
     For those cases the default is "off".


File: gpc.info,  Node: Code Gen Options,  Next: Warning Options,  Prev: Pascal Dialect Options,  Up: Invoking GPC

Options for Code Generation Conventions
=======================================

   These machine-independent options control the interface conventions
used in code generation.

   Most of them have both positive and negative forms; the negative form
of `-ffoo' would be `-fno-foo'.  In the table below, only one of the
forms is listed--the one which is not the default.  You can figure out
the other form by either removing `no-' or adding it.

`--short-circuit  (*$B-*)'
     Use short circuit evaluation of Boolean expressions.  Otherwise,
     Boolean expressions are evaluated completely even if the result is
     kwown already.  The default is "on" unless full ISO compliance has
     been requested using `--standard-pascal', `--extended-pascal', or
     `--object-pascal'.  For those cases the default is "off".

`--lazy-io  (*$L+*)'
     Enable "lazy I/O", i.e. do a `put' as soon as you can and do `get'
     as late as you can.

`--setlimit:NUMBER'
     Define the maximum number of elements a set can hold to be NUMBER.

`--gpc-main:NAME'
     Name the entry point of the main program "NAME" instead of `main'.
     This is useful when working with some C libraries which define
     their own `main' function and require the program's "main" to be
     named differently.

`--pcc-struct-return'
     Return "short" `Record' values in memory like longer ones, rather
     than in registers.  This convention is less efficient, but it has
     the advantage of allowing intercallability between GNU
     Pascal-compiled files and files compiled with other compilers.

     The precise convention for returning records in memory depends on
     the target configuration macros.

     Short records are those whose size and alignment match that of some
     integer type.

`--reg-struct-return'
     Use the convention that `Record' values are returned in registers
     when possible.  This is more efficient for small records than
     `--pcc-struct-return'.

     If you specify neither `--pcc-struct-return' nor its contrary
     `--reg-struct-return', GNU Pascal defaults to whichever convention
     is standard for the target.  If there is no standard convention,
     GNU Pascal defaults to `--pcc-struct-return', except on targets
     where GNU Pascal is the principal compiler.  In those cases, we
     can choose the standard, and we chose the more efficient register
     return alternative.

`--short-enums'
     Allocate to enumeral types only as many bytes as it needs for the
     declared range of possible values.

`--short-double'
     Use a smaller size for `Real'.

`--shared-data'
     Requests that the data and non-`const' variables of this
     compilation be shared data rather than private data.  The
     distinction makes sense only on certain operating systems, where
     shared data is shared between processes running the same program,
     while private data exists in one copy per process.

`--no-common'
     Allocate even uninitialized global variables in the bss section of
     the object file, rather than generating them as common blocks.
     This has the effect that if the same variable is declared (without
     `external') in two different compilations, you will get an error
     when you link them.  The only reason this might be useful is if
     you wish to verify that the program will work on other systems
     which always work this way.

`--no-ident'
     Ignore the `#ident' directive.

`--no-gnu-linker'
     Do not output global initializations (such as C++ constructors and
     destructors) in the form used by the GNU linker (on systems where
     the GNU linker is the standard method of handling them).  Use this
     option when you want to use a non-GNU linker, which also requires
     using the `collect2' program to make sure the system linker
     includes constructors and destructors.  (`collect2' is included in
     the GNU GCC distribution.)  For systems which *must* use
     `collect2', the compiler driver `gpc' is configured to do this
     automatically.

`--inhibit-size-directive'
     Don't output a `.size' assembler directive, or anything else that
     would cause trouble if the function is split in the middle, and the
     two halves are placed at locations far apart in memory.  This
     option is used when compiling `crtstuff.c'; you should not need to
     use it for anything else.

`--verbose-asm'
     Put extra commentary information in the generated assembly code to
     make it more readable.  This option is generally only of use to
     those who actually need to read the generated assembly code
     (perhaps while debugging the compiler itself).

`--volatile'
     Consider all memory references through pointers to be volatile.

`--volatile-global'
     Consider all memory references to external and global data items to
     be volatile.

`--pic'
     Generate position-independent code (PIC) suitable for use in a
     shared library, if supported for the target machine.  Such code
     accesses all constant addresses through a global offset table
     (GOT).  If the GOT size for the linked executable exceeds a
     machine-specific maximum size, you get an error message from the
     linker indicating that `--pic' does not work; in that case,
     recompile with `--PIC' instead.  (These maximums are 16k on the
     m88k, 8k on the Sparc, and 32k on the m68k and RS/6000.  The 386
     has no such limit.)

     Position-independent code requires special support, and therefore
     works only on certain machines.  For the 386, GNU Pascal supports
     PIC for System V but not for the Sun 386i.  Code generated for the
     IBM RS/6000 is always position-independent.

     The GNU assembler does not fully support PIC.  Currently, you must
     use some other assembler in order for PIC to work.  We would
     welcome volunteers to upgrade GAS to handle this; the first part
     of the job is to figure out what the assembler must do differently.

`--PIC'
     If supported for the target machine, emit position-independent
     code, suitable for dynamic linking and avoiding any limit on the
     size of the global offset table.  This option makes a difference
     on the m68k, m88k and the Sparc.

     Position-independent code requires special support, and therefore
     works only on certain machines.

`--fixed-REG'
     Treat the register named REG as a fixed register; generated code
     should never refer to it (except perhaps as a stack pointer, frame
     pointer or in some other fixed role).

     REG must be the name of a register.  The register names accepted
     are machine-specific and are defined in the `REGISTER_NAMES' macro
     in the machine description macro file.

     This flag does not have a negative form, because it specifies a
     three-way choice.

`--call-used-REG'
     Treat the register named REG as an allocatable register that is
     clobbered by function calls.  It may be allocated for temporaries
     or variables that do not live across a call.  Functions compiled
     this way will not save and restore the register REG.

     Use of this flag for a register that has a fixed pervasive role in
     the machine's execution model, such as the stack pointer or frame
     pointer, will produce disastrous results.

     This flag does not have a negative form, because it specifies a
     three-way choice.

`--call-saved-REG'
     Treat the register named REG as an allocatable register saved by
     functions.  It may be allocated even for temporaries or variables
     that live across a call.  Functions compiled this way will save
     and restore the register REG if they use it.

     Use of this flag for a register that has a fixed pervasive role in
     the machine's execution model, such as the stack pointer or frame
     pointer, will produce disastrous results.

     A different sort of disaster will result from the use of this flag
     for a register in which function values may be returned.

     This flag does not have a negative form, because it specifies a
     three-way choice.

`--pack-struct'
     Pack all structure members together without holes.  Usually you
     would not want to use this option, since it makes the code
     suboptimal, and the offsets of structure members won't agree with
     system libraries.


File: gpc.info,  Node: Warning Options,  Next: Debugging Options,  Prev: Code Gen Options,  Up: Invoking GPC

Options to Request or Suppress Warnings
=======================================

   Warnings are diagnostic messages that report constructions which are
not inherently erroneous but which are risky or suggest there may have
been an error.

   You can request many specific warnings with options beginning `-W',
for example `-Wimplicit' to request warnings on implicit declarations.
Each of these specific warning options also has a negative form
beginning `-Wno-' to turn off warnings; for example, `-Wno-implicit'.
This manual lists only one of the two forms, whichever is not the
default.

   These options control the amount and kinds of warnings produced by
GNU Pascal:

   *GPC note: theses are all in toplev.c, but not all of them apply.*

`-fsyntax-only'
     Check the code for syntax errors, but don't do anything beyond
     that.

`-pedantic'
     Warn about everything which is known to be rejected in some Pascal
     dialect, for example redefinition of keywords of other dialects.

`-pedantic-errors'
     Produce errors rather than warnings for portability violations.
     Unlike in C, this does *not* imply the `-pedantic' option, so you
     can, for instance, use `-pedantic-errors' without `-pedantic', but
     with `--extended-pascal'.

`-w'
     Inhibit all warning messages.

`-Wno-import'
     Inhibit warning messages about the use of `#import'.

`-Wchar-subscripts'
     Warn if an array subscript has type `char'.  This is a common cause
     of error, as programmers often forget that this type is signed on
     some machines.

`-Wcomment'
     Warn whenever a comment-start sequence `/*' appears in a comment.

`-Wformat'
     Check calls to `printf' and `scanf', etc., to make sure that the
     arguments supplied have types appropriate to the format string
     specified.

`-Wimplicit'
     Warn whenever a function or parameter is implicitly declared.

`-Wparentheses'
     Warn if parentheses are omitted in certain contexts, such as when
     there is an assignment in a context where a truth value is
     expected, or when operators are nested whose precedence people
     often get confused about.

`-Wreturn-type'
     Warn whenever a function is defined with a return-type that
     defaults to `int'.  Also warn about any `return' statement with no
     return-value in a function whose return-type is not `void'.

`-Wswitch'
     Warn whenever a `switch' statement has an index of enumeral type
     and lacks a `case' for one or more of the named codes of that
     enumeration.  (The presence of a `default' label prevents this
     warning.)  `case' labels outside the enumeration range also
     provoke warnings when this option is used.

`-Wtrigraphs'
     Warn if any trigraphs are encountered (assuming they are enabled).

`-Wunused'
     Warn whenever a variable is unused aside from its declaration,
     whenever a function is declared static but never defined, whenever
     a label is declared but not used, and whenever a statement
     computes a result that is explicitly not used.

     To suppress this warning for an expression, simply cast it to
     void.  For unused variables and parameters, use the `unused'
     attribute.

`-Wuninitialized'
     An automatic variable is used without first being initialized.

     These warnings are possible only in optimizing compilation,
     because they require data flow information that is computed only
     when optimizing.  If you don't specify `-O', you simply won't get
     these warnings.

     These warnings occur only for variables that are candidates for
     register allocation.  Therefore, they do not occur for a variable
     that is declared `volatile', or whose address is taken, or whose
     size is other than 1, 2, 4 or 8 bytes.  Also, they do not occur for
     records or arrays, even when they are in registers.

     Note that there may be no warning about a variable that is used
     only to compute a value that itself is never used, because such
     computations may be deleted by data flow analysis before the
     warnings are printed.

     These warnings are made optional because GNU Pascal is not smart
     enough to see all the reasons why the code might be correct
     despite appearing to have an error.  Here is one example of how
     this can happen:

            Var
              x, y: Integer;
          
            ...
          
            case y of
              1: x:= 1;
              2: x:= 4;
              3: x:= 5;
            end (* case *);
            foo ( x );

     If the value of `y' is always 1, 2 or 3, then `x' is always
     initialized, but GNU Pascal doesn't know this.  Here is another
     common case:

            Var
              change_y: Boolean;
              y, new_y, save_y: Integer;
          
            ...
          
            if change_y then
              begin
                save_y:= y;
                y = new_y;
              end (* if *)
          
            ...
          
            if change_y then
              y:= save_y;

     This has no bug because `save_y' is used only if it is set.

     Some spurious warnings can be avoided if you declare all the
     functions you use that never return as `noreturn'.

`-Wall'
     All of the above `-W' options combined.  These are all the options
     which pertain to usage that we recommend avoiding and that we
     believe is easy to avoid, even in conjunction with macros.

   The remaining `-W...' options are not implied by `-Wall' because
they warn about constructions that we consider reasonable to use, on
occasion, in clean programs.

`-W'
     Print extra warning messages for these events:

        * A nonvolatile automatic variable might be changed by a call to
          `longjmp'.  These warnings as well are possible only in
          optimizing compilation.

          The compiler sees only the calls to `setjmp'.  It cannot know
          where `longjmp' will be called; in fact, a signal handler
          could call it at any point in the code.  As a result, you may
          get a warning even when there is in fact no problem because
          `longjmp' cannot in fact be called at the place which would
          cause a problem.

        * A function can return either with or without a value.
          (Falling off the end of the function body is considered
          returning without a value.)  For example, this function would
          evoke such a warning:

               foo (a)
               {
                 if (a > 0)
                   return a;
               }

        * An expression-statement or the left-hand side of a comma
          expression contains no side effects.  To suppress the
          warning, cast the unused expression to void.  For example, an
          expression such as `x[i,j]' will cause a warning, but
          `x[(void)i,j]' will not.

        * An unsigned value is compared against zero with `<' or `<='.

        * A comparison like `x<=y<=z' appears; this is equivalent to
          `(x<=y ? 1 : 0) <= z', which is a different interpretation
          from that of ordinary mathematical notation.

        * Storage-class specifiers like `static' are not the first
          things in a declaration.  According to the C Standard, this
          usage is obsolescent.

        * If `-Wall' or `-Wunused' is also specified, warn about unused
          arguments.

        * An aggregate has a partly bracketed initializer.  For
          example, the following code would evoke such a warning,
          because braces are missing around the initializer for `x.h':

               struct s { int f, g; };
               struct t { struct s h; int i; };
               struct t x = { 1, 2, 3 };

`-Wtraditional'
     Warn about certain constructs that behave differently in
     traditional and ANSI C.

        * Macro arguments occurring within string constants in the
          macro body.  These would substitute the argument in
          traditional C, but are part of the constant in ANSI C.

        * A function declared external in one block and then used after
          the end of the block.

        * A `switch' statement has an operand of type `long'.

`-Wshadow'
     Warn whenever a local variable shadows another local variable.

`-Wid-clash-LEN'
     Warn whenever two distinct identifiers match in the first LEN
     characters.  This may help you prepare a program that will compile
     with certain obsolete, brain-damaged compilers.

`-Wlarger-than-LEN'
     Warn whenever an object of larger than LEN bytes is defined.

`-Wpointer-arith'
     Warn about anything that depends on the "size of" a function type
     or of `void'.  GNU C assigns these types a size of 1, for
     convenience in calculations with `void *' pointers and pointers to
     functions.

`-Wbad-function-cast'
     Warn whenever a function call is cast to a non-matching type.  For
     example, warn if `int malloc()' is cast to `anything *'.

`-Wcast-qual'
     Warn whenever a pointer is cast so as to remove a type qualifier
     from the target type.  For example, warn if a `const char *' is
     cast to an ordinary `char *'.

`-Wcast-align'
     Warn whenever a pointer is cast such that the required alignment
     of the target is increased.  For example, warn if a `char *' is
     cast to an `int *' on machines where integers can only be accessed
     at two- or four-byte boundaries.

`-Wwrite-strings'
     Give string constants the type `const char[LENGTH]' so that
     copying the address of one into a non-`const' `char *' pointer
     will get a warning.  These warnings will help you find at compile
     time code that can try to write into a string constant, but only
     if you have been very careful about using `const' in declarations
     and prototypes.  Otherwise, it will just be a nuisance; this is
     why we did not make `-Wall' request these warnings.

`-Wconversion'
     Warn if a prototype causes a type conversion that is different
     from what would happen to the same argument in the absence of a
     prototype.  This includes conversions of fixed point to floating
     and vice versa, and conversions changing the width or signedness
     of a fixed point argument except when the same as the default
     promotion.

     Also, warn if a negative integer constant expression is implicitly
     converted to an unsigned type.  For example, warn about the
     assignment `x = -1' if `x' is unsigned.  But do not warn about
     explicit casts like `(unsigned) -1'.

`-Waggregate-return'
     Warn if any functions that return arrays or records are defined or
     called.

`-Wstrict-prototypes'
     Warn if a function is declared or defined without specifying the
     argument types.  (An old-style function definition is permitted
     without a warning if preceded by a declaration which specifies the
     argument types.)

`-Wmissing-prototypes'
     Warn if a global function is defined without a previous prototype
     declaration.  This warning is issued even if the definition itself
     provides a prototype.  The aim is to detect global functions that
     fail to be declared in header files.

`-Wmissing-declarations'
     Warn if a global function is defined without a previous
     declaration.  Do so even if the definition itself provides a
     prototype.  Use this option to detect global functions that are
     not declared in header files.

`-Wredundant-decls'
     Warn if anything is declared more than once in the same scope,
     even in cases where multiple declaration is valid and changes
     nothing.

`-Wnested-externs'
     Warn if an `extern' declaration is encountered within an function.

`-Winline'
     Warn if a function cannot be inlined, and either it was declared
     as inline, or else the `-finline-functions' option was given.

`-Woverloaded-virtual'
     Warn when a derived class function declaration may be an error in
     defining a virtual function (C++ only).  In a derived class, the
     definitions of virtual functions must match the type signature of a
     virtual function declared in the base class.  With this option, the
     compiler warns when you define a function with the same name as a
     virtual function, but with a type signature that does not match any
     declarations from the base class.

`-Wsynth (C++ only)'
     Warn when g++'s synthesis behavior does not match that of cfront.
     For instance:

          struct A {
            operator int ();
            A& operator = (int);
          };
          
          main ()
          {
            A a,b;
            a = b;
          }

     In this example, g++ will synthesize a default `A& operator =
     (const A&);', while cfront will use the user-defined `operator ='.

`-Werror'
     Make all warnings into errors.

