/*
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Linux/i386 specific include file for crtc.c

This file implements the functions, as described in crtdummy.h, for a
Linux/386 system. Some parts of this code (signal handlers) may be usable
on generic Unix systems, other parts (using I/O registers to play sounds,
and changing the console size) not.

Notes:

- Changing the number of screen columns is not implemented.

- Changing the number of rows requires the programs resizecons, setfont
  and loadunimap to be present in the PATH, and requires root permissions,
  either to the program compiled with CRT or to resizecons.
  (To achieve the latter, once do a "chmod u+s `which resizecons`" as root,
  but only if you really want each user to be allowed to change the console
  size.)

- Using Sound and NoSound requires root permissions to the program compiled
  with CRT. Without root permissions, Sound and NoSound simply do nothing.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <asm/ioctls.h>
#include "crtunix1.h"

int ioperm_flag;

static void crt_special_init ()
{
  crt_special_init1 ();
  ioperm_flag = ioperm (0x42, 2, 1) == 0 && ioperm (0x61, 1, 1) == 0;
}

static void crt_special_done ()
{
}

void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
  if (Lines50)
    system ("resizecons -lines 50 > /dev/null 2>&1 && setfont cp850-8x8; loadunimap");
  else
    system ("resizecons -lines 25 > /dev/null 2>&1; loadunimap");
}

int crt_getshiftstate ()
{
  int state = Shiftstate;
  int arg = 6; /* TIOCLINUX function #6 */
  if (ioctl (fileno (stdin), TIOCLINUX, &arg) == 0)
    {
      if (arg & (1 | 32)) state |= shRightShift;
      if (arg & (1 | 16)) state |= shLeftShift;
      if (arg & 4)        state |= shCtrl;
      if (arg & 8)        state |= shAlt;
      if (arg & 2)        state |= shAltGr;
    }
  return state;
}

/* I use these functions instead of <asm/io.h> so that they can be used
   with or without optimization. */

typedef unsigned char byte;

static byte inb (unsigned short port)
{
  byte result;
  asm ("inb %%dx, %%al" : "=a" (result) : "d" (port));
  return result;
}

static void outb (byte val, unsigned short port)
{
  asm ("outb %%al, %%dx" : : "d" (port), "a" (val));
}

void crt_nosound ()
{
  if (ioperm_flag)
    outb (inb (0x61) & 0xfc, 0x61);
}

void crt_sound (unsigned Hz)
{
  unsigned t;
  byte a,l,h;
  t = 1193181 / Hz;
  if (ioperm_flag)
    {
      if (t >= 0x10000)
        crt_nosound ();
      else
        {
          l = t & 0xff;
          h = (t >> 8) & 0xff;
          a = inb (0x61);
          if ((a & 3) == 0)
            {
              outb (a | 3, 0x61);
              outb (0xb6, 0x43);
            }
          outb (l, 0x42);
          outb (h, 0x42);
        }
    }
}
