/*
 * Copyright (C) 1996, jack
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static char rcsid[]= "$Id: cdmake.c,v 1.2 1996/07/09 18:28:22 jack Exp $";

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>

/* my name */
char *progname = NULL;


/* safety functions */

void fatal (char *format, ...);
void *xmalloc (size_t size);
void *xrealloc (void *p, size_t size);
void xchdir (char *dir);

void
fatal (char *format, ...)
{
  va_list ap;

  va_start (ap, format);
  fprintf (stderr, "%s: ", progname);
  vfprintf (stderr, format, ap);
  va_end (ap);
  fprintf (stderr, "\n");
  exit (EXIT_FAILURE);
}

void *
xmalloc (size_t size)
{
  void *p;

  p = malloc (size);
  if (p == NULL)
    fatal ("Memory allocate error");

  return p;
}

void *
xrealloc (void *p, size_t size)
{
  p = realloc (p, size);
  if (p == NULL)
    fatal ("Memory allocate error");

  return p;
}

void
xchdir (char *dir)
{
  if (chdir (dir) < 0)
    fatal ("Cannot chdir(%s)", dir);
}


void
usage (void)
{
  printf ("usage: %s makearg directry [directry...]\n", progname);
  exit (EXIT_FAILURE);
}

int
main (int argc, char *argv[])
{
  char topdir[PATH_MAX+1];
  char *comline;
  int result;
  int i;

  progname = argv[0];
  if (argc < 3)
    usage ();

  comline = xmalloc (strlen (argv[1]) + PATH_MAX);
  sprintf (comline, "make %s", argv[1]);

  if (getcwd (topdir, PATH_MAX) == NULL)
    fatal ("Cannot getcwd");

  for (i = 2; i < argc; i++)
    {
      printf ("make in %s\n", argv[i]);
      if (chdir (argv[i]) >= 0)
	{
	  result = system (comline);
	  xchdir (topdir);
	  if (result != 0)
	    {
	      free (comline);
	      exit (EXIT_FAILURE);
	    }
	}
      else
	{
	  printf ("%s: ignore...\n", progname);
	}
    }

  xchdir (topdir);
  free (comline);
  return 0;
}
