/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbstowcs.c,v 1.1 1996/06/21 13:25:05 jack Exp $ */

#include <stdlib.h>

size_t
mbstowcs (wchar_t *pwcs, const char *s, size_t n)
{
  size_t wn;
  int len;

  /* Shift-JIS is not state-dependent encoding */
  if (s == 0)
    return (size_t) 0;

  /* special case */
  if (pwcs == 0)
    return (size_t) -1;

#if 0
  /* into initial state */
  (void) mbtowc ((wchar_t *) 0, 0, MB_CUR_MAX);
#endif

  for (wn = 0; wn < n; wn++)
    {
      /* convert to wide character */
      len = mbtowc (pwcs, s, MB_CUR_MAX);
      if (len < 0)
	return (size_t) -1;

      /* EOS ? */
      if (len == 0)
	{
	  *pwcs = (wchar_t) (unsigned char) '\0';
	  return wn;
	}

      /* increase for next address */
      pwcs++;
      s += len;
    }

  return wn;
}
