/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbctype.h,v 1.2 1996/06/14 17:23:24 jack Exp $ */

#ifndef __mbctype_h__
#define __mbctype_h__

#ifdef __cplusplus
extern "C" {
#endif

#define _MB_CALPHA 0x01
#define _MB_CBLANK 0x02
#define _MB_CDIGIT 0x04
#define _MB_CPUNCT 0x08
#define _MB_SINGLE 0x10
#define _MB_PUNCT  0x20
#define _MB_LEAD   0x40
#define _MB_TRAIL  0x80

extern unsigned char *__mbctype;

extern int _ismbbalnum (int c);
extern int _ismbbalpha (int c);
extern int _ismbbgraph (int c);
extern int _ismbbkalnum (int c);
extern int _ismbbkana (int c);
extern int _ismbbkpunct (int c);
extern int _ismbbkprint (int c);
extern int _ismbblead (int c);
extern int _ismbbprint (int c);
extern int _ismbbpunct (int c);
extern int _ismbbtrail (int c);


#define _ismbbalnum(c) (__mbctype[(unsigned char)(c)] & (_MB_CALPHA|_MB_CDIGIT|_MB_SINGLE|_MB_PUNCT))
#define _ismbbalpha(c) (__mbctype[(unsigned char)(c)] & (_MB_CALPHA|_MB_SINGLE|_MB_PUNCT))
#define _ismbbgraph(c) (__mbctype[(unsigned char)(c)] & (_MB_CALPHA|_MB_CDIGIT|_MB_CPUNCT|_MB_SINGLE|_MB_PUNCT))
#define _ismbbkalnum(c) (__mbctype[(unsigned char)(c)] & (_MB_SINGLE))
#define _ismbbkana(c) (__mbctype[(unsigned char)(c)] & (_MB_SINGLE|_MB_PUNCT))
#define _ismbbkpunct(c) (__mbctype[(unsigned char)(c)] & (_MB_PUNCT))
#define _ismbbkprint(c) (__mbctype[(unsigned char)(c)] & (_MB_SINGLE|_MB_PUNCT))
#define _ismbblead(c) (__mbctype[(unsigned char)(c)] & (_MB_LEAD))
#define _ismbbprint(c) (__mbctype[(unsigned char)(c)] & (_MB_CALPHA|_MB_CBLANK|_MB_CDIGIT|_MB_CPUNCT|_MB_SINGLE|_MB_PUNCT))
#define _ismbbpunct(c) (__mbctype[(unsigned char)(c)] & (_MB_CPUNCT|_MB_PUNCT))
#define _ismbbtrail(c) (__mbctype[(unsigned char)(c)] & (_MB_TRAIL))

#ifdef __cplusplus
}
#endif

#endif /* !__mbctype_h__ */
