// Associated include file : Graphics/Box.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// ----- TGroupBox

DEFINE(TGroupBox);

short RegTGroupBox;
char *IdentTGroupBox = "TGroupBox";

// Constructors

TGroupBox::TGroupBox()
{ Defaults();
}

TGroupBox::TGroupBox(int X, int Y, int L, int H, char *_Text)
{ Defaults();
  Init(X,Y,L,H,_Text);
}

TGroupBox::TGroupBox(TRect R, char *_Text)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Text);
}

void TGroupBox::Defaults(void)
{ // Object Identification
  Register=RegTGroupBox;
  Ident=IdentTGroupBox;
  // Other default values
  Value=0;
  SetOptions(opSelectable | opGetAllEvents);
  Text=NULL;
}

void TGroupBox::Init(int X, int Y, int L, int H, char *_Text)
{ // Herited constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  if (_Text!=NULL)
  { Text=(char*)malloc(strlen(_Text)+3);
    sprintf(Text," %s ",_Text);
  }
}

void TGroupBox::Done(void)
{ // Herited destructions
  TZone::Done();
  // Other destructions
  if (Text!=NULL) free(Text);
}

// Graphics

void TGroupBox::Draw(TRect )
{ int L=Where.Width();
  int H=Where.Height();
  //
  if (L+H==0) return;
  //
  SetSysColor(FaceGray);
    Bar(0,0,L-1,5);
    Bar(2,8,L-3,H-3);
  SetSysColor(DarkGray);
    LineX(0,6,L-1);
    LineY(0,7,H-1);
    LineX(2,H-2,L-2);
    LineY(L-2,8,H-3);
  SetSysColor(LightGray);
    LineX(1,7,L-1);
    LineY(1,8,H-1);
    LineX(2,H-1,L-1);
    LineY(L-1,8,H-2);
  if (Text!=NULL)
  { SetSysColor(Black);
    FontSystem->BackColor(NoSysColor[FaceGray]);
    PutStr(10,0,Text,FontSystem);
    FontSystem->BackColor(NoColor);
  }
}

// Data exchange

long TGroupBox::DataSize()
{ return TZone::DataSize()+sizeof(int);
}

void TGroupBox::SetData(void *Rec)
{ TZone::SetData(Rec);
  Value=*((int*)Rec);
  Invalidate();
}

void TGroupBox::GetData(void *Rec)
{ TZone::SetData(Rec);
  *((int*)Rec)=Value;
}

// Objects streams

void TGroupBox::Read(TDisk *file)
{ TZone::Read(file);
  if (Text!=NULL) free(Text);
  ReadString(file,&Text);
}

void TGroupBox::Write(TDisk *file)
{ TZone::Write(file);
  WriteString(file,Text);
}

// ----- TItemBox

DEFINE(TItemBox);

DEFINE_EVENTS_TABLE(TItemBox,TButton)
  KEYDOWN()
END_EVENTS_TABLE;

short RegTItemBox;
char *IdentTItemBox = "TItemBox";

TItemBox::TItemBox()
{ Defaults();
}


TItemBox::TItemBox(int X, int Y, int L, int _Options, char *_Text)
{ Defaults();
  Init(X,Y,L,_Options,_Text);
}

TItemBox::TItemBox(TRect R, int _Options, char *_Text)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),_Options,_Text);
}

void TItemBox::Defaults(void)
{ // Object Identification
  Register=RegTItemBox;
  Ident=IdentTItemBox;
  // Other default values
  Text=NULL;
}

void TItemBox::Init(int X, int Y, int L, int _Options, char *_Text)
{ // Herited creations
  TButton::Init(X,Y,L,16,0,0,_Options);
  // New creations
  if (_Text!=NULL)
  { // Truncate the text to the space allowed
    Text=strdup(_Text);
    FontSystem->TruncSysStr(Where.Width()-20,_Text,Text);
    // Search for a HotKey
    char *P=strchr(Text,'&');
    if (P!=NULL) ScanCode=(int)(*(P+1));
  }
  RectChanging=TRect(0,0,15,15);
}

void TItemBox::Done(void)
{ // Herited destructions
  TButton::Done();
  // New destructions
  if (Text!=NULL) free(Text);
}

// Events

boolean TItemBox::KeyDown(int SC, int Toggle)
{ switch(SC)
  { case ScanTab      :
    case ScanShiftTab :
      return FALSE;
  }
  if (TButton::KeyDown(SC,Toggle)) return TRUE;
  switch(SC)
  { case ScanUpArrow   :
      SelectPrevious();
      return TRUE;
    case ScanDownArrow :
      SelectNext();
      return TRUE;
    case (int)' ' :
      KeyboardAction();
      return TRUE;
  }
  return FALSE;
}

// Graphics

void TItemBox::DrawSelect(int )
{ SetSysColor(DarkGray);
  Rectangle(18,0,Where.Width()-1,Where.Height()-1);
}

void TItemBox::Draw(TRect )
{ int D,L;
  SetSysColor(FaceGray);
  Bar(0,0,Where.Width(),Where.Height());
  L=Where.Width();
  Where.X2()=Where.X1()+15;
  D=DrawFrame();
  Where.X2()=Where.X1()+L-1;
  if (GetStatus(sfDisabled)) FontSystem->Grayed(TRUE);
  else SetSysColor(Black);
  if (Text!=NULL) PutSysStr(20,1,Text,FontSystem);
  FontSystem->Grayed(FALSE);
  DrawInside(D);
  if (Focus()) DrawSelect(D);
}

// Objects streams

void TItemBox::Read(TDisk *file)
{ TButton::Read(file);
  if (Text!=NULL) free(Text);
  ReadString(file,&Text);
}

void TItemBox::Write(TDisk *file)
{ TButton::Write(file);
  WriteString(file,Text);
}

// ----- TCheckBox

DEFINE(TCheckBox);

short RegTCheckBox;
char *IdentTCheckBox = "TCheckBox";

// Constructors

TCheckBox::TCheckBox()
{ Defaults();
}

TCheckBox::TCheckBox(int X, int Y, int L, int _Options, int _Mask, char *_Text)
{ Defaults();
  Init(X,Y,L,_Options,_Mask,_Text);
}

void TCheckBox::Defaults(void)
{ // Object identification
  Register=RegTCheckBox;
  Ident=IdentTCheckBox;
  // Other default values
  Mask=0;
}

void TCheckBox::Init(int X, int Y, int L, int _Options, int _Mask, char *_Text)
{ // Herited creations
  TItemBox::Init(X,Y,L,_Options,_Text);
  // New creations
  Mask=_Mask;
  Check=new TSysIcone(9,10,ICO_Check);
}

void TCheckBox::Done(void)
{ // Herited destructions
  TItemBox::Done();
  // New destructions
  if (Check!=NULL) delete Check;
}

// Graphics

void TCheckBox::DrawInside(int Depl)
{ if ((Father()->Value) & Mask)
    if (Check!=NULL)
      Check->Draw(Corner.X()+Depl+3,Corner.Y()+Depl+3);
}

// Action

void TCheckBox::Action(void)
{ Father()->Value^=Mask;
  Invalidate(0,0,15,15);
}

// Objects streams

void TCheckBox::Read(TDisk *file)
{ TItemBox::Read(file);
  ReadInt(file,&Mask);
}

void TCheckBox::Write(TDisk *file)
{ TItemBox::Write(file);
  WriteInt(file,Mask);
}

// ----- TRadioBox

DEFINE(TRadioBox);

short RegTRadioBox;
char *IdentTRadioBox = "TRadioBox";

// Constructors

TRadioBox::TRadioBox()
{ Defaults();
}

TRadioBox::TRadioBox(int X, int Y, int L, int _Options, int _Value, char *_Text)
{ Defaults();
  Init(X,Y,L,_Options,_Value,_Text);
}

void TRadioBox::Defaults(void)
{ // Object identification
  Register=RegTRadioBox;
  Ident=IdentTRadioBox;
  // Other default values
  Value=0;
}

void TRadioBox::Init(int X, int Y, int L, int _Options, int _Value, char *_Text)
{ // Herited constructions
  TItemBox::Init(X,Y,L,_Options,_Text);
  // New constructions
  I1=new TSysIcone(16,16,ICO_Radio1);
  I2=new TSysIcone(16,16,ICO_Radio2);
  I3=new TSysIcone(9,9,ICO_Radio3);
  Value=_Value;
}

void TRadioBox::Done(void)
{ // Herited destructions
  TItemBox::Done();
  // New destructions
  if (I1!=NULL) delete I1;
  if (I2!=NULL) delete I2;
  if (I3!=NULL) delete I3;
}

// Graphics

int TRadioBox::DrawFrame(void)
{ if (GetStatus(sfDown))
  { if (I1!=NULL) I1->Draw(Corner.X(),Corner.Y());
    return 1;
  }
  else
  { if (I2!=NULL) I2->Draw(Corner.X(),Corner.Y());
    return 0;
  }
}

void TRadioBox::DrawInside(int D)
{ if (Father()->Value==Value)
    if (I3!=NULL) I3->Draw(Corner.X()+3+D,Corner.Y()+3+D);
}

// Action

void TRadioBox::Action(void)
{ int *FVal=&(Father()->Value);
  if (*FVal!=Value)
  { // Recherche le Radio Box actuellement slectionn
    TRadioBox *O=First();
    while((O!=NULL)&&(O->Value!=*FVal)) O=O->Next();
    // Slectionne ce Radio Box
    *FVal=Value;
    Invalidate(0,0,15,15);
    // Dselectionne l'ancien
    if (O!=NULL) O->Invalidate(0,0,15,15);
  }
}

// Objects streams

void TRadioBox::Read(TDisk *file)
{ TItemBox::Read(file);
  ReadInt(file,&Value);
}

void TRadioBox::Write(TDisk *file)
{ TItemBox::Write(file);
  WriteInt(file,Value);
}
