// Associated include file : Graphics/Edition.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// ----- TEditLine

DEFINE(TEditLine);

DEFINE_EVENTS_TABLE(TEditLine,TZone)
  COMMAND(cmSelect,    doChangeSelect)
  COMMAND(cmUnSelect,  doChangeSelect)
  COMMAND(cmDrawCursor,doChangeSelect)
  KEYDOWN()
  MOUSELDOWN()
  MOUSEDBLCLK()
  MOUSEMOVE()
END_EVENTS_TABLE

short RegTEditLine;
char *IdentTEditLine    = "TEditLine";

// Constructors

TEditLine::TEditLine()
{ Defaults();
}

TEditLine::TEditLine(int X, int Y, int L, char Lt, char Dpl, boolean Border)
{ Defaults();
  Init(X,Y,L,Lt,Dpl,Border);
}

TEditLine::TEditLine(TRect R, char Lt, char Dpl, boolean Border)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),Lt,Dpl,Border);
}

void TEditLine::Defaults(void)
{ // Object identification
  Register=RegTEditLine;
  Ident=IdentTEditLine;
  // Other default values
  SetOptions(opSelectable);
  BegText=0;
  Cursor=0;
  BackColor=White;
  TextColor=Black;
  Text=NewText=TempText=NULL;
  BeginSelect=EndSelect=-1;
  MouseAspect=MouseCursorText;
}

void TEditLine::Init(int X, int Y, int L, char Lt, char Dpl, boolean Border)
{ // Herited creations
  TZone::Init(X,Y,L,Border ? 22 : 18);
  // New creations
  LengthText=Lt;
  Deplacement=Dpl;
  // Get memory for text
  Text    =new char[Lt+1];
  *Text=0;
  NewText =new char[Lt+1];
  TempText=new char[Lt+12];
  //
  if (Border) SetOptions(opEditBorder);
  SizeChanged();
}

void TEditLine::Done(void)
{ // Herited destructions
  TZone::Done();
  // New destructions
  if (TempText!=NULL) delete TempText;
  if (NewText!=NULL)  delete NewText;
  if (NewText!=NULL)  delete Text;
}

void TEditLine::Draw(TRect )
{ SetSysColor(BackColor);
  Bar(DrawX,DrawY,DrawX+1,DrawY+DrawHeight-1);
  Bar(DrawX+DrawLength-2,DrawY,DrawX+DrawLength-1,DrawY+DrawHeight-1);
  LineX(DrawX,DrawY,DrawX+DrawLength-1);
  Bar(DrawX,DrawY+DrawHeight-2,DrawX+DrawLength-1,DrawY+DrawHeight-1);
  if (GetOptions(opEditBorder)) Frame3D(1);
  DrawText();
  if (Focus()) DrawCursor();
}

void TEditLine::DrawText(void)
{ int   DX,Cur;
  char  *T,Ch;
  FontSystem->TruncStr(DrawLength-4,Text+BegText,TempText);
  LengthDraw=strlen(TempText);
  DX=2;
  T=TempText;
  if (IsSelection())
  { // Trac 1re partie : AVANT la zone slectionne
    Cur=BeginSelect-BegText;
    if (Cur>=0)
    { FontSystem->BackColor(NoSysColor[BackColor]);
      SetSysColor(TextColor);
      Ch=TempText[Cur];
      TempText[Cur]=0;
      PutStr(DrawX+DX,DrawY+1,TempText,FontSystem);
      DX+=FontSystem->WidthStr(TempText);
      TempText[Cur]=Ch;
      T=TempText+Cur;
    }
    // Trac 2me partie : la zone slectionne
    Cur=EndSelect-BegText;
    if (Cur>=0)
    { FontSystem->BackColor(NoSysColor[TextColor]);
      SetSysColor(BackColor);
      Ch=TempText[Cur];
      TempText[Cur]=0;
      PutStr(DrawX+DX,DrawY+1,T,FontSystem);
      DX+=FontSystem->WidthStr(T);
      TempText[Cur]=Ch;
      T=TempText+Cur;
    }
    // Trac 3me partie : APRES la zone slectionne (ce qui reste)
  }
  FontSystem->BackColor(NoSysColor[BackColor]);
  SetSysColor(TextColor);
  PutStr(DrawX+DX,DrawY+1,T,FontSystem);
  DX+=FontSystem->WidthStr(T);
  //
  FontSystem->BackColor(NoColor);
  SetSysColor(BackColor);
  if (DX<=DrawLength-2-1)
    Bar(DrawX+DX,DrawY+1,DrawX+DrawLength-2-1,DrawY+DrawHeight-3);
}

void TEditLine::DrawCursor(void)
{ int X,L;
  SetWriteMode(wmXOR);
  memset(TempText,0,LengthText+1);
  strncpy(TempText,Text+BegText,Cursor-BegText);
  X=1+FontSystem->WidthStr(TempText);
  SetSysColor(TextColor ^ BackColor);
  if (CursorIns) Rectangle(DrawX+X,DrawY,DrawX+X+1,DrawY+DrawHeight-1);
  else
  { if (Cursor<strlen(Text)) L=FontSystem->WidthChar(Text[Cursor]);
    else L=FontSystem->WidthChar('E');
    Rectangle(DrawX+X,DrawY,DrawX+X+L+1,DrawY+DrawHeight-1);
  }
  SetWriteMode(wmREPLACE);
}

void TEditLine::DoDrawCursor(void)
{ if (Status & sfVisible)
  { DrawBegin();
    GrSetClipBox(0,0,GrMaxX(),GrMaxY());
    DrawCursor();
    DrawEnd();
  }
}

boolean TEditLine::MakeCursorVisible(void)
{ boolean DrawTxt=FALSE;
  if (*Text==0)
  { // Cas particulier n 1 : La chane est vide
    if (BegText!=0)
    { BegText=0;
      DrawTxt=TRUE;
    }
  }
  else
  { // Verifie qu'au moins le curseur n'est pas  gauche !!
    while(BegText>Cursor)
    { if (BegText>Deplacement) BegText-=Deplacement;
                          else BegText=0;
      DrawTxt=TRUE;
    }
    // Calcule la longueur de texte actuellement visibile
    FontSystem->TruncStr(DrawLength-4,Text+BegText,TempText);
    LengthDraw=strlen(TempText);
    if (Cursor==strlen(Text))
    { // Cas particulier n2 : Le curseur est en fin de chane
      // :: Dplace tant que la fin de la chane n'est pas visible
      while(strlen(Text+BegText)!=LengthDraw)
      { BegText+=Deplacement;
        FontSystem->TruncStr(DrawLength-4,Text+BegText,TempText);
        LengthDraw=strlen(TempText);
        DrawTxt=TRUE;
      }
    }
    else
    { // Autres cas
      // :: Ramne le curseur s'il est trop  droite
      while(BegText+LengthDraw<Cursor)
      { BegText+=Deplacement;
        FontSystem->TruncStr(DrawLength-4,Text+BegText,TempText);
        LengthDraw=strlen(TempText);
        DrawTxt=TRUE;
      }
    }
  }
  return DrawTxt;
}

void TEditLine::SetData(void* Ptr)
{ memmove(Text,Ptr,LengthText+1);
  TextChanged();
}

void TEditLine::GetData(void* Ptr)
{ memmove(Ptr,Text,LengthText+1);
}

long TEditLine::DataSize(void)
{ return TZone::DataSize()+LengthText+1;
}

void TEditLine::TextChanged(void)
{ BegText=0;
  Cursor=strlen(Text);
  // Make the cursor visible
  MakeCursorVisible();
  // Ask for re-drawing
  Invalidate();
}

int TEditLine::ValidInput(int& )
{ return TRUE;
}

int TEditLine::ValidResult(void)
{ return TRUE;
}

void TEditLine::CursorRight(boolean Shift)
{ boolean DrawTxt=FALSE;
  if (Cursor<strlen(Text))
  { DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor++;
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    DoDrawCursor();
  }
}

void TEditLine::CursorCtrlRight(boolean Shift)
{ boolean DrawTxt=FALSE;
  if (Cursor<strlen(Text))
  { DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor++;
    while((Cursor<strlen(Text))&&(Text[Cursor-1]!=' ')) Cursor++;
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    DoDrawCursor();
  }
}

void TEditLine::CursorLeft(boolean Shift)
{ boolean DrawTxt=FALSE;
  if (Cursor>0)
  { DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor--;
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    DoDrawCursor();
  }
}

void TEditLine::CursorCtrlLeft(boolean Shift)
{ boolean DrawTxt = FALSE;
  if (Cursor>0)
  { DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor--;
    while((Cursor!=0)&&(Text[Cursor-1]!=' ')) Cursor--;
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    DoDrawCursor();
  }
}

void TEditLine::CursorEnd(boolean Shift)
{ boolean DrawTxt = FALSE;
  if (Cursor!=strlen(Text))
  { if (Focus()) DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor=strlen(Text);
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    if (Focus()) DoDrawCursor();
  }
}

void TEditLine::CursorHome(boolean Shift)
{ boolean DrawTxt = FALSE;
  if (Cursor)
  { DoDrawCursor();
    if (Shift)
    { if (!IsSelection()) BaseSelect=Cursor;
      DrawTxt=TRUE;
    }
    else
      if (IsSelection()) { NoSelection(); DrawTxt=TRUE; }
    Cursor=0;
    if (Shift)
      if (Cursor<BaseSelect) { BeginSelect=Cursor;     EndSelect=BaseSelect; }
                        else { BeginSelect=BaseSelect; EndSelect=Cursor;     }
    DrawTxt|=MakeCursorVisible();
    if (DrawTxt) DrawText();
    DoDrawCursor();
  }
}

void TEditLine::Insertion(char C)
{ if (strlen(Text)<LengthText)
  { *TempText=C;
    *(TempText+1)=0;
    strcat(TempText,Text+Cursor);
    strcpy(NewText,Text);
    strcpy(NewText+Cursor,TempText);
    if (ValidResult())
    { DoDrawCursor();
      NoSelection();
      Cursor++;
      strcpy(Text,NewText);
      MakeCursorVisible();
      DrawText();
      DoDrawCursor();
      Modified();
    }
  }
}

void TEditLine::Recover(char C)
{ strcpy(NewText,Text);
  *(NewText+Cursor)=C;
  if (ValidResult())
  { DoDrawCursor();
    NoSelection();
    Cursor++;
    strcpy(Text,NewText);
    FontSystem->TruncStr(LengthDraw-4,Text+BegText,TempText);
    LengthDraw=strlen(TempText);
    MakeCursorVisible();
    DrawText();
    DoDrawCursor();
    Modified();
  }
}

void TEditLine::BackSpace(void)
{ if (Cursor)
  { memset(NewText,0,LengthText+1);
    strncpy(NewText,Text,Cursor-1);
    strcat(NewText,Text+Cursor);
    if (ValidResult())
    { DoDrawCursor();
      NoSelection();
      strcpy(Text,NewText);
      Cursor--;
      MakeCursorVisible();
      DrawText();
      DoDrawCursor();
      Modified();
    }
  }
}

void TEditLine::Delete(void)
{ if (Cursor!=strlen(Text))
  { memset(NewText,0,LengthText+1);
    strncpy(NewText,Text,Cursor);
    strcat(NewText,Text+Cursor+1);
    if (ValidResult())
    { DoDrawCursor();
      NoSelection();
      strcpy(Text,NewText);
      DrawText();
      DoDrawCursor();
      Modified();
    }
  }
}

void TEditLine::ReplaceSelection(char C)
{ char Ch;
  // Prepare le nouveau texte
  // :: 1. Zone AVANT la selection
  Ch=Text[BeginSelect];
  Text[BeginSelect]=0;
  strcpy(NewText,Text);
  Text[BeginSelect]=Ch;
  // :: 2. + Caractre entr
  NewText[BeginSelect]=C;
  NewText[BeginSelect+1]=0;
  // :: 3. + Zone APRES la selection
  strcat(NewText,Text+EndSelect);
  //
  if (ValidResult())
  { DoDrawCursor();
    Cursor=BeginSelect+1;
    NoSelection();
    strcpy(Text,NewText);
    MakeCursorVisible();
    DrawText();
    DoDrawCursor();
    Modified();
  }
}

void TEditLine::Cut(void)
{ if (IsSelection())
  { // Essaye d'enlever le texte coup
    strcpy(NewText,Text);
    strcpy(TempText,Text+EndSelect);
    strcpy(NewText+BeginSelect,TempText);
    if (ValidResult())
    { DoDrawCursor();
      // Place le texte dans le clipboard
      Text[EndSelect]=0;
      SetClipBoard(new TClipBoard_TextLine(Text+BeginSelect));
      // Active le nouveau texte
      strcpy(Text,NewText);
      // Change le curseur de place
      Cursor=BeginSelect;
      MakeCursorVisible();
      // Plus de slection
      NoSelection();
      // Affiche le rsultat
      DrawText();
      DoDrawCursor();
      Modified();
    }
  }
}

void TEditLine::Copy(void)
{ char Ch;
  if (IsSelection())
  { // Place le texte dans le clipboard
    Ch=Text[EndSelect];
    Text[EndSelect]=0;
    SetClipBoard(new TClipBoard_TextLine(Text+BeginSelect));
    Text[EndSelect]=Ch;
  }
}

void TEditLine::Paste(void)
{ int                  InsPoint;
  TClipBoard_TextLine *Clip;
  int                  ClipLength;
  char                 Ch;

  if (ClipBoardType()==cpTextLine)
  { Clip=(TClipBoard_TextLine*)GetClipBoard();
    ClipLength=strlen(Clip->GetLine());
    if (IsSelection())
    { // S'il y avait une slection, on la vire
      strcpy(NewText,Text);
      strcpy(TempText,Text+EndSelect);
      strcpy(NewText+BeginSelect,TempText);
      InsPoint=BeginSelect;
    }
    else
    { strcpy(NewText,Text);
      InsPoint=Cursor;
    }
    if (ClipLength+strlen(NewText)<=LengthText)
    { // OK, il y a de la place dans les buffers, on continue
      // :: on insre le clipboard  InsPoint dans NewText
      Ch=NewText[InsPoint];
      NewText[InsPoint]=0;
      strcpy(TempText,NewText);
      NewText[InsPoint]=Ch;
      strcat(TempText,Clip->GetLine());
      strcat(TempText,NewText+InsPoint);
      strcpy(NewText,TempText);
      //
      if (ValidResult())
      { DoDrawCursor();
        strcpy(Text,NewText);
        Cursor=InsPoint+ClipLength;
        MakeCursorVisible();
        NoSelection();
        DrawText();
        DoDrawCursor();
        Modified();
      }
    }
  }
}

boolean TEditLine::doChangeSelect(void)
{ if (Focus()) DoDrawCursor();
  return FALSE;
}

void TEditLine::Modified()
{ // Send a notification message for this modification
  SetCommand(cmEditChanged,this);
}

boolean TEditLine::KeyDown(int ScanCode, int Toggle)
{ boolean Shift=(Toggle & tgShift)!=0;
  if (TZone::KeyDown(ScanCode,Toggle)) return TRUE;

  if (Focus())
    switch(ScanCode)
    { case ScanRightArrow      : CursorRight(Shift);     return TRUE;
      case ScanLeftArrow       : CursorLeft(Shift);      return TRUE;
      case ScanEnd             : CursorEnd(Shift);       return TRUE;
      case ScanHome            : CursorHome(Shift);      return TRUE;
      case ScanBackSpace       : BackSpace();            return TRUE;
      case ScanDelete          : Delete();               return TRUE;
      case ScanCtrlLeftArrow   : CursorCtrlLeft(Shift);  return TRUE;
      case ScanCtrlRightArrow  : CursorCtrlRight(Shift); return TRUE;
      case ScanCtrlX           : Cut();                  return TRUE;
      case ScanCtrlC           : Copy();                 return TRUE;
      case ScanCtrlV           : Paste();                return TRUE;
      default             :
        if ((ScanCode>=0x0020) && (ScanCode<=/*0x00FF*/0x007F))
        { if (ValidInput(ScanCode))
          { if (IsSelection()) ReplaceSelection((char)ScanCode);
            else
              if (Cursor==strlen(Text)) Insertion((char)ScanCode);
              else
                if (CursorIns) Insertion((char)ScanCode);
                else Recover((char)ScanCode);
          }
          return TRUE;
        }
        break;
    }
  return FALSE;
}

boolean TEditLine::MouseLDown(TPoint W, int )
{ if (GetStatus(sfMouseIn))
  { MakeGlobal(Where.P1(),Corner);
    if (!(Status & sfSelected)) Select();
    DoDrawCursor();
    NoSelection();
	 if (W.X()<Corner.X()+4) Cursor=BegText;
    else
    { FontSystem->TruncStr(DrawLength-8,Text+BegText,TempText);
	   while(W.X()-(Corner.X()+4)<FontSystem->WidthStr(TempText))
        *(TempText+strlen(TempText)-1)=0;
      BaseSelect=Cursor=BegText+strlen(TempText);
    }
    DoDrawCursor();
    return TRUE;
  }
  return FALSE;
}

boolean TEditLine::MouseDblClk(TPoint , int )
{ if (GetStatus(sfMouseIn))
  { if (!(Status & sfSelected)) Select();
    DoDrawCursor();
    // Selectionne tout
    BaseSelect=BeginSelect=0;
    EndSelect=strlen(Text);
    // Place le curseur a la fin
    Cursor=strlen(Text);
    MakeCursorVisible();
    DrawText();
    DoDrawCursor();
    return TRUE;
  }
  return FALSE;
}

boolean TEditLine::MouseMove(TPoint W, int Buttons)
{ int OldCursor;
  if (Buttons & mbLeft)
    if (GetStatus(sfMouseIn))
    { MakeGlobal(Where.P1(),Corner);
      if (!(Status & sfSelected)) Select();
      DoDrawCursor();
      OldCursor=Cursor;
      if (W.X()<Corner.X()+4) Cursor=BegText;
      else
      { FontSystem->TruncStr(DrawLength-4,Text+BegText,TempText);
        while(W.X()-(Corner.X()+4)<FontSystem->WidthStr(TempText))
          *(TempText+strlen(TempText)-1)=0;
        Cursor=BegText+strlen(TempText);
      }
      if (Cursor!=OldCursor)
      { if (Cursor>BaseSelect) { BeginSelect=BaseSelect; EndSelect=Cursor; }
                          else { BeginSelect=Cursor;     EndSelect=BaseSelect; }
        DrawText();
      }
      DoDrawCursor();
    }
  return FALSE;
}

void TEditLine::SizeChanged(void)
{ if (GetOptions(opEditBorder))
  { DrawLength=Where.Width()-4;
    DrawHeight=Where.Height()-4;
    DrawX=DrawY=2;
  }
  else
  { DrawLength=Where.Width();
    DrawHeight=Where.Height();
    DrawX=DrawY=0;
  }
  // Repositionne BegText si besoin est
  DoDrawCursor();
  if (MakeCursorVisible()) DrawText();
  DoDrawCursor();
}

void TEditLine::NoSelection(void)
{ if (IsSelection())
  { BeginSelect=EndSelect=-1;
    DrawText();
  }
}

boolean TEditLine::IsSelection(void)
{ return BeginSelect>=0;
}

// ----- Mthodes de TEditReal

DEFINE(TEditReal);

short RegTEditReal;
char *IdentTEditReal    = "TEditReal";

// Constructors

TEditReal::TEditReal()
{ Defaults();
}

TEditReal::TEditReal(int X, int Y, int L, boolean Border)
{ Defaults();
  Init(X,Y,L,Border);
}

TEditReal::TEditReal(TRect R, boolean Border)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),Border);
}

void TEditReal::Defaults(void)
{ // Object identification
  Register=RegTEditReal;
  Ident=IdentTEditReal;
  // Other default values
}

void TEditReal::Init(int X, int Y, int L, boolean Border)
{ // Herited constructions
  TEditLine::Init(X,Y,L,40,5,Border);
  // New constructions
}

void TEditReal::SetData(void* Ptr)
{ float R;
  char* P;
  memmove(&R,Ptr,sizeof(float));
  sprintf(Text,"%g",R);
  P=Text;
  while((*P)&&(*P!='.')) P++;
  if (*P=='.') *P=PointChar;
  Cursor=0;
  BegText=0;
  // Then perform CursorEnd
  CursorEnd(FALSE);
  // Ask for re-drawing
  Invalidate();
}

void TEditReal::GetData(void* Ptr)
{ float R;
  char  *P=Text;
  while((*P)&&(*P!=PointChar)) P++;
  if (*P==PointChar) *P='.';
  sscanf(Text,"%g",&R);
  if (*P=='.') *P=PointChar;
  memmove(Ptr,&R,sizeof(float));
}

long TEditReal::DataSize(void)
{ return (TZone::DataSize()+sizeof(float));
}

int TEditReal::ValidInput(int& ScanCode)
{ switch(ScanCode)
  { case 0x0030 :     // '0'
    case 0x0031 :     // '1'
    case 0x0032 :     // '2'
    case 0x0033 :     // '3'
    case 0x0034 :     // '4'
    case 0x0035 :     // '5'
    case 0x0036 :     // '6'
    case 0x0037 :     // '7'
    case 0x0038 :     // '8'
    case 0x0039 :     // '9'
      break;
    case 0x0045 :     // 'E'
    case 0x0065 :     // 'e'
      ScanCode=0x0045;
      break;
    case 0x002E :    // '.'
    case 0x002C :    // ','
      ScanCode=(int)PointChar;
      break;
    case 0x002D :   // '-'
    case 0x002B :   // '+'
      break;
    default :
      return FALSE;
  }
  return TRUE;
}

// *** Routines d'analyse syntaxique d'un rel
// Syntaxe de la grammaire : |    Ou bien
//                           [ ]  Rptition n fois, n=0,1,2...
//                           ( )  Facultatif (rptition 0 ou 1 fois)
// Digit ::= '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'
// NP    ::= [ Digit ]
// ZP    ::=   NP ( PointChar NP )
// N     ::= ( '-' | '+' ) NP
// Z     ::= ( '-' | '+' ) ZP
// R     ::= Z ( 'E' N )

int ScanDigit(char* &P)
{ if ((*P>='0') && (*P<='9'))
  { P++;
    return TRUE;
  }
  return FALSE;
}

void ScanNP(char* &P)
{ while(ScanDigit(P)) ;
}

void ScanZP(char* &P)
{ ScanNP(P);
  if (*P==PointChar)
  { P++;
    ScanNP(P);
  }
}

void ScanN(char* &P)
{ if ((*P=='-') || (*P=='+')) P++;
  ScanNP(P);
}

void ScanZ(char* &P)
{ if ((*P=='-') || (*P=='+')) P++;
  ScanZP(P);
}

int ScanR(char*& P)
{ ScanZ(P);
  if (*P=='E')
  { P++;
    ScanN(P);
  }
  if (*P) return FALSE;
  return TRUE;
}

int TEditReal::ValidResult(void)
{ char* P=NewText;
  if (!(*P)) return TRUE;
        else return ScanR(P);
}

// ----- Mthodes de TEditInteger

DEFINE(TEditInteger);

short RegTEditInteger;
char *IdentTEditInteger = "TEditInteger";

// Constructors

TEditInteger::TEditInteger()
{ Defaults();
}

TEditInteger::TEditInteger(int X, int Y, int L, int _DataType, boolean Border)
{ Defaults();
  Init(X,Y,L,_DataType,Border);
}

TEditInteger::TEditInteger(TRect R, int _DataType, boolean Border)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),_DataType,Border);
}

void TEditInteger::Defaults(void)
{ // Object Identification
  Register=RegTEditInteger;
  Ident=IdentTEditInteger;
  // Other default values
  DataType=dt_int16;
}

void TEditInteger::Init(int X, int Y, int L, int _DataType, boolean Border)
{ // Herited creations
  TEditLine::Init(X,Y,L,40,5,Border);
  // New creations
  DataType=_DataType;
}

void TEditInteger::SetData(void* Ptr)
{ char   c;
  byte   b;
  int16  i16;
  word16 w16;
  int32  i32;
  word32 w32;
  // Number -> text
  // 1. Unsigned number
  if (DataType & 1)
  { switch(DataType)
    { case dt_byte :
        memmove(&b,Ptr,sizeof(byte));
        w32=b;
        break;
      case dt_word16 :
        memmove(&w16,Ptr,sizeof(word16));
        w32=w16;
        break;
      case dt_word32 :
        memmove(&w32,Ptr,sizeof(word32));
        break;
    }
    sprintf(Text,"%lu",w32);
  }
  // 2. Signed number
  else
  { switch(DataType)
    { case dt_char :
        memmove(&c,Ptr,sizeof(char));
        i32=c;
        break;
      case dt_int16 :
        memmove(&i16,Ptr,sizeof(int16));
        i32=i16;
        break;
      case dt_int32 :
        memmove(&i32,Ptr,sizeof(int32));
        break;
    }
    sprintf(Text,"%ld",i32);
  }
  TextChanged();
}

void TEditInteger::GetData(void* Ptr)
{ char   c;
  byte   b;
  int16  i16;
  word16 w16;
  int32  i32;
  word32 w32;
  // Text -> number
  // 1. Unsigned number
  if (DataType & 1)
  { sscanf(Text,"%lu",&w32);
    switch(DataType)
    { case dt_byte :
        b=w32;
        memmove(Ptr,&b,sizeof(byte));
        break;
      case dt_word16 :
        w16=w32;
        memmove(Ptr,&w16,sizeof(word16));
        break;
      case dt_word32 :
        memmove(Ptr,&w32,sizeof(word32));
        break;
    }
  }
  // 2. Signed number
  else
  { sscanf(Text,"%ld",&i32);
    switch(DataType)
    { case dt_char :
        c=i32;
        memmove(Ptr,&c,sizeof(char));
        break;
      case dt_int16 :
        i16=i32;
        memmove(Ptr,&i16,sizeof(int16));
        break;
      case dt_int32 :
        memmove(Ptr,&i32,sizeof(int32));
        break;
    }
  }
}

long TEditInteger::DataSize(void)
{ int L;
  switch(DataType)
  { case dt_char   :
    case dt_byte   : L=1; break;
    case dt_int16  :
    case dt_word16 : L=2; break;
    case dt_int32  :
    case dt_word32 : L=4; break;
  }
  return (TZone::DataSize()+L);
}

int TEditInteger::ValidInput(int& ScanCode)
{ switch(ScanCode)
  { case 0x0030 :     // '0'
    case 0x0031 :     // '1'
    case 0x0032 :     // '2'
    case 0x0033 :     // '3'
    case 0x0034 :     // '4'
    case 0x0035 :     // '5'
    case 0x0036 :     // '6'
    case 0x0037 :     // '7'
    case 0x0038 :     // '8'
    case 0x0039 :     // '9'
      break;
    case 0x002D :     // '-'
    case 0x002B :     // '+'
      break;
    default :
      return FALSE;
  }
  return TRUE;
}

int TEditInteger::ValidResult(void)
{ char* P=NewText;
  if (!(*P)) return TRUE;
        else
  { if ((*P=='-') || (*P=='+')) P++;
    while(*P)
    { if ((*P<'0')||(*P>'9')) return FALSE;
      P++;
    }
    return TRUE;
  }
}