;
; Copyright (C) 1998 Grzegorz Kowal
;

.486

CODE32  SEGMENT PUBLIC PARA USE32 'CODE'
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

INCLUDE	DEMO.ASH		; header file

Start32:
	VESAInit		; init the library (NESSECARY!)
	SetMode 1		; set 640x480x256 mode
	MouseInit		; init mouse
	mov	eax,O Font
	mov	WindowFont,eax	; set window (dialog) font
	mov	eax,O Font
	mov	ButtonFont,eax	; set button font

	mov	ebx,O Picture	; get filespec
	stc			; center image
	call	ShowGif		; Presto!
	jc	Error		; just in  case...

	mov	al,255		; color
	mov	ecx,10		; x-pos
	mov	edx,10		; y-pos
	mov	esi,O HelloM	; text offset
	mov	ebx,O Font	; font offset
	call	PutGpxText
	jc	Error

	GetKey			; wait for keypress
	mov	al,0		; black
	mov	ah,1		; wipe mode (the cool one)
	call	WipeScr
	jc	Error

	call	SetGrayPal
	MouseOn
	mov	ebx,O Main	; dialog structure
	call	PutDialog	; display dialog and wait for the user to decide
	jc	Error
	Term			; kill mouse, restore text mode and exit to DOS


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Button functions
;

;
; This procedure is invoked after the main dialog is displayed but before
; the buttons are handled.
;
MainInit:
	ret


MainRightButton:
	mov	ebx,O Dlg4
	call	PutDialog
	jc	Error
	retc				; return and continue dialog


MainKillButt:
	retx				; return and exit dialog


Main1B:
	mov	ebx,O Dlg1	; dialog structure
	call	PutDialog	; display dialog and wait for the user to decide
	jc	Error
	retc


Main2B:
	mov	ebx,O Dlg2	; dialog structure
	call	PutDialog	; display dialog and wait for the user to decide
	jc	Error
	retc


Main3B:
	mov	ebx,O Dlg3	; dialog structure
	call	PutDialog	; display dialog and wait for the user to decide
	jc	Error
	retc


MainSpecialB:
	MouseOff			; cursor off during display
	mov	ecx,120+348+5		; x-pos
	mov	edx,90+32+5		; y-pos
	mov	eax,30			; x-size
	mov	ebx,40			; y-size
	mov	esi,O Block		; offset
	stc				; raster sync
	call	PutBlock
	jc	Error
	MouseOn

	mov	ebx,O Block
	mov	ecx,30*40
Loop1:
	add	BYTE PTR [ebx],4
	inc	ebx
	loop	Loop1
	retc


;
; This proc exits dialogs 1,2,3
;
Dlg1Kill:
	retx


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Error handler
;
Error:
	Kill	ErrorM


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; DATA
;
	ALIGN 4
Block	DB	30*40 DUP(4*40)
Picture	DB	"demo.gif",0
HelloM	DB	"Hello, this is a demo that",0Ah
	DB	"illustrates how the Kojak's",0Ah
	DB	"VESA Library is easy to use!",0Ah
	DB	" -- any key to continue -- ",0
ErrorM	DB	"An error has ocurred!",0Dh,0Ah,'$'

INCLUDE DEMO.DLG		; include the dialog def file
INCLUDE DEMO.FNT		; include the font file
CODE32  ENDS
        END
