;
; Copyright (C) 1998 Grzegorz Kowal
;

;;
;; MOUSE EXTENTION MACROS
;;

LOCALS


;;
;; EAX ALLWAYS *DESTROYED*
;;

MousePresent	EQU	1
GLOBAL	MouseX:DWORD
GLOBAL	MouseY:DWORD
GLOBAL	MouseUp:DWORD
GLOBAL	MouseDown:DWORD
GLOBAL	MouseLeft:DWORD
GLOBAL	MouseRight:DWORD
GLOBAL	MouseScrollF:BYTE	; DON'T MODIFY THIS VAR, USE MACROS INSTEAD!!!
GLOBAL	_MouseInit:PROC
GLOBAL	_MouseOn:PROC
GLOBAL	_MouseOff:PROC
GLOBAL	_MousePos:PROC
GLOBAL	_MouseCursor:PROC


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseInit ()
;; Reset mouse driver and the extention, pass screen width and heigth.
;; Center mouse cursor, turn if off.
;; NOTE: ALLWAYS USE THIS MACRO AFTER SWITCHING TO A DIFFERENT MODE.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= button data
;;
MouseInit	MACRO
		call	_MouseInit
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseOn ()
;; Turns the mouse cursor on.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseOn		MACRO
		call	_MouseOn
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseOff ()
;; Turns the mouse cursor off.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseOff	MACRO
		call	_MouseOff
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseB ()
;; Gets mouse button status.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= button status
;;			  bit 0--left
;;			      1--right
;;			      2--middle
;;		CX	= X-Pos
;;		DX	= Y-Pos
;;
MouseB		MACRO
		mov	ax,3
		DosInt	33h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MousePos (X,Y)
;; Changes the cursor's position.
;;
;; Expects:	X	= x-pos (word)
;;		Y	= y-pos (word)
;;
;; Returns:	CF	= status [0--ok|1--error]
;;
MousePos	MACRO	X,Y
		IFDIFI	<X>,<ecx>
			push	ecx
			mov	ecx,X
		ENDIF
		IFDIFI	<Y>,<edx>
			push	edx
			mov	edx,Y
		ENDIF
		call	_MousePos
		IFDIFI	<Y>,<edx>
			pop	edx
		ENDIF
		IFDIFI	<X>,<ecx>
			pop	ecx
		ENDIF
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseCursor (OFFSET to bitmap)
;; Changes the mouse cursor bitmap.
;;
;; Expects:	OFFSET to bitmap
;;
;; Returns:	nothing
;;
MouseCursor	MACRO	P1
		push	edx
		lea	edx,P1
		call	_MouseCursor
		pop	edx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseScrollOn
;; Turns scrolling on.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseScrollOn	MACRO
		and	MouseScrollF,01111111b
;;
;; DON'T MODIFY THIS VAR ANY OTHER WAY!
;;
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseScrollOff
;; Turns scrolling off.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseScrollOff	MACRO
		or	MouseScrollF,10000000b
;;
;; DON'T MODIFY THIS VAR ANY OTHER WAY!
;;
		ENDM
