;
; Copyright (C) 1998 Grzegorz Kowal
;

;;
;; VESA BIOS MACROS
;;


VESAPresent	EQU	1
GLOBAL	VESAWidth:DWORD
GLOBAL	VESAHeight:DWORD
GLOBAL	VESAStartX:DWORD
GLOBAL	VESAStartY:DWORD
GLOBAL	VESABank:WORD
GLOBAL	VESABuffer:BYTE:256
GLOBAL	ScrBuff:DWORD

GLOBAL	_VESAInit:PROC
GLOBAL	PutBlock:PROC
GLOBAL	GetBlock:PROC
GLOBAL	FillBlock:PROC
GLOBAL	PutPixel:PROC
GLOBAL	GetPixel:PROC
GLOBAL	PutLine:PROC
GLOBAL	SetPal:PROC
GLOBAL	SetGrayPal:PROC
GLOBAL	SetNulPal:PROC
GLOBAL	LoadPal:PROC
GLOBAL	PutGpxText:PROC
GLOBAL	PutGpxChar:PROC
GLOBAL	ShowColoRIX:PROC
GLOBAL	ShowGIF:PROC
GLOBAL	WipeScr:PROC
GLOBAL	Input:PROC
GLOBAL	InitScrBuff:PROC
GLOBAL	KillScrBuff:PROC
GLOBAL	PutScrBuff:PROC
GLOBAL	GetScrBuff:PROC
GLOBAL	FastLine:PROC
GLOBAL	UseButtons:PROC
GLOBAL	PutWindow:PROC
GLOBAL	PutDialog:PROC
GLOBAL	ButtonFont:DWORD
GLOBAL	ButtonFg:BYTE
GLOBAL	ButtonBg:BYTE
GLOBAL	ButtonU1:BYTE
GLOBAL	ButtonU2:BYTE
GLOBAL	ButtonL1:BYTE
GLOBAL	ButtonL2:BYTE
GLOBAL	ButtonBd:BYTE
GLOBAL	WindowFont:DWORD
GLOBAL	WindowFg:BYTE
GLOBAL	WindowBg:BYTE
GLOBAL	WindowU:BYTE
GLOBAL	WindowL:BYTE


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; VESAInit  ->  buffer
;; Checks for VESA BIOS and returns SVGA information.
;;
;; Expects:	nothing
;;
;; Returns:	VESABuffer = info
;;
;; Note:	ALL REGISTERS *DESTROYED*
;;
VESAInit	MACRO
		call	_VESAInit
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetModeInfo (mode)  ->  AX,buffer
;; Returns info on bank switching and virtual screen size.
;;
;; Expects:	mode (word)
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		VESABuffer = info
;;
GetModeInfo	MACRO	P1
		push	cx di
		mov	ax,4F01h
		mov	cx,P1
		Init_es_di VESABuffer
		DosInt	10h
		pop	di cx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetMode (mode)  ->  AX
;; Set video mode.
;;
;; Expects:	mode = [1--640x480 | 2--800x600 | 3--1024x768]
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetMode		MACRO	P1
		LOCAL	Skip1
		IFDIFI	<P1>,<1>
			IFDIFI	<P1>,<2>
				IFDIFI	<P1>,<3>
					ERR	"Invalid video mode number"
				ENDIF
			ENDIF
		ENDIF
		push	bx
		mov	ax,4F02h
		IFIDNI	<P1>,<1>
			mov	bx,101h
		ENDIF
		IFIDNI	<P1>,<2>
			mov	bx,103h
		ENDIF
		IFIDNI	<P1>,<3>
			mov	bx,105h
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		IFIDNI	<P1>,<1>
			mov	VESAWidth,640
			mov	VESAHeight,480
		ENDIF
		IFIDNI	<P1>,<2>
			mov	VESAWidth,800
			mov	VESAHeight,600
		ENDIF
		IFIDNI	<P1>,<3>
			mov	VESAWidth,1024
			mov	VESAHeight,768
		ENDIF
		mov	VESABank,0
		mov	VESAStartX,0
		mov	VESAStartY,0
Skip1:
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetMode ()  ->  BX,AX
;; Returns current mode.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= mode (bit 15 ignored)
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
GetMode		MACRO
		mov	ax,4F03h
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetBank (bank)  ->  AX (DX may be modified if an error occurs).
;; Hooks bank to window A.
;;
;; Expects:	bank (word)
;;
;; Returns:	ZF	= status (ZY--ok, ZN--error)
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
;;
SetBank		MACRO	P1
		LOCAL	Skip1
		push	bx
		IFDIFI	<P1>,<dx>
			push	dx
		ENDIF
		mov	ax,4F05h
		xor	bx,bx
		IFDIFI	<P1>,<dx>
			mov	dx,P1
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	VESABank,dx
Skip1:
		IFDIFI	<P1>,<dx>
			pop	dx
		ENDIF
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetScanLen (width)  ->  AX,BX,CX,DX
;; Sets virtual screen width.
;;
;; Expects:	width (word) in pixels
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		BX	= bytes per line
;;		CX	= virtual screen width in pixels
;;		DX	= maximal number of lines
;;
SetScanLen	MACRO	P1
		LOCAL	Skip1
		mov	ax,4F06h
		xor	bl,bl
		mov	cx,P1
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	word ptr VESAWidth,cx
		cmp	dx,word ptr VESAHeight
		jae	Skip1
		mov	word ptr VESAHeight,dx
Skip1:
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetScanLen ()  ->  AX,BX,CD,DX
;; Returns virtual screen width.
;;
;; Expects:	nothing
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		BX	= bytes per line
;;		CX	= virtual screen width in pixels
;;		DX	= maximal number of lines
;;
GetScanLen	MACRO
		mov	ax,4F06h
		mov	bl,1
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetScreenStart (first column,first line)  ->  AX
;; Sets position of the virtual screen's upper-left corner.
;;
;; Expects:	column # displayed first (word) -- 388
;;		line # displayed first (word) -- 0
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetScreenStart	MACRO	P1,P2
		LOCAL	Skip1
		push	bx
		IFDIFI	<P1>,<cx>
			push	cx
		ENDIF
		IFDIFI	<P2>,<dx>
			push	dx
		ENDIF
		mov	ax,4F07h
		xor	bx,bx
		IFDIFI	<P1>,<cx>
			mov	cx,P1
		ENDIF
		IFDIFI	<P2>,<dx>
			mov	dx,P2
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	WORD PTR VESAStartX,cx
		mov	WORD PTR VESAStartY,dx
Skip1:
		IFDIFI	<P2>,<dx>
			pop	dx
		ENDIF
		IFDIFI	<P1>,<cx>
			pop	cx
		ENDIF
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetDACPal (bits per RGB)  ->  AX
;; Sets number of bits per RGB.
;;
;; Expects:	number of bits per RGB (byte)
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetDACPal	MACRO	P1
		push	bx
		mov	ax,4F08h
		xor	bl,bl
		mov	bh,P1
		DosInt	10h
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetDACPal ()  ->  BX,AX
;; Returns number of bits per RGB.
;;
;; Expects:	nothing
;;
;; Returns:	BH	= number of bits per RGB
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
GetDACPal	MACRO
		mov	ax,4F08h
		mov	bl,1
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Sets Button colors.
;;
;; Expects:	Fg,Bg,U1,U2,L1,L2,Bd
;; 
;; Returns:	nothing
;;
ButtonCol	MACRO	P1,P2,P3,P4,P5,P6,P7
		mov	ButtonFg,P1
		mov	ButtonBg,P2
		mov	ButtonU1,P3
		mov	ButtonU2,P4
		mov	ButtonL1,p5
		mov	ButtonL2,P6
		mov	ButtonBd,P7
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Sets Window colors.
;;
;; Expects:	Fg,Bg,U,L
;; 
;; Returns:	nothing
;;
WindowCol	MACRO	P1,P2,P3,P4
		mov	WindowFg,P1
		mov	WindowBg,P2
		mov	WindowU,P4
		mov	WindowL,P6
		ENDM

BuTerm		EQU	DD 0

DBu		STRUC
BuFunc		DD	?		; func
BuX		DW	?		; x
BuY		DW	?		; y
BuType		DB	?		; type
BuText		DB	8 DUP(?)	; text
DBu		ENDS

WinDef		STRUC
		DW	?		; x-pos
		DW	?		; y-pos
		DW	?		; x-size
		DW	?		; y-size
WinDef		ENDS

WinEnds		EQU	DB 0

WinTitle	MACRO	TitleText
		DB	1,TitleText,0
		ENDM

WinText		MACRO	XPos,YPos,Text
		DB	2
		DW	XPos,YPos
		DB	Text,0
		ENDM

WinTxt		MACRO	XPos,YPos,Text
		DB	2
		DW	10+9*XPos,30+16*YPos
		DB	Text,0
		ENDM

WinH		MACRO	XPos,YPos,XSize,YSize
		DB	3
		DW	XPos,YPos,XSize,YSize
		ENDM

WinHText	MACRO	XPos,YPos,Len,Text
		WinH	XPos,YPos,Len*9+10,20
		WinText XPos+5,YPos+2,Text
		ENDM

WinL		MACRO	XPos,YPos,XSize,YSize
		DB	4
		DW	XPos,YPos,XSize,YSize
		ENDM

WinLText	MACRO	XPos,YPos,Len,Text
		WinL	XPos,YPos,Len*9+10,20
		WinText XPos+5,YPos+2,Text
		ENDM

Dialog		STRUC
		DD	?		; win struc
		DD	?		; button struc
		DD	0		; right mouse click
		DD	0		; function
Dialog		ENDS

RetC		MACRO
		clc
		ret
		ENDM

RetX		MACRO
		stc
		ret
		ENDM
