#!/usr/local/bin/perl
#######################################################################
### otb.pl (OneTimeBoot) (c) IV 1998 Tomasz "Beret" Kawecki         ###
### This file is a part of BSL 1.20 package.                        ###
#######################################################################
### OPTIONS ###
# $RPATH must be a path to the *ROOT* directory of FAT16 partition
# (primary or logical) set in BSL.INI in [Main_MBR]
# 'OneTimeBootPartition' option.
# Notes: At the end og $RPATH must be '/' !
#        Do not use backslash '\', even in DOS. Use only slash '/'.
# $RPATH = "/usr/local/msdos/c/";
# $RPATH = "d:/";
$RPATH = "c:/";

# $RB_EXE is a name of the program that can reboot computer. This name
# depends on your operating system (e.g. reboot, down, shutdown, etc.)
$RB_EXE = "reboot";
#######################################################################
####         Do not change anything below this line !!             ####
#######################################################################
$FILE = $RPATH . "bsl_otb.ini";
$part = "\U$ARGV[0]";
$sd = "\U$ARGV[1]";
$rb = "\U$ARGV[2]";

printf "otb.pl (c) IV 1998 Tomasz \"Beret\" Kawecki\n";
&help unless (('0' le $part) && ($part le '9')) || (('A' le $part) && ($part le 'C'));

$p = ord ($part) - ord ('0');
$p = ord ($part) - ord ('A') + 10 if 'A' le $part;
if ($p) {
  $p |= 0x80 if $sd eq "+";
  $p |= 0x40 if $sd eq "-";
}
$c = chr ($p);

open (FI,">$FILE") || die "Cannot open file $FILE !\n";
binmode (FI);
printf FI "$c";
close (FI) || die "Cannot close file $FILE !\n";
if ($p) { printf "OneTimeBoot changed to partition $part.\n" }
   else { printf "OneTimeBoot disabled.\n" }
&reboot if $sd eq "RB" || $rb eq "RB";

#----------------------------------------------------------------------
sub help {
  printf "\nOTB.PL saves one byte file in root directory of FAT16 partition.\n";
  printf "BSL's MBR uses this file for OneTimeBoot feature.\n\n";
  printf "Usage: otb.pl  [0,1..9,A,B,C]  [ |+|-]  [rb]\n";
  printf " 1st parameter - required - Partitions:\n";
  printf "   0 = disable 'OneTimeBoot'; 1..9,A,B,C = run this partition;\n";
  printf " 2nd parameter - optional - like /S option from BSL.EXE:\n";
  printf "   'NOTHING' means \"Use current 'StoreDefault' mode saved in BSL's MBR\"\n";
  printf "   '-' means \"NEVER save 'OneTimeBoot' partition\"\n";
  printf "   '+' means \"ALWAYS save 'OneTimeBoot' partition\"\n";
  printf " 2nd/3rd parameter - optional:\n";
  printf "   'rb' means \"Reboot computer\"\n\n";
  printf " Examples:\n";
  printf "   otb.pl 0\n   otb.pl 2 - rb\n";
  printf "   otb.pl 1 +\n   otb.pl 7 rb\n";
  exit;
}

sub reboot {
  exec "$RB_EXE";
  printf "Reboot failed!\n";
}

__END__
