/****************************************************************************/
/* INPUTBOX                                                                 */
/*--------------------------------------------------------------------------*/
/* Affiche un message dans une boite de dialogue, attend que l'utilisateur  */
/* saisisse du texte et choisisse un bouton,et retourne le texte saisi      */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 12/05/95                                                    */
/****************************************************************************/

#include "Settings.h"

#include "Vocab.h"

#include "JPAppli.h"
#include "Mouse.h"
#include "Screen.h"
#include "Strings.h"

#include "TEdzone.h"
#include "TLabel.h"
#include "TPassEdz.h"
#include "TPushBut.h"
#include "TWindow.h"

#include "InputBox.h"

/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/

#define MARGIN_WIDTH      3
#define MARGIN_HEIGHT     2

#define MAX_WINDOW_WIDTH  (GetScreenWidth()-6)
#define MAX_WINDOW_HEIGHT (GetScreenHeight()-4)

#define TOTAL_BUTTON_HEIGHT  3   // Sans les ombres

/*ͻ*/
/*                            VARIABLES STATIQUES                         */
/*ͼ*/

static int s_button_pressed;

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

static char *InputBoxButtonText(int button_number)
{
  return(GetString((button_number==0)?VOC_OK_CAPTION:VOC_CANCEL_CAPTION));
}

static int InputBoxButtonWidth()
  {
    register int ok_width    =DisplayLength(InputBoxButtonText(0));
    register int cancel_width=DisplayLength(InputBoxButtonText(1));

    return(MAX(ok_width,cancel_width)+4);
  }


static void InputBoxButtonPressedCall(PObject /*sender*/,char *button_number)
{
  s_button_pressed=button_number[0]-'0';
  JPStop();
}

/****************************************************************************/
/* InputBox                                                                 */
/*--------------------------------------------------------------------------*/
/* Affiche un message dans une boite de dialogue, attend que l'utilisateur  */
/* saisisse du texte et choisisse un bouton,et retourne le texte saisi      */
/* (retourne "" en cas d'annulation).                                       */
/*--------------------------------------------------------------------------*/
/* title         : Titre de la bote de dialogue                            */
/* message       : Message  afficher                                       */
/* window_style  : Style de la fentre                                      */
/* default_string: Texte par dfaut                                         */
/* max_length    : Longueur maximale du texte saisi.                        */
/* return_string : Chaine qui en sortie contient le texte saisi             */
/*                 (doit tre de longueur max_length(+1)                    */
/* type          : Type de l'InputBox                                       */
/*--------------------------------------------------------------------------*/
/* Retourne le type de bouton choisi par l'utilisateur.                     */
/****************************************************************************/


void InputBox(char *title,char *message,int window_style,
	      char *default_string,int max_length,char *return_string,
	      int type)
{
  TMousePointer pointer;

  int           tmp;

  int           message_height,
		message_width;

  int           window_width,
		window_height,
		upper_part_height,
		margin_width,
		title_height,
		edzone_width;

  int      	x_button;
  int      	y_button;
  int      	button_width;


  PWindow  	input_box;
  PLabel   	message_label;

  PPushButton   button[2];

  PEditZone     edzone;

  int           max_window_width=MAX_WINDOW_WIDTH;
  int           max_window_height=MAX_WINDOW_HEIGHT;


  button_width=InputBoxButtonWidth();

  message_height=GetTextHeight(message);
  message_width=GetTextWidth(message);

  window_width=3*MARGIN_WIDTH+message_width+button_width;
  if (window_width>max_window_width)
    window_width=max_window_width;

  tmp=DisplayLength(title)+2;
  if (tmp>max_window_width)
    tmp=max_window_width;

  if (tmp>window_width)
    window_width=tmp;

  edzone_width=max_length+3;
  tmp=edzone_width+2;

  if (tmp>max_window_width)
    tmp=max_window_width;

  if (tmp>window_width)
    window_width=tmp;

  upper_part_height=MAX(TOTAL_BUTTON_HEIGHT,message_height);

  title_height=(title[0]==0)?0:1;
  window_height=3*MARGIN_HEIGHT+upper_part_height+1+title_height;
		   // +1 pour la zone de saisie

  // Vraie dimension des zones

  if (window_height>max_window_height)
    {
      message_height-=(window_height-max_window_height);
      window_height=max_window_height;
      upper_part_height=MAX(TOTAL_BUTTON_HEIGHT,message_height);
    }

  tmp=(window_width-button_width-(3*MARGIN_WIDTH)); // Disponible pour message
  if (tmp<message_width)
    message_width=tmp;

  margin_width=(window_width-message_width-button_width)/3;

  tmp=window_width-2; // Disponible pour zone d'dition
  if (tmp<edzone_width)
    edzone_width=tmp;

  input_box=new TWindow(window_style,
			((GetScreenWidth()-window_width)>>1)+1,
			((GetScreenHeight()-window_height)>>1)+1,
			window_width,window_height,title,NO_INFO_BAR,MODAL,MOVABLE);

  message_label=new TLabel(input_box,
			   margin_width,
                           title_height+MARGIN_HEIGHT+((upper_part_height-message_height)>>1),
                           message_width,message_height,
                           message);

  x_button=2*margin_width+message_width;
  y_button=title_height+MARGIN_HEIGHT;

  button[0]=new TPushButton(input_box,
                            x_button,
                            y_button,
			    button_width,
			    InputBoxButtonText(0),
			    PB_DEFAULT);

  button[1]=new TPushButton(input_box,
			    x_button,
			    y_button+2,
			    button_width,
			    InputBoxButtonText(1),
                            PB_CANCEL);

  if (type == IB_PASSWORD)
    {
      edzone=new TPasswordEditZone(input_box,
			   (window_width-edzone_width)>>1,
			   window_height-MARGIN_HEIGHT-1,
			   0,0,
			   "",
			   edzone_width-2,
			   max_length,
			   default_string);
    }
  else
    {
      edzone=new TEditZone(input_box,
			   (window_width-edzone_width)>>1,
			   window_height-MARGIN_HEIGHT-1,
			   0,0,
			   "",
			   edzone_width-2,
			   max_length,
			   default_string);
    }

  button[0]->m_set_pressed_callback(InputBoxButtonPressedCall,"0");
  button[1]->m_set_pressed_callback(InputBoxButtonPressedCall,"1");

  pointer=GetMousePointer();
  SetMousePointer(MP_ARROW);
  edzone->m_set_focus();
  input_box->m_open();
  JPRunDialog();
  input_box->m_close();
  SetMousePointer(pointer);


  JPRefresh();

  if (s_button_pressed==0)
    strcpy(return_string,edzone->m_get_string());
  else
    strcpy(return_string,"");

  delete edzone;

  delete button[1];
  delete button[0];

  delete message_label;

  delete input_box;

}
