/****************************************************************************/
/* TMENU                                                                    */
/*--------------------------------------------------------------------------*/
/* TMenu class (menus)                                                      */
/****************************************************************************/

#ifndef _TMENU_H_
#define _TMENU_H_

#include "Types.h"

#include "TList.h"


/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

// Elment du menu

typedef struct {char *label;
		int   attribute;
		int   short_cut;
		char  *help_message;} TMenuItem;


/*ͻ*/
/*                             CLASS DEFINITION                           */
/*ͼ*/


class TMenu:public TList
{
  /*----------------*/
  /* Friend classes */
  /*----------------*/

  friend TMenuBar;

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Menu bar

    PMenuBar            f_menu_bar;

    // Menu number (!= object number)

    int     	        f_menu_nb;

    // The size of the menu needs to be calculated again

    boolean 		f_size_to_adjust;

    // Width needed to display shortcuts
    // (only significant if  f_size_to_adjust==FALSE)

    int     		f_short_cut_width;

    // Callback invoked when an item of the menu is clicked

    void     		(*f_item_clicked_action)(PObject,int,char *);
    char     		*f_item_clicked_argument;

  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor / Destructor

    // See TList.h for TMenuItem (m_add_items)

			TMenu(PMenuBar menu_bar,
			      char *caption,
			      TMenuItem items[]=NULL,
			      boolean enabled=TRUE);
    virtual             ~TMenu();

    // Returns the menu-bar of the menu

	    PMenuBar    m_get_menu_bar() { return(f_menu_bar);};

    // Disables the menu

    virtual void        m_disable();

    // Opens the menu. Returns FALSE if it can't be open

	    boolean     m_open();

    // Closes the menu

	    void        m_close();

    // Clicks an item as if the user had clicked it with the mouse,
    // pressed its hotkey...

	    void        m_click_item(int item_index);

    // Add a item to the menu
    // Returns its index or 0 if it couldn't have been added

    virtual int         m_add_item(char *label,int attribute=LI_NOATTR,int short_cut=SC_NONE,char *help_message="") {return(m_insert_item(0,label,attribute,short_cut,help_message));};
    virtual int         m_insert_item(int index,char *label,int attribute=LI_NOATTR,int short_cut=SC_NONE,char *help_message="");

    // Add severals items to the menu
    // Each item is of type TListItem
    // For the last item, item[].label must be NULL

    // Returns the number of items really added

    virtual int         m_add_items(TMenuItem items[]);

    // Deletes items

    virtual void        m_delete_item(int item_index);
    virtual void        m_clear_list();


    // Defines the callbacks

	    void        m_set_item_clicked_callback(void (*item_clicked_action)(PObject,int,char *),char *item_clicked_argument);

  /*-------------------*/
  /* Protected methods */
  /*-------------------*/

  protected:

    // Display routines

    virtual void        m_display();

    // Callbacks

    virtual void        m_selected_item_changed_callback();
    virtual void        m_nb_items_changed_callback();
    virtual void        m_item_clicked_callback(int item_index);

    // Events

    virtual boolean     m_short_cut_pressed_event(int shortcut);


  /*-----------------*/
  /* Private methods */
  /*-----------------*/

  private:

    // Display routines

      virtual void      m_display_item_node_label(PItemNode node,boolean show_hot_key);

    // Changes the size of the menu so that all its items can be seen

	    void        m_adjust_size();

    // Events

    virtual boolean     m_leave_event_if_mouse_leave_list(int x,int y);
    virtual void        m_item_hot_key_pressed_event(int item_index);


};

#endif