/****************************************************************************/
/* TTABGRP                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TTabGroup (Groupe d'onglets)                                       */
/****************************************************************************/

#ifndef _TTABGRP_H_
#define _TTABGRP_H_

#include "Types.h"

#include "Keyboard.h"

#include "TGroup.h"



class TTabGroup:public TGroup
{
  /*---------------*/
  /* Classes amies */
  /*---------------*/

  friend TTab;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // Nombre d'onglets en largeur

    int     f_nb_tabs_width;

    // Onglet visible

    PObjectNode
            f_visible_tab;

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TTabGroup(PObject parent,
			      int rel_x,int rel_y,
			      int width,int height,
			      unsigned background,
                              boolean enabled=TRUE);
    virtual         ~TTabGroup();

    // Mthodes d'accs

    // Donne le focus au groupe (au 1er/dernier de ses objets qui le veut)

    virtual boolean m_set_focus();
    virtual boolean m_set_focus_to_last_element();


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:


    // Ajout d'un onglet

    virtual int     m_add_element(PObject object);
    virtual void    m_del_element(int object_number);

    // Ouverture/Fermeture du groupe

    virtual void    m_set_open(boolean open);


    // Affichage

    virtual void    m_display();

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_left_button_double_click_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_focus_depending_part();
            void    m_display_tab_caption(int tab_nb);

    // Donne le dbut et la largeur d'un des titres des onglets

            void    m_get_tab_caption_pos(int tab_nb,int &rel_x1,int &rel_x2);


    // Evnements

    virtual boolean m_tab_pressed_event() { return(FALSE);};
    virtual boolean m_shift_tab_pressed_event(){ return(FALSE);};

	    void    m_set_visible_tab(int tab_number);

    // L'objet peut obtenir le focus lors d'un dplacement
    // avec les touches flches

    virtual boolean m_focus_can_be_set_by_arrow_key() {return(TRUE);};
};

#endif
