/* Power Render Input Device Interface */

#ifndef _PRINPUT_
#define _PRINPUT_

#ifdef __cplusplus
  extern "C" {
#endif

#define INPUT_KEYBOARD 0
#define INPUT_MOUSE 1

#define MODEL_WALKING 0
#define MODEL_FLYING 1
#define MODEL_STEER 2
#define MODEL_INSPECT 3

/* When input is attached to a camera only */
#define NO_ENTITY NULL
#define NO_SEGMENT -1

extern PR_DWORD PR_InputDevice;             /* Input device */
extern PR_DWORD PR_InputModel;              /* Movement type */
extern PR_ENTITY *PR_InputEntity;           /* Entity attached to input */
extern PR_DWORD   PR_InputSegment;          /* Segment attached to input */
extern PR_CAMERA *PR_InputCamera;           /* Camera attached to input */

extern PR_REAL currentspeed;
extern PR_REAL rollspeed;
extern PR_REAL pitchspeed;
extern PR_REAL yawspeed;

extern PR_REAL TRANSLATE_SPEED;
extern PR_REAL MAX_TRANSLATE_SPEED;
extern PR_REAL TRANSLATE_DRAG;

extern PR_REAL PITCH_SPEED;
extern PR_REAL MAX_PITCH_SPEED;
extern PR_REAL PITCH_DRAG;

extern PR_REAL YAW_SPEED;
extern PR_REAL MAX_YAW_SPEED;
extern PR_REAL YAW_DRAG;

extern PR_REAL ROLL_SPEED;
extern PR_REAL MAX_ROLL_SPEED;
extern PR_REAL ROLL_DRAG;
extern PR_REAL cambase_roll;  /* 0 or 180 depending on orientation */
extern PR_REAL oribase_roll;  /* 0 or 180 depending on orientation */


/* Functions */
void PR_ReadInput (void);
/* Reads input from the user, based on the movement model */


void PR_SetInputCamera (PR_CAMERA *cam);
/* Sets the camera attached to the input device */


void PR_SetInputDevice (PR_DWORD devicetype);
/* Sets the input device used for controlling the objects */


void PR_SetInputEntity (PR_ENTITY *entity, PR_DWORD segnum);
/* Sets the entity and segment attached to the input device */


void PR_SetInputModel (PR_DWORD modeltype);
/* Sets the viewing model used */


void SmoothMove (PR_REAL *value, PR_REAL amount, PR_REAL max,
                 PR_REAL drag);
/* Adds one value to another, checks for a maximum value, and
   adds a drag factor if the amount is 0 */


#ifdef __cplusplus
}
#endif

#endif
