#include <stdio.h>
#include <direct.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>

#include <pr.h>
#include <prgui.h>

#ifdef __3DFX__
#include <glide.h>
#include <pr3dfx.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

LWO Conversion Utility

Converts Lightwave files to Power Render PRO files.

*/


char outfile[80];               /* Name of the output file */
PR_REAL scale;
PR_OBJECT *object;
PR_DWORD choice;
PR_DWORD device;


void InitializeDevices (void)
{
#ifdef __MYST__
  if ((device == DEVICE_MYSTIQUE) || (device == DEVICE_ANY))
    device = PR_DetectMystique ();
#endif

#ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  #if defined (MSDD) || defined (WTDD)
    if ((device == DEVICE_D3D) || (device == DEVICE_ANY))
      device = PR_DetectD3D ();   /* Attempt to find the device */
  #endif

  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   /* Attempt to find the device */

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   /* Attempt to find the device */
#endif

#ifdef __MYST__
  if (device == DEVICE_MYSTIQUE)
    {
     PR_InitializeMystique ();
     atexit (PR_ShutdownMystique);
    }
#endif

#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  #if defined (MSDD) || defined (WTDD)
  if (device == DEVICE_D3D)
    {
     PR_InitializeD3D ();
     atexit (PR_ShutdownD3D);
    }
  #endif
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
     atexit (PR_ShutdownVGA);
    }
#endif
}





void Fix_EnvMap (PR_OBJECT *obj)
{
PR_SEGMENT *segptr;
PR_MATERIAL *matptr;
PR_FACE *faceptr;
PR_DWORD seg, face;
  
  for (seg = 0; seg < obj->num_segments; seg++)
    { /* For every segment */

     segptr = &obj->segment_list[seg];
     segptr->flags &= ~FLAG_NORMALS;    /* Clear out the normals flag */

     for (face = 0; face < segptr->num_faces; face++)
       { /* For every face */

        faceptr = &segptr->face_list[face];
        matptr = &PR_ObjectMaterialList[faceptr->material];

        if (matptr->environment_map)
          segptr->flags |= FLAG_NORMALS;

        matptr = &PR_ObjectMaterialList[faceptr->backmaterial];
        if (matptr->environment_map)
          segptr->flags |= FLAG_NORMALS;
       }
    }

}



void main (int argc, char *argv[])
{
PR_DWORD argnum;
PR_DWORD loadmode = 0;

  scale = 1;

  PRGUI_InitPath (argv[0]);
  PRGUI_SetUserPath ();

  if (argc < 2)
    {
     PR_FatalError (
           "LWO2PRO Conversion Utility    version "
           PR_VERSION_NUMBER
           "\nCopyright 1997 Egerter Software\n\n"
           "Usage: \n"
       "LWO2PRO filename.LWO [options]\n"
       "\n"
       "Options:\n"
       "-s scale      Changes scaling factor\n"
       "-t ext        Imports textures, using extension (not supported yet)\n"
       "              ext = [PCX, 3DF, IFF, BLK, PAK]\n", "LWO2PRO");
    }

  printf ("LWS2PRO Conversion Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");


#if defined (MSGLIDE) || defined (WTGLIDE)
  device = DEVICE_3DFX;
#else
  device = DEVICE_SVGA;
#endif
  loadmode = LOAD_IGNORE_TEXTURES;

  argnum = 2;
  while (argnum < argc)
    {
     if (!strcmp (argv[argnum], "-s"))
       if (argc > argnum)
         {
          scale = atof (argv[argnum+1]);
          printf ("Scaling Factor: %f\n", scale);
          argnum++;
         }

     if (!strcmp (argv[argnum], "-t"))
       if (argc > argnum)
         {
          strcpy (L3DS_TextureExtension, argv[argnum+1]);
          if (strcmp (L3DS_TextureExtension, "3DF") == 0)
            device = DEVICE_3DFX;
          printf ("Textures Enabled\nTexture Extension: %s\n", L3DS_TextureExtension);
          loadmode = LOAD_NORMAL;
          argnum++;
         }
     argnum++;
    }


  PR_Initialize (50);

  InitializeDevices ();

#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    PR_Shutdown3Dfx ();
#endif

#ifndef WIN32
  wsetmode (3);
#endif


  PR_AllocMaterials (255);
  PR_AllocShadeTables (32);
  PR_AllocTextures (256);

  object = PR_LoadLWO (argv[1], scale, loadmode);
  if (object == NULL)
    PR_FatalError ("An error has occurred when loading the LWO file.\n", "LWO2PRO");


  strcpy (outfile, argv[1]);
  outfile[strlen(outfile)-4] = '\0';
  strcat (outfile, ".PRO");

  if (PRGUI_FileExists (outfile))
    {
     #ifdef WIN32
     if (MessageBox(NULL, "The file already exists! Overwrite?\n",
                 "LWO2PRO", MB_OKCANCEL) != IDOK)
                exit (1);
         #else
     printf ("%s already exists! Overwrite? (Y/N)\n",
            outfile);
     do {
       choice = toupper (getch ());
     } while (choice != 'N' && choice != 'Y');

     if (choice == 'N')
       exit (1);
     #endif
    }


  PR_InitializeFaceNormals (object);
  PR_InitializeVertexNormals (object);
  Fix_EnvMap (object);

  PR_SavePRO (outfile, object, SAVE_ALL_MATERIALS);
}



