#include <d3d.h>


/* D3D Capabilities related to Power Render */
typedef struct {
  PR_DWORD BilinearFiltering;
  PR_DWORD AlphaBlend;
  PR_DWORD AlphaStipple;
  PR_DWORD FogTable;
  PR_DWORD AlignBoundarySrc;
 } PR_D3D_CAPSSTRUCT;
extern PR_D3D_CAPSSTRUCT PR_D3D_Caps;


#define D3DAPP_MAXD3DDRIVERS 5
/*
 * D3DAppD3DDriver structure
 * Describes a D3D driver
 */
typedef struct {
    char Name[30];	/* short name of the driver */
    char About[128];     /* short string about the driver */
    D3DDEVICEDESC Desc; /* D3DDEVICEDESC for complete information */
    GUID Guid;		/* it's GUID */
    BOOL bIsHardware;	/* does this driver represent a hardware device? */
    BOOL bDoesTextures; /* does this driver do texture mapping? */
    BOOL bDoesZBuffer;  /* can this driver use a z-buffer? */
    BOOL bCanDoWindow;	/* can it render to Window's display depth? */
} D3DAppD3DDriver;


/* Interface and Device */
extern LPDIRECT3D2 wgtd3d;
extern LPDIRECT3DDEVICE2 wgtd3ddev;

/* Drivers */
extern D3DAppD3DDriver PR_D3D_Drivers[D3DAPP_MAXD3DDRIVERS]; /* avail. drivers*/
extern PR_DWORD PR_D3D_NumDrivers;
extern PR_DWORD PR_D3D_CurrentDriver;

/* Z Buffer */
extern LPDIRECTDRAWSURFACE2 PR_D3D_ZBuffer;
extern PR_DWORD PR_D3D_ZBufferInVideo;


/* Background material */
extern D3DMATERIALHANDLE PR_D3D_BackgroundHandle;
extern LPDIRECT3DMATERIAL2 PR_D3D_BackgroundObj; 
extern D3DMATERIAL PR_D3D_BackgroundMaterial;

/* Viewport */
extern D3DVIEWPORT PR_D3D_Viewport;
extern LPDIRECT3DVIEWPORT2 PR_D3D_ViewportObj;

extern D3DTLVERTEX PR_D3D_vertices[3];
extern LPDIRECT3DTEXTURE *PR_D3D_TextureObjs; /* texture objs */


void PR_InitializeRenderMethods (void);
/* Sets the initial rendering methods array */

#define RENDERFLAG_PRESORT 1
extern PR_DWORD PR_MethodFlags[256];
void PR_RegisterRenderMethod (int method_number, void (*MethodProc)(),
                PR_DWORD flags);
/* Sets the routine used for initializing the state data for a particular
   rendering method. This is used to add new rendering methods to the
   ones existing in Power Render.  */


PR_DWORD PR_DetectD3D (void);
/* -----------------------------------------------------------------------
   Function:   PR_DetectD3D
   Purpose:    Looks for the presence of Direct 3D modes
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_InitializeD3D (void);
/* -----------------------------------------------------------------------
   Function:   PR_InitializeD3D
   Purpose:    Initialize the virtual functions for DirectDraw
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_SetModeD3D (PR_DWORD width, PR_DWORD height, PR_DWORD refrate);
/* -----------------------------------------------------------------------
   Function:   PR_SetModeD3D
   Purpose:    Attempts to initialize a video mode 
   Parameters: width - width of mode
               height - height of mode
               refrate - refresh rate
   Return:     MODE_INVALID, MODE_SUCCESS
   ----------------------------------------------------------------------- */


void PR_ShutdownD3D (void);
/* -----------------------------------------------------------------------
   Function:   PR_ShutdownD3D
   Purpose:    Shuts down a display device 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_BarD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_BarD3D
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreenD3D (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreenD3D
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLineD3D (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLineD3D
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_LineD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_LineD3D
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */

PR_UDWORD PRGFX_MakeColorD3D (PR_DWORD r, PR_DWORD g, PR_DWORD b);
/* -----------------------------------------------------------------------
   Function:   PRGFX_MakeColorD3D
   Purpose:    Returns a color value for the RGB value given
   Parameters: r,g,b - Red, green, blue components (0-64)
   Return:     Packed color value (RGBA8888)
   ----------------------------------------------------------------------- */


void PRGFX_ReadRegionD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1, block image);
/* ------------------------------------------------------------------------
   Function:   PRGFX_ReadRegionD3D
   Purpose:    Grabs a section of the render buffer into memory
               Used internally by newblock and mouse routines
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     None
   ----------------------------------------------------------------------- */


block PRGFX_NewBlockD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* ------------------------------------------------------------------------
   Function:   PRGFX_NewBlockD3D
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXYD3D (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXYD3D
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlockD3D (PR_DWORD x, PR_DWORD y,
                        PR_DWORD width, PR_DWORD height,
                        block buffer);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlockD3D
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bitD3D (PR_DWORD x, PR_DWORD y, block src, color *pal,
                            PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bitD3D
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTextureD3D (PR_DWORD x, PR_DWORD y, PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTextureD3D
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_RectangleD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_RectangleD3D
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTextureD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1,
                                  PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTextureD3D
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetColorD3D (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetColorD3D
   Purpose:    Sets the current drawing color
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLineD3D (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLineD3D
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */

void PR_AddElementD3D (PR_FACE *elemptr, PR_VERTEX *pointlist,
                        PR_VERTEX_DATA *pointdata, PR_DWORD count);
/* Adds a face to the rendering list if it is visible */


void PR_RenderFrameD3D (void);
/* Renders all faces in the rendering list to the viewport */

void PR_SetFogColorD3D (PR_DWORD col);

void PR_SetFogStateD3D (PR_DWORD state);
/* Sets the global fog rendering state (0 or 1) */

void PR_SetFogRangeD3D (PR_REAL near_dist, PR_REAL far_dist);
/* Sets the range of fog */


PR_DWORD PR_AddTextureD3D (char *filename, block image);
/* -----------------------------------------------------------------------
   Function:   PR_AddTextureD3D
   Purpose:    Adds a texture to the PR_WorldTextures array
   Parameters: filename - Filename of the texture (must be present)
               image - 8 bit texture image
   Return:     Texture number
   ----------------------------------------------------------------------- */


void PR_AllocTexturesD3D (PR_DWORD maxtexture);
/* -----------------------------------------------------------------------
   Function:   PR_AllocTexturesD3D
   Purpose:    Allocates room for a list of textures
   Parameters: maxtexture - Number of textures positions to allocate
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ReleaseTextureD3D (PR_DWORD texnum);
/* -----------------------------------------------------------------------
   Function:   PR_ReleaseTextureD3D
   Purpose:    Releases a texture in video memory so another texture can be
               swapped in.
   Parameters: texnum - Texture number to release
   Return:     None
   ----------------------------------------------------------------------- */


void PR_DeleteAllTexturesD3D (void);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteAllTexturesD3D
   Purpose:    Deletes all the textures from the PR_WorldTextures array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_LoadTextureD3D (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_LoadTextureD3D
   Purpose:    Loads the texture if it hasn't been already
   Parameters: filename - Filename of the texture to load
   Return:     Texture number
   ----------------------------------------------------------------------- */


PR_DWORD PR_DownloadTextureD3D (PR_DWORD texnum, PR_DWORD force);
/* -----------------------------------------------------------------------
   Function:   PR_DownloadTextureD3D
   Purpose:    Loads the texture into the video memory.
               If force is true, it may release other textures in order
               to make room.
   Parameters: texnum - Texture number
               force - TRUE or FALSE
   Return:     TRUE if the texture was loaded
   ----------------------------------------------------------------------- */


PR_UDWORD PR_GetTextureMemoryD3D (void);
/* -----------------------------------------------------------------------
   Function:   PR_GetTextureMemoryD3D
   Purpose:    Returns how much texture memory the 3D card has.
   Parameters: None
   Return:     Amount of texture memory
   ----------------------------------------------------------------------- */


void PR_SelectTextureD3D (PR_DWORD texnum);
/* -----------------------------------------------------------------------
   Function:   PR_SelectTextureD3D
   Purpose:    Prepares the hardware for using a texture.  Other textures
               may be swapped out from this routine.
   Parameters: texnum - Texture number to select
   Return:     None
   ----------------------------------------------------------------------- */


