/* Power Render Graphics Interface */

#ifndef _PRGFX_
#define _PRGFX_

#ifdef __cplusplus
  extern "C" {
#endif

extern PR_UDWORD PR_CurrentColor;
extern PR_UDWORD PR_TextForeground;
extern PR_UDWORD PR_TextBackground;
extern PR_UDWORD PR_TextTransparent;


void PRGFX_SetTextBackground (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextBackground
   Purpose:    Sets the background color of text
   Parameters: col - Color index or packed value 
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetTextForeground (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextForeground
   Purpose:    Sets the foreground color of text
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetTextTransparent (PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextTransparent
   Purpose:    Sets the transparent flag of text
   Parameters: mode - TEXTFG, TEXTBG, or TEXTFGBG
   Return:     None
   ----------------------------------------------------------------------- */



void PRGFX_BarDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_BarDDraw
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreenDDraw (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreenDDraw
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClipDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClipDDraw
   Purpose:    Sets the clipping region in device coordinates
   Parameters: x0, y0, x1, y1 - Clipping rectangle
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLineDDraw (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLineDDraw
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_LineDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_LineDDraw
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


PR_UDWORD PRGFX_MakeColorDDraw (PR_DWORD r, PR_DWORD g, PR_DWORD b);
/* -----------------------------------------------------------------------
   Function:   PRGFX_MakeColorDDraw
   Purpose:    Returns a color index closest to the RGB value given
   Parameters: r,g,b - Red, green, blue components (0-64)
   Return:     Index to the closest color
   ----------------------------------------------------------------------- */


block PRGFX_NewBlockDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_NewBlockDDraw
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXYDDraw (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXYDDraw
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlockDDraw (PR_DWORD x, PR_DWORD y, PR_DWORD width,
                        PR_DWORD height, block src);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlockDDraw
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bitDDraw (PR_DWORD x, PR_DWORD y, block src, color *pal,
                            PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bitDDraw
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTextureDDraw (PR_DWORD x, PR_DWORD y, PR_DWORD texnum,
                          PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTextureDDraw
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_RectangleDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_RectangleDDraw
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTextureDDraw (PR_DWORD x0, PR_DWORD y0,
                             PR_DWORD x1, PR_DWORD y1,
                             PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTextureDDraw
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetColorDDraw (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetColorDDraw
   Purpose:    Sets the current drawing color
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLineDDraw (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLineDDraw
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */






#ifdef __cplusplus
}
#endif

#endif

