; COMMON.INC
; (c) 1989, 1990 Ashok P. Nadkarni
;
; Common definitions for CMDEDIT

;added by jmh 980511 - if you don't want 286 instructions, set this to zero.
i286		equ	1

if i286
.286
endif

;wd put comments in IFNDEF - ENDIF below to prevent TASM
;   doing a compatibility pass.  Remove the comments and
;   define TSR if you want to do that sort of testing.
;	IFNDEF	TSR
TSR		equ	1		;1 if we should TSR. If 0,
;					 used for debugging without TSRing
;	ENDIF

STACK_SIZE	equ	512		;Stack size after TSR'ing
					;(made 256 bytes smaller by jmh)
LINEBUF_SIZE	equ	256		;Max size of line storage
;					 buffer. Do NOT change this
;					 since applications can specify
;					 buffers upto this size.

; Min size for various string stack buffers
DOSSIZE_MIN	equ	4		;DOS history, 2 for sentinel +
;					 2 for top of history sentinel
MACROSIZE_MIN	equ	5		;Macro buffer, 2 for sentinel +
;					 3 for separator
SYMSIZE_MIN	equ	5		;Symbol buffer, same as MACROSIZE_MIN
IFNDEF NODIRS
DIRSIZE_MIN	equ	2		;Directory stack, 2 for sentinel
ENDIF
; Maximum size of all buffers (including stack) added by jmh 980506
MAX_BUFFER_SIZE equ	4096

TOGGLE_CURSOR	equ	1		;toggle cursor between 
;					 overwrite and insert modes
EXTRA_HANDLER	equ	0		;added by wd:
;  set above to 1 to include 0EAh line-input handler

; Uncomment the following line to remove all the directory code (jmh 980508)
;NODIRS 	equ	0

; Error codes for routine abort_processing. These codes must be in the
; same order as the error messages in table abort_msg_table in cmdedit.asm
E_TRUNCATE	equ	0		;Line too long
E_SIGNAL	equ	1		;User signal received
E_NESTED_MACRO	equ	2		;Nested macro def     jmh changed order
E_NESTED_DELM	equ	3		;delm inside a macro   to accomodate the
E_CTRL_BREAK	equ	4		;Ctrl-Break received   lack of the dir
IFNDEF NODIRS				;		       commands (9/3/97)
E_DIRSTK_EMPTY	equ	5		;Empty directory stack
E_DIRSTK	equ	6		;Other dir stack error
E_DIRSTK_DOS	equ	7		;Directory stack only for DOS
ENDIF

VAR_MARKER	equ	'%'

;Set the following to 1 to have CmdEdit display it's own colourful $p$g prompt
;(jmh 980710 - see notes in cmdedit.asm)
CMD_PROMPT	equ	0
;The colours used for the prompt (btw, I use a b.yellow on blue screen)
DRIVE_COL	equ	27	;Drive and colon,     bright cyan   on blue
SLASH_COL	equ	30	;Directory separator, bright yellow on blue
DIR_COL 	equ	26	;Directory,	      bright green  on blue
GT_COL		equ	30	;Greater than sign,   bright yellow on blue
CMD_COL 	equ	31	;Command line,	      bright white  on blue
