; EDIT.ASM
; (c) 1989, 1990 Ashok P. Nadkarni
;
; This module contains the line editing functions of CMDEDIT.
; Macro disable toggle added by dfa,  December 1990.
; Ability to switch ESC to filename completion added by dfa, May 1991.
; Twiddle key and filename display added by wd.
; Disable backslash appending to directory name added by dfa,  June 1992.
; Tab completion cycling added by wd and dfa,  June 1992.
; jmh, March, 1997:
;	Invalid filename characters added to file completion
;	Multiple commands on the one line
;	FEXEC and FIGNORE added to file completion
;	Changed the key mapping
; jmh, 15 December, 1997: tested for Win95 close command.
; jmh,	5 May, 1998:	  made TAB cycle by default.

	PUBLIC	get_kbd_line
	PUBLIC	auto_recall
	PUBLIC	expand_fnkey
	PUBLIC	backslash_char		;Added by dfa & wd
	PUBLIC	getkey_funcnum		;Added by wd

	PUBLIC	Edit_instance_offset	;Added by jmh
	PUBLIC	Edit_instance_size

	INCLUDE common.inc
	INCLUDE buffers.inc		;Added by wd
	INCLUDE ascii.inc
	INCLUDE bios.inc
	INCLUDE dos.inc
	INCLUDE general.inc


CSEG	SEGMENT	BYTE PUBLIC 'CODE'
CSEG	ENDS

DGROUP	GROUP	CSEG

	ASSUME	CS:DGROUP, DS:DGROUP, SS:DGROUP, ES:DGROUP

CSEG	SEGMENT	BYTE PUBLIC 'CODE'

	EXTRN	linebuf:BYTE
	EXTRN	lastchar:WORD
	EXTRN	caller_cursor:WORD
	EXTRN	dot:WORD
	EXTRN	edit_mode:BYTE
	EXTRN	omode_cursor:WORD
	EXTRN	disable_macro:BYTE	;added by dfa
	EXTRN	initial_curpos:WORD	;added by wd (was row jmh 980630)
	EXTRN	sym_stk:WORD
	EXTRN	linelimit:WORD		;changed from LINEBUF_END jmh 980512
	EXTRN	temp1:BYTE		;added by jmh 980512
	EXTRN	screen_width:BYTE	;ditto
	EXTRN	invalid_list:BYTE	;ditto
	EXTRN	invalid_len:ABS 	;ditto
	EXTRN	get_dosenv:PROC 	;added by jmh
	EXTRN	match_ext:PROC		;ditto 980513
	EXTRN	disable_macro:BYTE	;ditto
	EXTRN	macro_level:BYTE	;added by jmh 980519

	EXTRN	disp_line:PROC
	EXTRN	hist_back:PROC
	EXTRN	hist_fwd:PROC
	EXTRN	hist_bck_match:PROC
	EXTRN	hist_fwd_match:PROC
	EXTRN	remember:PROC
	EXTRN	execute_auto_recall:PROC
	EXTRN	insert_at_dot:PROC
	EXTRN	erase_to_dot:PROC
	EXTRN	isalphnum:PROC
	EXTRN	set_disp_marks:PROC
	EXTRN	bell:PROC
	EXTRN	line_to_scr:PROC
	EXTRN	isspace:PROC
	EXTRN	xlate_lower:PROC
	EXTRN	associate:PROC		;added by jmh 980513
	EXTRN	expand_braces:PROC	;added by jmh 980430
	EXTRN	expand_var:PROC
	EXTRN	expand_macro:PROC	;added by jmh 980518
	EXTRN	expand_symbol:PROC	;ditto
	EXTRN	ismacsym:PROC
	EXTRN	get_symbol:PROC
	EXTRN	tolower:PROC		;added by wd
	EXTRN	disp_prompt:PROC	;added by wd
	EXTRN	get_curpos:PROC 	;added by wd
	EXTRN	output_newline:PROC	;added by wd
	EXTRN	strlen:PROC		;added by jmh 980623
	EXTRN	get_line_len:PROC	;added by jmh 981106
	

; These 7 lines added by wd
FFBLK_SAVE_SIZE equ	30
Edit_instance_offset = $
ffblk_save	db	FFBLK_SAVE_SIZE dup (?)

CycleFlags	db	0		;bit 0 == 1 if cmd is cycle_complete
					;bit 1 == 1 if last cmd was ''
ExtFlags	db	0		;bit 0 == 1 if want only exes/dirs (jmh)
					;bit 1 == 1 to ignore extensions
ExtList 	dd	?		;Pointer to the list of extensions
fnameptr	dw	0		;fname location in linebuf	
olddot		dw	0		;Remember where dot was

auto_recall	db	0		;By default no auto recall
auto_recall_on	db	?		;1 if auto-recall in effect,
;					 else 0
continue_recall db	?		;auto-recall state variable
Edit_instance_size = $ - offset Edit_instance_offset
backslash_char	db	'\'		;added by dfa & wd
fnkey_tab	db	'S','F',0	;Used to look for function key
;					 definitions. 
fnkey_exec_char db	'@'		;If the last character a fn key
;					 definition is this, the key is
;					 executed immediately
getkey_funcnum	db	8		;what function to use for getkey

exevar		db	5,0,'FEXEC'     ;File completion extension lists
exelist 	db	'exe.com.bat',0
ignvar		db	7,0,'FIGNORE'
ignlist 	db	'exe.com.obj.o.bak',0

keymap	STRUC
key	dw	?
func	db	?
keymap	ENDS

; Must be IDENTICAL to the string in CMDCFG.C including the
; terminating '\0' byte. This must be followed immediately by ctrl_key_table.
cmdedit_keymap_id db	'CMDEDIT key map',0

ctrl_key_table:
	db	 0		;^@			ignore
	db	 9		;^A			bol
	db	 3		;^B			char_left
	db	28		;^C			cooked_char
	db	18		;^D			del_right
	db	10		;^E			eol
	db	 4		;^F			char_right
	db	25		;^G			abort_and_store
	db	17		;^H (Backspace) 	del_left
	db	15		;^I (Tab)		cycle_complete
	db	31		;^J (^Enter)		vars
	db	22		;^K			del_eol
	db	19		;^L			del_prev_word
	db	32		;^M (Enter)		done_editing
	db	12		;^N			next_line
	db	23		;^O			del_eol_exec
	db	11		;^P			prev_line
	db	 1		;^Q			quote
	db	13		;^R			search_back
	db	26		;^S			com_sep
	db	27		;^T			twiddle
	db	11		;^U			prev_line
	db	14		;^V			search_forw
	db	20		;^W			del_next_word
	db	21		;^X			del_bol
	db	29		;^Y			autorecall
	db	 2		;^Z			default_action
	db	24		;^[ (Esc)		erase_line
	db	15		;^\			cycle_complete
	db	26		;^]			com_sep
	db	33		;^^			done_wipeout
	db	30		;^_			macro

cmd_key_table:
	keymap	<127, 19>	;DEL (^Backspace)
	keymap	<271, 16>	;SHIFTTAB - added by jmh
	keymap	<327,  9>	;HOME
	keymap	<328, 11>	;UP
	keymap	<331,  3>	;LEFT
	keymap	<333,  4>	;RIGHT
	keymap	<335, 10>	;END
	keymap	<336, 12>	;DOWN
	keymap	<338, 34>	;INS
	keymap	<339, 18>	;KDEL
	keymap	<371,  5>	;CTLLEFT
	keymap	<372,  6>	;CTLRIGHT
	keymap	<373, 22>	;CTLEND
	keymap	<375, 21>	;CTLHOME
	keymap	<411,  7>	;ALTLEFT  - added by jmh
	keymap	<413,  8>	;ALTRIGHT - ditto

;number of command keys
NUM_CMD_KEYS	EQU	($ - cmd_key_table) / TYPE keymap


;The list of available functions, with default key assignments and func. number
cmd_key_funcs:
	dw	@ignore 		;^@		 0
	dw	@quote			;^Q		 1
	dw	@default_action 	;^Z		 2
	dw	@char_left		;^B, Left	 3
	dw	@char_right		;^F, Right	 4
	dw	@word_left		;^Left		 5
	dw	@word_right		;^Right 	 6
	dw	@full_word_left 	;@Left		 7	(@ = Alt)
	dw	@full_word_right	;@Right 	 8
	dw	@bol			;^A, Home	 9
	dw	@eol			;^E, End	10
	dw	@prev_line		;^P, ^U, Up	11
	dw	@next_line		;^N, Down	12
	dw	@search_back		;^R		13
	dw	@search_forw		;^V		14
	dw	@cycle_complete 	;^I/Tab, ^\	15
	dw	@complete		;#Tab		16	(# = Shift)
	dw	@del_left		;^H/Backspace	17
	dw	@del_right		;^D, KDel	18
	dw	@del_prev_word		;^L, ^Backspace 19
	dw	@del_next_word		;^W		20
	dw	@del_bol		;^X, ^Home	21
	dw	@del_eol		;^K, ^End	22
	dw	@del_eol_exec		;^O		23
	dw	@erase_line		;^[/Esc 	24
	dw	@abort_and_store	;^G		25
	dw	@com_sep		;^S, ^] 	26
	dw	@twiddle		;^T		27
	dw	@cooked_char		;^C		28
	dw	@autorecall		;^Y		29
	dw	@macro			;^_		30
	dw	@vars			;^J/^Enter	31
	dw	@done_editing		;^M/Enter	32
	dw	@done_wipeout		;^^		33
	dw	@toggle_insert		;Insert 	34


;+
; FUNCTION : get_kbd_line
;
;	Gets a line from the user and stores it in linebuf. The name is
;	a misnomer because the line is from standard input, not necessarily
;	from the keyboard.
;
; Parameters:
;	None.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;-

get_kbd_line	proc	near
	@save	si,di
	mov	al,auto_recall
	mov	auto_recall_on,al	;Indicate if auto-recall is enabled
	mov	continue_recall,1	;Init auto-recall memory

; Main editing loop
@get_kbd_line_10:
	mov	al,continue_recall
	and	auto_recall_on,al	;Indicate if we should keep
;					 auto-recalling
	mov	continue_recall,0	;Reset the flag. It will be set
;					 for the default actions keys.
	call	near ptr disp_line	;Show current line
	shl	CycleFlags,1		;shift the cycle_complete flag (wd)
	mov	ah,getkey_funcnum	;might be a raw keystroke (wd)
	call	near ptr getkey		;get next key from the user
	and	CycleFlags,6		;assume this cmd isn't a cycle_complete
	cmp	ax,32			;Control character ?
	jge	@get_kbd_line_15	;No, then check if fn key
	mov	bx,offset DGROUP:ctrl_key_table ;jmh 980516: modified to test
	add	bx,ax				; for default action
	jmp	short @get_kbd_line_40
@get_kbd_line_15:			;Check if function key
	cmp	ax,256+59		;>= F1 ?
	jb	@get_kbd_line_20	;No, then check next table
	cmp	ax,256+68		;<= F10
	jg	@get_kbd_line_20	;Not fn key
	jmp	@fn_key 		;Handle the function key
@get_kbd_line_20:
	cmp	ax,256+84		;>= Shift-F1 ?
	jb	@get_kbd_line_25	;No, then check next table
	cmp	ax,256+93		;<= Shift-F10
	jg	@get_kbd_line_25	;
	jmp	@sfn_key		;Handle the shifted function key
@get_kbd_line_25:
	mov	cx,NUM_CMD_KEYS		;size and...
	mov	bx,offset DGROUP:cmd_key_table+2  ;beginning of jump table
@get_kbd_line_30:			;Loop begin
	cmp	ax,[bx-2]		;Is this the key ?
	je	@get_kbd_line_40	;Hurrah, found
	inc	bx			;point to next key
	inc	bx
	inc	bx
	loop	@get_kbd_line_30	;If more keys, repeat
	jmp	short @default_action	;key not in table
@get_kbd_line_40:
	cmp	byte ptr [bx],2 	;jmh 980516: Default action ?
	je	@default_action 	;Yep.
	mov	al,[bx] 		;Get the function assigned to the key
	cbw
	add	ax,ax
	xchg	di,ax
	jmp	word ptr cmd_key_funcs[di]

@quote:					;Insert next char
;					 without interpreting it
	mov	ah,7			;get a raw keystroke (wd)
	call	near ptr getkey

@default_action:			;Insert the character (in AX)
	call	near ptr store_char
	jc	@get_kbd_line_10	;No room for char, keep looping
	mov	al,auto_recall_on	;Are we auto-recalling ?
	or	al,al
	jz	@get_kbd_line_10	;No
	call	near ptr execute_auto_recall
	jc	@get_kbd_line_10	;If carry set, no matching
;					 string in history buffer
	mov	continue_recall,1	;Else indicate auto-recall is
;					 still to go on
	jmp	short @get_kbd_line_10a


@char_left:				;Cursor one char left
	call	near ptr char_left	;char_left will return to top

@get_kbd_line_10a:			;added by jmh 980511
	jmp	@get_kbd_line_10
;					 of editing loop

@char_right:				;Cursor one char right
	call	near ptr char_right	;char_right will return to top
	jmp	short @get_kbd_line_10a
;					 of editing loop

@word_left:				;Cursor one word left
	call	near ptr word_left
	jmp	short @get_kbd_line_10a

@word_right:				;Cursor one word right
	call	near ptr word_right
	jmp	short @get_kbd_line_10a

@full_word_left:			;Cursor one "full" word left
	call	near ptr full_word_left
	jmp	short @get_kbd_line_10a

@full_word_right:			;Cursor one "full" word right
	call	near ptr full_word_right
	jmp	short @get_kbd_line_10a

@bol:					;Beginning of line
	call	near ptr go_bol
	jmp	short @get_kbd_line_10a

@eol:					;End of line
	call	near ptr go_eol
	jmp	short @get_kbd_line_10a


@prev_line:				;Get previous history line
	mov	ax,offset DGROUP:hist_back
@history_line:
	call	ax
	mov	ax,lastchar
	mov	dot,ax			;Leave cursor at end of line
@history_search:
	jnc	@history_line_done	;Line found
	call	near ptr strstk_settop	;added by wd
	call	near ptr bell		;No line
@history_line_done:
	jmp	short @get_kbd_line_10a

@next_line:				;Get next history line
	mov	ax,offset DGROUP:hist_fwd
	jmp	short @history_line

@search_back:				;Search back thru history buffer
	mov	ax,offset DGROUP:hist_bck_match
@search:
	mov	di,dot			;Save current dot
	call	ax
	mov	dot,di			;Restore it
	jmp	short @history_search

@search_forw:				;Search forward thru history buffer
	mov	ax,offset DGROUP:hist_fwd_match
	jmp	short @search

@cycle_complete:
	or	CycleFlags,1
@complete:				;Try to find a matching filename
	call	near ptr match_file
	cmp	auto_recall_on,1	;Autorecall ongoing?
	je	@del_eol		;Yes, then delete to end of line
	jmp	short @get_kbd_line_10a

@del_left:				;Delete char before cursor
	mov	ax,offset dgroup:char_left
	jmp	short @delete

@del_right:				;Delete char at cursor
	mov	ax,offset dgroup:char_right
	jmp	short @delete

@del_prev_word:				;Delete upto word beginning
	mov	ax,offset dgroup:word_left
	jmp	short @delete

@del_next_word:				;Delete to start of next word
	mov	ax,offset dgroup:word_right
	jmp	short @delete

@del_bol:				;Delete to beginning of line
	mov	ax,offset dgroup:go_bol
	jmp	short @delete


@toggle_insert:
	mov	ax,1
	xor	al,edit_mode		;Toggle edit mode
	mov	edit_mode,al
	IF	TOGGLE_CURSOR
	xchg	ax,bx
	add	bx,bx			;Word offset
	@SetCurSz omode_cursor[bx]	;cx<-cursor shape
	ENDIF
	jmp	 short @ignore

@abort_and_store:			;Erases current line but remembers
;					 it in the history buffer
	call	near ptr remember
;	Fall through to erase line
@erase_line:
	call	near ptr go_bol		;Move dot to beginning of line
;	fall thru to delete to end of line

@del_eol:				;Delete to end of line
	mov	ax,offset dgroup:go_eol

@delete:				;General purpose delete
	mov	si,dot			;Remember the dot
	call	ax			;Move dot to new position
	xchg	si,ax
	call	near ptr erase_to_dot	;Delete characters between ax and dot
	jmp	short @ignore

@com_sep:				;command separator, added by jmh
	mov	ax,CTL_S
@default_action_a:			;added by jmh 980518
	jmp	@default_action

@twiddle:				;added by wd, rewritten by jmh 981106
	call	get_line_len		;SI->start of line, CX = line length
	cmp	cx,2			;Need at least two characters
	jb	@ignore

	mov	ax,dot
	xchg	si,ax			;SI->current pos., AX->start of line
	cmp	si,ax			;If at the beginning of the line
	je	@twiddle_20		; go ahead and swap
	cmp	si,lastchar		;If beyond the end of line,
	jne	@twiddle_10		; need to decrease twice, otherwise
	dec	si			; just once (want to swap this char.
@twiddle_10:				; with the next).
	dec	si
@twiddle_20:
IF i286
	rol	word ptr [si],8 	;Do the swap by rotating bits
ELSE
	mov	cl,8
	rol	word ptr [si],cl
ENDIF
	xchg	ax,si			;Indicate the display has changed
	mov	dx,ax
	inc	ax
	inc	ax
	call	near ptr set_disp_marks
	jmp	short @ignore

@cooked_char:				;added by wd
	mov	ah,8			;get a cooked keystroke (wd)
	call	near ptr getkey
	jmp	short @default_action_a

@autorecall:
	xor	auto_recall,1		;Toggle auto recall mode
	jmp	short @ignore

@macro: 				;added by dfa
	xor	disable_macro,1 	;Toggle macro,symbol expansion disable
	jmp	short @ignore


@vars:
; Expand the variables on the line.
	call	near ptr expand_braces	;added by jmh 980430
	call	near ptr expand_var
	call	near ptr associate	;added by jmh 980513
	call	near ptr expand_macro	;added by jmh 980518
	mov	macro_level,0		;jmh 980519: ignore rest of macro
	call	near ptr expand_symbol	;added by jmh 980518
	jnc	@vars			;recurse (jmh 981106)

@ignore:
	jmp	@get_kbd_line_10	;Ignore the character



@sfn_key:
; A shifted function key has been struck.
	sub	ax,256+84-'1'           ;added by jmh 980511
	mov	dx,3
	jmp	short @fn_key_1
@fn_key:
; A function key has been struck.
	sub	ax,256+59-'1'           ;F1 = '1' ... F9 = '9', F10 = ':'
	mov	dx,2
@fn_key_1:
	call	near ptr expand_fnkey
	jc	@fn_key_20			;Error or no expansion
	or	dx,dx				;Line to be executed
;						 immediately ?
	je	short @done_editing_2		;Yes, all done
@fn_key_20:
	jmp	short @ignore			;else keep editing

@del_eol_exec:				;Deletes characters from the dot
;					 to end of the line and then
;					 executes the line
	mov	si,dot			;Remember the dot
	call	go_eol
	xchg	si,ax
	call	near ptr erase_to_dot
	jmp	short @done_editing


@done_wipeout:
; The line is executed. However it is not stored in the history buffer and
; is also removed from the screen (this is a little klugy).
	mov	ax,offset DGROUP:linebuf
	mov	dot,ax
	mov	dx,lastchar
	mov	lastchar,ax			;Temporarily pretend line
;						 is empty
	xchg	ax,dx
	push	ax
	call	near ptr set_disp_marks
	call	disp_line
	pop	ax
	mov	lastchar,ax			;Restore line length
	jmp	short @get_kbd_line_90

@done_editing:
	call	near ptr remember	;Store in history buffer
;					 Picks up line from global linebuf
@done_editing_2:
	call	near ptr disp_line	;Necessary for @del_eol_exec,
;					 might as well do for others
	mov	ax,lastchar
	mov	dot,ax			;Set dot to end of line
	call	near ptr line_to_scr	;Set cursor beyond last character

@get_kbd_line_90:
	@DispCh CR			;Do a carriage return because
;					 some applications like EDLIN
;					 only do a LF to go to next line
;	@DispCh LF			;Go onto next line
;	all done
@get_kbd_line_99:
	@restore
	ret
get_kbd_line endp



;+
; FUNCTION : getkey
;
;	Read a keystroke, interpreting function keys into a 16-bit value.
;
; Parameters:
;	AH	= 7 for a raw keystroke, 8 for a cooked keystroke
;
; Returns:
;	AX	= 16-bit key value
; Register(s) destroyed:
;	DL
;-
; Requires AH be set to either 7 (raw) or 8 (cooked)
;
getkey proc near
	mov	dl,ah
	int	21h

	push	dx		;jmh 971215 - Test if Win95 has closed the DOS
	push	ax		; box. If so, fudge pressing enter to allow it
	mov	ax,168fh	; to be closed.
	mov	dh,1		;Win95 - Query Close function
	int	2fh
	or	ax,ax
	pop	ax
	pop	dx
	jnz	@not_closed
	mov	al,13		;I'll assume no-one has re-mapped ^M
@not_closed:
	or	al,al		;jmh 980511: reorganized this section
	je	@114		;not '\0'
@113:
	xor	ah,ah
	ret
@114:
	mov	ah,0Bh
	int	21h		;check if key available
	or	al,al
	jz	@113		;no character available
	mov	ah,dl
	int	21h
	mov	ah,1
	ret
getkey	endp



;+
; FUNCTION : expand_fnkey
;
;	Inserts the expansion corresponding to a symbol key into the
;	linebuffer. If the buffer is too small, only as many characters as
;	possible are inserted and the function returns an error. The
;	function also returns an error if the symbol is not defined. The
;	function also updates the displayed line. The function also checks
;	if the line is to be executed immediately or not, based on the last
;	character of the fn key expansion.
;
; Parameters:
;	AX	= function key character, between '1' and ':' (sic).
;	DX	= length of string (2 for function, 3 for shifted).
;
; Returns:
;	CF	= 0 if no error, else 1
;		  If CF is 1, then AX is 0 if symbol not found or non-zero
;		  if symbol found but no room in line.
;	AX	= 1 if symbol was present    (jmh 980511: currently unused)
;		  0 if symbol was not found.
;	DX	= 0 if the line is to be executed immediately
;		  non-0 otherwise
;		  DX is only valid if CF=0 and AX=1
; Register(s) destroyed:
; 	<TBA>
;-
expand_fnkey proc near
	@link	LINEBUF_SIZE
exp_buf	equ <byte ptr [bp-LINEBUF_SIZE]>

	mov	si,offset DGROUP:fnkey_tab+3	;SI->end of 'SFn'
	mov	di,si
	dec	di				;DI->the digit
	sub	si,dx				;SI->the symbol
@expand_fnkey_15:
	cmp	al,':'                          ;F10 must appear as F0
	jne	@expand_fnkey_20
	sub	al,10
@expand_fnkey_20:
	mov	[di],al 			;Store in 'SFn' string
; OK now try and expand the symbol.
;						 SI->symbol
	mov	ax,LINEBUF_SIZE
	xchg	ax,dx				;AX<-length of synbol
;						 DX<-length of expansion buffer
	lea	di,exp_buf
	call	near ptr get_symbol		;Params SI,AX,DI,DX
	jc	@expand_fnkey_99		;No symbol (buffer too
;						 small case not possible).
;						 AX will be 0 for this case.
; OK now we have the symbol expansion, so try to insert it into the linebuffer.
;	AX contains length of expansion
	mov	si,di				;SI->expansion
	add	di,ax
	dec	di				;DI->last char of expansion
	xor	dx,dx
	mov	dl,byte ptr [di]		
	sub	dl,fnkey_exec_char		;Is this line to be
;						 immediately executed
	jne	@expand_fnkey_80		;No
	dec	ax				;The last char of expansion
;						 is a special char. Do not
;						 include it in the insert
;						 string 
@expand_fnkey_80:
	push	dx
	call	near ptr insert_at_dot		;Params SI,AX
;	mov	ax,1				;AX<-exit code (; by jmh 980511)
	pop	dx				;DX is 0 if line is to be
;						 executed immediately
@expand_fnkey_99:
	@unlink
	ret

expand_fnkey endp


;+
; FUNCTION : store_char
;
;	Stores	the character in AX into the line buffer if max line
;	length will not be exceeded. Characters may be inserted or
;	overwrite chars in the buffer depending on the edit mode and whether
;	auto-recall is on.
;
; Parameters:
;	AX	= character
;
; Returns:
;	CF	= 0 if no error, else 1
; Register(s) destroyed:
; 	<TBA>
;-
store_char proc near
	@save	si
	or	ah,ah			;char >= 256
	jnz	@store_char_90		;Ignore if so
	cmp	edit_mode,ah		;1 if insert mode
	je	@store_char_20		;Jump if overtype mode
	cmp	auto_recall_on,ah	;Is auto-recall on ?
	jne	@store_char_20		;Yes, behave as if in overtype mode
	mov	si,offset dgroup:temp1	;temporary storage
	mov	[si],al			;Store char
	mov	al,1			;Length of string
	call	near ptr insert_at_dot	;Insert the character
	jnc	@store_char_99		;No problemo
	jmp	short @store_char_90	;No room in buffer
@store_char_20:
	mov	si,dot			;Current position in line
	cmp	si,linelimit		;At line end?
	jae	@store_char_90
;	Enough room for a char
	mov	[si],al			;Store the char
	mov	dx,si			;DX->changed character
	mov	ax,si
	inc	ax			;AX->char after change
	mov	dot,ax			;Store it as new dot position
	cmp	si,lastchar		;Was it end of line ?
	jb	@store_char_30
	mov	lastchar,ax		;Store new end of line
@store_char_30:
	call	near ptr set_disp_marks	;ax,dx parameters
	clc				;Indicate no error
	jmp	short @store_char_99
@store_char_90:
	call	near ptr bell
	stc				;Indicate error
@store_char_99:
	@restore
	ret
store_char endp


;+
; FUNCTION : word_left, full_word_left
;
;       Move one word or "full" word left. A word is delimited by non-alpha-
;	numerics; a full word is delimited by space/tab. (Full word by jmh.)
;
; Parameters:
;	Globals linebuf and dot.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;
; jmh 980512: removed the return code, tidied code accordingly. Comments are
;	      for the word_left case; for full_word_left it skips over spaces,
;	      then everything but spaces.
;-
word_left proc near
	mov	dx,offset DGROUP:isalphnum
	jmp	short @word_left_10

full_word_left LABEL near
	mov	dx,offset DGROUP:isspace

@word_left_10:				;Loop to backup over non-alphanumeric
	call	near ptr char_left	;Move one char left
	jc	@word_left_99		;Already at beginning of line
	call	dx			;AL alphanumeric ?
	je	@word_left_10		;No, loop back
@word_left_15:				;Now backup to beginning of word
;	At this point, dot is always at an alphabetic char or beginning
;	of the line
	call	near ptr char_left
	jc	@word_left_99		;Were already at beginning of line
	call	dx			;Alphanumeric?
	jne	@word_left_15		;Yes, loop back
					;Found non-alphanumeric char
	call	near ptr char_right	;move over one
@word_left_99:
	ret
word_left endp



;+
; FUNCTION : word_right, full_word_right
;
;       Move one word or "full" word right. A word is delimited by non-alpha-
;	numerics; a full word is delimited by space/tab. (Full word by jmh.)
;
; Parameters:
;	Globals linebuf and dot.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;
; jmh 980512: Comments are for the word_right case; for full_word_right it
;	      skips over non-spaces, then spaces.
;-
word_right proc near
	mov	dx,offset DGROUP:isalphnum
	jmp	short @word_right_10

full_word_right LABEL near
	mov	dx,offset DGROUP:isspace

@word_right_10:				;Loop fwd over alphanumerics
	call	near ptr char_right	;One char right
					;AL<-char at dot
	jc	@word_right_99		;Already at end of line
	call	dx			;Is AL alphanumeric ?
	jne	@word_right_10		;Yes, loop back
@word_right_15:				;Now move to beginning of word
	call	near ptr char_right
	jc	@word_right_99		;Already at end of line
	call	dx			;Alphanumeric ?
	je	@word_right_15		;Not alphanumeric char, loop back
@word_right_99:
	ret
word_right endp



;+
; FUNCTION : char_left
;
;	Moves the 'dot' one character to the left unless
;	already at the beginning of the line.
;
; Parameters:
;	Global	dot is current position in the line.
;
; Returns:
;	AL	= char at new dot position.
;	CF	= 1 if OLD dot was at beginning of line
;		  0 otherwise.
; Register(s) destroyed:
;-
char_left proc	near
	@save	si
	mov	ax,dot			;Current position in line
	cmp	ax,offset dgroup:linebuf
	jne	@char_left_5
	stc				;Dot already at beginning of line
	jmp	short @char_left_99
@char_left_5:
	dec	ax			;Move dot left
	mov	dot,ax
@char_left_99:
	xchg	ax,si
	lodsb				;AL<-char at dot
	@restore
	ret
char_left endp


;+
; FUNCTION : char_right
;
;	Moves the 'dot' one character to the right unless
;	already at the end of the line.
;
; Parameters:
;	Global	dot is current position in the line.
;
; Returns:
;	AL	= char at new dot position. Undefined if new dot is at
;		  the end of the line.
;	CF	= 1 if OLD dot was already at end of the line.
;		  0 otherwise.
; Register(s) destroyed:
;-
char_right proc	near
	@save	si
	mov	ax,dot			;Current position in line
	mov	si,lastchar		;SI->Beyond last char
	dec	si			;SI->last char in line
	cmp	si,ax			;Dot at end ?
	jc	@char_right_99		;Already at line end
	inc	ax			;Move dot right, CF not affected
	mov	dot,ax
	xchg	ax,si
	lodsb				;AL<-char at dot, (undefined if
;					 dot is now at end of line).
;	CF	already clear
@char_right_99:
	@restore
	ret
char_right endp



;+
; FUNCTION : go_bol
;
;	Sets dot to point to the beginning of the line
;
; Register(s) destroyed: None.
;-
go_bol	proc	near
	mov	dot,offset dgroup:linebuf
	ret
go_bol	endp



;+
; FUNCTION : go_eol
;
;	Sets dot to point to the end of the line
;
; Register(s) destroyed: AX.
;-
go_eol	proc	near
	mov	ax,lastchar
	mov	dot,ax
	ret
go_eol	endp



;+
; FUNCTION : match_file
;
;	match_file tries to expand the filename to the left of the
;	cursor. If there are several matching files, the longest common
;	prefix is placed on the line.
;	Added by wd:	If no characters can be placed on the line,
;			list the possible matches.  Alternately, add
;			one match at a time to the line.
;
;	jmh 980512:	maximum path changed to 80 (66 characters for the drive,
;			colon and path, one character for the "trailing" back-
;			slash, 12 characters for the filename, dot and exten-
;			sion, and one more for the null). However, the biggest
;			path I have is 60 characters (including null).
;
; Parameters:
;	None.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;-
match_file proc	near
	@link	80+44+2+2+2+2+2
pathbuf 	equ	80		;Storage for entire filename with path
ffblk		equ	pathbuf+44
ffblk_attr 	equ	ffblk-15h	;Attr byte within ffblk
ffblk_name 	equ	ffblk-1Eh	;filename within ffblk
lineptr		equ	ffblk+2
remaining	equ	lineptr+2	;Remembers remaining space in path
oldDTAseg 	equ	remaining+2
oldDTAoff 	equ	oldDTAseg+2
breakstate	equ	oldDTAoff+2	;Remembers break state

	mov	ax,3300h		;Get current break state
	int	21h			;DL<-current break state
	mov	byte ptr [bp-breakstate],dl ;Remember it
	xor	dl,dl
	inc	ax			;Disable break check during
;					 disk I/O
	int	21h

	push	es
	@GetDTA				;Get and save old DTA
	mov	[bp-oldDTAseg],es
	mov	[bp-oldDTAoff],bx
	pop	es
;
	lea	dx,[bp-ffblk]
	@SetDTA 			;Set DTA to our DTA

; If the last call was also a cycle, continue what we started (wd,dfa)
	cmp	CycleFlags,7
	je	@match_file_60

	mov	si,dot			;Current line position
	mov	olddot,si		;Remember current dot position (wd)
	mov	ExtFlags,1		;Assume executable/dir wanted (jmh)
	mov	cx,79			;Max length of path
@match_file_10:
	cmp	si,offset dgroup:linebuf
	je	@match_file_51		;Beginning of line and filename
	dec	si
	mov	al,[si]			;AL<-next char
@match_file_25:
	call	near ptr @match_file_start ;Changed from isspace by jmh
	je	@match_file_50		;Beginning of filename
@match_file_45:				;Check for next char if
;					 pathname not too long
	loop	@match_file_10
	jmp	@match_file_90		;Pathname too long, just exit
@match_file_50:
	inc	si
	mov	ExtFlags,2		;Ignore files
@match_file_51:
	mov	[bp-lineptr],si		;Save start of path name in linebuf
	mov	ax,79
	sub	ax,cx			;Length of name
	mov	[bp-remaining],cx	;remember num bytes left in pathbuf
	xchg	ax,cx			;CX<-length of name

	call	near ptr @match_file_parse

	call	@match_file_first
	jnc	@match_file_70		;No error
	and	ExtFlags,NOT 2		;Try again with ignore off
	call	@match_file_first
	jnc	@match_file_70
@match_file_58:
	mov	ffblk_save,0		;Make sure the DTA will fail a GetNext
	call	near ptr bell		;No files found
	jmp	@match_file_90		;Restore DTA and exit

@match_file_60:
	mov	cx,FFBLK_SAVE_SIZE/2	;5 lines by dfa and wd
	mov	si,offset ffblk_save
	lea	di,[bp-ffblk]
	rep 	movsw			;restore the DTA for the GetNext
	and	CycleFlags,3		;Don't need more than this now
@match_file_65:
	call	@match_file_next	;Get the next file name
	jnc	@match_file_70		;Got one
	mov	ax,olddot		;AX->start of chars to be deleted
	call	near ptr erase_to_dot	;Delete characters between dot
	mov	CycleFlags,1            ;If next key is cycle,  want to do
	jmp	short @match_file_58    ;it immediately

@match_file_70:				;At least one file found
	lea	di,[bp-pathbuf]		;DI->pathbuf
@match_file_71:				;Copy the file name
	lodsb
	stosb
	or	al,al
	jnz	@match_file_71

	mov	ax,SPACE		;If file, add a space (ah = 0 -- wd)
	test	byte ptr [bp-ffblk_attr],16 ;Subdirectory?
	je	@match_file_72		;No
	mov	al,backslash_char	;If subdir, (possibly) add a backslash
@match_file_72:
	mov	word ptr [di-1],ax	;Add a space or a '\' and a null

	cmp	CycleFlags,3		;If cycling, bug out (wd,dfa)
	je	@match_file_79

;	Now hunt for more files. For each file found, keep the longest 
;	prefix in common so far.

	call	@match_file_next	;Get the next file name
	jc	@match_file_80		;No more files

	lea	di,[bp-pathbuf]		;DI->start of file name
	mov	cx,13			;Max Length of field
	repe	cmpsb			;Compare strings
	xor	ax,ax			;Terminating null for [di-1]
	jmp	short @match_file_72	;Try for more files

@match_file_79:
	mov	cx,FFBLK_SAVE_SIZE/2	;4 lines by dfa and wd
	lea	si,[bp-ffblk]
	mov	di,offset ffblk_save
	rep	movsw			;save ffblk for next call

@match_file_80:
;	Found one or more files, copy the longest common prefix
;	into the line buffer
	lea	si,[bp-pathbuf]		;SI->name to be copied
	mov	di,si
	call	near ptr strlen		;CX<-length of string

;following 10 lines added by wd & dfa (reduced to 9 by jmh 980512)
	cmp	CycleFlags,3		;If cycling, no length check
	je	@match_file_87
	mov	dx,dot
	sub	dx,fnameptr		;DX<-length of search string
	cmp	cx,dx
    	ja      @match_file_85          ;If cycling,  we want first call
	jb	@match_file_list	;not to actually cycle,  but just
	test	CycleFlags,1            ;complete to longest common prefix
    	jz    	@match_file_list

@match_file_85:
	test	CycleFlags,1
	jnz	@match_file_87         	;If next key is cycle,  want to do
	mov	CycleFlags,1   		;it immediately (dfa)

@match_file_87:
; SI->string, CX is length
	push	cx
	call	near ptr xlate_lower	;Convert to lowercase
	mov	ax,fnameptr		;AX->start of chars to be deleted
	call	near ptr erase_to_dot	;Delete chars between dot and start
	pop	ax	
	call	near ptr insert_at_dot	;SI->source, AX == length

@match_file_90:
	push	ds
	lds	dx,[bp-oldDTAoff]
	@SetDTA 			;Restore DTA
	pop	ds
; Restore previous state of break checking
	mov	dl,byte ptr [bp-breakstate]
	mov	ax,3301h
	int	21h
	@unlink
	ret

; remainder of this file extensively modified by wd
@match_file_list:
	mov	CycleFlags,1            ;If next key is cycle,  want to do
	   				;it immediately (dfa)
	mov	si,[bp-lineptr]
	mov	cx,dot
	sub	cx,si
	call	near ptr @match_file_parse

	call	near ptr output_newline
	mov	al,ExtFlags		;Remember the ignore flag (jmh)
	push	ax
	and	ExtFlags,NOT 2		; and turn it off for the list
	call	@match_file_first

;jmh 980512: display as many files on a line as will fit.
	mov	bh,screen_width
	sub	bh,16			;BH determines if the next file fits
	xor	bl,bl			;BL counts columns
@match_file_list_10:
	mov	cx,15

@match_file_list_20:
	lodsb
	test	al,al
	jz	@match_file_list_30
	call	near ptr tolower
	@DispCh al
	dec	cx
	inc	bx
	jmp	@match_file_list_20

@match_file_list_30:
	mov	al,SPACE
	test	byte ptr [bp-ffblk_attr],16	;Subdirectory?
	je	@match_file_list_40		;No
	mov	al,'\'				;If subdir, add a backslash
@match_file_list_40:
	@DispCh al
	inc	bx
	mov	dl,SPACE
@match_file_list_50:
	int	21h
	inc	bx
	loop	@match_file_list_50
	cmp	bl,bh				;Would any more files fit?
	jbe	@match_file_list_55		;Yep
	cmp	bl,screen_width
	je	@match_file_list_54		;Wrapped around
	call	near ptr output_newline
@match_file_list_54:
	xor	bl,bl				;Start over again
@match_file_list_55:
	push	bx
	call	@match_file_next
	pop	bx
	jnc	@match_file_list_10
	pop	ax				;Get the ignore flag back (jmh)
	mov	ExtFlags,al
	call	near ptr get_curpos		;DX<-current cursor position
	test	dl,dl
	jz	@match_file_list_60
	call	near ptr output_newline
@match_file_list_60:
	call	near ptr disp_prompt
	call	near ptr get_curpos		;DX<-current cursor position
	mov	initial_curpos,dx
	mov	ax,lastchar
	mov	dx,offset DGROUP:linebuf
	call	near ptr set_disp_marks
	call	disp_line			;Redisplay line
	jmp	@match_file_90
match_file endp

@match_file_parse proc near
;   Copy filename into ASCIIZ buffer
;   SI->first char of filename in line buffer, CX=length
	xor	dx,dx			;Flags
	lea	di,[bp-pathbuf]		;OK 'cause SS==DS
	mov	fnameptr,si		;Assumed start of filename in linebuf
	jcxz	@match_file_p42
@match_file_p0:
	lodsb				;AL<-next char
	stosb				;Store it
	cmp	al,'.'
	jne	@match_file_p10
	or	dl,1			;Set flag to remember file type '.'
	jmp	short @match_file_p40	;Check out next character
@match_file_p10:
	cmp	al,':'			;Disk?
	je	@match_file_p30
	cmp	al,'\'			;Directory separator?
	je	@match_file_p20
	cmp	al,'/'			;Same thing
	jne	@match_file_p40
@match_file_p20:
	cmp	backslash_char,0	;is backslash appending turned on?
	je	@match_file_p30		;no
	mov	backslash_char,al	;remember the type of slash (/ or \)
@match_file_p30:
	mov	fnameptr,si		;Update start of filename in linebuf
	and	dl,0FEh			;Forget file type flag

@match_file_p40:
	loop	@match_file_p0

@match_file_p42:
	mov	cx,[bp-remaining]	;CX<-remaining space
	jcxz	@match_file_p50		;Only space for terminator
	mov	al,'*'
	stosb				;Attach a '*'
	cmp	cl,3			;Enough space for ".*"
	jb	@match_file_p50
	and	dl,1			;Saw a file type ?
	jne	@match_file_p50		;Yes, go attach terminator
	mov	[di],2A2Eh		;Attach a ".*"
	inc	di
	inc	di
@match_file_p50:
	xor	al,al			;AL<-0
	stosb				;Terminating 0
	ret
@match_file_parse endp


@match_file_start proc near
; Test if the character in AL is an invalid filename character.
; Return: ZF = 1 if AL is an invalid filename character
;	       0 otherwise
	cmp	al,33
	jc	@match_file_s1
	@save	di,cx
	mov	cx,invalid_len
	mov	di,offset invalid_list
	repne	scasb
	@restore
	ret
@match_file_s1:
	cmp	al,al			;Set ZF for invalid character
	ret
@match_file_start endp



;+
; FUNCTION: match_file_{first,next}
;
;	Get the first and next files for the cycle, skipping the two directory
;	entries ("." and "..").
;
; Parameters:
;
; Returns:
;	CF = 1 for no (more) files
;	     0 for a file, SI -> filename.
;-
@match_file_first proc near
	;Find the appropriate list of extensions
	lea	si,exevar		;Assume executables
	test	ExtFlags,1		;Do we want executables only?
	jnz	@match_file_e10 	;Yes
	test	ExtFlags,2		;Ignoring extensions
	jz	@match_file_e12 	;No, go start searching
	lea	si,ignvar
@match_file_e10:
	mov	ax,[si] 		;Length of env. variable
	inc	si
	inc	si			;Point to the variable itself
	xor	di,di			;Get the pointer to its expansion
	push	ax
	call	get_dosenv
	pop	ax			;Don't need its length
	jnc	@match_file_e11 	;Found it
	add	si,ax			;Point to the default list
	mov	di,si
@match_file_e11:
	mov	word ptr ExtList,di
	mov	word ptr ExtList+2,es
@match_file_e12:
	lea	dx,[bp-pathbuf]		;dx->ASCII name
	@GetFirst ,16
	jmp	short @match_file_e20

@match_file_next LABEL near
	mov	es,word ptr ExtList+2

@match_file_e15:
	@GetNext
@match_file_e20:
	jc	@match_file_e99
	lea	si,[bp-ffblk_name]
	lodsb
	cmp	al,'.'                  ;Is this '.' or '..'?
	je	@match_file_e15
	test	byte ptr [bp-ffblk_attr],16 ;Subdirectory?
	jnz	@match_file_e98 	;Yes, go exit
	cmp	ExtFlags,0		;Testing extensions?
	je	@match_file_e98 	;No, go exit
	mov	di,word ptr ExtList
@match_file_e30:
	lodsb
	cmp	al,'.'
	je	@match_file_e32
	or	al,al
	jnz	@match_file_e30
	dec	si			;No extension, so point back to the zero
@match_file_e32:
	push	si
@match_file_e33:
	lodsb
	or	al,al
	jnz	@match_file_e33
	pop	cx
	dec	si
	sub	si,cx
	xchg	si,cx			;SI -> extension, CX = length
	call	match_ext
	jne	@match_file_e40
	test	ExtFlags,1		;If matching executables then
	jnz	@match_file_e98 	; we can exit
	jmp	short @match_file_e15	; otherwise get the next file
@match_file_e40:
	test	ExtFlags,2		;If it didn't match the ignore list,
	jnz	@match_file_e98 	; it's okay.
	cmp	disable_macro,1 	;It didn't match the executable list so
	je	@match_file_e15 	; try the associations list, if it's
	call	strstk_ext_find 	; enabled.
	jc	@match_file_e15 	;Still no good.
@match_file_e98:
	lea	si,[bp-ffblk_name]
	clc
@match_file_e99:
	push	ds
	pop	es
	ret
@match_file_first endp


CSEG	ENDS

	END
