; UTL.ASM
; (c) 1989, 1990 Ashok P. Nadkarni
;
; General utility functions for CMDEDIT. SMALL model only. Also assume 
; ES == DS. 
;

	INCLUDE common.inc
	INCLUDE	general.inc
	INCLUDE	ascii.inc
	INCLUDE dos.inc
	INCLUDE buffers.inc

	PUBLIC	stre_cmp
	PUBLIC	strlen			;added by jmh 980623
	PUBLIC	tolower
	PUBLIC	xlate_lower
	PUBLIC	isalphnum
;	PUBLIC	iscntrl 		; removed by jmh
	PUBLIC	isspace
	PUBLIC	isdelim
	PUBLIC	bell
	PUBLIC	push_string
	PUBLIC	push_word
	PUBLIC	skip_nonwhite
	PUBLIC	skip_whitespace
	PUBLIC	skip_nondelim
	PUBLIC	output_newline
	PUBLIC	dosify_line		; added by wd
	PUBLIC	match_ext		;added by jmh 980513
	
	EXTRN	silent:BYTE
	EXTRN	lastchar:WORD
	EXTRN	linebuf:BYTE
	EXTRN	newline:BYTE		;added by jmh 980510
	EXTRN	delim_list:BYTE 	;these two by jmh 980512
	EXTRN	delim_len:ABS


CSEG	SEGMENT	BYTE PUBLIC 'CODE'

DGROUP	GROUP	CSEG

	ASSUME	CS:DGROUP,DS:DGROUP,ES:DGROUP,SS:DGROUP

;+
; FUNCTION : stre_cmp
;
;	Does a case-insensitive comparison of two strings of equal length.
;
; Parameters:
;	DS:SI :=	Address of string 1.
;	ES:DI :=	Address of string 2.
;	CX    :=	Length.
;
; Returns:
;	If string 1 = string 2, ZF = 1, CF = 0.
;	If string 1 < string 2, ZF = 0, CF = 1.
;	If string 1 > string 2, ZF = 0, CF = 0.
; Registers AX,CX destroyed.
;-
stre_cmp proc near
	@save	si,di
	dec	si		;Prime for loop
	dec	di
	xor	ax,ax		;Clear flags
	jcxz	@stre_cmp_99
@stre_cmp_10:
	cmpsb			;Point SI,DI to next byte
	mov	al,[si]		;String 1 byte
	call	near ptr tolower ;al := Uppercase version
	xchg	al,ah		;Save it.
	mov	al,ES:[di]	;Ditto for string 2
	call	near ptr tolower ;al := Uppercase version
	cmp	ah,al		;Compare string 1 with string 2
@stre_cmp_20:
	loope	@stre_cmp_10	;Keep looping as long as equal
@stre_cmp_99:
	@restore
	ret
stre_cmp endp


;+
; FUNCTION : strlen by jmh 980623
;
;	Determine the length of a null-terminated (ASCIIZ) string.
;
; Parameters:
;	DI :=	address of string
;
; Returns:
;	CX :=	length of string
;	DI :=	address of character after NUL
;
; Registers destroyed:
;	AL (0)
;-
strlen proc near
	xor	al,al			;Search for NUL
	mov	cx,0ffffh
	repne	scasb			;DI->byte after NUL
	not	cx
	dec	cx			;CX<-length of string
	ret
strlen endp


;+
; FUNCTION : tolower
;
;	Converts the character in AL to lower case if it is a upper case
;	character, else leaves it unchanged.
;
; Parameters:
;	Al :=	character
;
; Returns:
;	AL :=	lowercase version or unchanged
;-
tolower	proc near
	cmp	al,'A'
	jb	@tolower_99
	cmp	al,'Z'
	ja	@tolower_99
	add	al,20h
@tolower_99:
	ret
tolower	endp



;+
; FUNCTION : xlate_lower
;
;	Converts the passed string to lower case.
;
; Parameters:
;	CX :=	length of string	(jmh 980512: changed from AX)
;	SI :=	address of string
;
; Returns:
;	Nothing.
;
; Registers destroyed:
;	AX,CX
;-
xlate_lower proc near
	@save	si,di
	mov	di,si
	jcxz	@xlate_lower_99

@xlate_lower_10:
	lodsb
	call	near ptr tolower
	stosb
	loop	@xlate_lower_10
	
@xlate_lower_99:
	@restore
	ret
xlate_lower endp



;+
; FUNCTION : isalphnum
;
;	Test if the character is alphanumeric.
;
; Parameters:
;	AL	= character
;
; Returns:
;	ZF	= 0 if alphanumeric (changed from CF by jmh)
;		  1 if not
; Register(s) destroyed:
;-
isalphnum proc near
	cmp	al,'0'
	jc	@isalphnum_98		;Not alphanumeric
	cmp	al,'9'+1
	jc	@isalphnum_99		;Number
	cmp	al,'A'
	jc	@isalphnum_98		;Not alphanumeric
	cmp	al,'Z'+1
	jc	@isalphnum_99		;Uppercase letter
	cmp	al,'a'
	jc	@isalphnum_98		;Not alphanumeric
	cmp	al,'z'+1
	jc	@isalphnum_99		;Lowercase letter
@isalphnum_98:
	cmp	al,al			;Set ZF
@isalphnum_99:				;NZ is already set
	ret
isalphnum endp


comment ^ removed by jmh
;+
; FUNCTION : iscntrl
;
;	Check if control character and DEL (00h-1Fh and 0FFh).
;
; Parameters:
;	AL	= character to be checked
;
; Returns:
;	CF	= 0 if AL is a control character or DEL
;		  1 not a control char or DEL
; Register(s) destroyed:
;-
iscntrl	proc	near
	cmp	al,DEL
	jne	@iscntrl_99
	cmp	al,' '
	cmc
@iscntrl_99:
	ret
iscntrl	endp
^


;+
; FUNCTION : isspace
;
;	Check if a character is a SPACE or a TAB
;
; Parameters:
;	AL	= character to check
;
; Returns:
;	ZF	= 1 if AL is a space or a tab
;		  0 otherwise
; Register(s) destroyed:
;
;-
isspace	proc	near
	cmp	al,TAB
	je	@isspace_99
	cmp	al,SPACE
@isspace_99:
	ret
isspace	endp



;+
; FUNCTION : isdelim
;
;	Check if a character is an MSDOS delimiter.
;
; Parameters:
;	AL	= character to check
;
; Returns:
;	ZF	= 1 if AL is a delimiter
;		  0 otherwise
; Register(s) destroyed:
;
;
; jmh 980512: rewrote using the list
;-
isdelim proc	near
	@save	di,cx
	mov	di,offset delim_list
	mov	cx,delim_len
	repne	scasb
	@restore
	ret
isdelim	endp


;+
; FUNCTION : skip_whitespace
;
;	Searches for the next non-whitespace character in a given string.
;
; Parameters:
;	SI	-> pointer to string
;	CX	== num chars in the string
;
; Returns:
;	CF	= 1 if end-of string reached else 0
;	SI	->next non-whitespace character or end-of-string
;	CX	<-num remaining characters including one pointed to by SI
;
; Register(s) destroyed:
;	AX
;-
skip_whitespace proc near
	jcxz	@skip_whitespace_98		;Empty string
@skip_whitespace_10:
	lodsb					;AL<-next char
	call	near ptr isspace		;Whitespace character ?
	loope	@skip_whitespace_10		;Repeat until
;						 non-whitespace or string ends
	je	@skip_whitespace_98		;End-of-string
; Non-whitespace char found
	dec	si				;SI->non-whitespace char
	inc	cx				;CX<-remaining number of bytes
	clc					;CF<-0 (char found)
;	jmp	short @skip_whitespace_99	;removed by jmh
	ret					;added by jmh

@skip_whitespace_98:
; End of string reached.
	stc					;Set CF

@skip_whitespace_99:
	ret
skip_whitespace endp



;+ FUNCTION : skip_nonwhite, skip_nondelim
;
;	Searches for the next whitespace character / delimiter in a given
;	string.
;
; Parameters:
;	SI	-> pointer to string
;	CX	== num chars in the string
;
; Returns:
;	CF	= 1 if end-of string reached else 0
;	SI	->next whitespace character or end-of-string
;	CX	<-num remaining characters including one pointed to by SI
;
; Register(s) destroyed:
;	AX
;-
skip_non proc near
skip_nonwhite LABEL near
	push	dx
	mov	dx,offset DGROUP:isspace
	jmp	short @skip_non	

skip_nondelim LABEL near
	push	dx
	mov	dx,offset DGROUP:isdelim
@skip_non:
	jcxz	@skip_non_98			;Empty string
@skip_non_10:
	lodsb					;AL<-next char
	call	dx				;nonwhite / delimiter
;						 character ? 
	loopne	@skip_non_10			;Repeat until
;						 whitespace or string ends
	jne	@skip_non_98			;End-of-string
; whitespace char found
	dec	si				;SI->whitespace char
	inc	cx				;CX<-remaining number of bytes
	clc					;CF<-0 (char found)
	jmp	short @skip_non_99

@skip_non_98:
; End of string reached.
	stc					;Set CF

@skip_non_99:
	pop	dx
	ret
skip_non endp



;+
; FUNCTION : push_word
;
;	Looks for the next word (delimited by whitespace) and pushes it
;	onto the specified string stack.
;
; Parameters:
;	BX	-> strstack descriptor
;	SI	-> string
;	CX	== length of string (< 256)
;
; Returns:
;	AX	<- 0 if no errors
;		  -1 if no room in stack
;		  +1 if no word in string
;	SI	-> char after first word (or end-of-string)
;	CX	<- num remaining characters
;
; Register(s) destroyed:
;	DX
;-
push_word proc	near
; Skip forward to first word
	call	near ptr skip_whitespace	;Returns
;						 SI->start of word
;						 CX<-remaining chars
	jcxz	@push_word_98			;No words in line
	mov	dx,si				;DX->start of word
	push	cx				;Save count
	call	near ptr skip_nonwhite		;Find end of word
;						 SI->beyond word
;						 CX<-remaining chars
	pop	ax
	sub	ax,cx				;AX<-length of word
	push	cx				;Save remaining char count
	xor	cx,cx				;CX<-0 (don't force push)
	call	near ptr strstk_push		;Store macro name into
;						 macro stack. Params
;						 AX,BX,CX,DX
;						 Returns Cf = 0 or 1
	pop	cx				;CX<-remaining character
;	Assume no error
	mov	ax,0	;DON'T DO xor ax,ax SINCE CF to be preserved
	jnc	@push_word_99			;Jump if no error
	dec	ax				;Error AX <- -1
;	jmp	short @push_word_99		;Exit (removed by jmh)
	ret

@push_word_98:
; No words found in line. Set return codes.
	mov	ax,1				;Code for blank line

@push_word_99:
	ret
push_word	endp



;+
; FUNCTION : push_string
;
;	Pushed the specified string onto the specified stack.
;
; Parameters:
;	BX	-> strstack descriptor
;	SI	-> string
;	CX	== length of string must be < 256
;
; Returns:
;	CF	<- 0 if no errors
;		   1 if no room in stack
;
; Register(s) destroyed:
;	AX,CX,DX
;-
push_string proc near
	mov	dx,si				;DX->start of string
	xchg	ax,cx				;AX<-length of string
	xor	cx,cx				;CX<-0 (don't force push)
	call	near ptr strstk_push		;Store macro name into
;						 macro stack. Params
;						 AX,BX,CX,DX
;						 Returns Cf = 0 or 1
	ret
push_string	endp



;+
; FUNCTION : bell
;
;	Called to ring the bell.
;
; Parameters:
;	None.
;
; Returns:
;	Nothing.
; Register(s) destroyed:
;	AX
;-
bell	proc	near
	cmp	silent,1
	je	@bell_99
	mov	ax,0e07h		;jmh 980518: use teletype
	int	10h			;Ignore page and attribute
@bell_99:
	ret
bell	endp


;+
; FUNCTION: output_newline
;
; Registers destroyed:
;	AX,DX
;-
output_newline proc near
;	@DispCh CR
;	@DispCh LF
	@DispStr newline		;changed by jmh 980510
	ret
output_newline endp


;+
; FUNCTION: dosify_line by wd
;
; Parameters:
;	SI -> string to massage
;	CX =  line length
; Registers destroyed:
;	AL
;-
dosify_line proc near
	jcxz	@dosify_line_99
	push	cx
	push	si
@dosify_line_10:
	lodsb				;al = currentchar
	cmp	al,'/'			;is this a slash?
	je	@dosify_line_20		;yes, change it
	cmp	al,'\'			;is this a backslash?
	je	@dosify_line_25		;yes, check it
	cmp	al,'-'			;is this a dash
	jne	@dosify_line_40		;no, leave it alone

	cmp	byte ptr [si-2],' '	;is lastchar a space?
	jne	@dosify_line_40		;no, leave it alone
	mov	al,'/'			;yes, change " -" to " /"
	jmp	short @dosify_line_30
@dosify_line_20:
	mov	al,'\'			;change '/' to '\'
@dosify_line_25:			;see if this is a trailing slash
	cmp	cl,1			;is it at the end of the line?
	jne	@dosify_line_26 	;jmh 980514: added following 7 lines
	cmp	si,offset linebuf+1	;is it the only character?
	je	@dosify_line_30 	;yes, leave it alone
	cmp	byte ptr [si-2],':'     ;does it follow a colon
	je	@dosify_line_30
	cmp	byte ptr [si-2],' '     ; or a space?
	je	@dosify_line_30 	;yes, leave it alone
	jmp	short @dosify_line_27	;chop it off
@dosify_line_26:
	cmp	byte ptr [si],' '	;is it before a space?
	jne	@dosify_line_30		;no, leave it alone
@dosify_line_27:
	mov	al,' '			;change trailing slash to a space
@dosify_line_30:
	mov	[si-1],al		;store the revised character
@dosify_line_40:
	loop	@dosify_line_10
	pop	si
	pop	cx
@dosify_line_99:
	ret
dosify_line endp



;+
; FUNCTION : match_ext
;
;	Determine if an extension is in a list of extensions.
;
; Paramters:
;	DS:SI	= Extension
;	CX	= length of extension
;	ES:DI	= Dot ('.') separated, null-terminated list of extensions
;
; Returns:
;	ZF	= 1 for a match
;		  0 otherwise
;
; Registers destroyed:
;	AX,DX
;-
match_ext proc near
	@save	di
@match_ext_0:
	push	di
	xor	dx,dx			;Length of matching extension
@match_ext_1:
	mov	al,es:[di]		;Find the length of the extension to
	cmp	al,'.'                  ;be matched
	je	@match_ext_2
	or	al,al
	je	@match_ext_2
	inc	dx
	inc	di
	jmp	short @match_ext_1
@match_ext_2:
	pop	di			;DI->extension to test against
	cmp	dx,cx			;Lengths the same?
	jne	@match_ext_98		;Nope
	push	cx
	call	stre_cmp
	pop	cx
	je	@match_ext_99
@match_ext_98:
	add	di,dx			;Point to the next extension
	mov	al,es:[di]		;Zero for end of list
	inc	di
	or	al,al			;More extensions left?
	jnz	@match_ext_0		;Yep, go test 'em
	inc	ax			;Clear the Z flag
@match_ext_99:
	@restore
	ret
match_ext endp


CSEG	ENDS

	END

