/*
 * MultiMail offline mail reader
 * help windows

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"

extern mmail		mm;

HelpWindow::HelpWindow()
{
	active = 0;
}

void HelpWindow::redraw()
{
	if (active) {
		touchwin(menu);
		wnoutrefresh(menu);
	}
}

void HelpWindow::newHelpMenu()
{
	menu = newwin(3, COLS - 2, LINES - 4, 1);
	wbkgdset(menu, C_HELP1 | ' ');
	werase(menu);
	wbkgdset(menu, ' ');
}

void HelpWindow::packetlist()
{
	newHelpMenu();
	wattrset(menu, C_HELP2 | A_BOLD);
	mvwaddstr(menu, 0, 1, "Q");
	mvwaddstr(menu, 0, (COLS / 2) - 13, "Enter");
	mvwaddstr(menu, 0, COLS - 20, "A");
	mvwaddstr(menu, 1, (COLS / 2) - 16, "Space, F");
	mvwaddstr(menu, 1, COLS - 20, "B");
	mvwaddstr(menu, 1, 1, "K");
	mvwaddstr(menu, 2, (COLS / 2) - 9, "+");
	mvwaddstr(menu, 2, COLS - 20, "-");
	wattrset(menu, C_HELP1 | A_BOLD);
	mvwaddstr(menu, 0, 2, ": Quit");
	mvwaddstr(menu, 0, (COLS / 2) - 8, ": Select packet");
	mvwaddstr(menu, 0, COLS - 19, ": Addressbook");
	mvwaddstr(menu, 1, (COLS / 2) - 8, ": aliases for PgDn");
	mvwaddstr(menu, 1, COLS - 19, ": alias for PgUp");
	mvwaddstr(menu, 1, 2, ": Kill packet");
	mvwaddstr(menu, 2, (COLS / 2) - 8, ": alias for Right");
	mvwaddstr(menu, 2, COLS - 19, ": alias for Left");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::arealist()
{
	newHelpMenu();
	wattrset(menu, C_HELP2 | A_BOLD);
	mvwaddch(menu, 0, 1, 'Q');
	mvwaddstr(menu, 0, (COLS / 2) - 9, "Enter");
	mvwaddch(menu, 0, COLS - 20, 'A');
	mvwaddch(menu, 1, 1, 'E');
	mvwaddstr(menu, 1, (COLS /2) - 9, "Right");
	mvwaddstr(menu, 1, COLS - 23, "Left");
	mvwaddch(menu, 2, 1, 'L');

	mm.areaList->gotoArea(REPLY_AREA);
	if (mm.areaList->getNoOfLetters() > 0)
		mvwaddstr(menu, 2, (COLS / 2) - 9, "F2, !");

	wattrset(menu, C_HELP1 | A_BOLD);
	mvwaddstr(menu, 0, 2, ": Go to Packet Selection");
	mvwaddstr(menu, 0, (COLS / 2) - 4, ": Select area");
	mvwaddstr(menu, 0, COLS - 19, ": Addressbook");
	mvwaddstr(menu, 1, 2, ": Enter letter to area");
	mvwaddstr(menu, 1, (COLS / 2) - 4, ": Next non-empty");
	mvwaddstr(menu, 1, COLS - 19, ": Prev non-empty");
	mvwaddstr(menu, 2, 2, ": Long/short area list");

	if (mm.areaList->getNoOfLetters() > 0)
		mvwaddstr(menu, 2, (COLS / 2) - 4, ": Make reply packet");

	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::letterlist()
{
	reply_area_letterlist();
	mvwaddstr(menu, 1, 2, ": Enter letter in area");
	mvwaddstr(menu, 1, COLS - 29, ": Mark/unmark");
	mvwaddstr(menu, 2, 2, ": Unread/read toggle");
	mvwaddstr(menu, 2, (COLS / 2) - 8, ": Next unread");
	mvwaddstr(menu, 2, COLS - 29, ": Previous unread");
	wattrset(menu, C_HELP2 | A_BOLD);
	mvwaddch(menu, 1, 1, 'E');
	mvwaddch(menu, 1, COLS - 30, 'M');
	mvwaddch(menu, 2, 1, 'U');
	mvwaddstr(menu, 2, (COLS / 2) - 13, "Right");
	mvwaddstr(menu, 2, COLS - 33, "Left");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::reply_area_letterlist()
{
	newHelpMenu();
	wattrset(menu, C_HELP2 | A_BOLD);
	mvwaddch(menu, 0, 1, 'Q');
	mvwaddstr(menu, 0, (COLS / 2) - 13, "Enter");
	mvwaddch(menu, 0, COLS - 30, 'S');
	mvwaddch(menu, 1, 1, 'E');
	mvwaddch(menu, 1, (COLS / 2) - 9, 'K');
	mvwaddch(menu, 1, COLS - 30, 'A');
	wattrset(menu, C_HELP1 | A_BOLD);
	mvwaddstr(menu, 0, 2, ": Back to arealist");
	mvwaddstr(menu, 0, (COLS / 2) - 8, ": Read letter");
	mvwaddstr(menu, 0, COLS - 29, ": Save all letters in area");
	mvwaddstr(menu, 1, 2, ": Edit letter");
	mvwaddstr(menu, 1, (COLS / 2) - 8, ": Kill letter");
	mvwaddstr(menu, 1, COLS - 29, ": Addressbook");

	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::letter()
{
	menu2 = new ShadowedWin(19, 50, LINES / 2 - 9, COLS / 2 - 25,
		C_HELP3 | A_BOLD);
	wattrset(menu2->win, C_HELP4 | A_BOLD);
	mvwaddstr(menu2->win, 1, 2, "S - Save letter");
	mvwaddstr(menu2->win, 2, 2, "R - Reply to letter");
	mvwaddstr(menu2->win, 3, 2, "O - reply to Original sender");
	mvwaddstr(menu2->win, 4, 2, "E - Enter letter");
	mvwaddstr(menu2->win, 5, 2, "N - Netmail reply");
	mvwaddstr(menu2->win, 6, 2, "T - Take tagline");
	mvwaddstr(menu2->win, 7, 2, "A - Addressbook");
	mvwaddstr(menu2->win, 8, 2, "M - Mark/unmark letter");
	mvwaddstr(menu2->win, 9, 2, "U - Unread/read toggle");
	mvwaddstr(menu2->win, 10, 2, "C - toggle Character set translation");
	mvwaddstr(menu2->win, 11, 2, "V, ^V, ^A - ANSI viewer");
	mvwaddstr(menu2->win, 12, 2, "Left - Previous letter");
	mvwaddstr(menu2->win, 13, 2, "Right, Enter - Next letter");
	mvwaddstr(menu2->win, 14, 2, "Space - Page through area");
	mvwaddstr(menu2->win, 15, 2, "Q - Go back to index");
	mvwaddstr(menu2->win, 17, 2,
		"Plus the standard up/down and PgUp/PgDn keys");
	menu2->touch();
	active = 2;
}

void HelpWindow::reply_area_letter()
{
	menu2 = new ShadowedWin(14, 50, LINES / 2 - 7, COLS / 2 - 25,
		C_HELP3 | A_BOLD);
	wattrset(menu2->win, C_HELP4 | A_BOLD);
	mvwaddstr(menu2->win, 1, 2, "K - Kill letter");
	mvwaddstr(menu2->win, 2, 2, "E - Edit letter");
	mvwaddstr(menu2->win, 3, 2, "S - Save letter");
	mvwaddstr(menu2->win, 4, 2, "A - Addressbook");
	mvwaddstr(menu2->win, 5, 2, "C - toggle Character set translation");
	mvwaddstr(menu2->win, 6, 2, "V, ^V, ^A - ANSI viewer");
	mvwaddstr(menu2->win, 7, 2, "Left - Previous letter");
	mvwaddstr(menu2->win, 8, 2, "Right, Enter - Next letter");
	mvwaddstr(menu2->win, 9, 2, "Space - Page through area");
	mvwaddstr(menu2->win, 10, 2, "Q - Go back to index");
	mvwaddstr(menu2->win, 12, 2,
		"Plus the standard up/down and PgUp/PgDn keys");
	menu2->touch();
	active = 2;
}

void HelpWindow::Delete()
{
	if (active == 2)
		delete menu2;
	else
		delwin(menu);
	active = 0;
}
