/*
 * MultiMail offline mail reader
 * compress and decompress packets

 Copyright (c) 1997 John Zero <john@graphisoft.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"
#include "compress.h"
#include "../interfac/mysystem.h"

int lastAType = 0;	// saves&stores last arch type for compress routine

int getArchiveType(const char *fname)
{
	FILE *f;
	unsigned magic;
	int tip;

	if (!(f = fopen(fname, "rb")))
		fatalError("Could not open packet to uncompress");
	magic = fgetc(f) << 8;
	magic += fgetc(f);

	tip = A_UNKNOWN;
	switch (magic) {
	case 0x60EA:
		tip = A_ARJ;

	case 0x504B:		// PK - check for ZIP
		if (3 == fgetc(f))
			if (4 == fgetc(f))
				tip = A_ZIP;

	default:		// can be LHA - check 3. and 4. bytes
		if ('-' == fgetc(f))
			if ('l' == fgetc(f))
				tip = A_LHA;
	// we should check another byte (l/z) but i'm lazy
	}
	fclose(f);

	return tip;
}

// clears the working directory and uncompresses the packet into it.
void uncompressFile(resource *ro, const char *fname, const char *todir)
{
	char command[255];
	const char *cm;
	int at;

	clearDirectory(todir);
	at = getArchiveType(fname);
	lastAType = at;

	switch (at) {
	case A_ARJ:
		cm = ro->get(arjUncompressCommand);
		break;
	case A_ZIP:
		cm = ro->get(zipUncompressCommand);
		break;
	case A_LHA:
		cm = ro->get(lhaUncompressCommand);
		break;
	default:
		cm = ro->get(unknownUncompressCommand);
	}

	sprintf(command, "%s %s", cm, canonize(fname));

	if (mysystem(command))
		fatalError("Could not uncompress packet");
};

void compressAddFile(resource *ro, const char *arcdir, const char *arcfile, 
			const char *addfname)
{
	char tmp[256], tmp2[256];
	const char *cm;

	switch (lastAType) {
	case A_ARJ:
		cm = ro->get(arjCompressCommand);
		break;
	case A_ZIP:
		cm = ro->get(zipCompressCommand);
		break;
	case A_LHA:
		cm = ro->get(lhaCompressCommand);
		break;
	default:
		cm = ro->get(unknownCompressCommand);
	}

	sprintf(tmp2, "%s/%s", arcdir, arcfile);
	sprintf(tmp, "%s %s %s", cm, canonize(tmp2), addfname);
	mysystem(tmp);

	if (lastAType == A_LHA) {	// then the fixup
		char *tmp2 = strdupplus(arcfile);
		strtok(tmp2, ".");
		sprintf(tmp, "%s/%s.bak", arcdir, tmp2);
		remove(tmp);
		delete(tmp2);
	}
};
