/*
 * MultiMail offline mail reader
 * main_read_class, reply_read_class

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"
#include "compress.h"

/* main_read_class -- for regular areas */

main_read_class::main_read_class(mmail *mm, specific_driver *driver)
{
	FILE *readFile;
	char *readFileN;

	ro = mm->resourceObject;

	noOfAreas = driver->getNoOfAreas();
	noOfLetters = new int[noOfAreas];
	readStore = new int *[noOfAreas];

	readFileN = readFilePath(ro->get(PacketName));
	readFile = mm->workList->ftryopen(readFileN, "rb");

	for (int c = 0; c < noOfAreas; c++) {
		driver->selectArea(c);
		noOfLetters[c] = driver->getNoOfLetters();
		readStore[c] = new int[noOfLetters[c]];
		for (int d = 0; d < noOfLetters[c]; d++)
			readStore[c][d] = readFile ? getc(readFile) : 0;
	}
	if (readFile)
		fclose(readFile);
}

main_read_class::~main_read_class()
{
	while(noOfAreas)
		delete readStore[--noOfAreas];
	delete readStore;
}

void main_read_class::setRead(int area, int letter, int value)
{
	readStore[area][letter] &= (255 - MS_READ);  // take out the read bit
	if (value)
		readStore[area][letter] |= MS_READ;
}

int main_read_class::getRead(int area, int letter)
{
	return readStore[area][letter] & MS_READ;
}

void main_read_class::setStatus(int area, int letter, int value)
{
	readStore[area][letter] = value;
}

int main_read_class::getStatus(int area, int letter)
{
	return readStore[area][letter];
}

int main_read_class::getNoOfUnread(int area)
{
	int tmp = 0;

	for (int c = 0; c < noOfLetters[area]; c++)
		if (!(readStore[area][c] & MS_READ))
			tmp++;
	return tmp;
}

void main_read_class::saveAll()
{
	FILE *readFile;
	const char *readFileN;

	readFileN = readFilePath(ro->get(PacketName));
	readFile = fopen(readFileN, "wb");

	for (int c = 0; c < noOfAreas; c++)
		for (int d = 0; d < noOfLetters[c]; d++)
			putc(readStore[c][d], readFile);

	fclose(readFile);

	// add the .red file to the packet
	compressAddFile(ro, ro->get(PacketDir),
		ro->get(PacketName), readFileN);
}

char *main_read_class::readFilePath(const char *FileN)
{
	static char tmp[13];

	if(mychdir(ro->get(WorkDir)))
		fatalError("Unable to change to work directory");
	sprintf(tmp, "%.8s.red", findBaseName(FileN));
	return tmp;
}

/* reply_read_class -- for reply areas */
/* (Formerly known as dummy_read_class, because it does almost nothing) */

reply_read_class::reply_read_class(mmail *mmA, specific_driver *driverA)
{
	mmA = mmA;
	driverA = driverA;
}

reply_read_class::~reply_read_class()
{
}

void reply_read_class::setRead(int area, int letter, int value)
{
	area = area;
	letter = letter;
	value = value;
}

int reply_read_class::getRead(int area, int letter)
{
	area = area;
	letter = letter;
	return 1;
}

void reply_read_class::setStatus(int area, int letter, int value)
{
	area = area;
	letter = letter;
	value = value;
}

int reply_read_class::getStatus(int area, int letter)
{
	area = area;
	letter = letter;
	return 1;
}

int reply_read_class::getNoOfUnread(int area)
{
	area = area;
	return 0;
}

void reply_read_class::saveAll()
{
}
