REM Polynomial program Copyright 1998 by Chris Katscher.
REM Base code for user input routines and menu routines provided by B.J. Black.
REM E-Mail to:      schmong@primenet.com

REM Original Apple II program inception:     11- 6-1989
REM Original Apple II program completion:    11- 6-1992
REM Revised PC program inception:             6- 7-1996
REM Revised PC program last revised on:       1-11-1999,  2:25 PM
REM Revised PC program completion:             -  -1998
REM Immediate to-do's:
REM 1: Finish implementing plotting routine into polynomial

REM Subroutine/Function naming Conventions:
REM These naming conventions affect in no way how QBasic operates, and is
REM     not required of any QBasic programs.  I implemented these naming
REM     conventions because there are so many subs, I myself get lost
REM     navigating through the myriad of subs.
REM Those subs and functions that end with "0" (ex: Getkey0):
REM     These are subs and functions that any sub or function and even the
REM     main routine can call at any time during program execution.
REM     Different from "CS" subroutines because "F" subroutines can only
REM     call "0" subs and other "F" prefixed subs.
REM Those subs and functions that end with "1" (ex: Calculus1):
REM     These are subroutines that are only called by the main program, they
REM     are subroutines nested 1 level deep from the main program.
REM Those subs and functions that end with "2" (ex: AddSub2):
REM     These are subroutines that are only called from within a sub with a
REM     "1" suffix on the end of it, these are subs that are 2 levels deep
REM     from the main program.
REM Those subs and functions that end with "CS" (ex: ChooseCS):
REM     These are subs that are so called "Common Subs" which are accessed
REM     from any other sub or function except those that have the "F" prefix.
REM Those subs and functions that begin with "F", and end with "0" (ex: FPAK0):
REM     These are the subs that deal with function keys directly and should
REM     only called from within themselves except FChoice0, which can be
REM     called anywhere.  This is due to memory considerations.
REM Any subs or functions that have no designation are not to be included in
REM     the final release.  These subs are for debugging purposes only and
REM     implemented in F-Keys.  Examples: DisplayRaw, FreeMem

REM Declare's ================================================================

DECLARE SUB Plot2 ()
DECLARE SUB Root1 ()
DECLARE SUB ExitP1 ()
DECLARE SUB FMenu0 ()
DECLARE SUB Graph1 ()
DECLARE SUB FreeMem ()
DECLARE SUB FShell0 ()
DECLARE SUB Fractal2 ()
DECLARE SUB Calculus1 ()
DECLARE SUB DisplayRaw ()
DECLARE SUB FChoice0 (a$)
DECLARE SUB InputPolCS ()
DECLARE SUB PolyMenuCS ()
DECLARE SUB Arithmetic1 ()
DECLARE SUB ChangePolCS ()
DECLARE SUB InputRootCS ()
DECLARE SUB DisplayPolCS ()
DECLARE SUB Explanation1 ()
DECLARE SUB InputCoeffCS ()
DECLARE SUB UtilityMenu1 ()
DECLARE SUB ClearScreenCS ()
DECLARE SUB InputRandomCS ()
DECLARE SUB CreateP1CS (Deg%)
DECLARE SUB SetVideoModeCS ()
DECLARE SUB ClearLocCS (pLoc%)
DECLARE SUB CreateN1CS (pLoc%)
DECLARE SUB CreateP2CS (pLoc%)
DECLARE SUB ClearRootCS (pLoc%)
DECLARE SUB DisplayOutputCS (op$)
DECLARE SUB DisplayRootCS (pLoc%)
DECLARE SUB ChangeLocCS (Loc1%, Loc2%)
DECLARE SUB ChangeRootCS (Loc1%, Loc2%)
DECLARE SUB PrintMenu0 (Menu1$, Menu2$)
DECLARE SUB AddSub2 (Loc1%, Loc2%, Loc3%)
DECLARE SUB MinSub2 (Loc1%, Loc2%, Loc3%)
DECLARE SUB PowSub2 (Loc1%, Loc2%, Loc3%, Power#)
DECLARE SUB AxisTick2 (tpd1#, tpd2#, tpr1#, tpr2#, tmaxX%, tmaxY%)
DECLARE SUB ReDrawCS (theArr() AS ANY, CurX%, CurY%, dimen%, ind%, r1%, r2%, CLen%, Cstart%)
DECLARE FUNCTION FPAK0$ ()
DECLARE FUNCTION GetKey0$ ()
DECLARE FUNCTION FofX# (xtmp#)
DECLARE FUNCTION SynthWithoutCS# (pLoc%, xx#)
DECLARE FUNCTION MulSub2% (Loc1%, Loc2%, Loc3%)
DECLARE FUNCTION InputErrorCS% (CHK$, low%, high%)
DECLARE FUNCTION SynthWithCS# (Loc1%, Loc2%, Loc3%)
DECLARE FUNCTION DivSub2% (Loc1%, Loc2%, Loc3%, Loc4%)
DECLARE FUNCTION SubSub2% (Loc1%, Loc2%, Loc3%, Loc4%)
DECLARE FUNCTION ChooseCS% (MenuID%, row%, col%, initS%)
DECLARE FUNCTION EditStrCS$ (theStr$, row%, col%, max%, accChars$)
DECLARE FUNCTION ArrEditCS% (theArr() AS ANY, max%, dimen%, absBeg%, absLen%, CLen%, Cstart%)

REM ==========================================================================

REM Definitions of data types
TYPE ComplexInput
    Real AS DOUBLE
    Imag AS DOUBLE
    Num AS INTEGER
END TYPE
REM =========================

REM Mathematical constants
CONST pi = 3.141592653589793#
REM ======================

REM Programmer changeable constants
CONST mDeg = 50: REM Max Degree allowed                             (initable)
CONST nPol = 13: REM Max number of polynomials that the program knows about
CONST uPol = 10: REM Max number of polynomials that the user knows about
CONST maxCol = 80: REM Maximum number of columns, can be 40 or 80   (initable)
CONST numMenus = 7: REM Total number of menus
CONST numStrs = 40: REM Total number of menu items
CONST text = 15: REM text color                                     (initable)
CONST back = 1: REM background color                                (initable)
CONST info = 11: REM informational text color                       (initable)
REM ===============================

COMMON SHARED LoopExit%
COMMON SHARED MenuTitle$
COMMON SHARED maxRow%
COMMON SHARED maxX%, maxY%, screenMode%
COMMON SHARED n1$, n2$, p1$, p2$
COMMON SHARED errorCode%
COMMON SHARED ZeroArr AS ComplexInput
CLEAR , , 1024

REM n1$ is the name of the polynomial in question.
REM n2$ is the name of the polynomial just created at location ?
REM p1$ is the name of the polynomial in question.
REM p2$ is the look of the polynomial just created at location ?

REM Programmer changeable variables
maxRow% = 25: REM Maximum number of rows, can be 25, 43, 50
DATA 5,9,2,6,8,7,3: REM the number of items on each menu
REDIM SHARED a#(nPol, 2 * mDeg)
REDIM SHARED d%(nPol), d$(nPol), ndRoots%(nPol)
REDIM SHARED Flag%(10), scrdmp%(8000)
REDIM SHARED menuItems$(numStrs)
REDIM SHARED numItems%(numMenus)
REDIM SHARED x(nPol, 2 * mDeg) AS ComplexInput
REM ===============================

REM mDeg is the maximum degree that can be used by all functions.
REM a#(nPol,2 * mDeg) is the coefficient array, a(1,?) is the 1st pol,
REM                   a(2,?) is the 2nd pol, etc...
REM x(nPol, mDeg) is the value of the mDeg roots at the nPol locations
REM               x(n,m).Real = the real part
REM               x(n,m).Imag = the imaginary part
REM               x(n,m).Num = the multiplicity of root m at location n
REM ndRoots%(nPol) is the number of distinct roots at location n
REM d%(nPol) is the degree of the polynomials at Locs: 0 - nPol

REM x(nPol, mDeg), d%(nPol), and ndRoots%(nPol) are related by:
REM d%(nPol) = 0
REM FOR z% = 1 TO ndRoots%(nPol)
REM     d%(nPol) = d%(nPol) + x(nPol, z%).Num
REM NEXT z%

REM Flag%(?) are flag values that flag special cases.
REM Flag%(1) flags that a subroutine failed to complete its task, value points
REM          to the reason why.
REM Flag%(2) Obsolete (find a use for me please!)
REM Flag%(3) flags that the Explanation subroutine was used and the screen
REM          needs to be refreshed, used only in FChoice.
REM Flag%(4) flags that the PAK$ was pressed used only in "F" subs.
REM Flag%(5) flags that a polynomial is to be overwritten or not: 0 = yes, 1 = no
REM Flag%(6) flags that a routine should not be used because a process was
REM          already done.  Only used in InputRootCS.
REM Flag%(7) flags that the DisplayRootCS routine should pipe its output to a
REM          file, instead of the screen.

REM ArrEditCS and EditStrCS control characters

DIM SHARED cr AS STRING * 1
cr = CHR$(13)
DIM SHARED bs AS STRING * 1
bs = CHR$(8)
DIM SHARED es AS STRING * 1
es = CHR$(27)
DIM SHARED ta AS STRING * 1
ta = CHR$(9)
DIM SHARED st AS STRING * 2
st = CHR$(0) + CHR$(15)
DIM SHARED up AS STRING * 2
up = CHR$(0) + CHR$(72)
DIM SHARED dn AS STRING * 2
dn = CHR$(0) + CHR$(80)
DIM SHARED le AS STRING * 2
le = CHR$(0) + CHR$(75)
DIM SHARED ri AS STRING * 2
ri = CHR$(0) + CHR$(77)
DIM SHARED in AS STRING * 2
in = CHR$(0) + CHR$(82)
DIM SHARED de AS STRING * 2
de = CHR$(0) + CHR$(83)
DIM SHARED ho AS STRING * 2
ho = CHR$(0) + CHR$(71)
DIM SHARED en AS STRING * 2
en = CHR$(0) + CHR$(79)
DIM SHARED pu AS STRING * 2
pu = CHR$(0) + CHR$(73)
DIM SHARED pd AS STRING * 2
pd = CHR$(0) + CHR$(81)

REM ==========================================

REM Read in all menu items
OPEN "POLYMENU.DAT" FOR INPUT AS #1
FOR a% = 0 TO numStrs - 1
    LINE INPUT #1, menuItems$(a%)
NEXT a%
CLOSE #1
REM ======================

REM Load the values for items/menus
FOR a% = 0 TO numMenus - 1
    READ numItems%(a%)
NEXT a%
REM ===============================

ON ERROR GOTO ErrorTrap

WIDTH maxCol, maxRow%
init1% = 1
COLOR info, 1: CLS
Explanation1
FChoice0 (FPAK0)

REM ******************** BEGINING OF MAIN LOOP ********************
DO
    MenuTitle$ = "Polynomial Program Main Menu v0.4"
    PrintMenu0 MenuTitle$, ""
    FMenu0
    Choice% = ChooseCS%(0, 3, 1, init1%)
    SELECT CASE Choice%
        CASE 0
            init1% = 1: ExitP1
        CASE 1
            init1% = 1: Arithmetic1
        CASE 2
            init1% = 2: Graph1
        CASE 3
            init1% = 3: Calculus1
        CASE 4
            init1% = 4: Root1
        CASE 5
            init1% = 5: UtilityMenu1
    END SELECT
LOOP UNTIL (LoopExit% = 1)
REM ********************** END OF MAIN LOOP ***********************

COLOR 7, 0: CLS
PRINT "Thank you for using poly05."
SYSTEM

REM Error trap routine
ErrorTrap:
    SELECT CASE ERR
        CASE 5: REM Illegal function call
            errorCode% = 5: REM Return to start with negative response
            REM PRINT : PRINT : PRINT "Illegal function call, program aborted!": END
        CASE 6: REM Overflow
            PRINT : PRINT : PRINT "Overflow error, program aborted!": END
        CASE 7: REM Out of Memory
            PRINT : PRINT : PRINT "Out of memory error, program aborted!": END
        CASE 11: REM Division by Zero
            PRINT : PRINT : PRINT "Division by Zero error, program aborted!": END
        CASE 14: REM Out of string space
            PRINT : PRINT : PRINT "Out of string space, program aborted!": END
        CASE 53: REM File not found
            errorCode% = 53
        CASE 58: REM File already exists
            errorCode% = 58
        CASE 64: REM Bad file name
            PRINT : PRINT : PRINT "Bad file name, program aborted!": END
            'errorCode% = 64
        CASE 75: REM Path/File access error
            PRINT : PRINT : PRINT "Path/File access error, program aborted!": END
            'errorCode% = 75
        CASE 76: REM Path not found
            PRINT : PRINT : PRINT "Path not found, program aborted!": END
            'errorCode% = 76
        CASE ELSE
            PRINT : PRINT "Undefined error #"; ERR; "program terminated!": END
    END SELECT
RESUME NEXT
REM ==================

SUB AddSub2 (Loc1%, Loc2%, Loc3%)

IF (d%(Loc1%) > d%(Loc2%)) THEN
    maxDeg% = d%(Loc1%)
ELSE
    maxDeg% = d%(Loc2%)
END IF
ClearLocCS (Loc3%)
IF ((d$(Loc1%) = "") OR (d$(Loc1%) = "Z")) THEN
    d$(Loc1%) = "Z"
END IF
IF ((d$(Loc2%) = "") OR (d$(Loc2%) = "Z")) THEN
    d$(Loc2%) = "Z"
END IF
FOR z% = 0 TO maxDeg%
    a#(Loc3%, z%) = a#(Loc1%, z%) + a#(Loc2%, z%)
NEXT z%
d%(Loc3%) = maxDeg%: d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))

END SUB

SUB Arithmetic1

MenuTitle$ = "Poly Arithmetic Menu"
init2% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
PrintMenu0 MenuTitle$, ""
LOCATE 13, 1, 0
PRINT : PRINT
COLOR info, 1
PRINT "NOTE: To use the raising to a power routine, the 2nd location will be used,"
PRINT "and then cleared.  When using the division and substitution algorithm, the"
PRINT "computer must use the 4th location in memory. When finished, the 4th location"
PRINT "will hold the remainder polynomial from the division algorithm."
COLOR text, back
Choice% = ChooseCS%(1, 3, 1, init2%)
SELECT CASE Choice%
    CASE 1
        init2% = 1
        subTitle$ = ": Adding Polys"
        PrintMenu0 MenuTitle$, subTitle$
        AddSub2 1, 2, 3
        PolyMenuCS
        DisplayOutputCS ("+")
    CASE 2
        init2% = 2
        subTitle$ = ": Subtracting Polys"
        PrintMenu0 MenuTitle$, subTitle$
        MinSub2 1, 2, 3
        PolyMenuCS
        DisplayOutputCS ("-")
    CASE 3
        init2% = 3
        subTitle$ = ": Multiplying Polys"
        PrintMenu0 MenuTitle$, subTitle$
        Flag%(1) = MulSub2(1, 2, 3)
        PolyMenuCS
        IF (Flag%(1) = 0) THEN
            DisplayOutputCS ("x")
        ELSE
            PRINT : PRINT "The resulting polynomial will be of a degree greater than"; 2 * mDeg; "."
        END IF
     CASE 4
        init2% = 4
        subTitle$ = ": Dividing Polys"
        PrintMenu0 MenuTitle$, subTitle$
        Flag%(1) = DivSub2(1, 2, 3, 4)
        PolyMenuCS
        IF (Flag%(1) = 1) THEN
            PRINT : PRINT "The 1st polynomial's degree is smaller than the 2nd polynomial's degree.": PRINT
        ELSE
            CreateP2CS (1): PRINT : PRINT "("; p2$; ") /":
            CreateP2CS (2): PRINT "("; p2$; ") ="
            CreateP2CS (3): PRINT : PRINT "("; p2$;
            IF (d$(4) = "Z") THEN
                PRINT ")"
            ELSE
                CreateP2CS (4): PRINT ") + ("; p2$; ") / (";
                CreateP2CS (2): PRINT p2$; "))"
            END IF
            PRINT : PRINT "The resulting polynomial is a": PRINT
            CreateN1CS (3): PRINT n1$; ", and has the form:": PRINT
            IF ((d$(3) = "U") OR (d$(3) = "I")) THEN
                CreateP2CS (3): PRINT p2$
            ELSE
                IF (d$(4) = "Z" AND d$(2) <> "Z") THEN
                    CreateP2CS (3): PRINT p2$: PRINT : PRINT "The 2nd polynomial ";
                    COLOR back, text: PRINT "IS"; : COLOR text, back
                    PRINT " a factor of the first.": PRINT
                ELSE
                    CreateP2CS (3): PRINT p2$; " + R(x)/Q(x)": PRINT
                END IF
            END IF
        END IF
        IF (d$(3) = "I" OR d$(3) = "U") THEN
            ClearLocCS (3)
        END IF
    CASE 5
        init2% = 5
        subTitle$ = ": Raising a Poly to a Power"
        PrintMenu0 MenuTitle$, subTitle$
        IF (d%(1) = 0) THEN
            IF (a#(1, 0) = 0) THEN
                UpLimit# = 1D+308: d$(1) = "Z"
            ELSEIF (a#(1, 0) = 1) THEN
                UpLimit# = 1D+308
            ELSE
                UpLimit# = ABS((308 * LOG(10)) / (LOG(ABS(a#(1, 0)))))
            END IF
        ELSE
            UpLimit# = 2 * mDeg / d%(1)
        END IF
        CreateP2CS (1): PRINT : PRINT "f(x) = "; p2$: PRINT
        PRINT "You can raise this polynomial to a"
        IF (d%(1) = 0 AND a#(1, 0) >= 0) THEN
            PRINT "real power from "; -UpLimit#; "to"; UpLimit#; "."
        ELSE
            PRINT "positive integer power from 0 to"; INT(UpLimit#); "."
        END IF
        DO
            ImpErr% = 0: PRINT
            CurrCol% = CSRLIN - 1: INPUT "Input the power, p-->"; xx$: xx# = VAL(xx$)
            PRINT
            IF (ABS(xx#) > UpLimit# AND xx# > 0) THEN
                PRINT "Input error!  Your value for abs(p) must be <"; UpLimit#:
                PRINT "please input again!"
                ImpErr% = 1
                FChoice0 (FPAK0)
                LOCATE CurrCol%, 1
                PRINT SPACE$(640)
                LOCATE CurrCol%, 1
            ELSE
                IF ((d%(1) = 0 AND a#(1, 0) < 0) OR (d%(1) > 0)) THEN
                    IF (xx# < 0 OR xx# <> INT(xx#)) THEN
                        PRINT "Input Error! Your value for p must be an integer greater than zero.  Please"
                        PRINT "input again!": ImpErr% = 1
                        FChoice0 (FPAK0)
                        LOCATE CurrCol%, 1
                        PRINT SPACE$(640)
                        LOCATE CurrCol%, 1
                    END IF
                END IF
            END IF
        LOOP UNTIL (ImpErr% = 0)
        CLS 2
        CreateP2CS (1): PRINT : PRINT "("; p2$; ") ^ "; LTRIM$(STR$(xx#)); " = ": PRINT
        PowSub2 1, 2, 3, xx#
        CurX% = POS(0)
        CurY% = CSRLIN
        PolyMenuCS
        LOCATE CurY%, CurX%
        CreateP2CS (3): PRINT "("; p2$; ")": PRINT
        PRINT "The resulting polynomial is a": PRINT
        CreateN1CS (3): PRINT n1$; ", and has the form:": PRINT
        CreateP2CS (3): PRINT p2$: PRINT
        IF (d$(2) = "I" OR d$(2) = "U") THEN
            ClearLocCS (2): ClearLocCS (3)
        END IF
    CASE 6
        init2% = 6
        subTitle$ = ": Subing one Poly into another"
        PrintMenu0 MenuTitle$, subTitle$
        Flag%(1) = 0: ClearLocCS (3): ClearLocCS (4)
        IF ((d%(1) = 0) AND (a#(1, 0) = 0)) THEN
            d$(1) = "Z"
        ELSE
            d$(1) = LTRIM$(STR$(d%(1)))
        END IF
        IF ((d%(2) = 0) AND (a#(2, 0) = 0)) THEN
            d$(2) = "Z"
        ELSE
            d$(2) = LTRIM$(STR$(d%(2)))
        END IF
        CreateP2CS (1): PRINT : PRINT "f(x) = "; p2$
        CreateP2CS (2): PRINT "g(x) = "; p2$
        Flag%(1) = SubSub2(1, 2, 3, 4)
        CurX% = POS(0)
        CurY% = CSRLIN
        PolyMenuCS
        LOCATE CurY%, CurX%
        IF (Flag%(1) = 0) THEN
            CreateP2CS (3): PRINT "f[g(x)] = "; p2$: PRINT
            PRINT "The resulting polynomial is a": PRINT
            CreateN1CS (3): PRINT n1$; ", and has the form:": PRINT
            PRINT p2$: PRINT
        ELSE
            PRINT "f[g(x)] is of a degree >"; 2 * mDeg; "."
        END IF
    CASE 7
        init2% = 7: InputCoeffCS
    CASE 8
        init2% = 8: ChangePolCS
    CASE 9
        init2% = 9: DisplayPolCS
END SELECT
IF (Choice% <> 0) THEN FChoice0 (FPAK0)
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

FUNCTION ArrEditCS% (theArr() AS ComplexInput, max%, dimen%, absBeg%, absLen%, CLen%, Cstart%)

numElem% = 0: REM numElem% is the total number of elements in the array
curElemX% = 1: REM curElemX% is the current element being edited in the X direction
curElemY% = 0: REM curElemY% is the current element being edited in the Y direction
begScr% = 0: REM begScr% is the first element in the current viewable window
lenScr% = 1: REM lenScr% is the length of the current viewable window
REM absBeg% is the absolute beginning that the virtual window will always start at
REM absLen% is the absolute length that the virtual window will always be

accChars$ = "0123456789.deDE+- ": REM allowStr% is the allowable string values

VIEW PRINT absBeg% TO absBeg% + absLen%

DO
    ReDrawCS theArr(), curElemX%, curElemY%, dimen%, begScr%, absBeg%, absBeg% + lenScr%, CLen%, Cstart%
    IF (curElemX% = 1) THEN
        IF (theArr(curElemY%).Real <> 0) THEN
            b$ = LTRIM$(STR$(theArr(curElemY%).Real))
        ELSE
            b$ = "0"
        END IF
        a$ = EditStrCS$(b$, curElemY% - begScr% + absBeg%, Cstart% + 1, CLen%, accChars$)
    ELSEIF (curElemX% = 2) THEN
        IF (theArr(curElemY%).Imag <> 0) THEN
            b$ = LTRIM$(STR$(theArr(curElemY%).Imag))
        ELSE
            b$ = "0"
        END IF
        a$ = EditStrCS$(b$, curElemY% - begScr% + absBeg%, Cstart% + CLen% + 6, CLen%, accChars$)
    ELSE
        IF (theArr(curElemY%).Num <> 1) THEN
            b$ = LTRIM$(STR$(theArr(curElemY%).Num))
        ELSE
            b$ = "1"
        END IF
        a$ = EditStrCS$(b$, curElemY% - begScr% + absBeg%, Cstart% + 2 * CLen% + 11, 5, accChars$)
    END IF
    IF (curElemX% = 1) THEN
        theArr(curElemY%).Real = VAL(b$)
    ELSEIF (curElemX% = 2) THEN
        theArr(curElemY%).Imag = VAL(b$)
    ELSE
        InputErr% = InputErrorCS(b$, 0, mDeg)
        IF (InputErr% = 0) THEN
            theArr(curElemY%).Num = VAL(b$)
        ELSE
            theArr(curElemY%).Num = 1
        END IF
    END IF
    SELECT CASE a$
        CASE es
            LOCATE , , , 30
        CASE cr
            IF (curElemY% < numElem%) THEN
                curElemY% = curElemY% + 1
                IF (curElemY% = begScr% + lenScr%) THEN begScr% = begScr% + 1
            ELSE
                IF (numElem% < max% - 1) THEN
                    numElem% = numElem% + 1: curElemY% = numElem%
                    IF (numElem% < absLen%) THEN lenScr% = lenScr% + 1
                    IF (begScr% + lenScr% <= curElemY%) THEN begScr% = begScr% + 1
                END IF
            END IF
        CASE ta
            IF (dimen% = 2) THEN
                IF (curElemX% < 3) THEN
                    curElemX% = curElemX% + 1
                END IF
            ELSE
                IF (curElemY% < numElem%) THEN
                    curElemY% = curElemY% + 1
                    IF (curElemY% = begScr% + lenScr%) THEN begScr% = begScr% + 1
                ELSE
                    IF (numElem% < max% - 1) THEN
                        numElem% = numElem% + 1: curElemY% = numElem%
                        IF (numElem% < absLen%) THEN lenScr% = lenScr% + 1
                        IF (begScr% + lenScr% <= curElemY%) THEN begScr% = begScr% + 1
                    END IF
                END IF
            END IF
        CASE st
            IF (dimen% = 2) THEN
                IF (curElemX% > 1) THEN
                    curElemX% = curElemX% - 1
                END IF
            ELSE
                IF (curElemY% > 0) THEN
                    curElemY% = curElemY% - 1
                    IF (begScr% > curElemY%) THEN begScr% = begScr% - 1
                ELSE
                    curElemY% = numElem%
                    IF (numElem% > absLen% - 1) THEN begScr% = numElem% - absLen% + 1 ELSE begScr% = 0
                END IF
            END IF
        CASE up
            IF (curElemY% > 0) THEN
                curElemY% = curElemY% - 1
                IF (begScr% > curElemY%) THEN begScr% = begScr% - 1
            ELSE
                curElemY% = numElem%
                IF (numElem% > absLen% - 1) THEN begScr% = numElem% - absLen% + 1 ELSE begScr% = 0
            END IF
        CASE dn
            IF (curElemY% < numElem%) THEN
                curElemY% = curElemY% + 1
                IF (begScr% + lenScr% <= curElemY%) THEN begScr% = begScr% + 1
            ELSE
                curElemY% = 0: begScr% = 0
            END IF
        CASE pd
            IF (numElem% < absLen% - 1) THEN
                curElemY% = numElem%
            ELSE
                IF (curElemY% > numElem% - lenScr% + 1) THEN
                    curElemY% = numElem%
                    begScr% = curElemY% - lenScr% + 1
                ELSE
                    curElemY% = curElemY% + lenScr% - 1
                    begScr% = curElemY% - lenScr% + 1
                END IF
            END IF
        CASE pu
            curElemY% = curElemY% - lenScr% + 1
            IF (curElemY% < 0) THEN curElemY% = 0
            IF (curElemY% < absLen%) THEN
                begScr% = curElemY%
            ELSEIF (curElemY% < begScr%) THEN
                begScr% = curElemY%
            END IF
    END SELECT
LOOP UNTIL (a$ = es)
ArrEditCS% = numElem% + 1

END FUNCTION

SUB AxisTick2 (tpd1#, tpd2#, tpr1#, tpr2#, tmaxX%, tmaxY%)

REM DisplayType% = 1 is 80 columns and 4 rows
REM DisplayType% = 2 is 40 columns and 4 rows

DisplayType% = 0

IF (screenMode% = 11 OR screenMode% = 12) THEN
    VIEW PRINT 26 TO 30
    CLS 2
    LOCATE 26, 1, 1
    DisplayType% = 1
ELSEIF (screenMode% = 1 OR screenMode% = 7 OR screenMode% = 13) THEN
    VIEW PRINT 21 TO 25
    CLS 2
    LOCATE 21, 1, 1
    DisplayType% = 2
ELSE
    VIEW PRINT 21 TO 25
    CLS 2
    LOCATE 21, 1, 1
    DisplayType% = 1
END IF

IF (tpr1# <= 0 AND tpr2# >= 0) THEN
    PRINT "Do you want an x axis? (y/x)-->";
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
ELSE
    a$ = "n"
END IF
IF (LCASE$(a$) <> "n") THEN
    xAxis% = tmaxY% * tpr2# / (tpr2# - tpr1#)
    IF ((xAxis% >= 0) AND (xAxis% <= tmaxY%)) THEN
        LINE (1, xAxis%)-(tmaxX%, xAxis%), 15: REM x axis
    END IF
    PRINT : PRINT "Do you want tic marks? (y/n)-->";
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
    IF (LCASE$(a$) <> "n") THEN
        DO
            PRINT : INPUT "Enter tic interval-->"; xTic#
            IF (xTic# <= 0 OR xTic# > (ABS(tpd1#) + ABS(tpd2#))) THEN
                PRINT "Out of range!"
            END IF
        LOOP WHILE (xTic# <= 0 OR xTic# > (ABS(tpd1#) + ABS(tpd2#)))
        tpd1mod# = -INT(ABS(tpd1# / xTic#)) * xTic#
        FOR z# = tpd1mod# TO tpd2# STEP xTic#
            xTicStep# = tmaxX% * (z# - tpd1#) / (tpd2# - tpd1#)
            IF (xAxis% >= 3) THEN
                xAxisAbove% = 1
            ELSE
                xAxisAbove% = 0
            END IF
            IF (xAxis% <= tmaxY% - 3) THEN
                xAxisBelow% = 1
            ELSE
                xAxisBelow% = 0
            END IF
            LINE (xTicStep#, xAxis% - 3 * xAxisAbove%)-(xTicStep#, xAxis% + 3 * (xAxisBelow%))
        NEXT z#
    END IF
END IF

IF (tpd1# <= 0 AND tpd2# >= 0) THEN
    PRINT "Do you want a y axis? (y/x)-->";
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
ELSE
    a$ = "n"
END IF
IF (LCASE$(a$) <> "n") THEN
    yAxis% = tmaxX% * tpd1# / (tpd1# - tpd2#)
    IF ((yAxis% >= 0) AND (yAxis% <= tmaxX%)) THEN
        LINE (yAxis%, 1)-(yAxis%, tmaxY%), 15: REM y axis
    END IF
    PRINT : PRINT "Do you want tic marks? (y/n)-->";
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
    IF (LCASE$(a$) <> "n") THEN
        DO
            PRINT : INPUT "Enter tic interval-->"; yTic#
            IF (yTic# <= 0 OR yTic# > (ABS(tpr1#) + ABS(tpr2#))) THEN
                PRINT "Out of range!"
            END IF
        LOOP WHILE (yTic# <= 0 OR yTic# > (ABS(tpr1#) + ABS(tpr2#)))
        tpr1mod# = -INT(ABS(tpr1# / yTic#)) * yTic#
        FOR z# = tpr1mod# TO tpr2# STEP yTic#
            yTicStep# = tmaxY% * (z# - tpr2#) / (tpr1# - tpr2#)
            IF (yAxis% >= 3) THEN
                yAxisAbove% = 1
            ELSE
                yAxisAbove% = 0
            END IF
            IF (yAxis% <= tmaxX% - 3) THEN
                yAxisBelow% = 1
            ELSE
                yAxisBelow% = 0
            END IF
            LINE (yAxis% - 3 * yAxisAbove%, yTicStep#)-(yAxis% + 3 * yAxisBelow%, yTicStep#)
        NEXT z#
    END IF
END IF

END SUB

SUB Calculus1

MenuTitle$ = "Calculus of Polys Menu"
init2% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
PrintMenu0 MenuTitle$, ""
Choice% = ChooseCS%(3, 3, 1, init2%)
SELECT CASE Choice%
    CASE 1
        init2% = 1
        subTitle$ = ": Evaluating Polys"
        DO
            PrintMenu0 MenuTitle$, subTitle$
            PRINT : PRINT "Input the polynomial Loc (0-9)-->";
            LOCATE , , 1
            pLoc$ = GetKey0$
            LOCATE , , 0
            Junk% = InputErrorCS(pLoc$, 0, 9)
            pLoc% = VAL(pLoc$): CreateP2CS (pLoc%)
            IF (pLoc$ = CHR$(27)) THEN
                Junk% = 0
            ELSEIF (p2$ = "") THEN
                PRINT : PRINT "There is no polynomial in this Loc."
                FChoice0 (FPAK0)
                Junk% = 1
            END IF
        LOOP WHILE (Junk% = 1)
        IF (pLoc$ <> CHR$(27)) THEN
            PRINT "The polynomial in the given Loc is:"
            CreateP2CS (pLoc%): PRINT "f(x) = "; p2$; ","
            CreateN1CS (pLoc%): PRINT
            PRINT "and is a "; n1$; ".": PRINT
            VIEW PRINT CSRLIN TO (maxRow% - 1)
            DO
                INPUT "Input a value for x (or q to quit) -->"; xx$
                IF (LCASE$(xx$) <> "q" AND xx$ <> "") THEN
                    IF (ASC(MID$(xx$, 1, 1)) < 42 OR ASC(MID$(xx$, 1, 1)) = 47 OR ASC(MID$(xx$, 1, 1)) > 57) THEN
                        PRINT "Invalid input, Please enter again!"
                    ELSE
                        xx# = VAL(xx$)
                        IF (d%(pLoc%) = 0) THEN
                            y# = a#(pLoc%, 0)
                        ELSE
                            y# = SynthWithoutCS#(pLoc%, xx#)
                        END IF
                            PRINT "f("; LTRIM$(STR$(xx#)); ") = "; LTRIM$(STR$(y#))
                    END IF
                END IF
            LOOP WHILE (LCASE$(xx$) <> "q" AND xx$ <> "")
        END IF
    CASE 2
        init2% = 2
        subTitle$ = ": finding the Derivative"
        PrintMenu0 MenuTitle$, subTitle$
        IF (d$(1) = "") THEN
            d$(1) = "Z"
        END IF
        CreateP2CS (1): PRINT : PRINT "f(x) = "; p2$: PRINT
        ClearLocCS (2): ClearRootCS (2)
        IF (d%(1) > 0) THEN
            FOR z% = 1 TO d%(1)
                a#(2, (z% - 1)) = a#(1, z%) * z%
            NEXT z%
            d%(2) = d%(1) - 1: d$(2) = LTRIM$(STR$(d%(2)))
        ELSE
            d$(2) = "Z"
        END IF
        PolyMenuCS
        PRINT : PRINT "f(x) = "; p2$: PRINT
        CreateP2CS (2): PRINT "f'(x) = "; p2$: PRINT
    CASE 3
        init2% = 3
        subTitle$ = ": finding the Integral"
        PrintMenu0 MenuTitle$, subTitle$
        IF (d%(1) = 2 * mDeg) THEN
            PRINT : PRINT "The resulting integral will be of a degree >"; 2 * mDeg: PRINT
        ELSE
            IF (d$(1) = "") THEN
                d$(1) = "Z"
            END IF
            CreateP2CS (1): PRINT : PRINT "f(x) = "; p2$: PRINT
            ClearLocCS (3): ClearRootCS (3)
            IF (d%(1) = 0 AND a#(1, 0) = 0) THEN
                d$(1) = "Z": d$(3) = "Z"
            ELSE
                FOR z% = 0 TO d%(1)
                    a#(3, (z% + 1)) = a#(1, z%) / (z% + 1)
                NEXT z%
                d%(3) = d%(1) + 1: d$(3) = LTRIM$(STR$(d%(3)))
            END IF
            PolyMenuCS
            PRINT : PRINT "f(x) = "; p2$: PRINT
            CreateP2CS (3): PRINT "F(x) = "; p2$: PRINT
            PRINT "Where F'(x) = f(x)."
            PRINT : PRINT "Note: Don't forget to add the constant of integration, C, to F(x).": PRINT
        END IF
    CASE 4
        init2% = 4: InputCoeffCS
    CASE 5
        init2% = 5: ChangePolCS
    CASE 6
        init2% = 6: DisplayPolCS
END SELECT
LOCATE 23, 1, 0
IF (Choice% <> 0 AND pLoc$ <> CHR$(27) AND LCASE$(xx$) <> "q") THEN FChoice0 (FPAK0)
pLoc$ = "": xx$ = ""
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

SUB ChangeLocCS (Loc1%, Loc2%)

IF (Loc1% <> Loc2%) THEN
    ClearLocCS (Loc2%)
    FOR z% = 0 TO d%(Loc1%)
        a#(Loc2%, z%) = a#(Loc1%, z%)
    NEXT z%
    d%(Loc2%) = d%(Loc1%): d$(Loc2%) = d$(Loc1%)
END IF

END SUB

SUB ChangePolCS

subTitle$ = ": Changing Polys' Locations"
DO
    PrintMenu0 MenuTitle$, subTitle$
    PRINT : PRINT "From Location (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; Loc1$
    InputErr% = InputErrorCS(Loc1$, 0, uPol)
    PRINT "To   Location (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; Loc2$
    InputErr% = InputErr% + InputErrorCS(Loc2$, 0, uPol)
LOOP UNTIL (InputErr% < 1)
Loc1% = VAL(Loc1$): Loc2% = VAL(Loc2$): PRINT
PRINT "Before:"
CreateP2CS (Loc1%): PRINT : PRINT "P("; LTRIM$(STR$(Loc1%)); ") = "; p2$
CreateP2CS (Loc2%): PRINT "P("; LTRIM$(STR$(Loc2%)); ") = "; p2$
ChangeLocCS Loc1%, Loc2%: ChangeRootCS Loc1%, Loc2%
CurX% = POS(0)
CurY% = CSRLIN
PolyMenuCS
LOCATE CurY%, CurX%
PRINT : PRINT "After:"
CreateP2CS (Loc1%): PRINT : PRINT "P("; LTRIM$(STR$(Loc1%)); ") = "; p2$
CreateP2CS (Loc2%): PRINT "P("; LTRIM$(STR$(Loc2%)); ") = "; p2$

END SUB

SUB ChangeRootCS (Loc1%, Loc2%)

IF (Loc1% <> Loc2%) THEN
    ClearRootCS (Loc2%)
    ndRoots%(Loc2%) = ndRoots%(Loc1%)
    FOR z% = 1 TO ndRoots%(Loc1%)
        x(Loc2%, z%) = x(Loc1%, z%)
    NEXT z%
END IF

END SUB

FUNCTION ChooseCS% (MenuID%, row%, col%, initS%)

begPos% = 0: REM Where is the beginning position?
FOR z% = 0 TO MenuID% - 1
    begPos% = begPos% + numItems%(z%)
NEXT z%
maxLen% = 0: REM How long is the longest menu?
FOR z% = 0 TO numItems%(MenuID%) - 1
    IF (maxLen% < LEN(menuItems$(begPos% + z%))) THEN
        maxLen% = LEN(menuItems$(begPos% + z%))
    END IF
NEXT z%
Choice% = initS% - 1: lchoice% = 0
DO
    FOR z% = 0 TO numItems%(MenuID%) - 1
        IF (z% = Choice%) THEN
            COLOR back, text
            LOCATE row% + z%, col%
            PRINT "> "; menuItems$(begPos% + z%);
            PRINT SPACE$(maxLen% - LEN(menuItems$(begPos% + z%))); " <";
        ELSE
            COLOR text, back
            LOCATE row% + z%, col%
            PRINT "  "; menuItems$(begPos% + z%);
            PRINT SPACE$(maxLen% - LEN(menuItems$(begPos% + z%))); "  ";
        END IF
    NEXT z%: REM Print initial menu
    COLOR text, back
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
    FChoice0 (a$)
    IF (a$ = CHR$(0) + CHR$(72)) THEN
        IF (Choice% > 0) THEN
            lchoice% = Choice%: Choice% = Choice% - 1
        ELSE
            lchoice% = Choice%: Choice% = numItems%(MenuID%) - 1
        END IF
        REM Up arrow
    ELSEIF (a$ = CHR$(0) + CHR$(maxCol)) THEN
        IF (Choice% < numItems%(MenuID%) - 1) THEN
            lchoice% = Choice%: Choice% = Choice% + 1
        ELSE
            lchoice% = Choice%: Choice% = 0
        END IF
        REM Down arrow
    ELSEIF (ASC(a$) > 48 AND ASC(a$) < 49 + numItems%(MenuID%)) THEN
        lchoice% = Choice%: Choice% = VAL(CHR$(ASC(a$))) - 1
        REM Number choice
    END IF
LOOP UNTIL (a$ = CHR$(13) OR a$ = CHR$(27))
IF (a$ = CHR$(13)) THEN
    ChooseCS% = Choice% + 1
ELSE
    ChooseCS% = 0
END IF
LOCATE row% + numItems%(MenuID%), col%

END FUNCTION

SUB ClearLocCS (pLoc%)

FOR z% = 0 TO 2 * mDeg: a#(pLoc%, z%) = 0: NEXT z%
d%(pLoc%) = 0: d$(pLoc%) = ""

END SUB

SUB ClearRootCS (pLoc%)

ndRoots%(pLoc%) = 0
FOR z% = 0 TO 2 * mDeg
    x(pLoc%, z%) = ZeroArr
NEXT z%

END SUB

SUB ClearScreenCS

SCREEN 12
IF (errorCode% = 5) THEN
    errorCode% = 0
    SCREEN 9
    IF (errorCode% = 5) THEN
        errorCode% = 0
        SCREEN 2
        IF (errorCode% = 5) THEN
            errorCode% = 0
            SCREEN 3
        END IF
    END IF
END IF
SCREEN 0

WIDTH maxCol, maxRow%
COLOR text, back
CLS

END SUB

SUB CreateN1CS (pLoc%)

d$ = LTRIM$(STR$(d%(pLoc%)))
t1$ = "ST DEGREE EQUATION"
t2$ = "ND DEGREE EQUATION"
t3$ = "RD DEGREE EQUATION"
t4$ = "TH DEGREE EQUATION"

IF (d$(pLoc%) <> "0" AND d%(pLoc%) = 0) THEN
    SELECT CASE d$(pLoc%)
        CASE "I"
            n1$ = "INDETERMINATE"
        CASE "U"
            n1$ = "UNDEFINED"
        CASE "Z", ""
            d$(pLoc%) = "Z"
            n1$ = "ZERO POLYNOMIAL"
    END SELECT
ELSE
    SELECT CASE d%(pLoc%)
        CASE 0
            IF (a#(pLoc%, 0) = 0) THEN
                n1$ = "ZERO POLYNOMIAL"
            ELSE
                n1$ = d$ + t4$
            END IF
        CASE 1, 101
            n1$ = d$ + t1$
        CASE 2, 102
            n1$ = d$ + t2$
        CASE 3, 103
            n1$ = d$ + t3$
        CASE 4 TO 20, 104 TO 120
            n1$ = d$ + t4$
        CASE 21, 121
            n1$ = d$ + t1$
        CASE 22, 122
            n1$ = d$ + t2$
        CASE 23, 123
            n1$ = d$ + t3$
        CASE 24 TO 30, 124 TO 130
            n1$ = d$ + t4$
        CASE 31, 131
            n1$ = d$ + t1$
        CASE 32, 132
            n1$ = d$ + t2$
        CASE 33, 133
            n1$ = d$ + t3$
        CASE 34 TO 40, 134 TO 140
            n1$ = d$ + t4$
        CASE 41, 141
            n1$ = d$ + t1$
        CASE 42, 142
            n1$ = d$ + t2$
        CASE 43, 143
            n1$ = d$ + t3$
        CASE 44 TO 50, 144 TO 150
            n1$ = d$ + t4$
        CASE 51, 151
            n1$ = d$ + t1$
        CASE 52, 152
            n1$ = d$ + t2$
        CASE 53, 153
            n1$ = d$ + t3$
        CASE 54 TO 60, 154 TO 160
            n1$ = d$ + t4$
        CASE 61, 161
            n1$ = d$ + t1$
        CASE 62, 162
            n1$ = d$ + t2$
        CASE 63, 163
            n1$ = d$ + t3$
        CASE 64 TO 70, 164 TO 170
            n1$ = d$ + t4$
        CASE 71, 171
            n1$ = d$ + t1$
        CASE 72, 172
            n1$ = d$ + t2$
        CASE 73, 173
            n1$ = d$ + t3$
        CASE 74 TO 80, 174 TO 180
            n1$ = d$ + t4$
        CASE 81, 181
            n1$ = d$ + t1$
        CASE 82, 182
            n1$ = d$ + t2$
        CASE 83, 183
            n1$ = d$ + t3$
        CASE 84 TO 90, 184 TO 190
            n1$ = d$ + t4$
        CASE 91, 191
            n1$ = d$ + t1$
        CASE 92, 192
            n1$ = d$ + t2$
        CASE 93, 193
            n1$ = d$ + t3$
        CASE 94 TO 100, 194 TO 200
            n1$ = d$ + t4$
    END SELECT
END IF

END SUB

SUB CreateP1CS (Deg%)

p1$ = ""
IF (Deg% > 1) THEN
    FOR z% = Deg% TO 2 STEP -1
        tmp$ = "a(" + MID$(STR$(z%), 2, LEN(STR$(z%)) - 1)
        tmp$ = tmp$ + ")x^" + LTRIM$(STR$(z%)) + " + "
        l% = LEN(p1$)
        WHILE (l% > maxCol)
            l% = l% - maxCol
        WEND
        IF ((l% + LEN(tmp$)) > maxCol) THEN
            p1$ = p1$ + SPACE$(maxCol - l%) + tmp$
        ELSE
            p1$ = p1$ + tmp$
        END IF
    NEXT z%
END IF
IF (Deg% > 0) THEN
    tmp$ = "a(1)x + a(0)"
    l% = LEN(p1$)
    WHILE (l% > maxCol)
        l% = l% - maxCol
    WEND
    IF ((l% + LEN(tmp$)) > maxCol) THEN
        p1$ = p1$ + SPACE$(maxCol - l%) + tmp$
    ELSE
        p1$ = p1$ + tmp$
    END IF
ELSE
    p1$ = "a(0)"
END IF

END SUB

SUB CreateP2CS (pLoc%)

DIM sign$(1)

IF (d$(pLoc%) = "") THEN
    p2$ = ""
ELSEIF (d$(pLoc%) = "I" OR d$(pLoc%) = "U") THEN
    SELECT CASE d$(pLoc%)
        CASE "I"
            p2$ = "Indeterminate"
        CASE "U"
            p2$ = "Undefined"
    END SELECT
ELSEIF (d%(pLoc%) = 0) THEN
    IF (a#(pLoc%, 0) = 0) THEN
        p2$ = "0"
    ELSE
        p2$ = LTRIM$(STR$(a#(pLoc%, d%(pLoc%))))
    END IF: REM take care of special zero case polynomials
ELSE
    p2$ = ""
    IF (d%(pLoc%) > 1) THEN
        SignA% = SGN(a#(pLoc%, d%(pLoc%)))
        IF (SignA% = 1) THEN
            IF (a#(pLoc%, d%(pLoc%)) <> 1) THEN
                p2$ = LTRIM$(STR$(ABS(a#(pLoc%, d%(pLoc%)))))
            END IF
            p2$ = p2$ + "x^" + LTRIM$(STR$(d%(pLoc%)))
        ELSEIF (SignA% = -1) THEN
            p2$ = " - "
            IF (a#(pLoc%, d%(pLoc%)) <> -1) THEN
                p2$ = p2$ + LTRIM$(STR$(ABS(a#(pLoc%, d%(pLoc%)))))
            END IF
            p2$ = p2$ + "x^" + LTRIM$(STR$(d%(pLoc%)))
        END IF: REM take care of leading coefficient
        IF (d%(pLoc%) > 2) THEN
            FOR z% = d%(pLoc%) - 1 TO 2 STEP -1
                SignA% = SGN(a#(pLoc%, z%))
                IF (SignA% <> 0) THEN
                    IF (SignA% = 1) THEN
                        tmp$ = " + "
                    ELSEIF (SignA% = -1) THEN
                        tmp$ = " - "
                    END IF
                    IF (ABS(a#(pLoc%, z%)) <> 1) THEN
                        tmp$ = tmp$ + LTRIM$(STR$(ABS(a#(pLoc%, z%))))
                    ELSE
                        tmp$ = tmp$ + ""
                    END IF
                    tmp$ = tmp$ + "x^" + LTRIM$(STR$(z%))
                    REM Setting up the coefficient
                    l% = LEN(p2$)
                    WHILE (l% > maxCol)
                        l% = l% - maxCol
                    WEND
                    IF ((l% + LEN(tmp$)) > maxCol) THEN
                        p2$ = p2$ + SPACE$(maxCol - l%) + tmp$
                    ELSE
                        p2$ = p2$ + tmp$
                    END IF
                    REM Word wrapping the coefficient
                END IF
            NEXT z%
        END IF
    END IF
    FOR z% = 0 TO 1
        SignA% = SGN(a#(pLoc%, z%))
        IF (SignA% = 1) THEN
            sign$(z%) = " + "
        ELSEIF (SignA% = -1) THEN
            sign$(z%) = " - "
        ELSEIF (SignA% = 0) THEN
            sign$(z%) = "0"
        END IF
    NEXT z%
    IF (sign$(1) <> "0") THEN
        IF (d%(pLoc%) <> 1) THEN
            tmp$ = sign$(1)
        ELSEIF (sign$(1) = " - ") THEN
            tmp$ = "- "
        END IF
        IF (ABS(a#(pLoc%, 1)) <> 1) THEN
            tmp$ = tmp$ + LTRIM$(STR$(ABS(a#(pLoc%, 1))))
        END IF
        tmp$ = tmp$ + "x"
        l% = LEN(p2$)
        WHILE (l% > maxCol)
            l% = l% - maxCol
        WEND
        IF ((l% + LEN(tmp$)) > maxCol) THEN
            p2$ = p2$ + SPACE$(maxCol - l%) + tmp$
        ELSE
            p2$ = p2$ + tmp$
        END IF
        REM Word wrapping the x coefficient
    END IF
    IF (sign$(0) <> "0") THEN
        tmp$ = sign$(0) + LTRIM$(STR$(ABS(a#(pLoc%, 0))))
        l% = LEN(p2$)
        WHILE (l% > maxCol)
            l% = l% - maxCol
        WEND
        IF ((l% + LEN(tmp$)) > maxCol) THEN
            p2$ = p2$ + SPACE$(maxCol - l%) + tmp$
        ELSE
            p2$ = p2$ + tmp$
        END IF
        REM Word wrapping the constant
    END IF
END IF

END SUB

SUB DisplayOutputCS (op$)

CreateP2CS (1): PRINT : PRINT "["; p2$; "] "; op$
CreateP2CS (2): PRINT "["; p2$; "] =":
CreateP2CS (3): PRINT p2$
PRINT : PRINT "The resulting polynomial is a:"
CreateN1CS (3): PRINT : PRINT n1$; ", and has the form:"
PRINT : PRINT p2$

END SUB

SUB DisplayPolCS

subTitle$ = ": Displaying Polys"

DO
    PrintMenu0 MenuTitle$, subTitle$
    PRINT : PRINT "Do you want the (M)anual display, or (A)utomatic display (M/A)-->"; : signKey$ = GetKey0$
LOOP UNTIL (LCASE$(signKey$) = "m" OR LCASE$(signKey$) = "a")

IF (signKey$ = "m") THEN
    DO
        PRINT : PRINT "Display the Location from (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; Loc1$
        InputErr% = InputErrorCS(Loc1$, 0, uPol)
        PRINT "                       to (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; Loc2$
        InputErr% = InputErr% + InputErrorCS(Loc2$, 0, uPol)
    LOOP UNTIL (InputErr% < 1)
    Loc1% = VAL(Loc1$): Loc2% = VAL(Loc2$): PRINT
    IF (Loc2% < Loc1%) THEN
        temp% = Loc2%
        Loc2% = Loc1%
        Loc1% = temp%
    END IF
    FOR z% = Loc1% TO Loc2%
         CreateP2CS (z%): PRINT "P("; LTRIM$(STR$(z%)); ") = "; p2$
         IF (ndRoots%(z%) > 0) THEN
            DisplayRootCS (z%)
         END IF
    NEXT z%
ELSE
    PRINT
    count% = 0
    FOR z% = 0 TO 10
        IF (d$(z%) <> "") THEN
            CreateP2CS (z%): PRINT "P("; LTRIM$(STR$(z%)); ") = "; p2$
            IF (ndRoots%(z%) > 0) THEN DisplayRootCS (z%)
            count% = count% + 1
        END IF
    NEXT z%
    IF (count% = 0) THEN
        PRINT "There are no polynomials in memory yet."
    END IF
END IF

END SUB

SUB DisplayRaw

LOCATE 16, 1, 0
PRINT SPACE$(640)
LOCATE 16, 1, 1
PRINT "Loc-->"; : pLoc$ = GetKey0$: pLoc% = VAL(pLoc$)
PRINT "Degree-->"; : pDeg$ = GetKey0$: pDeg% = VAL(pDeg$)
PRINT d%(pLoc%)
FOR z% = pDeg% TO 0 STEP -1
    PRINT a#(pLoc%, z%); "     ";
NEXT z%
CreateN1CS (pLoc%)
CreateP2CS (pLoc%)
PRINT
IF (LEN(p2$) > 63) THEN
    PRINT "'"; d$(pLoc%); "'"
    PRINT "'"; p2$; "'"
    PRINT "'"; n1$; "'"
ELSE
    PRINT "'"; d$(pLoc%); "'", "'"; p2$; "'", "'"; n1$; "'"
END IF
PolyMenuCS

END SUB

SUB DisplayRootCS (pLoc%)

REDIM root$(ndRoots%(pLoc%))

FOR z% = 1 TO ndRoots%(pLoc%)
    sgnImag% = SGN(x(pLoc%, z%).Imag)
    root$(z%) = "x ="
    IF (x(pLoc%, z%).Real = 0 AND sgnImag% = 0) THEN
        root$(z%) = root$(z%) + " " + LTRIM$(STR$(x(pLoc%, z%).Real))
    ELSEIF (x(pLoc%, z%).Real <> 0) THEN
        root$(z%) = root$(z%) + " " + LTRIM$(STR$(x(pLoc%, z%).Real))
    END IF
    IF (sgnImag% = 1) THEN
        root$(z%) = root$(z%) + " + " + LTRIM$(STR$(x(pLoc%, z%).Imag)) + "i"
    ELSEIF (sgnImag% = -1) THEN
        root$(z%) = root$(z%) + " - " + LTRIM$(STR$(ABS(x(pLoc%, z%).Imag))) + "i"
    END IF
NEXT z%
FOR z% = 1 TO ndRoots%(pLoc%)
    IF (maxLen% < LEN(root$(z%))) THEN
        maxLen% = LEN(root$(z%))
    END IF
NEXT z%
FOR z% = 1 TO ndRoots%(pLoc%)
    IF (Flag%(7) = 0) THEN
        PRINT root$(z%); TAB(maxLen% + 1); ", M ="; x(pLoc%, z%).Num
    ELSE
        PRINT #1, root$(z%); TAB(maxLen% + 1); ", M ="; x(pLoc%, z%).Num
    END IF
    IF (CSRLIN > maxRow% - 2) THEN
        FChoice0 (FPAK0)
        CLS 2
    END IF
NEXT z%

END SUB

FUNCTION DivSub2% (Loc1%, Loc2%, Loc3%, Loc4%)

ClearLocCS (Loc3%): ClearRootCS (Loc3%)
ClearLocCS (Loc4%): ClearRootCS (Loc4%)
IF ((d$(Loc1%) = "") OR (d$(Loc1%) = "Z")) THEN
    d$(Loc1%) = "Z"
END IF
IF ((d$(Loc2%) = "") OR (d$(Loc2%) = "Z")) THEN
    d$(Loc2%) = "Z"
    IF (d$(Loc1%) = "Z") THEN
        d$(Loc3%) = "I": d$(Loc4%) = "Z"
    ELSE
        d$(Loc3%) = "U": d$(Loc4%) = "Z"
    END IF
END IF
IF (d$(Loc3%) <> "I" AND d$(Loc3%) <> "U") THEN
    IF (d%(Loc1%) >= d%(Loc2%)) THEN
        d%(Loc3%) = d%(Loc1%) - d%(Loc2%)
        IF ((d%(Loc3%) = 0) AND (a#(Loc3%, 0) = 0)) THEN
            d$(Loc3%) = "Z"
        ELSE
            d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
        END IF
        IF (d%(Loc2%) = 0) THEN
            FOR z% = 0 TO d%(Loc1%)
                a#(Loc3%, z%) = a#(Loc1%, z%) / a#(Loc2%, 0)
            NEXT z%
            d$(Loc4%) = "Z"
            d%(Loc3%) = d%(Loc1%): d$(Loc3%) = d$(Loc1%)
        ELSEIF (d%(Loc2%) = 1 AND a#(Loc2%, 1) = 1) THEN
            a#(Loc4%, 0) = SynthWithCS(Loc1%, Loc2%, Loc3%)
            d%(Loc4%) = d%(Loc2%) - 1
            IF ((d%(Loc4%) = 0) AND (a#(Loc4%, 0) = 0)) THEN
                d$(Loc4%) = "Z"
            ELSE
                d$(Loc4%) = LTRIM$(STR$(d%(Loc4%)))
            END IF
        ELSE
            ChangeLocCS Loc1%, Loc4%
            FOR z% = d%(Loc1%) TO d%(Loc2%) STEP -1
                a#(Loc3%, z% - d%(Loc2%)) = a#(Loc4%, z%) / a#(Loc2%, d%(Loc2%))
                FOR y% = d%(Loc2%) TO 0 STEP -1
                    a#(Loc4%, y% + z% - d%(Loc2%)) = a#(Loc4%, y% + z% - d%(Loc2%)) - a#(Loc3%, z% - d%(Loc2%)) * a#(Loc2%, y%)
                NEXT y%
            NEXT z%
            IF (d%(Loc2%) > 0) THEN d%(Loc4%) = d%(Loc2%) - 1
            FOR z% = d%(Loc2%) - 1 TO 1 STEP -1
                IF a#(Loc4%, z%) = 0 THEN d%(Loc4%) = d%(Loc4%) - 1
            NEXT z%
            IF ((d%(Loc4%) = 0) AND (a#(Loc4%, 0) = 0)) THEN
                d$(Loc4%) = "Z"
            ELSE
                d$(Loc4%) = LTRIM$(STR$(d%(Loc4%)))
            END IF
        END IF
    ELSE
        DivSub2 = 1
    END IF
END IF

END FUNCTION

FUNCTION EditStrCS$ (theStr$, row%, col%, max%, accChars$)

COLOR back, text
begCur% = 30
tmpStr$ = theStr$
curPos% = 0
accStr$ = accChars$ + es + cr + ta + st + bs + up + dn
accStr$ = accStr$ + ri + le + in + de + ho + en + pu + pd
DO
    dispStr$ = LEFT$(tmpStr$ + SPACE$(max%), max%)
    LOCATE row%, col% - 1
    PRINT dispStr$;
    LOCATE row%, col% + curPos% - 1, 1, begCur%, 31
    IF (accStr$ = "") THEN
        DO
            a$ = INKEY$
        LOOP WHILE (a$ = "")
    ELSE
        DO
            DO
                a$ = INKEY$
            LOOP WHILE (a$ = "")
        LOOP WHILE (INSTR(accStr$, a$) = 0)
    END IF
    LOCATE , , 0
    SELECT CASE a$
        CASE cr, up, dn, ta, st, es
        CASE bs
            IF (curPos% > 0) THEN
                tmpStr$ = LEFT$(tmpStr$, curPos% - 1) + RIGHT$(tmpStr$, LEN(tmpStr$) - curPos%)
                curPos% = curPos% - 1
            END IF
        CASE in
            IF (begCur% = 30) THEN begCur% = 15 ELSE begCur% = 30
        CASE de
            IF (curPos% < LEN(tmpStr$)) THEN
                tmpStr$ = LEFT$(tmpStr$, curPos%) + RIGHT$(tmpStr$, LEN(tmpStr$) - curPos% - 1)
            END IF
        CASE ri
            IF ((LEN(tmpStr$) = max%) AND (curPos% = LEN(tmpStr$) - 1)) THEN
                curPos% = curPos%
            ELSE
                IF (curPos% < LEN(tmpStr$)) THEN curPos% = curPos% + 1
            END IF
        CASE le
            IF (curPos% > 0) THEN curPos% = curPos% - 1
        CASE ho
            curPos% = 0
        CASE en
            IF (LEN(tmpStr$) <> max%) THEN
                curPos% = LEN(tmpStr$)
            ELSE
                curPos% = LEN(tmpStr$) - 1
            END IF
        CASE ELSE
            IF ((INSTR(accChars$, a$) <> 0) AND (LEN(tmpStr$) <= max%)) THEN
                oldLen% = LEN(tmpStr$)
                IF ((begCur% = 30) AND (LEN(tmpStr$) <> curPos%)) THEN
                    tmpStr$ = LEFT$(tmpStr$, curPos%) + a$ + RIGHT$(tmpStr$, LEN(tmpStr$) - curPos% - 1)
                ELSEIF (LEN(tmpStr$) < max%) THEN
                    tmpStr$ = LEFT$(tmpStr$, curPos%) + a$ + RIGHT$(tmpStr$, LEN(tmpStr$) - curPos%)
                END IF
                IF (curPos% < max% - 1) THEN
                    IF (curPos% < max% AND oldLen% < max%) THEN
                        curPos% = curPos% + 1
                    ELSEIF (begCur% = 30) THEN
                        curPos% = curPos% + 1
                    END IF
                END IF
            END IF
    END SELECT
LOOP WHILE (a$ <> cr AND a$ <> up AND a$ <> dn AND a$ <> ta AND a$ <> st AND a$ <> es AND a$ <> pd AND a$ <> pu)
theStr$ = tmpStr$
EditStrCS$ = a$
COLOR text, back

END FUNCTION

SUB ExitP1

DO
    VIEW PRINT 1 TO (maxRow% - 1)
    CLS : LOCATE (maxRow% / 2), 1, 1
    PRINT "Are you sure you want to quit (y/n)-->";
    AN$ = GetKey0$: LoopExit% = 1
    IF (LCASE$(AN$) = "n") THEN
        LoopExit% = 0
    END IF
LOOP UNTIL ((LCASE$(AN$) = "y") OR (LCASE$(AN$) = "n"))
LOCATE (maxRow% / 2), 1, 0

END SUB

SUB Explanation1

VIEW PRINT 1 TO (maxRow% - 1)
ExpTitle$ = "Explanation"
COLOR text, back
PrintMenu0 ExpTitle$, ""
COLOR info, 1
PRINT "  This program will allow you to input a polynomial of degree, n <= "; LTRIM$(STR$(mDeg)); ".  With"
PRINT "this polynomial, the program will be able to do the following: add, subtract,"
PRINT "multiply, divide or substitute it with another polynomial.  It can find the"
PRINT "derivative and integral. It can raise it to a positive integer power. It will"
PRINT "also find the roots of a polynomial by the following methods: For n <= "; LTRIM$(STR$(mDeg)); ","
PRINT "the rational roots theorem, Newton's method, and/or deMoiver's theorem.  For"
PRINT "n <= 4 the formula for the appropriate degree. It will allow you to find the"
PRINT "value of the polynomial with a given value for x, and you will also be able to"
PRINT "graph your polynomials."
PRINT "  You will be able to save a total of "; LTRIM$(STR$(uPol)); " polynomials in memory.  The first 3 in "
PRINT "memory are respectively used for: The main polynomial you are working with (all"
PRINT "functions), the second polynomial you are working with (add, subtract, multiply,"
PRINT "divide, power or substitute functions), and the resulting equation from the"
PRINT "first 6 functions.  Always keep in mind the first three locations in memory,"
PRINT "locations 4 through 10 are not really used for computational purposes, just for"
PRINT "storage purposes.  Note: the coefficients will deal with real numbers only."
PRINT "  You are limited to a polynomial of n <= "; LTRIM$(STR$(mDeg)); " for finding roots, and graphing."
PRINT "You are limited to a polynomial of n <= "; LTRIM$(STR$(2 * mDeg - 1)); " for finding the integral.  You are"
PRINT "limited to a polynomial of n <= "; LTRIM$(STR$(2 * mDeg)); " for adding, subtracting, multiplying,"
PRINT "dividing, raising to a power, substituting, finding the value of a polynomial,"
PRINT "and finding the derivative of a polynomial.  At no time, with any function,"
PRINT "will the value of n > "; LTRIM$(STR$(2 * mDeg)); "."
COLOR text, back

END SUB

SUB FChoice0 (a$)

Flag%(3) = 0
test$ = MID$(a$, 2, 1)
IF (LEN(a$) = 2) THEN
    IF (ASC(test$) > 58 AND ASC(test$) < 69) THEN
        DO
            IF (LEN(a$) = 2) THEN
                test$ = MID$(a$, 2, 1)
            ELSE
                test$ = "0"
            END IF
            IF (a$ = CHR$(0) + CHR$(59)) THEN
                a$ = "": PRINT : PRINT : PRINT "Sorry, help not available on that subject."
            ELSEIF (a$ = CHR$(0) + CHR$(60)) THEN
                a$ = "": FShell0
                IF (Flag%(4) > 0) THEN a$ = FPAK0$
            ELSEIF (a$ = CHR$(0) + CHR$(61)) THEN
                Flag%(3) = 1
                a$ = "": Explanation1
                a$ = FPAK0$
            ELSEIF (a$ = CHR$(0) + CHR$(62)) THEN
                a$ = "": DEF SEG = &HB800
                IF (maxRow% <> 25) THEN
                    FOR z% = 0 TO 3839
                        scrdmp%(z%) = PEEK(z%)
                    NEXT z%
                    maxRow% = 25: WIDTH maxCol, maxRow%
                    COLOR text, back: CLS
                    FOR z% = 0 TO 3839
                        POKE z%, scrdmp%(z%)
                    NEXT z%
                    FMenu0
                ELSE
                    FOR z% = 0 TO 3839
                        scrdmp%(z%) = PEEK(z%)
                    NEXT z%
                    maxRow% = 50: WIDTH maxCol, maxRow%
                    COLOR text, back: CLS
                    FOR z% = 0 TO 3839
                        POKE z%, scrdmp%(z%)
                    NEXT z%
                    FMenu0
                END IF
                IF (Flag%(4) > 0) THEN a$ = FPAK0$
            ELSEIF (a$ = CHR$(0) + CHR$(63)) THEN
                a$ = "": DisplayRaw
                a$ = FPAK0$
            ELSEIF (a$ = CHR$(0) + CHR$(64)) THEN
                a$ = "": FreeMem
                a$ = FPAK0$
            ELSEIF (a$ = CHR$(0) + CHR$(65)) THEN
                a$ = "": PRINT : PRINT : PRINT "Function key F7 does nothing               "
            ELSEIF (a$ = CHR$(0) + CHR$(66)) THEN
                a$ = "": PRINT : PRINT : PRINT "Function key F8 does nothing               "
            ELSEIF (a$ = CHR$(0) + CHR$(67)) THEN
                a$ = "": PRINT : PRINT : PRINT "Function key F9 does nothing               "
            ELSEIF (a$ = CHR$(0) + CHR$(68)) THEN
                a$ = "": PRINT : PRINT : PRINT "Function key F10 does nothing              "
                REM Function keys F1 - F10
            END IF
        LOOP UNTIL (ASC(test$) < 59 OR ASC(test$) > 68)
    END IF
END IF
IF (Flag%(3) > 0) THEN
    COLOR text, back: PrintMenu0 MenuTitle$, ""
END IF
Flag%(4) = 0

END SUB

SUB FMenu0

LOCATE maxRow%, 1, 0
COLOR 14, 0
PRINT " F1=Help     F2=Shell out     F3=Explanation    F4=25/50 row mode    ESC=Cancel ";
COLOR text, back
VIEW PRINT 2 TO (maxRow% - 1)

END SUB

FUNCTION FofX# (xtmp#)

    FofX# = SIN(xtmp#)

END FUNCTION

FUNCTION FPAK0$

CurX% = POS(0)
CurY% = CSRLIN
PAKC$ = "PRESS ANY KEY TO CONTINUE"
LOCATE (maxRow% - 1), 1, 1
PRINT SPACE$(INT((maxCol - LEN(PAKC$)) / 2)); PAKC$; SPACE$(INT((maxCol - LEN(PAKC$)) / 2));
DO
    a$ = INKEY$
LOOP WHILE (a$ = "")
LOCATE (maxRow% - 1), 1
PRINT SPACE$(maxCol);
LOCATE CurY%, CurX%, 0
FPAK0 = a$
Flag%(4) = 1

END FUNCTION

SUB Fractal2

ClearScreenCS
PRINT "Sorry, This Subroutine is not implemented yet."
Junk$ = FPAK0

END SUB

SUB FreeMem

Mmem1& = 980: Mmem2& = 160468: Mmem3& = 31476: Mmem4& = 31476
Cmem1& = FRE(-2): Cmem2& = FRE(-1): Cmem3& = FRE(0): Cmem4& = FRE("")

PRINT : PRINT "Type", "Stack Space", "Array Space", "String Space", "Defraged String Space"

PRINT "Total:", Mmem1&, Mmem2&, Mmem3&, Mmem4&
PRINT "Now:", Cmem1&, Cmem2&, Cmem3&, Cmem4&
PRINT "Dif:", Mmem1& - Cmem1&, Mmem2& - Cmem2&, Mmem3& - Cmem3&, Mmem4& - Cmem4&

END SUB

SUB FShell0

CurX% = POS(0)
CurY% = CSRLIN
DEF SEG = &H40
scrnum% = PEEK(&H49)
IF (scrnum% = 2 OR scrnum% = 3) THEN
    DEF SEG = &HB800: REM &hB800 is the start of CGA 16 color text 80 x 25
ELSEIF (scrnum% = 7) THEN
    DEF SEG = &HB000: REM &hB000 is the start of CGA mono text 80 x 25
END IF
FOR z% = 0 TO 3999
    scrdmp%(z%) = PEEK(z%)
NEXT z%
IF (maxRow% = 50) THEN
    FOR z% = 4000 TO 7999
        scrdmp%(z%) = PEEK(z%)
    NEXT z%
END IF
WIDTH maxCol, maxRow%
VIEW PRINT 1 TO maxRow%
shellecho1$ = "echo Type exit at any time to return to poly05.bas..."
shellecho2$ = "echo."

COLOR 7, 0: CLS
SHELL shellecho1$
SHELL shellecho2$
SHELL
COLOR text, back: CLS
WIDTH maxCol, maxRow%
IF (scrnum% = 2 OR scrnum% = 3) THEN
    DEF SEG = &HB800
ELSEIF (scrnum% = 7) THEN
    DEF SEG = &HB000
END IF
REM Keep this structure if ever there is a way of finding out how to keep the
REM 80 column screen when shelling back in.
IF (maxRow% = 25) THEN
    FOR z% = 0 TO 3999
        POKE z%, scrdmp%(z%)
    NEXT z%
ELSE
    FOR z% = 0 TO 7999
        POKE z%, scrdmp%(z%)
    NEXT z%
END IF
VIEW PRINT 2 TO (maxRow% - 1)
IF (CurY% <> 1) THEN
    LOCATE CurY%, CurX%
ELSE
    LOCATE 2, CurX%
END IF

END SUB

FUNCTION GetKey0$

DO
    a$ = INKEY$
LOOP UNTIL a$ <> ""
GetKey0$ = a$
PRINT a$

END FUNCTION

SUB Graph1

MenuTitle$ = "Graphing a Poly Menu"
init2% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
    PrintMenu0 MenuTitle$, ""
    FMenu0
    PrintMenu0 MenuTitle$, ""
    Choice% = ChooseCS%(2, 3, 1, init2%)
    SELECT CASE Choice%
        CASE 1
            init2% = 1
            SetVideoModeCS
            IF (screenMode% <> 0) THEN
                Plot2
            END IF
        CASE 2
            init2% = 2
            PRINT : PRINT "Sorry, Fractal is not implemented yet."
            ' SetVideoModeCS
            ' IF (screenMode% <> 0) THEN
            '     Fractal2
            ' END IF
    END SELECT
    IF (Choice% = 2) THEN FChoice0 (FPAK0)
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

SUB InputCoeffCS

DIM edArr(mDeg) AS ComplexInput
subTitle$ = ": Imputing by coefficients"
DO
    PrintMenu0 MenuTitle$, subTitle$
    PRINT : PRINT "Input the Location of the polynomial (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; pLoc$
    InputErr% = InputErrorCS(pLoc$, 0, uPol)
    PRINT "Input the degree of the polynomial (0-"; LTRIM$(STR$(mDeg)); ")-->"; : INPUT Deg$
    InputErr% = InputErr% + InputErrorCS(Deg$, 0, mDeg)
LOOP UNTIL (InputErr% < 1)
pLoc% = VAL(pLoc$): Deg% = VAL(Deg$)
IF (d$(pLoc%) <> "") THEN
    PRINT : PRINT "There is a polynomial already at this Loc, do you wish to (M)odify it,"
    PRINT "or (O)verwrite from scratch (M/O)-->";
    LOCATE CSRLIN, POS(0), 1
    Key$ = GetKey0$
    LOCATE CSRLIN, POS(0), 0
    IF (LCASE$(Key$) = "o") THEN
        ClearRootCS (pLoc%): ClearLocCS (pLoc%)
    ELSE
        ClearRootCS (pLoc%): p2$ = ""
    END IF
END IF

CLS 2
CreateP1CS (Deg%)
PRINT : PRINT "Press the <Esc> key when finished editing this polynomial."
PRINT "The Location is:"; pLoc%; ".  The general equation has the form:"
CreateP1CS (Deg%): PRINT : PRINT "f(x) = "; p1$: PRINT : CurY% = CSRLIN
IF (LCASE$(Key$) <> "o") THEN
    FOR z% = 0 TO Deg%
        edArr(z%).Real = a#(pLoc%, z%)
    NEXT z%
END IF
IF (maxRow% = 25) THEN
    Junk% = ArrEditCS%(edArr(), Deg% + 1, 1, CurY%, 24 - CurY%, 25, 10)
ELSE
    Junk% = ArrEditCS(edArr(), Deg% + 1, 1, CurY%, 49 - CurY%, 25, 10)
END IF
FOR z% = 0 TO Deg%: a#(pLoc%, z%) = edArr(z%).Real: NEXT z%
d%(pLoc%) = Deg%

FOR z% = d%(pLoc%) + 1 TO mDeg
    a#(pLoc%, z%) = 0
NEXT z%: REM Clean up residual coefficients

DO WHILE (d%(pLoc%) > 0 AND a#(pLoc%, d%(pLoc%)) = 0)
    d%(pLoc%) = d%(pLoc%) - 1
LOOP: REM find real polynomial degree, get rid of leading zeros
IF ((d%(pLoc%) = 0) AND (a#(pLoc%, 0) = 0)) THEN
    d$(pLoc%) = "Z"
ELSE
    d$(pLoc%) = LTRIM$(STR$(d%(pLoc%)))
END IF

PrintMenu0 MenuTitle$, subTitle$
CreateN1CS (pLoc%): PRINT : PRINT "Your polynomial is a "; n1$; ", and has the form:"
CreateP2CS (pLoc%): PRINT : PRINT "f(x) = "; p2$: PRINT

END SUB

FUNCTION InputErrorCS% (CHK$, low%, high%)

InputErrorCS = 0
IF (ABS(VAL(CHK$)) > 32768) THEN
    InputErrorCS = 1
ELSEIF (VAL(CHK$) <> INT(VAL(CHK$))) THEN
    InputErrorCS = 1
ELSEIF (VAL(CHK$) = 0 AND MID$(CHK$, 1, 1) <> "0") THEN
    InputErrorCS = 1
ELSE
    CHK% = VAL(CHK$)
    IF ((CHK% < low%) OR (CHK% > high%)) THEN
        InputErrorCS = 1
    END IF
END IF

END FUNCTION

SUB InputPolCS

subTitle$ = ": Imputing Polys"
init3% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
    PrintMenu0 MenuTitle$, subTitle$
    Choice% = ChooseCS%(6, 3, 1, init3%)
    SELECT CASE Choice%
        CASE 1
            init3% = 1: InputCoeffCS
        CASE 2
            init3% = 2: InputRootCS
        CASE 3
            init3% = 3: InputRandomCS
        CASE 4
    END SELECT
    IF (Choice% <> 0) THEN FChoice0 (FPAK0)
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

SUB InputRandomCS

Flag%(5) = 0: subTitle$ = ": Generating a random Poly"
DO
    PrintMenu0 MenuTitle$, subTitle$
    PRINT : PRINT "Input the Location of the polynomial (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; pLoc$
    InputErr% = InputErrorCS(pLoc$, 0, uPol)
LOOP UNTIL (InputErr% < 1)
LOCATE CSRLIN, POS(0), 1
pLoc% = VAL(pLoc$)
IF (d$(pLoc%) <> "") THEN
    PRINT : PRINT "There is a polynomial already at this location, do you really wish to"
    PRINT "overwrite it? (y/n)-->"; : Key$ = GetKey0$
    IF (LCASE$(Key$) = "n") THEN
        Flag%(5) = 1
    END IF
END IF
IF (Flag%(5) <> 1) THEN
    CLS 2
    ClearLocCS (pLoc%): ClearRootCS (pLoc%)
    RANDOMIZE TIMER
    PRINT : PRINT "This routine will create a polynomial of random degree between 0 and "; LTRIM$(STR$(mDeg)); ", with"
    PRINT "random coefficients between -9.999999999999*10^10 to -10^(-11), 0 and"
    PRINT "10^(-11) to 9.999999999999*10^10.  Do you wish to limit any of these"
    PRINT "parameters(y/n)-->"; : Key$ = GetKey0$
    IF (LCASE$(Key$) = "y") THEN
        CLS 2
        PRINT : PRINT "Do you wish to limit the degree? (y/n)-->"; : Key$ = GetKey0$
        IF (LCASE$(Key$) = "y") THEN
            DO
                PRINT : PRINT "What do you wish to limit the degree up to (0 to "; LTRIM$(STR$(mDeg));
                INPUT ")-->"; tmpDeg$
                InputErr% = InputErrorCS(tmpDeg$, 0, mDeg)
            LOOP UNTIL (InputErr% < 1)
            tmpDeg% = VAL(tmpDeg$)
            Deg% = INT(RND(TIMER) * (tmpDeg% + 1))
        ELSE
            Deg% = INT(RND(TIMER) * (mDeg + 1))
        END IF
        DO
            PRINT : PRINT "Do you want (I)nteger coefficients, or (N)on Integer coefficients? (I/N)-->"; : signKey$ = GetKey0$
        LOOP UNTIL (LCASE$(signKey$) = "i" OR LCASE$(signKey$) = "n")
        PRINT : PRINT "Do you want the limit the coefficients' range? (y/n)-->"; : Key$ = GetKey0$
        IF (LCASE$(Key$) = "y") THEN
            DO
                PRINT : INPUT "What is largest possible coefficient desirable? (0 to 10^11)-->"; Radius#
            LOOP UNTIL (ABS(Radius#) <= 10# ^ 11 AND Radius# >= 0)
        END IF
        IF (Radius# = 0) THEN Radius# = 10# ^ 11
        ERadius% = INT(LOG(ABS(Radius#)) / LOG(10))
        MRadius# = 10 ^ (LOG(ABS(Radius#)) / LOG(10) - ERadius%)
        FOR z% = 0 TO Deg%
            IF (LCASE$(signKey$) = "i") THEN
                a#(pLoc%, z%) = INT(Radius# - (2 * Radius# + 1) * RND(TIMER)) + 1
            ELSE
                a#(pLoc%, z%) = (MRadius# - 2 * MRadius# * RND(TIMER)) * 10 ^ INT((ERadius% + 1) - (2 * ERadius%) * RND(TIMER))
            END IF
        NEXT z%
    ELSE
        Deg% = INT(RND(TIMER) * (mDeg + 1))
        FOR z% = 0 TO Deg%
            a#(pLoc%, z%) = (1 - 2 * RND(TIMER)) * 10 ^ INT(11 - 20 * RND(TIMER))
        NEXT z%
    END IF
    d%(pLoc%) = Deg%
    IF (d%(pLoc%) = 0 AND a#(pLoc%, 0) = 0) THEN
        d$(pLoc%) = "Z"
    ELSE
        d$(pLoc%) = LTRIM$(STR$(d%(pLoc%)))
    END IF
    PrintMenu0 MenuTitle$, subTitle$
    CreateN1CS (pLoc%): PRINT : PRINT "Your polynomial is a "; n1$; ", and has the form:"
    CreateP2CS (pLoc%): PRINT : PRINT "f(x) = "; p2$: PRINT
END IF
LOCATE CSRLIN, POS(0), 0

END SUB

SUB InputRootCS

REM numArr1% is the number of roots the user input
REM numArr2% is the number of distinct roots the user input
REM numArr3% is the number of distinct roots without their conjugates
REM Array1() is the array that is being edited
REM Array2() is the array that contains the distinct roots after being sorted
REM          from Array1()
REM Array3() is the array that contains the distinct roots and their
REM          conjugates obtained from Array2()

DIM Array1(mDeg%) AS ComplexInput
DIM Array2(mDeg%) AS ComplexInput
DIM Array3(mDeg%) AS ComplexInput

Flag%(5) = 0: subTitle$ = ": Inputting by roots"
DO
    PrintMenu0 MenuTitle$, subTitle$
    PRINT : PRINT "Input the Location of the polynomial (0-"; LTRIM$(STR$(uPol)); : INPUT ")-->"; pLoc$
    InputErr% = InputErrorCS(pLoc$, 0, uPol)
LOOP UNTIL (InputErr% < 1)
pLoc% = VAL(pLoc$)
IF (d$(pLoc%) <> "") THEN
    PRINT : PRINT "There is a polynomial already at this location, do you really wish to"
    LOCATE , , 1
    PRINT "overwrite it? (y/n)-->"; : Key$ = GetKey0$
    IF (LCASE$(Key$) = "n") THEN
        Flag%(5) = 1
    END IF
    LOCATE , , 0
END IF
IF (Flag%(5) <> 1) THEN
    CLS 2
    COLOR info, 1
    PRINT : PRINT "This routine will enable you to create a polynomial just by specifying the"
    PRINT "roots of the polynomial and the multiplicity's of those roots.  You can specify"
    PRINT "real AND imaginary parts to the roots.  If the conjugate of a root is not input"
    PRINT "then it is assumed to be a root with the same multiplicity in order to preserve"
    PRINT "real coefficients (M stands for multiplicity, multiplicity 2 is: M = 2).  Ex:"
    PRINT "A polynomial is input with the following roots:"
    PRINT "x = -4, M = 2;  x = 1 + 5i, M = 5;  x = -10 + 2i, M = 1"
    PRINT "                                    x = -10 - 2i, M = 3"
    PRINT "The program will build an equation of 18th degree with the following roots:"
    PRINT "x = -4, M = 2;  x = 1 + 5i, M = 5;  x = -10 + 2i, M = 3"
    PRINT "                x = 1 - 5i, M = 5;  x = -10 - 2i, M = 3"
    PRINT "When inputting complex conjugates, they must be exactly, character per character,"
    PRINT "be input the same.  Ex:"
    PRINT "x = -1 + 1.414213562373095i"
    PRINT "x = -1 - 1.414213562373i"
    PRINT "this example will NOT register as a complex conjugate."
    PRINT
    PRINT "If at any time the building of an equation will result in the polynomials'"
    PRINT "degree becoming > "; LTRIM$(STR$(2 * mDeg)); ", then an alert will be displayed saying that the"
    PRINT "polynomial cannot be created."
    COLOR text, back
    FChoice0 (FPAK0)
    CLS 2
    PRINT : PRINT "Press the <Esc> key when finished editing this polynomial.  Press <TAB> to move"
    PRINT "right, Shift-<TAB> to move left."
    PRINT "The Location is:"; pLoc%; ". ": CurY% = CSRLIN

    PRINT : LOCATE CurY% + 1, 10: PRINT "Re[r(n)]"
    LOCATE CurY% + 1, 40: PRINT "Im[r(n)]"
    LOCATE CurY% + 1, 70: PRINT "M ="
    ClearRootCS (pLoc%)
   
    REM =========================== Create Array1() ========================

    FOR z% = 0 TO mDeg - 1
        Array1(z%).Num = 1
    NEXT z%
    IF (maxRow% = 25) THEN
        numArr1% = ArrEditCS%(Array1(), mDeg, 2, CurY% + 3, 11, 25, 10)
    ELSE
        numArr1% = ArrEditCS%(Array1(), mDeg, 2, CurY% + 3, 36, 25, 10)
    END IF
    REM Get raw root array from user

    REM =========================== Create Array2() ========================
    
    numArr2% = 0
    FOR z% = 0 TO numArr1% - 1
        Flag%(6) = 0
        FOR y% = z% + 1 TO numArr1% - 1
            IF ((Array1(z%).Real = Array1(y%).Real) AND (Array1(z%).Imag = Array1(y%).Imag) AND Array1(z%).Num <> 0 AND Array1(y%).Num <> 0) THEN
                Flag%(6) = Flag%(6) + 1
                Array2(numArr2%).Real = Array1(z%).Real
                Array2(numArr2%).Imag = Array1(z%).Imag
                IF (Flag%(6) = 1) THEN
                    Array2(numArr2%).Num = Array2(numArr2%).Num + Array1(z%).Num + Array1(y%).Num
                ELSE
                    Array2(numArr2%).Num = Array2(numArr2%).Num + Array1(y%).Num
                END IF
                Array1(y%) = ZeroArr: REM Sets all three arguments to 0
            END IF
        NEXT y%
        IF (Flag%(6) = 0) THEN
            IF (Array1(z%).Num <> 0) THEN
                Array2(numArr2%) = Array1(z%): REM sets all three arguments = Array1(z%)
                numArr2% = numArr2% + 1
            END IF
        ELSE
            numArr2% = numArr2% + 1
        END IF
    NEXT z%
    REM Create array with all roots conglomerated (counted up to their totals)

    REM =========================== Create Array3() ========================

    numArr3% = 0: d%(pLoc%) = 0: ndRoots%(pLoc%) = 0
    FOR z% = 0 TO numArr2% - 1
        IF (Array2(z%).Real = 0 AND Array2(z%).Imag = 0) THEN
            Array3(numArr3%) = Array2(z%): REM sets all three arguments = Array2(z%)
            ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
            x(pLoc%, ndRoots%(pLoc%)) = Array3(numArr3%)
            numArr3% = numArr3% + 1
            d%(pLoc%) = d%(pLoc%) + Array2(z%).Num
        END IF
    NEXT z%
    REM Moves all the 0 roots to the top of the root list
    FOR z% = 0 TO numArr2% - 1
        IF (Array2(z%).Real <> 0 AND Array2(z%).Imag = 0) THEN
            Array3(numArr3%) = Array2(z%): REM sets all three arguments = Array2(z%)
            ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
            x(pLoc%, ndRoots%(pLoc%)) = Array3(numArr3%)
            numArr3% = numArr3% + 1
            d%(pLoc%) = d%(pLoc%) + Array2(z%).Num
        END IF
    NEXT z%
    REM Moves all the real nonzero roots to next to the top of the root list
    FOR z% = 0 TO numArr2% - 1
        IF (Array2(z%).Imag <> 0) THEN
            Flag%(6) = 0
            FOR y% = z% + 1 TO numArr2% - 1
                IF ((Array2(z%).Real = Array2(y%).Real) AND (Array2(z%).Imag = -Array2(y%).Imag)) THEN
                    IF (Array2(z%).Num > Array2(y%).Num) THEN
                        Mmax% = Array2(z%).Num
                    ELSE
                        Mmax% = Array2(y%).Num
                    END IF
                    Array3(numArr3%).Real = Array2(z%).Real
                    Array3(numArr3%).Imag = ABS(Array2(z%).Imag)
                    Array3(numArr3%).Num = Mmax%
                    ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
                    x(pLoc%, ndRoots%(pLoc%)) = Array3(numArr3%)
                    ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
                    x(pLoc%, ndRoots%(pLoc%)).Real = Array3(numArr3%).Real
                    x(pLoc%, ndRoots%(pLoc%)).Imag = -Array3(numArr3%).Imag
                    x(pLoc%, ndRoots%(pLoc%)).Num = Array3(numArr3%).Num
                    d%(pLoc%) = d%(pLoc%) + 2 * Mmax%
                    Array2(y%) = ZeroArr
                    numArr3% = numArr3% + 1
                    Flag%(6) = 1
                END IF
            NEXT y%
            REM Find the largest multiplicity of root possible between positive and negative conjugates
            IF (Flag%(6) = 0) THEN
                Array3(numArr3%).Real = Array2(z%).Real
                Array3(numArr3%).Imag = ABS(Array2(z%).Imag)
                Array3(numArr3%).Num = Array2(z%).Num
                ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
                x(pLoc%, ndRoots%(pLoc%)) = Array3(numArr3%)
                ndRoots%(pLoc%) = ndRoots%(pLoc%) + 1
                x(pLoc%, ndRoots%(pLoc%)).Real = Array3(numArr3%).Real
                x(pLoc%, ndRoots%(pLoc%)).Imag = -Array3(numArr3%).Imag
                x(pLoc%, ndRoots%(pLoc%)).Num = Array3(numArr3%).Num
                d%(pLoc%) = d%(pLoc%) + 2 * Array2(z%).Num
                numArr3% = numArr3% + 1
            END IF
            REM If no conjugate, just make Array3 = Array2
        END IF
    NEXT z%
    REM creates Array3() with roots sorted, and complex roots put to the max
    REM M between conjugate pairs, also creates x(pLoc%, ndRoots%(pLoc%))

    PrintMenu0 MenuTitle$, subTitle$
    IF (d%(pLoc%) > 2 * mDeg) THEN
        PRINT : PRINT "The degree of the polynomial that you are trying to create will be "; LTRIM$(STR$(d%(pLoc%))); ","
        PRINT "which is greater than the maximum allowable degree of "; LTRIM$(STR$(2 * mDeg)); "."
        PRINT "Note: Current polynomial at location "; LTRIM$(STR$(pLoc%)); " has not been touched."
    ELSEIF (d%(pLoc%) = 0) THEN
        ClearLocCS (pLoc%): ClearRootCS (pLoc%)
        d%(pLoc%) = 0: d$(pLoc%) = "Z"
        CreateN1CS (pLoc%): PRINT : PRINT "Your polynomial is a "; n1$; ", and has the form:"
        CreateP2CS (pLoc%): PRINT : PRINT "f(x) = "; p2$: PRINT
    ELSE
        ClearLocCS (pLoc%)
        a#(pLoc%, 0) = 1: d$(pLoc%) = "0"
        FOR z% = 0 TO numArr3% - 1
            ClearLocCS (11): ClearLocCS (13)
            IF (Array3(z%).Imag = 0) THEN
                IF (Array3(z%).Real = 0) THEN
                    a#(11, Array3(z%).Num) = 1
                    d%(11) = Array3(z%).Num: d$(11) = LTRIM$(STR$(d%(11)))
                ELSE
                    a#(11, 1) = 1
                    a#(11, 0) = -Array3(z%).Real
                    d%(11) = 1: d$(11) = "1"
                    Power# = Array3(z%).Num
                    PowSub2 11, 12, 13, Power#
                    ChangeLocCS 13, 11
                END IF
                Junk% = MulSub2(pLoc%, 11, 13)
                ChangeLocCS 13, pLoc%
            ELSE
                a#(11, 2) = 1
                a#(11, 1) = -2 * Array3(z%).Real
                a#(11, 0) = (Array3(z%).Real) ^ 2 + (Array3(z%).Imag) ^ 2
                d%(11) = 2: d$(11) = "2"
                Power# = Array3(z%).Num
                PowSub2 11, 12, 13, Power#
                ChangeLocCS 13, 11
                Junk% = MulSub2(pLoc%, 11, 13)
                ChangeLocCS 13, pLoc%
            END IF
        NEXT z%
        REM create correct coefficients for this polynomial
         
        d$(pLoc%) = LTRIM$(STR$(d%(pLoc%)))
        PrintMenu0 MenuTitle$, subTitle$
        CreateN1CS (pLoc%): PRINT : PRINT "Your polynomial is a "; n1$; ", and has the form:"
        CreateP2CS (pLoc%): PRINT : PRINT "f(x) = "; p2$: PRINT
        DisplayRootCS (pLoc%)
    END IF
END IF

END SUB

SUB MinSub2 (Loc1%, Loc2%, Loc3%)

SubMin% = 0
IF (d%(Loc1%) > d%(Loc2%)) THEN
    maxDeg% = d%(Loc1%)
ELSE
    maxDeg% = d%(Loc2%)
END IF
ClearLocCS (Loc3%)
IF (d$(Loc1%) = "") THEN
    d$(Loc1%) = "Z"
END IF
IF (d$(Loc2%) = "") THEN
    d$(Loc2%) = "Z"
END IF
FOR z% = 0 TO maxDeg%
    a#(Loc3%, z%) = a#(Loc1%, z%) - a#(Loc2%, z%)
    IF (a#(Loc3%, z%) <> 0) THEN
        SubMin% = SubMin% + 1
    END IF
NEXT z%
IF (SubMin% <> 0) THEN
    d%(Loc3%) = maxDeg%
ELSE
    d%(Loc3%) = 0
END IF
IF (d%(Loc3%) = 0 AND a#(Loc3%, 0) = 0) THEN
    d$(Loc3%) = "Z"
ELSE
    d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
END IF

END SUB

FUNCTION MulSub2% (Loc1%, Loc2%, Loc3%)

MulSub2 = 0
IF (d%(Loc1%) > d%(Loc2%)) THEN
    maxDeg% = d%(Loc1%)
ELSE
    maxDeg% = d%(Loc2%)
END IF
ClearLocCS (Loc3%)
IF ((d$(Loc1%) = "") OR (d$(Loc1%) = "Z")) THEN
    d$(Loc1%) = "Z": d$(Loc3%) = "Z"
END IF
IF ((d$(Loc2%) = "") OR (d$(Loc2%) = "Z")) THEN
    d$(Loc2%) = "Z": d$(Loc3%) = "Z"
END IF
IF (((d%(Loc1%) + d%(Loc2%)) < (2 * mDeg + 1)) AND (d$(Loc1%) <> "Z") AND (d$(Loc2%) <> "Z")) THEN
    FOR y% = d%(Loc1%) TO 0 STEP -1
        FOR z% = d%(Loc2%) TO 0 STEP -1
            a#(Loc3%, y% + z%) = a#(Loc3%, y% + z%) + a#(Loc1%, y%) * a#(Loc2%, z%)
        NEXT z%
    NEXT y%
    d%(Loc3%) = d%(Loc1%) + d%(Loc2%): d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
ELSEIF ((d%(Loc1%) + d%(Loc2%)) > (2 * mDeg)) THEN
    MulSub2 = 1
END IF

END FUNCTION

SUB Plot2

REM "%" variables are in QBasic's virtual plotting space
REM "#" variables are in the actual mathematical plotting space

REM Global Variables
pd1# = -2 * pi: REM Screen Domain, Min
pd2# = 2 * pi: REM Screen Domain, Max
pr1# = -2: REM Screen Range, Min
pr2# = 2: REM Screen Range, Max
fd1# = -2 * pi: REM Function Domain, Min
fd2# = 2 * pi: REM Function Domain, Max
denFac# = 1
REM ================

REM Plot the function
IF ((maxX% > 0) AND (maxY% > 0)) THEN
    lcolor% = 9
 
    REM Initial x#, y#
    xg# = fd1# - ((fd2# - fd1#) / (denFac# * maxX%))
    yg# = FofX(xg#)

    REM Initial x2#, y2# position off the screen
    x2# = maxX% * (pd1# - xg#) / (pd1# - pd2#)
    y2# = maxY% * (pr2# - yg#) / (pr2# - pr1#)

    AxisTick2 pd1#, pd2#, pr1#, pr2#, maxX%, maxY%
 
    FOR xg# = fd1# TO fd2# STEP ((fd2# - fd1#) / (denFac# * maxX%))
        y1# = y2#: x1# = x2#
        IF screenMode% = 13 THEN lcolor% = 32 + x1# / 5
        yg# = FofX(xg#)
        x2# = maxX% * (pd1# - xg#) / (pd1# - pd2#)
        y2# = maxY% * (pr2# - yg#) / (pr2# - pr1#)
        IF ((-maxY% <= y1#) AND (y1# <= maxY% + 1) AND (-maxY% <= y2#) AND (y2# <= maxY% + 1)) THEN
            LINE (x1#, y1#)-(x2#, y2#), lcolor%
        END IF
    NEXT xg#
 
    Junk$ = FPAK0
    ClearScreenCS
END IF
REM =================

END SUB

SUB PolyMenuCS

PolMenu$ = ""
FOR z% = 0 TO 10
    IF (d$(z%) = "") THEN
        PolMenu$ = PolMenu$ + " "
    ELSE
        IF (z% = 10) THEN
            PolMenu$ = PolMenu$ + "A"
        ELSE
            PolMenu$ = PolMenu$ + LTRIM$(STR$(z%))
        END IF
    END IF
NEXT z%
VIEW PRINT 1 TO (maxRow% - 1)
LOCATE 1, 66: PRINT "Loc:"; PolMenu$
VIEW PRINT 2 TO (maxRow% - 1)

END SUB

SUB PowSub2 (Loc1%, Loc2%, Loc3%, Power#)

ClearLocCS (Loc2%): ClearLocCS (Loc3%)
IF ((d$(Loc1%) = "") OR (d$(Loc1%) = "Z")) THEN
    d$(Loc1%) = "Z"
    IF (Power# > 0) THEN
        d$(Loc3%) = "Z"
    ELSEIF (Power# = 0) THEN
        d$(Loc3%) = "I"
    ELSEIF (Power# < 0) THEN
        d$(Loc3%) = "U"
    END IF
END IF
IF (d$(Loc3%) <> "Z" AND d$(Loc3%) <> "I" AND d$(Loc3%) <> "U") THEN
    IF (d%(Loc1%) = 0 OR Power# = 0 OR Power# = 1) THEN
        IF (Power# <> 1) THEN
            a#(Loc2%, 0) = a#(Loc1%, 0) ^ Power#
            ChangeLocCS Loc2%, Loc3%
            ClearLocCS (Loc2%)
            d%(Loc3%) = 0
            IF (a#(Loc3%, 0) = 0) THEN
                d$(Loc3%) = "Z"
            ELSE
                d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
            END IF
        ELSE
            ChangeLocCS Loc1%, Loc3%
        END IF
    ELSE
        ChangeLocCS Loc1%, Loc2%
        FOR w% = 1 TO (Power# - 1)
            FOR y% = d%(Loc1%) TO 0 STEP -1
                FOR z% = d%(Loc2%) TO 0 STEP -1
                    a#(Loc3%, y% + z%) = a#(Loc3%, y% + z%) + a#(Loc1%, y%) * a#(Loc2%, z%)
                NEXT z%
            NEXT y%
            d%(Loc2%) = d%(Loc2%) + d%(Loc1%)
            FOR y% = 0 TO d%(Loc2%)
                a#(Loc2%, y%) = a#(Loc3%, y%): a#(Loc3%, y%) = 0
            NEXT y%
        NEXT w%
        ChangeLocCS Loc2%, Loc3%
        ClearLocCS (Loc2%)
        d%(Loc3%) = d%(Loc1%) * Power#: d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
    END IF
END IF

END SUB

SUB PrintMenu0 (Menu1$, Menu2$)

VIEW PRINT 1 TO (maxRow% - 1): CLS 2
PRINT TAB((maxCol - LEN(Menu1$ + Menu2$)) / 2); Menu1$ + Menu2$
PolyMenuCS
VIEW PRINT 2 TO (maxRow% - 1)

END SUB

SUB ReDrawCS (theArr() AS ComplexInput, CurX%, CurY%, dimen%, ind%, r1%, r2%, CLen%, Cstart%)

REM theArr() is the array being edited
REM CurX% is the current element in the x direction
REM CurY% is the current element in the y direction
REM dimen% is the dimension of the array (only 1 and 2 are supported)
REM ind% is the first element in the current virtual window
REM r1% is the start location of the current virtual window
REM r2% is the end location of the current virtual window
REM CLen% is the length of the current virtual window
REM Cstart% is where the current virtual window starts on the x axis
REM hit% = r2% - r1% which is the height of the current virtual window

hit% = r2% - r1%
FOR a% = 0 TO hit% - 1
    LOCATE a% + r1%, 1, 0
    IF (dimen% = 1) THEN
        PRINT "a("; LTRIM$(STR$(a% + ind%)); ")"; SPC(3);
    ELSE
        PRINT "n = "; LTRIM$(STR$(a% + ind% + 1)); SPC(3);
    END IF
    t$ = RTRIM$(STR$(theArr(a% + ind%).Real) + SPACE$(CLen%))
    t$ = RIGHT$(SPACE$(CLen%) + t$, CLen%)
    IF ((a% + ind% = CurY%) AND CurX% = 1) THEN COLOR back, text ELSE COLOR text, back
    LOCATE a% + r1%, Cstart%: PRINT t$;
    COLOR text, back
    IF (dimen% = 2) THEN
        t$ = RTRIM$(STR$(theArr(a% + ind%).Imag) + SPACE$(CLen%))
        t$ = RIGHT$(SPACE$(CLen%) + t$, CLen%)
        IF ((a% + ind% = CurY%) AND CurX% = 2) THEN COLOR back, text ELSE COLOR text, back
        LOCATE a% + r1%, Cstart% + CLen% + 5: PRINT t$;
        COLOR text, back
        t$ = RTRIM$(STR$(theArr(a% + ind%).Num) + SPACE$(5))
        t$ = RIGHT$(SPACE$(5) + t$, 5)
        IF ((a% + ind% = CurY%) AND CurX% = 3) THEN COLOR back, text ELSE COLOR text, back
        LOCATE a% + r1%, Cstart% + 2 * CLen% + 10: PRINT t$;
        COLOR text, back
    END IF
NEXT a%

END SUB

SUB Root1

MenuTitle$ = "Root Finder Menu"
init2% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
    PrintMenu0 MenuTitle$, ""
    Choice% = ChooseCS%(4, 3, 1, init2%)
    SELECT CASE Choice%
        CASE 1
            init2% = 1: PRINT : PRINT : PRINT "Sorry, Rational Root not yet implemented..."
        CASE 2
            init2% = 2: PRINT : PRINT : PRINT "Sorry, Newton's method not yet implemented..."
        CASE 3
            init2% = 3: PRINT : PRINT : PRINT "Sorry, Formula not yet implemented..."
        CASE 4
            init2% = 4: PRINT : PRINT : PRINT "Sorry, de'Moiver's Theorem/Formula not yet implemented..."
        CASE 5
            init2% = 5: PRINT : PRINT : PRINT "Sorry, All methods not yet implemented..."
        CASE 6
            init2% = 6: InputCoeffCS
        CASE 7
            init2% = 7: ChangePolCS
        CASE 8
            init2% = 8: DisplayPolCS
    END SELECT
    IF (Choice% <> 0) THEN FChoice0 (FPAK0)
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

SUB SetVideoModeCS

REM Prompt the user for what they want to do
posScreen$ = "1234  789ABCD"
DO
    CLS 2
    errorCode% = 1
    PRINT
    PRINT "The following video modes are supported by this program:"
    PRINT
    PRINT "1, for CGA 320 x 200, 4 colors"
    PRINT "2, for CGA 640 x 200, 2 colors"
    PRINT "3, for Hercules 720 x 348, monochrome (must invoke msherc.com)"
    PRINT "4, for Olivetti Graphics 640 x 400, monochrome"
    PRINT "7, for EGA 320 x 200, 16 colors"
    PRINT "8, for EGA 640 x 200, 16 colors"
    PRINT "9, for EGA 640 x 350, 4 colors, or 16 colors"
    PRINT "A, for EGA 640 x 350, monochrome"
    PRINT "B, for VGA 640 x 480, monochrome"
    PRINT "C, for VGA 640 x 480, 16 colors"
    PRINT "D, for VGA 320 x 200, 256 colors"
    PRINT
    PRINT "Do you want to autodetect the video modes that your adapter supports?  Press"
    PRINT "Y to autodetect, N to exit the program, or the number or letter from the above"
    PRINT "list if you know your video adapters supported video mode (y/n/...)-->";
    LOCATE , , 1
    DO
        a$ = INKEY$
    LOOP WHILE (a$ = "")
    PRINT a$
    a% = VAL(a$)
    a$ = LCASE$(a$)
    SELECT CASE a$
        CASE "a"
            a% = 10
        CASE "b"
            a% = 11
        CASE "c"
            a% = 12
        CASE "d"
            a% = 13
    END SELECT
    IF (a% > 0) THEN
        IF (MID$(posScreen$, a%, 1) <> " ") THEN
            IF (LCASE$(MID$(posScreen$, a%, 1)) = a$) THEN
                errorCode% = 0
                SCREEN a%
                IF (errorCode% <> 0) THEN
                    PRINT
                    PRINT "This is not a valid video mode for your video adapter! Please select another."
                    FChoice0 (FPAK0)
                END IF
            END IF
        END IF
    END IF
    IF ((a$ = "y") OR (a$ = "n")) THEN
        errorCode% = 0
    END IF
LOOP WHILE (errorCode% <> 0)
REM ========================================

REM Continue with the autodetect routine/selection after autodetect
IF (a$ = "y") THEN

    REM Video mode autodetect routine
    posScreen$ = ""
    FOR z% = 1 TO 13
        errorCode% = 0
        SCREEN z%
        IF (errorCode% <> 5) THEN
            SELECT CASE z%
                CASE 1 TO 9
                    posScreen$ = posScreen$ + LTRIM$(STR$(z%))
                CASE 10
                    posScreen$ = posScreen$ + "a"
                CASE 11
                    posScreen$ = posScreen$ + "b"
                CASE 12
                    posScreen$ = posScreen$ + "c"
                CASE 13
                    posScreen$ = posScreen$ + "d"
            END SELECT
        ELSE
            posScreen$ = posScreen$ + " "
        END IF
    NEXT z%
    REM =============================

    REM Prompt the user for the video modes that are available
    ClearScreenCS
    COLOR 15, 1
    PrintMenu0 MenuTitle$, ""
    PRINT : PRINT "The screen choices available to your video adapter are:"
    FOR z% = 1 TO 13
        IF (z% < 10) THEN
            IF (VAL(MID$(posScreen$, z%, 1)) = z%) THEN
                SELECT CASE z%
                    CASE 1
                        PRINT "1, for CGA 320 x 200, 4 colors"
                    CASE 2
                        PRINT "2, for CGA 640 x 200, 2 colors"
                    CASE 3
                        PRINT "3, for Hercules 720 x 348, monochrome (must invoke msherc.com)"
                    CASE 4
                        PRINT "4, for Olivetti Graphics 640 x 400, monochrome"
                    CASE 5
                    CASE 6
                    CASE 7
                        PRINT "7, for EGA 320 x 200, 16 colors"
                    CASE 8
                        PRINT "8, for EGA 640 x 200, 16 colors"
                    CASE 9
                        PRINT "9, for EGA 640 x 350, 4 colors, or 16 colors"
                END SELECT
            END IF
        ELSE
            IF (MID$(posScreen$, z%, 1) = "a") THEN
                PRINT "A, for EGA 640 x 350, monochrome"
            END IF
            IF (MID$(posScreen$, z%, 1) = "b") THEN
                PRINT "B, for VGA 640 x 480, monochrome"
            END IF
            IF (MID$(posScreen$, z%, 1) = "c") THEN
                PRINT "C, for VGA 640 x 480, 16 colors"
            END IF
            IF (MID$(posScreen$, z%, 1) = "d") THEN
                PRINT "D, for VGA 320 x 200, 256 colors"
            END IF
        END IF
    NEXT z%
    DO
        errChk% = 1
        PRINT "Enter the video mode you would like to select -->";
        LOCATE , , 1
        DO
            a$ = INKEY$
        LOOP WHILE (a$ = "")
        PRINT a$
        a% = VAL(a$)
        a$ = LCASE$(a$)
        SELECT CASE a$
            CASE "a"
                a% = 10
            CASE "b"
                a% = 11
            CASE "c"
                a% = 12
            CASE "d"
                a% = 13
        END SELECT
        IF (a% > 0) THEN
            IF (MID$(posScreen$, a%, 1) <> " ") THEN
                IF (LCASE$(MID$(posScreen$, a%, 1)) = a$) THEN
                    errChk% = 0
                END IF
            END IF
        END IF
    LOOP WHILE (errChk% = 1)
    REM ======================================================
END IF

IF (a$ <> "n") THEN
    REM Select the max screen size
    SCREEN a%
    SELECT CASE a%
        CASE 0
   
        CASE 1: REM CGA 320x200, 4 color
            maxX% = 318
            maxY% = 158
        CASE 2: REM CGA 640x200, 2 color
            maxX% = 638
            maxY% = 158
        CASE 3: REM Hercules 720x348, monochrome.  Must invoke msherc.com
            maxX% = 718
            maxY% = 278
        CASE 4: REM Olivetti Graphics 640x400, monochrome
            maxX% = 638
            maxY% = 320
        CASE 5: REM Unknown
        CASE 6: REM Unknown
        CASE 7: REM EGA 320x200, 16 color
            maxX% = 318
            maxY% = 158
        CASE 8: REM EGA 640x200, 16 color
            maxX% = 638
            maxY% = 158
        CASE 9: REM EGA 640x350, 4 color or 16 color
            maxX% = 638
            maxY% = 278
        CASE 10: REM EGA 640x350, monochrome
            maxX% = 638
            maxY% = 278
        CASE 11: REM VGA 640x480, monochrome
            maxX% = 638
            maxY% = 398
        CASE 12: REM VGA 640x480, 16 color
            maxX% = 638
            maxY% = 398
        CASE 13: REM VGA 320x200, 256 color
            maxX% = 318
            maxY% = 158
    END SELECT
    REM ==========================
    screenMode% = a%
ELSE
    screenMode% = 0
END IF
REM ===============================================================

END SUB

FUNCTION SubSub2% (Loc1%, Loc2%, Loc3%, Loc4%)

SubSub2 = 0
ClearLocCS (Loc3%): ClearLocCS (Loc4%): ClearLocCS (11)
IF ((d$(Loc1%) = "") OR (d$(Loc1%) = "Z")) THEN
    d$(Loc1%) = "Z"
END IF
IF ((d$(Loc2%) = "") OR (d$(Loc2%) = "Z")) THEN
    d$(Loc2%) = "Z"
END IF
IF ((d%(Loc2%) = 0) AND (a#(Loc2%, 0) = 0)) THEN
    d$(Loc2%) = "Z"
ELSE
    d$(Loc2%) = LTRIM$(STR$(d%(Loc2%)))
END IF
IF ((d%(Loc1%) * d%(Loc2%)) < (2 * mDeg + 1) AND d$(Loc1%) <> "Z" AND d$(Loc2%) <> "Z") THEN
    FOR z% = 0 TO d%(Loc1%)
        IF (z% > 1) THEN
            IF (a#(Loc1%, z%) <> 0) THEN
                PowSub2 Loc2%, 11, Loc4%, z% * 1!
                FOR y% = 0 TO d%(Loc2%) * z%
                    a#(Loc3%, y%) = a#(Loc3%, y%) + a#(Loc1%, z%) * a#(Loc4%, y%)
                NEXT y%
            END IF
        ELSEIF (z% = 1) THEN
            FOR y% = 0 TO d%(Loc2%)
                a#(Loc3%, y%) = a#(Loc3%, y%) + a#(Loc1%, z%) * a#(Loc2%, y%)
            NEXT y%
        ELSEIF (z% = 0) THEN
            a#(Loc3%, 0) = a#(Loc3%, 0) + a#(Loc1%, 0)
        END IF
    NEXT z%
    d%(Loc3%) = d%(Loc1%) * d%(Loc2%)
    IF ((d%(Loc3%) = 0) AND a#(Loc3%, 0) = 0) THEN
        d$(Loc3%) = "Z"
    ELSE
        d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
    END IF
    ClearLocCS (11): ClearLocCS (Loc4%)
ELSEIF (d%(Loc1%) = 0) THEN
    a#(Loc3%, 0) = a#(Loc1%, 0)
    IF ((d%(Loc1%) = 0) AND (a#(Loc1%, 0) = 0)) THEN
        d$(Loc1%) = "Z"
    ELSE
        d$(Loc1%) = LTRIM$(STR$(d%(Loc1%)))
    END IF
    d%(Loc3%) = d%(Loc1%): d$(Loc3%) = d$(Loc1%)
ELSEIF (d%(Loc1%) <> 0 AND d%(Loc2%) = 0) THEN
    a#(Loc3%, 0) = SynthWithoutCS#(Loc1%, a#(Loc2%, 0))
    d%(Loc3%) = 0
    IF ((d%(Loc3%) = 0) AND (a#(Loc3%, 0) = 0)) THEN
        d$(Loc3%) = "Z"
    ELSE
        d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
    END IF
ELSEIF ((d%(Loc1%) * d%(Loc2%)) > (2 * mDeg)) THEN
    SubSub2 = 1
END IF

END FUNCTION

FUNCTION SynthWithCS# (Loc1%, Loc2%, Loc3%)

Divisor# = -a#(Loc2%, 0)
IF (d%(Loc1%) = 1) THEN
    a#(Loc3%, 0) = a#(Loc1%, 1)
ELSE
    a#(Loc3%, d%(Loc1%) - 1) = a#(Loc1%, d%(Loc1%))
    FOR z% = (d%(Loc1%) - 1) TO 1 STEP -1
        a#(Loc3%, z% - 1) = a#(Loc3%, z%) * Divisor# + a#(Loc1%, z%)
    NEXT z%
END IF
SynthWithCS = a#(Loc3%, 0) * Divisor# + a#(Loc1%, 0)
IF (d%(Loc1%) > 1) THEN
    d%(Loc3%) = d%(Loc1%) - 1
ELSE
    d%(Loc3%) = 0
END IF
IF ((d%(Loc3%) = 0) AND (a#(Loc3%, 0) = 0)) THEN
    d$(Loc3%) = "Z"
ELSE
    d$(Loc3%) = LTRIM$(STR$(d%(Loc3%)))
END IF

END FUNCTION

FUNCTION SynthWithoutCS# (pLoc%, xx#)

y# = 0
IF (d%(pLoc%) <> 0) THEN
    FOR z% = d%(pLoc%) TO 1 STEP -1
        y# = (y# + a#(pLoc%, z%)) * xx#
    NEXT z%
END IF
y# = y# + a#(pLoc%, 0)
SynthWithoutCS# = y#

END FUNCTION

SUB UtilityMenu1

DIM TmpLoc%(11), char AS STRING * 1
Flag%(5) = 0
MenuTitle$ = "Poly Utilities Menu"
init2% = 1

REM ******************** BEGINING OF MAIN LOOP ********************
DO
PrintMenu0 MenuTitle$, ""
Choice% = ChooseCS%(5, 3, 1, init2%)
SELECT CASE Choice%
    CASE 1
        init2% = 1: InputPolCS
    CASE 2
        init2% = 2: ChangePolCS
    CASE 3
        init2% = 3: DisplayPolCS
    CASE 4
        init2% = 4: subTitle$ = ": Saving coefficients"
        polLoc$ = ""
        FOR z% = 0 TO 9
            IF (d$(z%) <> "") THEN polLoc$ = polLoc$ + LTRIM$(STR$(z%))
        NEXT z%
        IF (d$(10) <> "") THEN polLoc$ = polLoc$ + "A"
        IF (LEN(polLoc$) = 0) THEN
            PrintMenu0 MenuTitle$, subTitle$
            PRINT : PRINT "There are no polynomials in memory.  Please input a polynomial first."
        ELSE
            DO
                PrintMenu0 MenuTitle$, subTitle$
                PRINT : PRINT "Please input the number of the file name that you want to save:"
                INPUT "(0000-9999)-->"; Junk$
                InputErr% = InputErrorCS(Junk$, 0, 9999)
            LOOP UNTIL (InputErr% < 1)
            Junk% = VAL(Junk$)
            FileName$ = "SAVE"
            FOR z% = 1 TO (4 - LEN(LTRIM$(STR$(Junk%))))
                FileName$ = FileName$ + "0"
            NEXT z%
            FileName$ = FileName$ + LTRIM$(STR$(Junk%)) + ".POL"
            lenPolLoc% = LEN(polLoc$)
            errorCode% = 0
            OPEN FileName$ FOR INPUT AS #1
            IF (errorCode% = 53) THEN
                CLOSE #1
                OPEN FileName$ FOR OUTPUT AS #1
                WRITE #1, lenPolLoc%
                FOR z% = 1 TO LEN(polLoc$)
                    IF (MID$(polLoc$, z%, 1) <> "A") THEN
                        pLoc% = VAL(MID$(polLoc$, z%, 1))
                    ELSE
                        pLoc% = 10
                    END IF
                    WRITE #1, pLoc%, d%(pLoc%)
                    FOR y% = 0 TO d%(pLoc%)
                        WRITE #1, a#(pLoc%, y%): REM The coefficients of the polynomial
                    NEXT y%
                NEXT z%
                WRITE #1, "Please do not edit this file!  If you do, poly05.bas will react unexpectedly."
                CLOSE #1
                PRINT : PRINT "File successfully saved as "; FileName$
            ELSE
                CLOSE #1
                PRINT : PRINT "File NOT saved, file: "; FileName$; " already exists!"
            END IF
        END IF
    CASE 5
        init2% = 5: subTitle$ = ": Loading coefficients"
        PrintMenu0 MenuTitle$, subTitle$
        polLoc$ = ""
        FOR z% = 0 TO 9
            IF (d$(z%) <> "") THEN polLoc$ = polLoc$ + LTRIM$(STR$(z%))
        NEXT z%
        IF (d$(10) <> "") THEN polLoc$ = polLoc$ + "A"
        IF (LEN(polLoc$) <> 0) THEN
            PRINT : PRINT "There are polynomials in memory, do you wish to overwrite ALL of them?(y/n)-->";
            LOCATE , , 1
            Key$ = GetKey0$
            LOCATE , , 0
            IF (LCASE$(Key$) <> "y") THEN
                PRINT : PRINT "Existing polynomials have not been touched."
                Flag%(5) = 0
            ELSE
                Flag%(5) = 1
            END IF
        ELSE
            Flag%(5) = 1
        END IF
        IF (Flag%(5) = 1) THEN
            PrintMenu0 MenuTitle$, subTitle$
            COLOR 7, 0: CLS 2
            PRINT : PRINT : PRINT : SHELL "dir save*.pol | more"
            FMenu0
            DO
                PRINT : PRINT "Please input the number of the file name that you want to load:"
                INPUT "(0000-9999)-->"; Junk$
                InputErr% = InputErrorCS(Junk$, 0, 9999)
            LOOP UNTIL (InputErr% < 1)
            Junk% = VAL(Junk$)
            FileName$ = "SAVE"
            FOR z% = 1 TO (4 - LEN(LTRIM$(STR$(Junk%))))
                FileName$ = FileName$ + "0"
            NEXT z%
            FileName$ = FileName$ + LTRIM$(STR$(Junk%)) + ".POL"
            errorCode% = 0
            OPEN FileName$ FOR INPUT AS #1
            IF (errorCode% = 53) THEN
                CLOSE #1
                PRINT "File: "; FileName$; " is not found!  Existing polynomials have not been touched."
            ELSE
                FOR z% = 0 TO nPol
                    ClearLocCS (z%): ClearRootCS (z%)
                NEXT z%
                INPUT #1, numPol%
                FOR z% = 1 TO numPol%
                    INPUT #1, TmpLoc%(z%), d%(TmpLoc%(z%))
                    FOR y% = 0 TO d%(TmpLoc%(z%))
                        INPUT #1, a#(TmpLoc%(z%), y%): REM The coefficients of the polynomial
                    NEXT y%
                NEXT z%
                CLOSE #1
                FOR z% = 1 TO numPol%
                    d$(TmpLoc%(z%)) = LTRIM$(STR$(d%(TmpLoc%(z%))))
                NEXT z%
                PolyMenuCS
                LOCATE 5, 1
                PRINT "File "; FileName$; " successfully loaded."
            END IF
        END IF
    CASE 6
        init2% = 6
        subTitle$ = ": Exporting Polys to a text file"
        polLoc$ = ""
        FOR z% = 0 TO 9
            IF (d$(z%) <> "") THEN polLoc$ = polLoc$ + LTRIM$(STR$(z%))
        NEXT z%
        IF (d$(10) <> "") THEN polLoc$ = polLoc$ + "A"
        IF (LEN(polLoc$) = 0) THEN
            PrintMenu0 MenuTitle$, subTitle$
            PRINT : PRINT "There are no polynomials in memory.  Please input a polynomial first."
        ELSE
            DO
                PrintMenu0 MenuTitle$, subTitle$
                PRINT : PRINT "Please input the number of the file name that you want to save:"
                INPUT "(0000-9999)-->"; Junk$
                InputErr% = InputErrorCS(Junk$, 0, 9999)
            LOOP UNTIL (InputErr% < 1)
            Junk% = VAL(Junk$)
            FileName$ = "EXPT"
            FOR z% = 1 TO (4 - LEN(LTRIM$(STR$(Junk%))))
                FileName$ = FileName$ + "0"
            NEXT z%
            FileName$ = FileName$ + LTRIM$(STR$(Junk%)) + ".TXT"
            lenPolLoc% = LEN(polLoc$)
            errorCode% = 0
            OPEN FileName$ FOR INPUT AS #1
            IF (errorCode% = 53) THEN
                Flag%(7) = 1
                CLOSE #1
                OPEN FileName$ FOR OUTPUT AS #1
                PRINT "Exporting polynomials to a file, this make take a few moments..."
                FOR z% = 1 TO LEN(polLoc$)
                    IF (MID$(polLoc$, z%, 1) <> "A") THEN
                        pLoc% = VAL(MID$(polLoc$, z%, 1))
                    ELSE
                        pLoc% = 10
                    END IF
                    temp$ = ""
                    CreateP2CS (pLoc%)
                    FOR y% = 1 TO LEN(p2$)
                        IF (MID$(p2$, y%, 1) = "D") THEN
                            temp$ = temp$ + "*10^("
                        ELSEIF ((y% = LEN(p2$)) AND (MID$(p2$, y%, 1) <> "x") AND (LEN(p2$) > 5)) THEN
                            IF ((MID$(p2$, y% - 5, 1) = "D") OR (MID$(p2$, y% - 4, 1) = "D")) THEN
                                temp$ = temp$ + MID$(p2$, y%, 1) + ")"
                            ELSE
                                temp$ = temp$ + MID$(p2$, y%, 1)
                            END IF
                        ELSEIF (MID$(p2$, y%, 1) = "x") THEN
                            IF (y% > 5) THEN
                                IF ((MID$(p2$, y% - 5, 1) = "D") OR (MID$(p2$, y% - 4, 1) = "D")) THEN
                                    temp$ = temp$ + ")*x"
                                ELSE
                                    temp$ = temp$ + "x"
                                END IF
                            ELSE
                                temp$ = temp$ + "x"
                            END IF
                        ELSEIF (MID$(p2$, y%, 1) = " ") THEN
                            temp$ = temp$
                        ELSE
                            temp$ = temp$ + MID$(p2$, y%, 1)
                        END IF
                    NEXT y%
                    REM Convert the non exportable "D" form to an exportable form
                    PRINT #1, temp$
                    IF (ndRoots%(pLoc%) > 0) THEN
                        DisplayRootCS (pLoc%)
                    END IF
                NEXT z%
                Flag%(7) = 0
                CLOSE #1
                PRINT "File successfully saved as "; FileName$
            ELSE
                PRINT : PRINT "File NOT exported, file: "; FileName$; " already exists!"
                CLOSE #1
            END IF
        END IF
    CASE 7
        init2% = 7
        subTitle$ = ": Clearing Polys"
        DO
            PrintMenu0 MenuTitle$, subTitle$
            LOCATE , , 1
            PRINT : PRINT "Are you sure you want to clear all polynomials (y/n)-->";
            Key$ = GetKey0$
            IF (LCASE$(Key$) = "y") THEN
                FOR z% = 0 TO nPol
                    ClearLocCS (z%): ClearRootCS (z%)
                NEXT z%
                PrintMenu0 MenuTitle$, subTitle$
                PRINT : PRINT "All Polynomials have been cleared."
            ELSEIF (LCASE$(Key$) = "n") THEN
                PrintMenu0 MenuTitle$, subTitle$
                PRINT : PRINT "Existing polynomials have not been touched."
            END IF
        LOOP UNTIL (LCASE$(Key$) = "y" OR LCASE$(Key$) = "n")
END SELECT
IF (Choice% <> 0 AND Choice% <> 1) THEN FChoice0 (FPAK0)
LOOP UNTIL (Choice% = 0)
REM ********************** END OF MAIN LOOP ***********************

END SUB

