IMPLEMENTATION MODULE LowLevel;

(*  This is FREE software, as described in the GNU General Public Licences.
    Therefore it comes WITH THE FULL SOURCES. Please feel free to improve this
    code when necessary. You OWN this code. I am not Bill Gates.

    I would appreciate that people let in this message when extending this
    library, as a small tribute to me (for laying the foundation).

    In case people need extra information, contact me via:

        snail mail: Jan Verhoeven, 5012 GH 272, The Netherlands
   electronic mail: aklasse@tip.nl

    I remain full copyrights to these sources. If you want to send me a small 
    "thanks", please send me a postcard of your hometown to the above shown
    snailmail address. Yes it is in code; the internal code of our national 
    mail deliverer.

    Use this software at your own risk. Please find yourself a GNU GPL if you 
    are in any doubt. I use these functions for all my own software, but there 
    is NO GUARANTEE OF ANY KIND covering it.            *)


FROM    SYSTEM      IMPORT  ASSEMBLER;

PROCEDURE InPort (Port : CARDINAL; WordSize : BOOLEAN) : CARDINAL;
(*
    Return value by reading I/O port <Port>.
    *)

VAR Result  : CARDINAL;

BEGIN
    IF WordSize THEN
        ASM
            MOV  DX, Port
            IN   AX, DX
            MOV  Result, AX
        END;
    ELSE
        ASM
            MOV  DX, Port
            IN   AL, DX
            MOV  AH, 0
            MOV  Result, AX
        END;
    END;
    RETURN Result;
END InPort;


PROCEDURE OutPort (Port, Value : CARDINAL; WordSize : BOOLEAN);
(*
    Send byte <Value> to I/O port <Port>.
    *)

BEGIN
    IF WordSize THEN
        ASM
            MOV  DX, Port
            MOV  AX, Value
            OUT  DX, AX
        END;
    ELSE
        ASM
            MOV  DX, Port
            MOV  AL, Value
            OUT  DX, AL
        END;
    END;
END OutPort;

END LowLevel.
