//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCMDGEN.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Command generators interface         |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_cmdgen( void );

#ifndef _PVCMDGEN_H
#define _PVCMDGEN_H

//MENU DEFINES

struct Tmenu_item;

struct Tmenu
{
  Tmenu_item *items;        //points to a list of items
  Tmenu_item *current;      //points to the default item
  Tmenu *old_menu;
  Tmenu_item *old_item;
};

struct Tmenu_item
{
  Tmenu_item *next;         //points to the next menu item
  char *name;               //points to the item's title
  boolean enabled;
  uint command;             //also used as item identifier
  uint help_ctx;
  uint kind;
  union
  {
    Tmenu *submenu;         //points to nested submenu
    char *param;            //points to item's parameter
    uint *check;            //points to item's check uint
  } what;
};

class Tmenu_base: public Titem
{
  public:
    Titem *client;
    Tmenu *menu;
    uint shortcut;
    Tmenu_base( int _xl, int _yl );
    virtual ~Tmenu_base( void );
    virtual uint exec( void );

  protected:
    Tset local_commands;
    Tmenu_base *parent;
    boolean pulled_down;
    virtual void set_palette( void );
    virtual void event_handler( Tevent &ev );
    void update_commands( Tmenu *m );
    Tmenu_item *next_line( void );
    Tmenu_item *previous_line( void );
    virtual int item_x( Tmenu_item *p ) = 0;
    virtual int item_y( Tmenu_item *p ) = 0;
    virtual Tmenu_item *pointed_ptr( int mx, int my ) = 0;
    virtual Tmenu_item *shortcut_ptr( uint ascii );
    void suspend_selection( void );
    void open_submenu( void );
    void close_submenu( void );
    void close_menu( void );

    inline void make_selection( void )
    {
      message( this, cmMENU_SELECTION );
    }

    inline void selection_made( void )
    {
      modal_broadcast( cmMENU_SELECTION_MADE );
    }

    inline void cancelled( void )
    {
      modal_broadcast( cmMENU_CANCELLED );
    }
};

class Tmenu_box: public Tmenu_base
{
  public:
    Tmenu_box( Tmenu *_menu, Tmenu_base *_parent );

  protected:
    virtual void draw( void );
    virtual void initialize( void );
    virtual void event_handler( Tevent &ev );
    virtual int item_x( Tmenu_item *p );
    virtual int item_y( Tmenu_item *p );
    virtual Tmenu_item *pointed_ptr( int mx, int my );
};

class Tmenu_bar: public Tmenu_base
{
  public:
    Tmenu_bar( Tmenu *_menu, int _xl );

  protected:
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual int item_x( Tmenu_item *p );
    virtual int item_y( Tmenu_item *p );
    virtual Tmenu_item *pointed_ptr( int mx, int my );
};


//TOOLS DEFINES

typedef void ( * Tcontext_handler ) ( int context );

#endif //_PVCMDGEN.H

#ifdef DECLARE_PVCMDGEN

//MENU DECLARATIONS

#ifndef NOMAINMENU
Tmenu_bar *main_menu = NULL;
#endif

//TOOLS DECLARATIONS

#ifndef NOTOOLBAR
uint toolbar_enabled = cmWINDOW_TOOLBAR;
Titem *toolbar;
#endif

#else //DECLARE_PVCMDGEN

//MENU DECLARATIONS

#ifndef NOMAINMENU
extern Tmenu_bar *main_menu;
#endif


//TOOLS DECLARATIONS

#ifndef NOTOOLBAR
extern uint toolbar_enabled;
extern Titem *toolbar;
#endif

#endif //DECLARE_PVCMDGEN


//MENU INTERFACE

#ifndef NOMAINMENU
Tmenu_bar *construct_main_menu( Tmenu *m );
#endif

#ifndef NOLOCALMENU
Tmenu_box *construct_local_menu( Tmenu *m );
#endif

Tmenu_box *construct_menu_box( Tmenu *m );
Tmenu_bar *construct_menu_bar( Tmenu *m, int _xl );

void menu( void );
Tmenu *endm( void );
void update_menu( Tmenu *cm, Tmenu_item *ci );
Tmenu_item *mitem( char *name, uint command );
Tmenu_item *mitem( char *name, char *param, uint command);
Tmenu_item *mitem( char *name, uint &_check, uint command );
Tmenu_item *mitem( void );
Tmenu_item *submenu( char *name );
void dispose_menu( Tmenu *p );
void show_menu_cursor( Tmenu *p );
void show_submenu_cursor( Tmenu_item *p );


//TOOLS INTERFACE

#ifndef NOTOOLBAR
void construct_toolbar( void );
#endif

#ifndef NOTOOLBAR
Tbutton *add_tool( char *t, uint cmd, uint key );
Tbutton *add_tool( char *t, uint cmd );
void add_tool( uint cmd, uint key );
#endif

void install_context_handler( Tcontext_handler ctxhnd );
void set_context( int context );
void update_context( void );

void global_key( uint cmd, uint key );
void local_key( Titem *p, uint cmd, uint key );
