//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSTDDLG.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Standard dialog boxes interface      |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

uint test_file_exist( char *path );
  //return cmYES, cmNO, or cmCANCEL

uint get_file( char *title, char *result );
  //0    - no file selected, or cancel;
  //1    - file is selected, call again for more selected files
  //cmOK - single file specified

Tdialog *action( char *txt, ... );
  //display an action window

void done_action( void );
  //close the action window

void ok( char *txt, ... );
  //OK message box

boolean kc( char *txt, ... );
  //OK/Cancel message box

boolean kch( char *txt, ... );
  //OK/Cancel/Help message box

boolean yn( char *txt, ... );
  //Yes/No message box

boolean ynh( char *txt, ... );
  //Yes/No/Help message box

uint ync( char *txt, ... );
  //Yes/No/Cancel message box

uint ynch( char *txt, ... );
  //Yes/No/Cancel/Help message box

boolean ra( char *txt, ... );
  //Retry/Abort message box

boolean rah( char *txt, ... );
  //Retry/Abort/Help message box

boolean drive_error( int drv );
  //Not ready


//PREFIXES

void _new_file( void );      boolean __new_file( void );
  //specify get_file to ask for overwrite if file exist

void _multi_files( void );   boolean __multi_files( void );
  //enables get_file multiple files selection feature

void _filters( char *f );    char *__filters( void );
  //specify filters for get_file: "Type1 (*.xt1)|Type2 (*.xt2)|..."

void _get_file_svd( char *get_file_dir, uint &get_file_filter );
                             void __get_file_svd( char **get_file_dir, uint **get_file_filter );
  //specify global buffers for saving selected dir and filter for get_file

void _title( char *t );      char *__title( void );
  //specify title for the message box

void _tmessage( void );
  //select 'Message' title for the message box

void _terror( void );
  //select 'Error' title for the message box

void _tconfirm( void );
  //select 'Confirm' title for the message box

void _iwarning( void );      char __icon( void );
  //select 'Warning' title for the message box

void _iquestion( void );
  //select '?' icon for the message box

void _iinfo( void );
  //select 'i' icon for the message box

void _inothing( void );
  //disable icon for the message box (default icon is '!')


#ifdef DECLARE_PVSTDDLG
boolean con_messages = 1; //if(con_messages) msg boxes print to stdout
#else
extern boolean con_messages;
#endif
