#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "allegro.h"
#include "lmuse.h"
#include "help.h"

DIALOG  help_dialog[] =
{
   { d_box_proc,         30,   30,    430,  360,   255, HELPBG,  0,   0,      0,    0, NULL},
   { d_textbox_proc,     32,   55,    426,  333,   255,  0,      0,   0,      0,    0, NULL},
   { d_button_proc,      35,   35,   20,   16,    255,  0,      27,  D_EXIT, 0,    0,    "X" },

   { NULL,               0,     0,    0,    0,   0,    0,    0,     0,      0,    0,    NULL }
};
#define HELPTEXTBOX 1


int helper(int whichhelp){
   char *helpfilepath=NULL;
   DATAFILE *helpdata;
   char *credittext=NULL;
   long sz;
   char *hd;
   helpfilepath = getenv("LMUSHELP");
   if (helpfilepath == NULL) helpfilepath = "help.dat";
   
   helpdata=load_datafile(helpfilepath);
   if (helpdata== 0) {

             alert("Error reading help.dat", NULL, NULL, "Oh well","Curses!", 13, 13);
             return D_O_K;
   }
   hd=helpdata[whichhelp].dat;
   sz=helpdata[whichhelp].size;
   hd[sz-1]='\0';
   if(whichhelp==CREDITHELP){
      credittext=(char *)malloc(sizeof(char)*(sz+256));
      if(credittext==NULL)
           help_dialog[HELPTEXTBOX].dp=helpdata[whichhelp].dat;
      else{
            sprintf(credittext,"LMUSe version %s, %s\n",PROGRAMVERSION,VERSIONDATE);
            strcat(credittext,helpdata[whichhelp].dat);
            help_dialog[HELPTEXTBOX].dp=credittext;
      }
   }
   else
      help_dialog[HELPTEXTBOX].dp=helpdata[whichhelp].dat;
   help_dialog[HELPTEXTBOX].d2=0;
   centre_dialog(help_dialog);
   popup_dialog(help_dialog,0);
   unload_datafile(helpdata);
   if(credittext!=NULL)
       free(credittext);
   return D_O_K;
}

int symbolshelp(){
   int ret;

   ret=helper(SYMBOLSHELP);
   return ret;
}
int commandlinehelp(){
   int ret;

   ret=helper(COMMANDLINEHELP);
   return ret;
}

int playhelp(){
   int ret;

   ret=helper(PLAYHELP);
   return ret;
}

int lsystemshelp(){
   int ret;

   ret=helper(LSYSHELP);
   return ret;
}

int menushelp(){
   int ret;

   ret=helper(MENUHELP);
   return ret;
}
int scaleshelp(){
   int ret;

   ret=helper(SCALESHELP);
   return ret;
}

int credithelp(){
   int ret;

   ret=helper(CREDITHELP);
   return ret;
}

int fileshelp(){
   int ret;

   ret=helper(FILESHELP);
   return ret;
}
int troublehelp(){
    int ret;

    ret=helper(TROUBLEHELP);
    return ret;
}
int rulefilehelp(){
    int ret;

    ret=helper(RULEFILEHELP);
    return ret;
}
int maphelp(){
    int ret;

    ret=helper(MAPHELP);
    return ret;
}

int instrumentshelp(){
    int ret;

    ret=helper(INSTRUMENTHELP);
    return ret;
}
extern volatile long int_t1;
int playhelpbutton_proc(int msg, DIALOG *d, int c){
        long holdt1;
        int sret;
        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           holdt1=int_t1;

           sret=playhelp();
           int_t1=holdt1;
           return sret;
        }
        return(ret);
}


DIALOG overview_dialog[]={

   {d_box_proc,      0,   0,   474,  356,   255,  8,       0,   0,      0,   0,   NULL},


   {d_bitmap_proc,   1,   25,  472,  330,  255,  0,       0,   0,      0,   0,   NULL},
   { d_button_proc,  5,   5,   30,   16,   255,  0,       13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};
#define OVERVIEWPIC 1
int overview(){
    DATAFILE *helpdata;
    BITMAP * overviewpic;
    helpdata=load_datafile("help.dat");
    if (helpdata== 0) {

             alert("Error reading help.dat", NULL, NULL, "Oh well","Curses!", 13, 13);
             return D_O_K;
    }

    overviewpic=helpdata[OVERVIEWBMP].dat;
    if(overviewpic){
           overview_dialog[OVERVIEWPIC].dp=overviewpic;
           centre_dialog(overview_dialog);
           popup_dialog(overview_dialog,2);
           destroy_bitmap(overviewpic);
    }
    unload_datafile(helpdata);
    return D_O_K;

}
