REM file: Drives.bas - Public Domain DOS Utility
REM Version 1.0a created 03/07/1995

REM Compiling with Microsoft BASIC Professional Development System 7.1:
REM    BC DRIVES/FS/X/O;
REM    LINK DRIVES,,,QBX/E;

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)

' declare registers
COMMON SHARED InregsX AS RegtypeX, OutregsX AS RegtypeX

' initialize filename buffer
DIM ASCIZ AS STRING * 260

' declare work variables
COMMON SHARED Default.Drive AS INTEGER, Drives AS INTEGER
COMMON SHARED Last.Drive AS INTEGER, Display.Drive1 AS INTEGER
COMMON SHARED Display.Drive2 AS INTEGER, Display.Errors AS INTEGER
COMMON SHARED Continuous.Display AS INTEGER, Display.Current AS INTEGER
COMMON SHARED New.Drive AS INTEGER, Change.Drive AS INTEGER
COMMON SHARED Skip.Drives() AS INTEGER, Windows.Detected AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING

' increase stack size
STACK STACK

' dimension work variables
REDIM Skip.Drives(1 TO 26) AS INTEGER

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, X$)
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    ParseLine = False
 END IF
END FUNCTION 

' check windows dos
InregsX.AX = &H160A
CALL InterruptX(&H2F, InregsX, OutregsX)
IF OutregsX.AX = False THEN
   Temp = (OutregsX.BX And &HFF00) / 256
   IF Temp >= 4 THEN
      Windows.Detected = True
   END IF
Endif

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' store and parse command line
Command.Line = COMMAND$
IF Command.Line = NUL THEN
   Command.Line = UCASE$(ENVIRON$("DRIVES"))
END IF

' remove blanks from command line
DO
   Imbedded = ParseLine (" ")
   IF Imbedded = False THEN
      EXIT DO
   END IF
LOOP

' check command line switches
Display.Drive1 = ParseLine ("/A")
Display.Drive2 = ParseLine ("/B")
Continuous.Display = ParseLine ("/C")
Display.Current = ParseLine ("/X")
Change.Drive = ParseLine ("/Y")
Display.Errors = ParseLine ("/Z")

' check command line switch
DO
   Imbedded = INSTR(Command.Line, "/1:")
   IF Imbedded = False THEN
      EXIT DO
   END IF
   Skip = ASC(MID$(Command.Line, Imbedded + 3, 1)) - 64
   IF Skip >= 1 AND Skip <= 26 THEN
      Skip.Drives(Skip) = True
   END IF
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 4)
LOOP

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Usage
END IF

' check command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
IF RIGHT$(Command.Line, 1) = ":" THEN
   New.Drive = ASC(LEFT$(Command.Line, 1)) - 64
END IF

' make header
IF Continuous.Display = False THEN
   COLOR White, Black
   PRINT "Drives v1.0a: Drive display utility;"
END IF

' get current drive
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Default.Drive = OutregsX.AX AND &HFF

' get maximum drives
InregsX.AX = &HE00
InregsX.DX = Default.Drive
CALL InterruptX(&H21, InregsX, OutregsX)
Last.Drive = OutregsX.AX AND &HFF

' check new drive
IF New.Drive THEN
   New.Drive = New.Drive - 1
   IF New.Drive >= False AND New.Drive <= Last.Drive THEN
      ' restore default drive
      InregsX.AX = &HE00
      InregsX.DX = New.Drive
      CALL InterruptX(&H21, InregsX, OutregsX)

      ' check windows dos
      IF Windows.Detected THEN
         ' check drive exists
         InregsX.AX = &H7147
         InregsX.DX = New.Drive + 1
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' check drive exists
         InregsX.AX = &H4700
         InregsX.DX = New.Drive + 1
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF
      CALL DisplayError ("Error changing to drive.")
      ' check error flag
      IF (OutregsX.Flags AND &H1) = &H0 THEN
         ' make directory filename
         ASCIZ = "\*.*" + CHR$(0)

         ' find first directory
         InregsX.AX = &H4E00
         InregsX.CX = &H37
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.DX = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
         CALL DisplayError ("Error changing to drive.")
         IF (OutregsX.Flags AND &H1) = &H0 THEN
            Default.Drive = New.Drive
         END IF
      END IF
   END IF
END IF

' display drives
COLOR Yellow, Black
ASCIZ = "\" + CHR$(0)
IF Change.Drive = False THEN
   IF Display.Current THEN
      IF Skip.Drives(Default.Drive + 1) = False THEN
         PRINT CHR$(Default.Drive + 65); ":"
      END IF
   ELSE
      IF Display.Drive1 = False THEN
         IF Skip.Drives(1) = False THEN
            PRINT "A:"
         END IF
      END IF
      IF Display.Drive2 = False THEN
         IF Skip.Drives(2) = False THEN
            PRINT "B:"
         END IF
      END IF
      FOR Drives = 3 TO Last.Drive
         IF Skip.Drives(Drives) = False THEN
            ' check windows dos
            IF Windows.Detected THEN
               ' check drive exists
               InregsX.AX = &H7147
               InregsX.DX = Drives
               InregsX.DS = VARSEG(ASCIZ)
               InregsX.SI = VARPTR(ASCIZ)
               CALL InterruptX(&H21, InregsX, OutregsX)
            ELSE
               ' check drive exists
               InregsX.AX = &H4700
               InregsX.DX = Drives
               InregsX.DS = VARSEG(ASCIZ)
               InregsX.SI = VARPTR(ASCIZ)
               CALL InterruptX(&H21, InregsX, OutregsX)
            END IF
            IF (OutregsX.Flags AND &H1) = &H0 THEN
               PRINT CHR$(Drives + 64) + ":"
            END IF
         END IF
      NEXT
   END IF
END IF

End.Copy:

' restore default drive
InregsX.AX = &HE00
InregsX.DX = Default.Drive
CALL InterruptX(&H21, InregsX, OutregsX)

' display new drive
IF Change.Drive THEN
   COLOR Yellow, Black
   PRINT CHR$(Default.Drive + 65); ":"
END IF

' finish header
IF Continuous.Display = False THEN
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
 ' make header
 COLOR White, Black
 PRINT "Drives v1.0a: Drive display utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Drives [d:][/abcxyz]"
 PRINT "Where:"
 PRINT "   d:  change to drive"
 PRINT "   /a  ignore drive A:"
 PRINT "   /b  ignore drive B:"
 PRINT "   /c  continuous display"
 PRINT "   /x  list only current drive"
 PRINT "   /y  change drive only"
 PRINT "   /z  suppress errors"
 PRINT "   /1:n  skip drive n (n is A to Z)"
 COLOR Plain, Black
 END

Boot.Error:
 COLOR White, Black
 PRINT "Command line error. Type Drives /? for help."
 COLOR Plain, Black
 END

' critical error trap
Error.Routine:
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 57
    Temp.Outpt$ = "Media error."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR Green, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Copy
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
 ' check carry flag error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check display errors flag
    IF Display.Errors = False THEN
       ' display error
       COLOR Red, Black
       PRINT Temp$
    END IF
 END IF
END SUB
