REM file: Newvol.bas - Public Domain DOS Utility
REM Version 1.0a created 02/12/1995

REM Compiling with Microsoft BASIC Professional Development System 7.1:
REM    BC NEWVOL/FS/X/O;
REM    LINK NEWVOL,,,QBX/E;

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'fcb.bi'
REM $INCLUDE: 'dta.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)

' initialize filename buffer
DIM ASCIZ AS STRING * 260, Drive.Search AS STRING * 1

' declare program dta
DIM BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

' declare structures
DIM FCBfile AS FCBtype, DTAfile AS DTAtype

' declare registers
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX
COMMON SHARED Inregs AS RegType, Outregs AS RegType

' declare work variables
COMMON SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
COMMON SHARED Update.Volume AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
COMMON SHARED Command.Work AS STRING

' increase stack size
STACK STACK

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, X$)
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    ParseLine = False
 END IF
END FUNCTION 

' store basic dta
InregsX.AX = &H2F00
CALL InterruptX(&H21, InregsX, OutregsX)
BASIC.DTA.SEG = OutregsX.ES
BASIC.DTA.OFF = OutregsX.BX

' restore directory search dta
InregsX.AX = &H1A00
InregsX.DS = VARSEG(DTAfile)
InregsX.DX = VARPTR(DTAfile)
CALL InterruptX(&H21, InregsX, OutregsX)

' get current drive
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Current.Drive$ = CHR$((OutregsX.AX AND &HFF) + 65)

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' store and parse command line
Command.Line = COMMAND$
IF Command.Line = NUL THEN
   Command.Line = UCASE$(ENVIRON$("NEWVOL"))
END IF

' get switches from command line
Continuous.Display = ParseLine ("/C")
Update.Volume = ParseLine ("/V")
Display.Errors = ParseLine ("/Z")

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Usage
END IF

' recheck command line
IF INSTR(Command.Line, "+") THEN
   GOTO Boot.Usage
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line.Redirect = Command.Line

' make header
IF Continuous.Display = False THEN
   COLOR White, Black
   PRINT "Newvol v1.0a: Volume update utility;"
END IF
   
' search through all input filenames
DO
   ' get standard input
   Redirected.Input = False
   Standard.Input$ = NUL
   Inregs.AX = &HB00
   CALL Interrupt(&H21, Inregs, Outregs)
   DO WHILE (Outregs.AX AND &HFF) = &HFF
      Redirected.Input = True
      Inregs.AX = &H800
      CALL Interrupt(&H21, Inregs, Outregs)
      Char$ = CHR$(Outregs.AX AND &HFF)
      SELECT CASE ASC(Char$)
      CASE 10, 26
      CASE 13
	 EXIT DO
      CASE ELSE
	 Standard.Input$ = Standard.Input$ + Char$
      END SELECT
      Inregs.AX = &HB00
      CALL Interrupt(&H21, Inregs, Outregs)
   LOOP

   ' check standard input
   IF Redirected.Input THEN
      IF Standard.Input$ = NUL THEN
	 EXIT DO
      END IF
   END IF

   ' store entire command
   Command.Work = Command.Line.Redirect

   DO
      ' store entire command
      Imbedded = INSTR(Command.Line, " ")
      IF Imbedded THEN
         Command.Work = Standard.Input$ + LEFT$(Command.Line, Imbedded - 1)
         Command.Line = MID$(Command.Line, Imbedded + 1)
      ELSE
         Command.Work = Standard.Input$ + Command.Line
         Command.Line = NUL
      END IF

      ' store current drive
      IF MID$(Command.Work, 2, 1) = ":" THEN
         Drive.Search = LEFT$(Command.Work, 1)
         Command.Work = MID$(Command.Work, 3)
      ELSE
	 Drive.Search = Current.Drive$
      END IF

      ' change to drive
      InregsX.AX = &HE00
      InregsX.DX = ASC(Drive.Search) - 65
      CALL InterruptX(&H21, InregsX, OutregsX)
   
      ' find volume label
      ASCIZ = "\*.*" + CHR$(0)
      InregsX.AX = &H4E00
      InregsX.CX = &H08
      InregsX.DS = VARSEG(ASCIZ)
      InregsX.DX = VARPTR(ASCIZ)
      CALL InterruptX(&H21, InregsX, OutregsX)

      ' store current volume label
      Volume.Label$ = RTRIM$(DTAfile.ASCIZfilename)
      WHILE RIGHT$(Volume.Label$, 1) = CHR$(0)
	 Volume.Label$ = LEFT$(Volume.Label$, LEN(Volume.Label$) - 1)
	 Volume.Label$ = RTRIM$(Volume.Label$)
      WEND

      ' check update volume variable
      IF Update.Volume = False THEN

	 ' check delete volume label
         IF Command.Work = NUL THEN

	    ' check volume label name
            Imbedded = INSTR(Volume.Label$, ".")
            IF Imbedded THEN
               Volume.Label$ = LEFT$(Volume.Label$, Imbedded - 1) +_
               MID$(Volume.Label$, Imbedded + 1)
	    END IF

	    ' trim volume label
	    Volume.Filename$ = MID$(Volume.Label$, 1, 8)
	    Volume.Extension$ = MID$(Volume.Label$, 9, 3)
	    Volume.Filename$ = RTRIM$(Volume.Filename$)
	    Volume.Extension$ = RTRIM$(Volume.Extension$)

	    ' store volume label
	    FCBfile.ExtendedFCB = CHR$(255)
            FCBfile.FileAttribute = CHR$(&H08)
	    FCBfile.Filename = Volume.Filename$
	    FCBfile.Extension = Volume.Extension$
	    FCBfile.DriveNumber = CHR$(ASC(Drive.Search$) - 64)

	    ' delete volume label
	    InregsX.AX = &H1300
	    InregsX.DS = VARSEG(FCBfile)
	    InregsX.DX = VARPTR(FCBfile)
	    CALL InterruptX(&H21, InregsX, OutregsX)

	    ' check volume flag
	    IF (OutregsX.AX AND &HFF) = &HFF THEN
               IF Display.Errors = False THEN
                  COLOR Red, Black
                  PRINT "Error deleting volume."
	       END IF
	    ELSE
	       ' display search filename
               COLOR Yellow, Black
               IF Continuous.Display = False THEN
		  PRINT "Deleting: ";
	       END IF
	       PRINT Volume.Label$
	    END IF
	 ELSE

	    ' check volume label name
            Imbedded = INSTR(Volume.Label$, ".")
            IF Imbedded THEN
               Volume.Label$ = LEFT$(Volume.Label$, Imbedded - 1) +_
               MID$(Volume.Label$, Imbedded + 1)
	    END IF

	    ' trim volume label
	    Volume.Filename$ = MID$(Volume.Label$, 1, 8)
	    Volume.Extension$ = MID$(Volume.Label$, 9, 3)
	    Volume.Filename$ = RTRIM$(Volume.Filename$)
	    Volume.Extension$ = RTRIM$(Volume.Extension$)

	    ' store volume label
	    FCBfile.ExtendedFCB = CHR$(255)
            FCBfile.FileAttribute = CHR$(&H08)
	    FCBfile.Filename = Volume.Filename$
	    FCBfile.Extension = Volume.Extension$
	    FCBfile.DriveNumber = CHR$(ASC(Drive.Search$) - 64)

	    ' delete volume label
	    InregsX.AX = &H1300
	    InregsX.DS = VARSEG(FCBfile)
	    InregsX.DX = VARPTR(FCBfile)
	    CALL InterruptX(&H21, InregsX, OutregsX)

	    ' store new volume label
            Volume.Label$ = Command.Work

	    ' check volume label name
            Imbedded = INSTR(Volume.Label$, ".")
            IF Imbedded THEN
               Volume.Label$ = LEFT$(Volume.Label$, Imbedded - 1) +_
               MID$(Volume.Label$, Imbedded + 1)
	    END IF

	    ' trim volume label
	    Volume.Filename$ = MID$(Volume.Label$, 1, 8)
	    Volume.Extension$ = MID$(Volume.Label$, 9, 3)
	    Volume.Filename$ = RTRIM$(Volume.Filename$)
	    Volume.Extension$ = RTRIM$(Volume.Extension$)

	    ' store volume label
	    FCBfile.ExtendedFCB = CHR$(255)
            FCBfile.FileAttribute = CHR$(&H08)
	    FCBfile.Filename = Volume.Filename$
	    FCBfile.Extension = Volume.Extension$
	    FCBfile.DriveNumber = CHR$(ASC(Drive.Search$) - 64)

	    ' store volume label
	    Volume.Filename$ = Volume.Filename$ + SPACE$(8 - LEN(Volume.Filename$))
	    Volume.Extension$ = Volume.Extension$ + SPACE$(3 - LEN(Volume.Extension$))
	    Volume.Label$ = Volume.Filename$ + Volume.Extension$

	    ' create volume label
	    InregsX.AX = &H1600
	    InregsX.DS = VARSEG(FCBfile)
	    InregsX.DX = VARPTR(FCBfile)
	    CALL InterruptX(&H21, InregsX, OutregsX)

	    ' check volume flag
	    IF (OutregsX.AX AND &HFF) = &HFF THEN
               IF Display.Errors = False THEN
                  COLOR Red, Black
		  PRINT "Error creating volume."
	       END IF
	    ELSE
	       ' display search filename
               COLOR Yellow, Black
               IF Continuous.Display = False THEN
		  PRINT "Creating: ";
	       END IF
	       PRINT Volume.Label$
	    END IF
	 END IF
      END IF

      ' check search filename
      IF Command.Line = NUL THEN
	 EXIT DO
      END IF
   LOOP

   ' check search filename
   IF Standard.Input$ = NUL THEN
      EXIT DO
   END IF
LOOP

End.Copy:

' restore basic dta
InregsX.AX = &H1A00
InregsX.DS = BASIC.DTA.SEG
InregsX.DX = BASIC.DTA.OFF
CALL InterruptX(&H21, InregsX, OutregsX)

' restore current drive
InregsX.AX = &HE00
InregsX.DX = ASC(Current.Drive$) - 65
CALL InterruptX(&H21, InregsX, OutregsX)

' display end program
IF Continuous.Display = False THEN
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
 ' make header
 COLOR White, Black
 PRINT "Newvol v1.0a: Volume update utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Newvol [d:][volumename][/cvz]"
 PRINT "Where:"
 PRINT "   /c  continuous display"
 PRINT "   /v  leave volume label unchanged"
 PRINT "   /z  suppress errors"
 COLOR Plain, Black
 END

Boot.Error:
 COLOR White, Black
 PRINT "Command line error. Type Newvol /? for help."
 COLOR Plain, Black
 END

' critical error trap
Error.Routine:
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR White, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Copy
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB
