REM file: Typey.bas - Public Domain DOS Utility
REM Version 1.0a created 06/13/1995

REM Compiling with Microsoft BASIC Professional Development System 7.1:
REM    BC TYPEY/FS/X/O;
REM    LINK TYPEY,,,QBX/E;

' declare subroutines
DECLARE SUB Directories (D$, f$)
DECLARE SUB Filenames (D$, f$)
DECLARE SUB DisplayFiles (D$, f$)

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'wdta.bi'
REM $INCLUDE: 'format.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)

' initialize filename buffer
DIM ASCIZ AS STRING * 260
COMMON SHARED Buffer AS STRING * 1024

' initialize drive variables
COMMON SHARED Drive.Number AS INTEGER, Current.Drive AS INTEGER

' initialize directory variables
COMMON SHARED Current.Directory AS STRING * 260, Denied AS INTEGER

' declare program dta
DIM BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

' declare registers
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX
COMMON SHARED Inregs AS RegType, Outregs AS RegType

' declare work variables
COMMON SHARED Continuous.Display AS INTEGER, Prompt.More AS INTEGER
COMMON SHARED Lines.Counted AS INTEGER, More.Display AS INTEGER
COMMON SHARED Quit.Searching AS INTEGER, Windows.Detected AS INTEGER

' declare search work variables
COMMON SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
COMMON SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE

' declare recurse work variables
COMMON SHARED Recurse.Directories AS INTEGER

' declare windows dta types
COMMON SHARED FDTAfile AS WDTAtype, WDTAfile AS WDTAtype

' declare display work variables
COMMON SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
COMMON SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
COMMON SHARED No.Display.Hidden AS INTEGER, No.Display.System AS INTEGER
COMMON SHARED No.Display.Readonly AS INTEGER, No.Display.Archive AS INTEGER
COMMON SHARED No.Display.Any AS INTEGER, Display.Any AS INTEGER
COMMON SHARED Display.Errors AS INTEGER, Display.File AS INTEGER

' declare file date and time work variables
COMMON SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
COMMON SHARED Command.Work AS STRING

' increase stack size
STACK STACK

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, LCASE$(X$))
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
       ParseLine = True
    ELSE
       ParseLine = False
    END IF
 END IF
END FUNCTION 

' check windows dos
InregsX.AX = &H160A
CALL InterruptX(&H2F, InregsX, OutregsX)
IF OutregsX.AX = False THEN
   Temp = (OutregsX.BX And &HFF00) / 256
   IF Temp >= 4 THEN
      Windows.Detected = True
   END IF
Endif

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' read command line from PSP
Command.line = NUL
InregsX.AX = &H6200
CALL InterruptX(&H21, InregsX, OutregsX)
PSPsegment = OutregsX.BX
PSPoffset = 128
DEF SEG = PSPsegment
FOR Count = 1 TO 127
   Command.Char = PEEK(PSPoffset + Count)
   SELECT CASE Command.Char
   CASE 0, 10, 13
      EXIT FOR
   CASE ELSE
      Command.line = Command.line + CHR$(Command.Char)
   END SELECT
NEXT
DEF SEG
IF Command.Line = NUL THEN
   Command.Line = UCASE$(ENVIRON$("TYPEA"))
END IF

' get switches from command line
Display.Archive = ParseLine ("/A")
Display.Hidden = ParseLine ("/H")
Display.Readonly = ParseLine ("/O")
Display.System = ParseLine ("/S")
Display.Any = ParseLine ("/X")
No.Display.Archive = ParseLine ("+A")
No.Display.Hidden = ParseLine ("+H")
No.Display.Readonly = ParseLine ("+O")
No.Display.System= ParseLine ("+S")
No.Display.Any = ParseLine ("+X")
Continuous.Display = ParseLine ("/C")
Prompt.More = ParseLine ("/P")
Recurse.Directories = ParseLine ("/R")
Display.Errors = ParseLine ("/Z")

' get date/time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
   D$ = MID$(Command.Line, Imbedded + 2, 21)
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
   IF LEN(D$) <> 21 THEN
      GOTO Boot.Error
   END IF
   IF MID$(D$, 11, 1) <> "-" THEN
      GOTO Boot.Error
   END IF
   S$ = LEFT$(D$, 10)
   D1! = INT(VAL(MID$(S$, 1, 2)))
   D2! = INT(VAL(MID$(S$, 4, 2)))
   D3! = INT(VAL(MID$(S$, 7, 4)))
   Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   S$ = RIGHT$(D$, 10)
   D1! = INT(VAL(MID$(S$, 1, 2)))
   D2! = INT(VAL(MID$(S$, 4, 2)))
   D3! = INT(VAL(MID$(S$, 7, 4)))
   Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   IF Search.From.Date < False OR Search.To.Date < False THEN
      GOTO Boot.Error
   END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
   T$ = MID$(Command.Line, Imbedded + 2, 17)
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
   IF LEN(T$) <> 17 THEN
      GOTO Boot.Error
   END IF
   IF MID$(T$, 9, 1) <> "-" THEN
      GOTO Boot.Error
   END IF
   S$ = LEFT$(T$, 8)
   T1! = INT(VAL(MID$(S$, 1, 2)))
   T2! = INT(VAL(MID$(S$, 4, 2)))
   T3! = INT(VAL(MID$(S$, 7, 2)))
   Search.From.Time = T1! * 2048 + T2! * 32 + INT(T3! / 2)
   S$ = RIGHT$(T$, 8)
   T1! = INT(VAL(MID$(S$, 1, 2)))
   T2! = INT(VAL(MID$(S$, 4, 2)))
   T3! = INT(VAL(MID$(S$, 7, 2)))
   Search.To.Time = T1! * 2048 + T2! * 32 + INT(T3! / 2)
   IF Search.From.Time < False OR Search.To.Time < False THEN
      GOTO Boot.Error
   END IF
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Usage
END IF

' recheck command line
IF INSTR(Command.Line, "+") THEN
   GOTO Boot.Usage
END IF

' initialize work variables
Lines.Counted = False
More.Display = False
Quit.Searching = False

' store basic dta
InregsX.AX = &H2F00
CALL InterruptX(&H21, InregsX, OutregsX)
BASIC.DTA.SEG = OutregsX.ES
BASIC.DTA.OFF = OutregsX.BX

' get current drive
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Current.Drive = (OutregsX.AX AND &HFF) + 65

' check windows dos
IF Windows.Detected THEN
   ' get current directory
   InregsX.AX = &H7147
   InregsX.DX = Current.Drive - 64
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.SI = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' get current directory
   InregsX.AX = &H4700
   InregsX.DX = Current.Drive - 64
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.SI = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' display any errors
CALL DisplayError ("Error accessing drive.")

' check findirst error
IF (OutregsX.Flags AND &H1) = &H1 THEN
   GOTO End.Copy
END IF

' store directory
IF LEN(Current.Directory) = False THEN
   Current.Directory = "\"
END IF
IF LEFT$(Current.Directory, 1) <> "\" THEN
   Current.Directory = "\" + Current.Directory
END IF
Current.Directory = Current.Directory + CHR$(0)

' Store video page
Inregs.AX = &HF00
CALL Interrupt(&H10, Inregs, Outregs)
Video.Page = Outregs.BX

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line.Redirect = Command.Line

' make header
IF Continuous.Display = False THEN
   COLOR White, Black
   PRINT "Typey v1.0a: File content display utility; "
END IF
   
' search through all input filenames
DO
   ' get standard input
   Redirected.Input = False
   Standard.Input$ = NUL
   InregsX.AX = &HB00
   CALL InterruptX(&H21, InregsX, OutregsX)
   DO WHILE (OutregsX.AX AND &HFF) = &HFF
      Redirected.Input = True
      InregsX.AX = &H800
      CALL InterruptX(&H21, InregsX, OutregsX)
      Char$ = CHR$(OutregsX.AX AND &HFF)
      SELECT CASE ASC(Char$)
      CASE 10, 26
      CASE 13
	 EXIT DO
      CASE ELSE
	 Standard.Input$ = Standard.Input$ + Char$
      END SELECT
      InregsX.AX = &HB00
      CALL InterruptX(&H21, InregsX, OutregsX)
   LOOP

   ' check standard input
   IF Redirected.Input THEN
      IF Standard.Input$ = NUL THEN
	 EXIT DO
      END IF
   END IF

   ' store entire command
   Command.Work = Command.Line.Redirect

   ' filename processing loop
   DO

      ' store redirected input
      Standard.Input$ = RTRIM$(Standard.Input$)
      Standard.Input$ = LTRIM$(Standard.Input$)
      IF LEFT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = MID$(Standard.Input$, 2)
      END IF
      IF RIGHT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = LEFT$(Standard.Input$, LEN(Standard.Input$) - 1)
      END IF

      ' store entire command
      IF LEFT$(Command.Line, 1) = CHR$(34) THEN
         Imbedded = INSTR(2, Command.Line, CHR$(34))
         IF Imbedded THEN
            Command.Work = Standard.Input$ + MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      ELSE
         Imbedded = INSTR(Command.Line, " ")
         IF Imbedded THEN
            Command.Work = Standard.Input$ + LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      END IF
      Command.Line = LTRIM$(Command.Line)
      Command.Line = RTRIM$(Command.Line)

      ' store current drive
      IF MID$(Command.Work, 2, 1) = ":" THEN
         Search.Drive = ASC(UCASE$(LEFT$(Command.Work, 1)))
         Command.Work = MID$(Command.Work, 3)
      ELSE
	 Search.Drive = Current.Drive
      END IF
      Drive.Number = Search.Drive - 64

      ' check windows dos
      IF Windows.Detected THEN
         ' get current directory
         InregsX.AX = &H7147
         InregsX.DX = Drive.Number
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' get current directory
         InregsX.AX = &H4700
         InregsX.DX = Drive.Number
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF

      ' display any errors
      CALL DisplayError ("Error accessing drive.")

      ' check findirst error
      IF (OutregsX.Flags AND &H1) = &H0 THEN

         ' store current directory
         Directory.Search$ = LEFT$(ASCIZ, INSTR(ASCIZ, CHR$(0)) - 1)
         IF LEFT$(Directory.Search$, 1) <> "\" THEN
            Directory.Search$ = "\" + Directory.Search$
         END IF
         Imbedded1 = INSTR(Command.Work, "\")
         Imbedded2 = Imbedded1
         WHILE Imbedded1
            Imbedded2 = Imbedded1
            Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
         WEND
         IF Imbedded2 THEN
            Directory.Search$ = LEFT$(Command.Work, Imbedded2)
            Command.Work = MID$(Command.Work, Imbedded2 + 1)
         END IF
         IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Directory.Search$ = Directory.Search$ + "\"
         END IF
   
         ' get filename spec
         Filename.Search$ = Command.Work
         IF Filename.Search$ = NUL THEN
            Filename.Search$ = "*.*"
         END IF
         Command.Work = NUL
   
         ' change to drive
         InregsX.AX = &HE00
         InregsX.DX = Drive.Number - 1
         CALL InterruptX(&H21, InregsX, OutregsX)
   
         ' display search filename
         IF Continuous.Display = False THEN
            COLOR Yellow, Black
            PRINT "Searching: " + Directory.Search$ + Filename.Search$
         END IF

         ' call routine to search for files
         CALL Directories(Directory.Search$, Filename.Search$)
      END IF

      ' check search filename
      IF Command.Line = NUL THEN
	 EXIT DO
      END IF
   LOOP

   ' check for more filenames
   IF Standard.Input$ = NUL THEN
      EXIT DO
   END IF
LOOP
End.Copy:
' restore basic dta
InregsX.AX = &H1A00
InregsX.DS = BASIC.DTA.SEG
InregsX.DX = BASIC.DTA.OFF
CALL InterruptX(&H21, InregsX, OutregsX)

' restore current drive
InregsX.AX = &HE00
InregsX.DX = Current.Drive - 65
CALL InterruptX(&H21, InregsX, OutregsX)

' check windows dos
IF Windows.Detected THEN
   ' restore current directory
   InregsX.AX = &H713B
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.DX = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' restore current directory
   InregsX.AX = &H3B00
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.DX = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' display end program
IF Continuous.Display = False THEN
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
 ' make header
 COLOR White, Black
 PRINT "Typey v1.0a: File display utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Typey [d:\path\filename.ext][+/ahosx][/cdprtz]"
 PRINT "Where:"
 PRINT "   /c  continuous display"
 PRINT "   /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
 PRINT "   /p  prompt for more"
 PRINT "   /r  recurse directories"
 PRINT "   /t  is range of file times in form hh:mm:ss-hh:mm:ss"
 PRINT "   /z  supress error messages"
 PRINT "   type files with attributes"
 PRINT "     + prefix to not type files with,"
 PRINT "     / prefix to type files only with,"
 PRINT "       a  archive, h  hidden, o  read-only, s  system, x  none"
 COLOR Plain, Black
 END

Boot.Error:
 COLOR White, Black
 PRINT "Command line error. Type Typey /? for help."
 COLOR Plain, Black
 END

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Attribute AS INTEGER
 DIM DTAfile AS DTAtype
 DIM ASCIZ AS STRING * 260
 DIM Wfile.Handle AS INTEGER

 ' make directory filename
 ASCIZ = Directory.Search$ + "*.*" + CHR$(0)
 GOSUB Restore.DTA1

 ' check windows dos
 IF Windows.Detected THEN
    ' find first long filename
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.Ds = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    ' find first directory
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' check findirst error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    EXIT SUB
 END IF

 ' search directory names
 CALL Filenames(Directory.Search$, Filename.Search$)
 GOSUB Restore.DTA1

 ' check to recurse directories
 IF Recurse.Directories THEN

    ' recurse directories
    DO
       ' check to quit searching
       IF Quit.Searching THEN
          EXIT DO
       END IF

       ' check directory attribute
       IF Windows.Detected THEN
          Attribute = ASC(WDTAfile.FileAttr)
       ELSE
          Attribute = ASC(DTAfile.FileAttr)
       END IF
       IF (Attribute AND &H10) = &H10 THEN

          ' store directory name
          IF Windows.Detected THEN
             Directory$ = WDTAfile.ASCIZfull
          ELSE
             Directory$ = DTAfile.ASCIZfilename
          END IF
          Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

          ' check directory name
          IF Directory$ <> "." AND Directory$ <> ".." THEN

             ' make next search directory
             Next.Directory$ = Directory.Search$ + Directory$ + "\"

             ' recursively search subdirectories
             CALL Directories(Next.Directory$, Filename.Search$)
             GOSUB Restore.DTA1
          END IF
       END IF

       ' check windows dos
       IF Windows.Detected THEN
          ' find next long filename
          InregsX.AX = &H714F
          InregsX.BX = Wfile.Handle
          InregsX.SI = &H1
          InregsX.ES = VARSEG(WDTAfile)
          InregsX.DI = VARPTR(WDTAfile)
          CALL InterruptX(&H21, InregsX, OutregsX)
       ELSE
          ' find next directory
          InregsX.AX = &H4F00
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF

       ' check findnext error
       IF (OutregsX.Flags AND &H1) = &H1 THEN
          EXIT DO
       END IF
    LOOP
 END IF
 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 EXIT SUB

Restore.DTA1:
 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
END SUB

' subroutine to display a file
SUB DisplayFiles (Directory$, Filename$)
 ' declare subroutine variables
 DIM ASCIZ AS STRING * 260
 DIM Attribute AS INTEGER
 DIM Handle AS INTEGER

 ' make filename
 ASCIZ = Directory$ + Filename$ + CHR$(0)

 ' check windows dos
 IF Windows.Detected THEN
    ' get file attributes
    InregsX.AX = &H7143
    InregsX.BX = &H0
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' get file attributes
    InregsX.AX = &H4300
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' display any errors
 CALL DisplayError ("Error reading file attributes.")

 ' check findirst error
 IF (OutregsX.Flags AND &H1) = &H0 THEN

    ' store file attribute
    Attribute = OutregsX.CX

    ' check file attribute
    Display.File = True

    ' check for no attributes
    IF Display.Any THEN
       IF (Attribute AND 1) = 1 THEN
          Display.File = False
       END IF
       IF (Attribute AND 2) = 2 THEN
          Display.File = False
       END IF
       IF (Attribute AND 4) = 4 THEN
          Display.File = False
       END IF
       IF (Attribute AND &H20) = &H20 THEN
          Display.File = False
       END IF
    END IF

    ' check for read-only file
    IF Display.Readonly THEN
       IF (Attribute AND 1) <> 1 THEN
          Display.File = False
       END IF
    END IF

    ' check for hidden file
    IF Display.Hidden THEN
       IF (Attribute AND 2) <> 2 THEN
          Display.File = False
       END IF
    END IF

    ' check for system file
    IF Display.System THEN
       IF (Attribute AND 4) <> 4 THEN
          Display.File = False
       END IF
    END IF

    ' check for archive file
    IF Display.Archive THEN
       IF (Attribute AND &H20) <> &H20 THEN
          Display.File = False
       END IF
    END IF

    ' check for no attributes
    IF No.Display.Any THEN
       IF (Attribute AND 1) = False THEN
          IF (Attribute AND 2) = False THEN
             IF (Attribute AND 4) = False THEN
                IF (Attribute AND &H20) = False THEN
                   Display.File = False
                END IF
             END IF
          END IF
       END IF
    END IF

    ' check for read-only file
    IF No.Display.Readonly THEN
       IF (Attribute AND 1) = 1 THEN
          Display.File = False
       END IF
    END IF

    ' check for hidden file
    IF No.Display.Hidden THEN
       IF (Attribute AND 2) = 2 THEN
          Display.File = False
       END IF
    END IF

    ' check for system file
    IF No.Display.System THEN
       IF (Attribute AND 4) = 4 THEN
          Display.File = False
       END IF
    END IF

    ' check for archive file
    IF No.Display.Archive THEN
       IF (Attribute AND &H20) = &H20 THEN
          Display.File = False
       END IF
    END IF

    ' verify display file
    IF Display.File = False THEN
       EXIT SUB
    END IF

    ' check windows dos
    Denied = False
    IF Windows.Detected THEN
       ' open file for input
       InregsX.AX = &H716C
       InregsX.BX = &H0044
       InregsX.CX = &H27
       InregsX.DX = &H01
       InregsX.DS = VARSEG(ASCIZ)
       InregsX.SI = VARPTR(ASCIZ)
       InregsX.DI = &H1
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' open file for input
       InregsX.AX = &H6C00
       InregsX.BX = &H0044
       InregsX.CX = &H27
       InregsX.DX = &H01
       InregsX.DS = VARSEG(ASCIZ)
       InregsX.SI = VARPTR(ASCIZ)
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF

    ' display any errors
    CALL DisplayError ("Error opening filename.")

    ' check findirst error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT SUB
    END IF

    ' check share flag
    IF Denied THEN
       EXIT SUB
    END IF

    ' store file handle
    Handle = OutregsX.AX

    ' get date/time
    InregsX.AX = &H5700
    InregsX.BX = Handle
    CALL InterruptX(&H21, InregsX, OutregsX)

    ' display any errors
    CALL DisplayError ("Error reading filename time.")

    ' check findirst error
    IF (OutregsX.Flags AND &H1) = &H0 THEN

       ' store date/time
       IF OutregsX.CX < False THEN
          File.Work.Time = CSNG(OutregsX.CX + 65536)
       ELSE
          File.Work.Time = CSNG(OutregsX.CX)
       END IF
       IF OutregsX.DX < False THEN
          File.Work.Date = CSNG(OutregsX.DX + 65536)
       ELSE
          File.Work.Date = CSNG(OutregsX.DX)
       END IF

       ' check date/time range
       IF Search.From.Date OR Search.To.Date THEN
          IF File.Work.Date < Search.From.Date THEN
             GOTO Close.File
          END IF
          IF File.Work.Date > Search.To.Date THEN
             GOTO Close.File
          END IF
       END IF
       IF Search.From.Time OR Search.To.Time THEN
          IF File.Work.Time < Search.From.Time THEN
             GOTO Close.File
          END IF
          IF File.Work.Time > Search.To.Time THEN
             GOTO Close.File
          END IF
       END IF

       ' read file in buffer loops
       COLOR Plain, Black
       DO
          InregsX.AX = &H3F00
          InregsX.BX = Handle
          InregsX.CX = &H0400
          InregsX.DS = VARSEG(Buffer)
          InregsX.DX = VARPTR(Buffer)
          CALL InterruptX(&H21, InregsX, OutregsX)

          ' display any errors
          CALL DisplayError ("Error reading file.")

          ' check error flag
          IF (OutregsX.Flags AND &H1) = &H1 THEN
             EXIT DO
          END IF

          ' check number of bytes to display
          Number.Bytes = OutregsX.AX
          IF Number.Bytes = False THEN
             EXIT DO
          END IF

          ' display buffer
          GOSUB Print.Buffer

          ' check quit flag
          IF Quit.Searching THEN
             EXIT DO
          END IF

          ' check dos windows
          IF Windows.Detected THEN
             ' release time slice
             InregsX.AX = &H1680
             InregsX.BX = &H0000
             CALL InterruptX(&H2F, InregsX, OutregsX)
          END IF
       LOOP
       GOTO Close.File
    END IF
 END IF
 EXIT SUB

 ' close file
Close.File:
 InregsX.AX = &H3E00
 InregsX.BX = Handle
 CALL InterruptX(&H21, InregsX, OutregsX)
 EXIT SUB

Print.Buffer:
 FOR Length = 1 TO Number.Bytes
    Char = ASC(MID$(Buffer, Length, 1))
    SELECT CASE Char
    CASE 0, 13, 26
    CASE 10
       PRINT
       IF Prompt.More THEN
          Lines.Counted = Lines.Counted + 1
          IF Lines.Counted >= 23 THEN
             Lines.Counted = False
             IF More.Display = False THEN
                Prompt$ = "More(y/n/c)?"
                CALL MorePrompt(Prompt$, "ync", Outpt$)
                SELECT CASE Outpt$
                CASE "c"
                   More.Display = True
                CASE "n"
                   Quit.Searching = True
                   EXIT FOR
                END SELECT
	     END IF
	  END IF
       END IF
    CASE ELSE
       COLOR Plain, Black
       PRINT CHR$(Char);
    END SELECT
 NEXT
 RETURN
END SUB

' subroutine to display filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Attribute AS INTEGER
 DIM DTAfile AS DTAtype
 DIM ASCIZ AS STRING * 260
 DIM Wfile.Handle AS INTEGER

 ' make filename
 ASCIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

 ' restore dta
 GOSUB Restore.DTA2

 ' check windows dos
 IF Windows.Detected THEN
    ' find first long filename
    InregsX.AX = &H714E
    InregsX.CX = &H27
    InregsX.SI = &H1
    InregsX.Ds = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    InregsX.ES = VARSEG(FDTAfile)
    InregsX.DI = VARPTR(FDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    ' find first filename
    InregsX.AX = &H4E00
    InregsX.CX = &H27
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 DO
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF

    ' store filename
    IF Windows.Detected THEN
       Filename$ = FDTAfile.ASCIZfull
    ELSE
       Filename$ = DTAfile.ASCIZfilename
    END IF
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

    ' check filename
    IF Filename$ <> "." AND Filename$ <> ".." THEN
       ' display file
       CALL DisplayFiles(Directory.Search$, Filename$)
       GOSUB Restore.DTA2
    END IF

    ' check quit searching
    IF Quit.Searching THEN
       EXIT DO
    END IF

    ' check windows dos
    IF Windows.Detected THEN
       ' find next long filename
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(FDTAfile)
       InregsX.DI = VARPTR(FDTAfile)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next filename
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF
 LOOP
 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 EXIT SUB

Restore.DTA2:
 ' restore filename search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
END SUB

' critical error trap
Error.Routine:
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Denied = True
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR Green, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Copy
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
 ' check carry flag error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check display errors flag
    IF Display.Errors = False THEN
       ' display error
       COLOR Red, Black
       PRINT Temp$
    END IF
 END IF
END SUB
