{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Advanced/Intercpt.pas            [x] Protected mode

  How to intercept instances with the tInterceptor class.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }



uses EFKERNEL;

type pSomeClass = ^tSomeClass;
     tSomeClass = object (tObject)
       destructor Intercept; virtual;
       { ... }
     end;


destructor tSomeClass.Intercept;
begin
     WriteLn ('tSomeClass was successfully intercepted.');
     Inherited Intercept;
end;


var MyThing : pSomeClass;

begin
     { Initialize an arbitrary EFLIB object. }
     New (MyThing, Initialize);

     { Leave the interception to the interceptor. It automatically
       calls MyThing^.Free and releases all memory for the instance
       upon program termination. }
     Interceptor^.Register (MyThing);
end.