{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Array3.pas        [x] Protected mode

  Demonstration of the array ADT and some advanced mechanisms
  in EFLIB arrays.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFADT, EFARRAY;


const NumberOfElements = 80 * 2;

var MyArray : tArray;
    Element : word; Index : word;
    MemoryCheck : longint;


{ Display a fragmentation report. }
procedure Display (What : pLinearADT);
var Index : word;
begin
     for Index := 1 to What^.Capacity do
         if What^.IsUsed (Index)
            then Write ('x') else Write ('o');
     WriteLn;
end;

{ Main program }

begin
     MemoryCheck := MemAvail;

     WriteLn;
     WriteLn ('Demonstration of common features in array ADT''s. EFLIB');
     WriteLn ('arrays are more than ordinary Pascal arrays:');
     WriteLn;


     with MyArray do begin

          Initialize (NumberOfElements, SizeOf(Element));

          { Fill 25% of the array with some
            random elements. }

          for Index := 1 to NumberOfElements div 4 do begin

              Element := Random (System.High(Word));
              Update (Element, Random (NumberOfElements) + 1);

          end;

          WriteLn ('(i) Random fragmentation:');
          Display (@MyArray);

          { Move elements to the right and erase
            elements that are overwritten. }
          Move (1, Capacity div 2, Capacity div 4);

          WriteLn ('(ii) Moved elements to the right:');
          Display (@MyArray);

          { Defragment elements (move all used slots to
            the front). }

          Defragment;

          WriteLn ('(iii) Defragmented array:');
          Display (@MyArray);

          Intercept;

     end;

     if MemAvail <> MemoryCheck
        then WriteLn ('Fatal memory error.');
end.