{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Varray1.pas       [x] Protected mode

  Demonstration of the virtual array ADT, ie. an array that automatically
  adjusts it size to the number of elements that it currently stores. That
  is, the virtual array grows and shrink on demand.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFARRAY, EFTEST;


const GrowthOfElements = 20;
      NumberOfElements = 10;

var MyList : tVirtualArray;
    Word1, Word2 : word;
    Timer : tTimer;


begin
     MemPush; { EFTEST }
     Randomize; Timer.Initialize;

     WriteLn ('* Virtual array with dynamic growth *');

     { Contsruct a virtual array with 10 elements }

     with MyList do begin

          { Initialize a virtual array with a specified growth factor. The
            growth factor specify the number of elements to grow each time
            the array is full (the higher value, the faster speed but more
            unused elements). }

          Initialize ( GrowthOfElements, GrowthOfElements, SizeOf(Word1) );
                       { Initial size }  { Growth ratio }  { Element size }


          { Sequential writing to array (write numbers 1 ... n in reversed
            order) }

          for Word2 := 1 to GrowthOfElements * 10 do
              Store (Word2);

          { Reverse element order (swap first and last element and decrement
            interval until all elements have been swapped) }
          for Word2 := 1 to Elements div 2 do
              Swap (Word2, Succ (Elements - Word2));

          { Display entries }
          for Word2 := Elements downto 1 do
              Write (Word(Get(Word2)^.Data(0)^):8); { Advanced element access }

          WriteLn;
          WriteLn ('Used ', Elements, ' elements of an array with capacity for ', Capacity, ' elements.');

          Intercept;

     end;

     with Timer do begin WriteLn (StringMS); Intercept; end;
     MemPop; { EFTEST }
end.