{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Linkage2.pas   [x] Protected mode

  Some ADT's use a special packaging for their elements, for example
  lists and trees. These ADT require links between their elements,
  these links are implemented in the packaging - the container
  class. This is a demonstration of tLinkage, the packaging of
  linked lists, that is, descendants of tList.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFLIST;


var Node1, Node2 : pLinkage;


begin
     WriteLn ('tLinkage - an introduction.');

     New (Node1, Initialize (NIL, NIL));
     New (Node2, Initialize (NIL, NIL));

     { Attach Node2 after Node1 }
     Node1^.AttachAfter (Node2);

     if pLinkage(Node1^.Last) = Node2
        then WriteLn ('Node1 forms a chain: the last element is Node2.');

     if pLinkage(Node2^.First) = Node1
        then WriteLn ('Node2 forms a chain: the first element is Node1. It''s the same chain.');

     { Release memory for Node1 and all successors, that is, also Node2. }
     Node1^.FreeAll;
end.