{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Olist3.pas        [x] Protected mode

  Example of tOrderList - the ordered list. An ordered list
  maintains its element in sorted order. This program reads
  data from a text file and inserts each line of text in
  a tOrderedList ADT - in sorted order.

  Make sure you are in the right directory before running
  this program. It require the file '..\cluster.dat' to run.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFBASIC, EFADT, EFLIST;


const Filename = '..\clusters.dat'; { Some text file! }

var List : tOrderedList; Timer : tTimer;
    TextFile : text; SomeData : string; Index : word;


procedure AddInOrder;
begin
     System.Assign (TextFile, Filename); Reset (TextFile);

     while not EOF (TextFile) do begin
           ReadLn (TextFile, SomeData);
           List.Store (SomeData[0]);
     end;
     System.Close (TextFile);
end;


begin
     WriteLn ('Testing text file sorting - please wait ...');

     with List do begin

          { Initialize a list based on text strings }
          Initialize (SizeOf(SomeData));

          { Since the first character in strings stores
            the length, we must install a bounded compare
            plug that ignores that character. (We could of
            course just use tTextElement elements, but we
            want to show the technique). }

          AssignKeyPlug ( New (pBoundedKeyPlug, Initialize (@List, 1, 255)) );
          { Existing plug is automatically intercepted. }

          Timer.Initialize;

          { Binary search method }
          AddInOrder;
          WriteLn ('Insertion with binary search : ', Timer.StringMS);

          if not IsIntact
             then WriteLn ('Fatal error. Sorting failed!');

          Clear; { Clear all elements }

          Timer.Reset;

          { Linear search method }
          SetSearchMethod (LinearSearchMethod);
          AddInOrder;
          WriteLn ('Insertion with linear search : ', Timer.StringMS);

          if not IsIntact
             then WriteLn ('Fatal error. Sorting failed!');

          WriteLn;
          WriteLn ('Conclusion: the default search method is prefarable.');


          Intercept; Timer.Intercept;
     end;
end.