{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Extend/Dataext1.pas              [x] Protected mode

  A very simple demonstration of class customizations in EFLIB. This
  example extends tList class into a somewhat customized string list.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST;


type tMyList = object (tList)
       constructor Initialize;
       procedure StoreText (Text : string);
       procedure DoMyTask;
     end;


constructor tMyList.Initialize;
begin
     { Initiailize doubly linked list based on text strings }
     Inherited Initialize (SizeOf(String));
end;

procedure tMyList.StoreText (Text : string);
begin
     Store (Text); { Add string }
end;

{ Do some task to perform }
procedure tMyList.DoMyTask;
var Index : word;
begin
     if IsEmpty then WriteLn ('I am empty.') else WriteLn ('I contain something:');
     for Index := 1 to Elements do
         Write (String(Get(Index)^.Data(0)^), ' ');
     WriteLn;
end;


var MyList : tMyList;

begin
     with MyList do begin

          Initialize;

          StoreText ('The object oriented approach');
          StoreText ('to data structures will make');
          StoreText ('life easier.');

          DoMyTask;
          Intercept;

     end;
end.