{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Misc/Arguments.pas               [x] Protected mode

  This program demonstrates how you can parse the arguments that
  were passed to the program on the command-line. It's done with
  the CommandLineParserObjectType object in EFLIBINI.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFBASIC, EFINI;


var MyCommandLine : tCommandLine;
    Index : word;

begin
     with MyCommandLine do begin

          Initialize;

          WriteLn;
          WriteLn ('* Let''s demonstrate command-line argument parsing! *');
          WriteLn;

          { Fake some command-line parameters. This line must be removed
            if you want to pass some real program parameters on the command-
            line. }
          Update ('FILE1.TXT FILE2.TXT /Copy /Encode /Remove /Clear /Wipe /?');

          { IsOption makes it easy to controll the options that the
            user passed to the program in the command-line. }
          if IsOption('?') then WriteLn ('You wanted help!');
          if IsOption('Copy') then WriteLn ('You specified that you wanted a copy.');

          { Use TokenIndex instead of IsOption if your argument is case
            sensitive. }
          if TokenIndex('/Remove') <> 0 then WriteLn ('You specified "/Remove" extactly.');
          if IsOption ('Remove') then WriteLn ('You specified "/REMOVE" in some way.');

          { You can access all the arguments, one-by-one. }
          for Index := 1 to Tokens do
              Write (Token(Index), ' * ');

          WriteLn; WriteLn;
          WriteLn ('Does something with ', Token(1),
                   ' and stores the result in ', Token(2), ' ?');

          Intercept; { Destructs and disposes allocated information }

     end; { MyCommandLineParser }

end.