{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Chained1.pas             [x] Protected mode

  Chanined tString instances. This is an example that demonstrates
  the built-in chain technique in tString. tStrings are more than
  simple text strings - they are prepared to handle an entire
  text structure!

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFSTRING, EFTEST;


var A, B : pToken;

begin
     MemPush; { EFTEST }

     { Construct a string with some blank spaces and
       a linefeed. }

     New (A, Initialize ('Some say that programming is fun. '));
     A^.Append ( Endl ); A^.AppendPascal ('-They are right.');

     { We can split (expand) strings using certain delimeters.
       By default blank spaces and CR/LF is used as separators. }

     A^.Expand; B := A;

     { Strings form a linked list! Let us parse through it and
       write all strings. Note! All token separators are independent
       blocks after the expand command. }

     WriteLn ('Expanded string into words and rows:');

     while Assigned (A) do begin
           if A^.IsEqual (Endl) then Write ('<Endl>')
              else A^.StreamWrite (StdIO);

           A := pToken (A^.Successor);
           if Assigned (A) then Write ('|');
     end;
     WriteLn;

     { Now, we want to combine all the small strings
       into one entity. We use the merge command. }

     WriteLn ('And merged into one entity again:');
     B^.Merge;
     B^.StreamWrite (StdIO);
     WriteLn;

     B^.Free;

     MemPop; { EFTEST }
end.