{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/String2.pas              [x] Protected mode

  Example of tString - the extended string type.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTRING;


begin
     WriteLn;
     WriteLn (StringFixedCentered(StringDoubled('Flexible routines for'), 79));
     WriteLn (StringFixedCentered(StringDoubled('string handling!'), 79));
     WriteLn;

     WriteLn (StringCentered('- Some features -' + StringFill (60, #32)));
     WriteLn;

     WriteLn (StringFill (15, #32), { 10 blank spaces }
              StringStripped ('- Remove leading or trailing blank spaces           '), '!');

     WriteLn (StringSpace (15), { 10 blank spaces }
              StringReplace ('- Replace x from inside a string!', 'x', 'substrings'));

     WriteLn  (StringSpace (15),
               '- Count the occurrence of substrings inside strings (',
               StringOccurrence ('z', 'zzzZ'), ')!');

     WriteLn (StringSpace (15),
              '- Search positions of substrings in many ways (',
              StringForwardPos ('1', '121', 2), '/',
              StringBackwardPos ('1', '121', 2), ')!');

     WriteLn (StringSpace (15),
              '- And much more!');
end.