{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Search1.pas              [x] Protected mode

  How to handle tStrings - a more advanced example with substring
  searching.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTRING;


var A, S1, S2, S3, S4 : pString; Location : word;

begin
     { Create a text string and some substrings. Dynamically
       allocate instances. }
     New (A,  Initialize ('Why are things this way? I would prefer them to be different.'));
     New (S1, Initialize ('be'));
     New (S2, Initialize ('different'));
     New (S3, Initialize ('?'));
     New (S4, Initialize (' '));

     { Search for substrings in different ways: }

     WriteLn;

     if A^.Search (S1, Location)
        then WriteLn ('(1) Located "', S1^.Pascal, '" at ', Location, ' - starting at position 0.');

     if A^.SearchBackward (S2, A^.Length, Location)
        then WriteLn ('(2) Located "', S2^.Pascal, '" at ', Location, ' - starting at end and searching backwards.');

     if A^.SearchClosest (S3, 27, Location)
        then WriteLn ('(3) Located "', S3^.Pascal, '" at ', Location, ' - starting at 27 searching the closest match.');

     WriteLn ('(4) Blank spaces occurr ', A^.Occurrence (S4), ' times in the string.');

     { Release memory for strings }
     A^.Free; S1^.Free; S2^.Free; S3^.Free; S4^.Free;
end.